// EVC_IO_Demo.cpp : Defines the entry point for the application.
//

#include "stdafx.h"

extern "C" _declspec(dllimport) unsigned char      SX_inpb(unsigned int nAddr);
extern "C" _declspec(dllimport) void               SX_outp(unsigned int nAddr, unsigned char dbData);
extern "C" _declspec(dllimport) unsigned short int SX_inpw(unsigned int nAddr);
extern "C" _declspec(dllimport) void               SX_outw(unsigned int nAddr, unsigned short int dwData);
extern "C" _declspec(dllimport) unsigned int       SX_inpl(unsigned int nAddr);
extern "C" _declspec(dllimport) void               SX_outl(unsigned int nAddr, unsigned int ddData);


int WINAPI WinMain(	HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPTSTR    lpCmdLine,
                    int       nCmdShow)
{
    int nAddr = 0x80;

    printf("1st Test:\n");

    SX_outp(nAddr,   0x12);
    SX_outp(nAddr+1, 0x34);
    SX_outp(nAddr+2, 0x56);
    SX_outp(nAddr+3, 0x78);

    unsigned char b1 = SX_inpb(nAddr);
    unsigned char b2 = SX_inpb(nAddr+1);
    unsigned char b3 = SX_inpb(nAddr+2);
    unsigned char b4 = SX_inpb(nAddr+3);
    printf("Read byte form %X H port is: %X H\n", nAddr,   b1);
    printf("Read byte form %X H port is: %X H\n", nAddr+1, b2);
    printf("Read byte form %X H port is: %X H\n", nAddr+2, b3);
    printf("Read byte form %X H port is: %X H\n", nAddr+3, b4);

    unsigned short int w1 = SX_inpw(nAddr);
    unsigned short int w2 = SX_inpw(nAddr+1);
    unsigned short int w3 = SX_inpw(nAddr+2);
    printf("Read word form %X H port is: %X H\n", nAddr,   w1);
    printf("Read word form %X H port is: %X H\n", nAddr+1, w2);
    printf("Read word form %X H port is: %X H\n", nAddr+2, w3);

    unsigned int dw = SX_inpl(nAddr);
    printf("Read double word form %X H port is: %X H\n", nAddr, dw);


    printf("2nd Test:\n");

    SX_outw(nAddr,  0x1234);
    SX_outw(nAddr+2, 0xabcd);
    w1 = SX_inpw(nAddr);
    w2 = SX_inpw(nAddr+2);
    printf("Read word form %X H port is: %X H\n", nAddr,   w1);
    printf("Read word form %X H port is: %X H\n", nAddr+2, w2);

    dw = SX_inpl(nAddr);
    printf("Read double word form %X H port is: %X H\n", nAddr, dw);

    b1 = SX_inpb(nAddr);
    b2 = SX_inpb(nAddr+1);
    b3 = SX_inpb(nAddr+2);
    b4 = SX_inpb(nAddr+3);
    printf("Read byte form %X H port is: %X H\n", nAddr,   b1);
    printf("Read byte form %X H port is: %X H\n", nAddr+1, b2);
    printf("Read byte form %X H port is: %X H\n", nAddr+2, b3);
    printf("Read byte form %X H port is: %X H\n", nAddr+3, b4);


    printf("3rd Test:\n");

    SX_outl(nAddr, 0xabcdef12);

    dw = dw = SX_inpl(nAddr);
    printf("Read double word form %X H port is: %X H\n", nAddr, dw);

    w1 = SX_inpw(nAddr);
    w2 = SX_inpw(nAddr+2);
    printf("Read word form %X H port is: %X H\n", nAddr,   w1);
    printf("Read word form %X H port is: %X H\n", nAddr+2, w2);

    b1 = SX_inpb(nAddr);
    b2 = SX_inpb(nAddr+1);
    b3 = SX_inpb(nAddr+2);
    b4 = SX_inpb(nAddr+3);
    printf("Read byte form %X H port is: %X H\n", nAddr,   b1);
    printf("Read byte form %X H port is: %X H\n", nAddr+1, b2);
    printf("Read byte form %X H port is: %X H\n", nAddr+2, b3);
    printf("Read byte form %X H port is: %X H\n", nAddr+3, b4);

    return 0;
}

