﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SX_WDT_Demo_Cs
{
    public partial class Frm_SX_WDT_Demo : Form
    {
        int iCurrentSelWDT = 1;
        public Frm_SX_WDT_Demo()
        {
            InitializeComponent();
        }
        // Disable WDT1 and enable WDT0
        private void RadiobtnSelectWDT0_CheckedChanged(object sender, EventArgs e)
        {
            if (iCurrentSelWDT == 1)
            {
                panelWDT0.Enabled = true;
                panelWDT1.Enabled = false;

                btnSetWDT0.Enabled = true;
                btnResetWDT0.Enabled = false;
                btnDisableWDT0.Enabled = false;

                Program.DisableWDT1();
                TimerWDT1.Enabled = false;
                iCurrentSelWDT = 0;
            }
        }
        // Disable WDT0 and enable WDT1
        private void RadiobtnSelectWDT1_CheckedChanged(object sender, EventArgs e)
        {
            if (iCurrentSelWDT == 0)
            {
                panelWDT1.Enabled = true;
                panelWDT0.Enabled = false;

                btnSetWDT1.Enabled = true;
                btnResetWDT1.Enabled = false;
                btnDisableWDT1.Enabled = false;

                Program.DisableWDT0();
                TimerWDT0.Enabled = false;
                iCurrentSelWDT = 1;
            }
        }

        // Setup WDT0
        private void btnSetWDT0_Click(object sender, EventArgs e)
        {
            if (txtSetTimeWDT0.Text.Length == 0)
            {
                MessageBox.Show("Please input a number");
                txtSetTimeWDT0.Focus();
                return;
            }

            txtSetTimeWDT0.Text.ToCharArray();
            for (int i = 0; i < txtSetTimeWDT0.Text.Length; i++)
            {
                if (!char.IsDigit(txtSetTimeWDT0.Text[i]))
                {
                    MessageBox.Show("'" + txtSetTimeWDT0.Text[i] + "' is not number, Please input a number!");
                    txtSetTimeWDT0.Focus();
                    return;
                }
            }

            if (int.Parse(txtSetTimeWDT0.Text) < 0 || int.Parse(txtSetTimeWDT0.Text) > 512 * 1000)
            {
                MessageBox.Show("Input range: 0 ~ 4096");
                txtSetTimeWDT0.Focus();
                return;
            }

            Program.SetWDT0(int.Parse(txtSetTimeWDT0.Text) * 1000, 0xD0);
            TimerWDT0.Enabled = true;
            txtPassedTimeWDT0.Text = "0";
            btnResetWDT0.Enabled = true;
            btnDisableWDT0.Enabled = true;  
        }
        // Setup WDT1
        private void btnSetWDT1_Click(object sender, EventArgs e)
        {
            if (txtSetTimeWDT1.Text.Length == 0)
            {
                MessageBox.Show("Please input a number");
                txtSetTimeWDT1.Focus();
                return;
            }

            txtSetTimeWDT1.Text.ToCharArray();
            for (int i = 0; i < txtSetTimeWDT1.Text.Length; i++)
            {
                if (!char.IsDigit(txtSetTimeWDT1.Text[i]))
                {
                    MessageBox.Show("'" + txtSetTimeWDT1.Text[i] + "' is not number, Please input a number!");
                    txtSetTimeWDT1.Focus();
                    return;
                }
            }

            if (int.Parse(txtSetTimeWDT1.Text) < 0 || int.Parse(txtSetTimeWDT1.Text) > 512 * 1000)
            {
                MessageBox.Show("Input range: 0 ~ 4096");
                txtSetTimeWDT1.Focus();
                return;
            }

            Program.SetWDT1(int.Parse(txtSetTimeWDT1.Text) * 1000, 0xD0);
            TimerWDT1.Enabled = true;
            txtPassedTimeWDT1.Text = "0";
            btnResetWDT1.Enabled = true;
            btnDisableWDT1.Enabled = true;
        }
        // Update time in dialog 
        private void TimerWDT0_Tick(object sender, EventArgs e)
        {
            int iPassedTime;
            iPassedTime = int.Parse(txtPassedTimeWDT0.Text) + 1;
            txtPassedTimeWDT0.Text = iPassedTime.ToString();
        }
        // Update time in dialog
        private void TimerWDT1_Tick(object sender, EventArgs e)
        {
            int iPassedTime;
            iPassedTime = int.Parse(txtPassedTimeWDT1.Text) + 1;
            txtPassedTimeWDT1.Text = iPassedTime.ToString();
        }
        // Reset WDT0
        private void btnResetWDT0_Click(object sender, EventArgs e)
        {
            Program.ResetWDT0();
            txtPassedTimeWDT0.Text = "0";
        }
        // Reset WDT1
        private void btnResetWDT1_Click(object sender, EventArgs e)
        {
            Program.ResetWDT1();
            txtPassedTimeWDT1.Text = "0";
        }
        // Disable WDT0
        private void btnDisableWDT0_Click(object sender, EventArgs e)
        {
            Program.DisableWDT0();
            TimerWDT0.Enabled = false;
            btnResetWDT0.Enabled = false;
            btnDisableWDT0.Enabled = false;
        }
        // Disable WDT1
        private void btnDisableWDT1_Click(object sender, EventArgs e)
        {
            Program.DisableWDT1();
            TimerWDT1.Enabled = false;
            btnResetWDT1.Enabled = false;
            btnDisableWDT1.Enabled = false;
        }
        // Exit program
        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }


    }
}
