;********************************************************
;														*
;	#@M16C START UP KIT MONITER S/W	 Ver1.00		*
;														*
;	FILENAME: mon30def.h								*
;	VER		: 1.00.00									*
;	CPU		: M16C										*
;	FUNCTION: Header file of M16C start_up kit moniter	*
;				(1) define MACRO						*
;	SPEC	:											*
;	OPTION	: "PDB" 0 : for KDB30						*
;					1 : for PDB30						*
;			  "DBG" 0 : for Normal use					*
;					1 : for DEBUG of moniter			*
;														*
;	CRAETE	: 1999.3.1									*
;														*
; 	Copyright(c) 1995-1999 MITSUBISHI ELECTRIC Co. 		*
; 	and MITSUBISHI ELECTRIC SEMICONDUCTOR SYSTEM Co.	*
;	All Rights Reserved.								*
;														*
;********************************************************
;--------------------------------------------
;	MACRO define
;--------------------------------------------
; ----- Preprocess of special page -----
mac_vec_rdy		.MACRO		
	PUSH.W		R0					; jmp to user area
	PUSH.W		R0					; "
;
	PUSH.W		R0					; work
	PUSH.W		R1					; work
	PUSH.W		A0					; work
	PUSH.W		A1					; work
;
	STC			FLG,R0				;> FLG save
	FCLR		I					; Interrupt disable
	STE.B		R0L,bbk_flgl		;> 
	STE.B		R0H,bbk_flgh		;> 
				.ENDM
; ----- Jmp to common special page process  -----
mac_vec_jmpcmn	.MACRO
	STE.B		R0L,bspc_no			;>
	JMP.W		VEC_SPC_UADR		; --> ALL
				.ENDM
;--------------------------------------------
;	for DEBUG 
;--------------------------------------------
ON				.EQU	1
;;;.IF	DBG==ON
Vdbg_s			.EQU	000500H				; area reserved for DEBUG
Vdbg_e			.EQU	002C00H				;  "
;;;.ENDIF
;--------------------------------------------
;	SECTION define
;--------------------------------------------
Vram_s			.EQU	004de6H-282			; TOP of RAM for moniter used
Vram_e			.EQU	0053FFH				; END of RAM for moniter used
Vspc_s			.EQU	0FC000H				; TOP of program area for special page process
Vint_s			.EQU	0F4000H				; Top of program area for interrupt process
Vprg_s			.EQU	0F5000H				; Top of program area for moniter program
Vtbl_s			.EQU	0FF710H				; Top of table area for moniter talbe
Vpge_s			.EQU	0FFE00H				; Top of table area for special page table
Vvec_s			.EQU	0FFFDCH				; Top of table area for fixed vecter table
;--------------------------------------------
;	Address define
;--------------------------------------------
; ----- for User program -----
Vusr_undef		.EQU	0FBFDCH				; Vecter address of undefine instruction
Vusr_overf		.EQU	0FBFE0H				; Vecter address of Overflow
Vusr_brk		.EQU	0FBFE4H				; Vecter address of BRK instructuon
Vusr_wdg		.EQU	0FBFF0H				; Vecter address of WDT
Vusr_nmi2		.EQU	0FBFF8H				; Vecter address of INT_NMI
Vusr_reset		.EQU	0FBFFCH				; Vecter address of user program rest
;--------------------------------------------
;	Intercase code
;--------------------------------------------
; ----- basic code  -----
C_CMD_0			.EQU	30H				; '0'
C_CMD_1			.EQU	31H				; '1'
C_CMD_2			.EQU	32H				; '2'
C_CMD_3			.EQU	33H				; '3'
C_CMD_4			.EQU	34H				; '4'
C_CMD_5			.EQU	35H				; '5'
C_CMD_6			.EQU	36H				; '6'
C_CMD_7			.EQU	37H				; '7'
C_CMD_8			.EQU	38H				; '8'
C_CMD_9			.EQU	39H				; '9'
C_CMD_A			.EQU	41H				; 'A'
C_CMD_B			.EQU	42H				; 'B'
C_CMD_C			.EQU	43H				; 'C'
C_CMD_D			.EQU	44H				; 'D'
C_CMD_E			.EQU	45H				; 'E'
C_CMD_F			.EQU	46H				; 'F'
C_CMD_G			.EQU	47H				; 'G'
C_CMD_H			.EQU	48H				; 'H'
C_CMD_I			.EQU	49H				; 'I'
C_CMD_J			.EQU	4AH				; 'J'
C_CMD_K			.EQU	4BH				; 'K'
C_CMD_L			.EQU	4CH				; 'L'
C_CMD_M			.EQU	4DH				; 'M'
C_CMD_N			.EQU	4EH				; 'N'
C_CMD_O			.EQU	4FH				; 'O'
C_CMD_P			.EQU	50H				; 'P'
; ----- flow contorl code -----
C_CMD_XON		.EQU	11H				; '^Q'
C_CMD_XOFF		.EQU	13H				; '^S'
; ----- control code -----
C_CMD_ESC		.EQU	1BH				; ESC code
C_CMD_SP		.EQU	20h				; Space
C_CMD_INIT		.EQU	21h				; Initialize/stop of exute
C_CMD_START		.EQU	28h				; [START] command start code
C_CMD_END		.EQU	29h				; [END]@command end code
C_CMD_RCVE		.EQU	2eh				; End of download code
C_CMD_BATSTA	.EQU	5bh				; Start code of chaind command
C_CMD_BATEND	.EQU	5dh				; End code of chaind command
; ----- ESC sequence code -----
C_CMD_EXON		.EQU	C_CMD_XON | 40H	; '^Q'
C_CMD_EXOFF		.EQU	C_CMD_XOFF | 40H; '^S'
C_CMD_EESC		.EQU	C_CMD_ESC | 40H	; ESC code
C_CMD_EINIT		.EQU	C_CMD_INIT | 40H; Initialize/stop of exute
; ----- error code(excute information) -----
C_CMD_ERR0		.EQU	C_CMD_0			; NORMAL 
C_CMD_ERR1		.EQU	C_CMD_1			; Reset status of targe
C_CMD_ERR2		.EQU	C_CMD_2			; Sumcheck error of receive
C_CMD_ERR3		.EQU	C_CMD_3			; Request data undefined
C_CMD_ERR4		.EQU	C_CMD_4			; Excute of target program
C_CMD_ERR5		.EQU	C_CMD_5			; Stop of target program
C_CMD_ERR6		.EQU	C_CMD_6			; Already Stopped
C_CMD_ERR7		.EQU	C_CMD_7			; Already Started
C_CMD_ERR8		.EQU	C_CMD_8			; Command parameter error
C_CMD_ERR9		.EQU	C_CMD_9			; Not comlate of measurement
C_CMD_ERRA		.EQU	C_CMD_A			; No data of requeset cycle
C_CMD_ERRB		.EQU	C_CMD_B			; No trace data
C_CMD_ERRC		.EQU	C_CMD_C			; Can not reset target MCU
C_CMD_ERRD		.EQU	C_CMD_D			; MCU HOLD status 
C_CMD_ERRE		.EQU	C_CMD_E			; Time count over flow
C_CMD_ERRF		.EQU	C_CMD_F			; Forced reset of POF status
C_CMD_ERRG		.EQU	C_CMD_G			; Out of renge point number
C_CMD_ERRH		.EQU	C_CMD_H			; Not defined break point
C_CMD_ERRI		.EQU	C_CMD_I			; Not load source line information
C_CMD_ERRJ		.EQU	C_CMD_J			; Not set software output of triger
C_CMD_ERRK		.EQU	C_CMD_K			; Stop of target clock
C_CMD_ERRL		.EQU	C_CMD_L			; Occured exception process
C_CMD_ERRM		.EQU	C_CMD_M			; out of range parametetr 
C_CMD_ERRN		.EQU	C_CMD_N			; EEPROM write error
C_CMD_ERRO		.EQU	C_CMD_O			; Target MCU power off 
C_CMD_ERRP		.EQU	C_CMD_P			; Target MCU excute error
;--------------------------------------------
;	Interface code (input command code)
;--------------------------------------------
; ----- '0' +  commands -----
C_CMD_CONF		.EQU	C_CMD_0<<8 | C_CMD_0	; [CONF] 	'00'
C_CMD_BAUD		.EQU	C_CMD_0<<8 | C_CMD_1	; [BAUD] 	'01'
C_CMD_MCU		.EQU	C_CMD_0<<8 | C_CMD_2	; [MCU] 	'02'
C_CMD_SELF		.EQU	C_CMD_0<<8 | C_CMD_3	; [SELF] 	'03'
C_CMD_MONP		.EQU	C_CMD_0<<8 | C_CMD_4	; [MONP] 	'04'
C_CMD_PMEM		.EQU	C_CMD_0<<8 | C_CMD_5	; [PMEM] 	'05'
C_CMD_DBG		.EQU	C_CMD_0<<8 | C_CMD_6	; [DBG] 	'06'
C_CMD_REST		.EQU	C_CMD_0<<8 | C_CMD_7	; [REST] 	'07'
C_CMD_CLR		.EQU	C_CMD_0<<8 | C_CMD_8	; [CLR] 	'08'
C_CMD_MAPC		.EQU	C_CMD_0<<8 | C_CMD_9	; [MAPC] 	'09'
C_CMD_SYMC		.EQU	C_CMD_0<<8 | C_CMD_A	; [SYMC] 	'0A'
C_CMD_DWNH		.EQU	C_CMD_0<<8 | C_CMD_B	; [DWNH] 	'0B'
C_CMD_DWNS		.EQU	C_CMD_0<<8 | C_CMD_C	; [DWNS] 	'0C'
C_CMD_IPAD		.EQU	C_CMD_0<<8 | C_CMD_D	; [IPAD] 	'0D'
C_CMD_CLOS		.EQU	C_CMD_0<<8 | C_CMD_E	; [CLOS] 	'0E'
C_CMD_STAT		.EQU	C_CMD_0<<8 | C_CMD_F	; [STAT] 	'0F'
; ----- '1' +  commands -----
C_CMD_EV		.EQU	C_CMD_1<<8 | C_CMD_0	; [EV] 		'10'
C_CMD_PID		.EQU	C_CMD_1<<8 | C_CMD_1	; [PID]		'11'
C_CMD_EPID		.EQU	C_CMD_1<<8 | C_CMD_2	; [EPID] 	'12'
; ----- '2' +  commands -----
C_CMD_PB		.EQU	C_CMD_2<<8 | C_CMD_0	; [PB] 		'20'
C_CMD_PBCL		.EQU	C_CMD_2<<8 | C_CMD_1	; [PBCL] 	'21'
C_CMD_PBA		.EQU	C_CMD_2<<8 | C_CMD_2	; [PBA] 	'22'
C_CMD_PBS		.EQU	C_CMD_2<<8 | C_CMD_3	; [PBS] 	'23'
C_CMD_EBLC		.EQU	C_CMD_2<<8 | C_CMD_4	; [EBLC] 	'24'
C_CMD_EBLP		.EQU	C_CMD_2<<8 | C_CMD_5	; [EBLP] 	'25'
C_CMD_EBSI		.EQU	C_CMD_2<<8 | C_CMD_6	; [EBSI] 	'26'
C_CMD_EBSC		.EQU	C_CMD_2<<8 | C_CMD_7	; [EBSC] 	'27'
C_CMD_STK		.EQU	C_CMD_2<<8 | C_CMD_8	; [STK] 	'28'
C_CMD_PROT		.EQU	C_CMD_2<<8 | C_CMD_9	; [PROT] 	'29'
C_CMD_PRTD		.EQU	C_CMD_2<<8 | C_CMD_A	; [PRTD] 	'2A'
C_CMD_BM		.EQU	C_CMD_2<<8 | C_CMD_B	; [BM]	 	'2B'
C_CMD_HB		.EQU	C_CMD_2<<8 | C_CMD_C	; [HB] 		'2C'
C_CMD_PRTB		.EQU	C_CMD_2<<8 | C_CMD_D	; [PRTB] 	'2D'
; ----- '3' +  commands -----
C_CMD_GO		.EQU	C_CMD_3<<8 | C_CMD_0	; [GO] 		'30'
C_CMD_GEB		.EQU	C_CMD_3<<8 | C_CMD_1	; [GEB] 	'31'
C_CMD_GPB		.EQU	C_CMD_3<<8 | C_CMD_2	; [GPB] 	'32'
C_CMD_GB		.EQU	C_CMD_3<<8 | C_CMD_3	; [GB] 		'33'
C_CMD_PROG		.EQU	C_CMD_3<<8 | C_CMD_4	; [PROG] 	'34'
C_CMD_STOP		.EQU	C_CMD_3<<8 | C_CMD_5	; [STOP] 	'35'
C_CMD_FSCP		.EQU	C_CMD_3<<8 | C_CMD_6	; [FSCP] 	'36'
C_CMD_SCPC		.EQU	C_CMD_3<<8 | C_CMD_7	; [SCPC] 	'37'
C_CMD_STEP		.EQU	C_CMD_3<<8 | C_CMD_8	; [STEP] 	'38'
C_CMD_NEXT		.EQU	C_CMD_3<<8 | C_CMD_9	; [NEXT] 	'39'
C_CMD_TM		.EQU	C_CMD_3<<8 | C_CMD_A	; [TM]	 	'3A'
C_CMD_TPID		.EQU	C_CMD_3<<8 | C_CMD_B	; [TPID] 	'3B'
C_CMD_STPD		.EQU	C_CMD_3<<8 | C_CMD_C	; [STPD]	'3C'
C_CMD_WDGO		.EQU	C_CMD_3<<8 | C_CMD_D	; [WDGO] 	'3D'
; ----- '4' +  commands -----
C_CMD_XREG		.EQU	C_CMD_4<<8 | C_CMD_0	; [XREG]	'40'
C_CMD_DUMP		.EQU	C_CMD_4<<8 | C_CMD_1	; [DUMP] 	'41'
C_CMD_FILL		.EQU	C_CMD_4<<8 | C_CMD_2	; [FILL] 	'42'
C_CMD_MOVE		.EQU	C_CMD_4<<8 | C_CMD_3	; [MOVE] 	'43'
C_CMD_CS		.EQU	C_CMD_4<<8 | C_CMD_4	; [CS] 		'44'
C_CMD_RDTM		.EQU	C_CMD_4<<8 | C_CMD_5	; [RDTM] 	'45'
C_CMD_MLOD		.EQU	C_CMD_4<<8 | C_CMD_6	; [MLOD] 	'46'
C_CMD_MCMP		.EQU	C_CMD_4<<8 | C_CMD_7	; [MCMP] 	'47'
; ----- '5' +  commands -----
C_CMD_RRMB		.EQU	C_CMD_5<<8 | C_CMD_0	; [RRMB]	'50'
C_CMD_RRMO		.EQU	C_CMD_5<<8 | C_CMD_1	; [RRMO] 	'51'
C_CMD_RRMI		.EQU	C_CMD_5<<8 | C_CMD_2	; [RRMI] 	'52'
C_CMD_RRMD		.EQU	C_CMD_5<<8 | C_CMD_3	; [RRMD] 	'53'
C_CMD_RRMA		.EQU	C_CMD_5<<8 | C_CMD_4	; [RRMS] 	'54'
C_CMD_RRMS		.EQU	C_CMD_5<<8 | C_CMD_5	; [RRMS] 	'55'
C_CMD_WP		.EQU	C_CMD_5<<8 | C_CMD_6	; [WP]	 	'56'
; ----- '6' +  commands -----
C_CMD_TRGM		.EQU	C_CMD_6<<8 | C_CMD_0	; [TRGM]	'60'
C_CMD_TRGD		.EQU	C_CMD_6<<8 | C_CMD_1	; [TRGD] 	'61'
; ----- '7' +  commands -----
C_CMD_RCLK		.EQU	C_CMD_7<<8 | C_CMD_0	; [RCLK] 	'70'
C_CMD_RPLC		.EQU	C_CMD_7<<8 | C_CMD_1	; [RPLC] 	'71'
C_CMD_RPLP		.EQU	C_CMD_7<<8 | C_CMD_2	; [RPLP] 	'72'
C_CMD_RPSI		.EQU	C_CMD_7<<8 | C_CMD_3	; [RPSI]	'73'
C_CMD_RPSC		.EQU	C_CMD_7<<8 | C_CMD_4	; [RPSC] 	'74'
C_CMD_RM		.EQU	C_CMD_7<<8 | C_CMD_5	; [RM]	 	'75'
C_CMD_RWC		.EQU	C_CMD_7<<8 | C_CMD_6	; [RWC] 	'76'
C_CMD_RD		.EQU	C_CMD_7<<8 | C_CMD_7	; [RD] 		'77'
C_CMD_RCY		.EQU	C_CMD_7<<8 | C_CMD_8	; [RCY] 	'78'
C_CMD_RSR		.EQU	C_CMD_7<<8 | C_CMD_9	; [RSR] 	'79'
C_CMD_RST		.EQU	C_CMD_7<<8 | C_CMD_A	; [RST]	 	'7A'
C_CMD_RRS		.EQU	C_CMD_7<<8 | C_CMD_B	; [RRS] 	'7B'
C_CMD_RCL		.EQU	C_CMD_7<<8 | C_CMD_C	; [RCL]		'7C'
; ----- '8' +  commands -----
C_CMD_PM		.EQU	C_CMD_8<<8 | C_CMD_0	; [PM]	 	'80'
C_CMD_PEV		.EQU	C_CMD_8<<8 | C_CMD_1	; [PEV] 	'81'
C_CMD_PSQI		.EQU	C_CMD_8<<8 | C_CMD_2	; [PSQI] 	'82'
C_CMD_PSQC		.EQU	C_CMD_8<<8 | C_CMD_3	; [PSQC]	'83'
C_CMD_PA		.EQU	C_CMD_8<<8 | C_CMD_4	; [PA] 		'84'
C_CMD_PD		.EQU	C_CMD_8<<8 | C_CMD_5	; [PD]	 	'85'
; ----- '9' +  commands -----
C_CMD_OHD		.EQU	C_CMD_9<<8 | C_CMD_0	; [OHD]	 	'90'
C_CMD_OHTC		.EQU	C_CMD_9<<8 | C_CMD_1	; [OHTC] 	'91'
; ----- 'A' +  commands -----
C_CMD_MD		.EQU	C_CMD_A<<8 | C_CMD_0	; [MD]	 	'A0'
C_CMD_MPD		.EQU	C_CMD_A<<8 | C_CMD_1	; [MPD] 	'A1'
C_CMD_MPCL		.EQU	C_CMD_A<<8 | C_CMD_2	; [MPCL] 	'A2'
C_CMD_MP		.EQU	C_CMD_A<<8 | C_CMD_3	; [MP]		'A3'
; ----- 'B' +  commands -----
C_CMD_CVA		.EQU	C_CMD_B<<8 | C_CMD_0	; [CVA] 	'B0'
C_CMD_CVM		.EQU	C_CMD_B<<8 | C_CMD_1	; [CVM] 	'B1'
C_CMD_CVDO		.EQU	C_CMD_B<<8 | C_CMD_2	; [CVDO] 	'B2'
C_CMD_CVDI		.EQU	C_CMD_B<<8 | C_CMD_3	; [CVDI]	'B3'
C_CMD_CVST		.EQU	C_CMD_B<<8 | C_CMD_4	; [CVST] 	'B4'
C_CMD_CVRS		.EQU	C_CMD_B<<8 | C_CMD_5	; [CVRS]	'B5'
C_CMD_CVCL		.EQU	C_CMD_B<<8 | C_CMD_6	; [CVCL] 	'B6'
C_CMD_CVS		.EQU	C_CMD_B<<8 | C_CMD_7	; [CVS] 	'B7'
; ----- 'C' +  commands -----
C_CMD_MAP		.EQU	C_CMD_C<<8 | C_CMD_0	; [MAP] 	'C0'
C_CMD_MAPD		.EQU	C_CMD_C<<8 | C_CMD_1	; [MAPD] 	'C1'
C_CMD_SYPC		.EQU	C_CMD_C<<8 | C_CMD_2	; [SYPC] 	'C2'
; ----- 'D' +  commands -----
C_CMD_CLK		.EQU	C_CMD_D<<8 | C_CMD_0	; [CLK] 	'D0'
C_CMD_MSTS		.EQU	C_CMD_D<<8 | C_CMD_1	; [MSTS] 	'D1'
; ----- Register select code -----
C_REG_R0_0		.EQU	C_CMD_0<<8 | C_CMD_0	; bank-0 R0
C_REG_R1_0		.EQU	C_CMD_0<<8 | C_CMD_1	; bank-0 R1
C_REG_R2_0		.EQU	C_CMD_0<<8 | C_CMD_2	; bank-0 R2
C_REG_R3_0		.EQU	C_CMD_0<<8 | C_CMD_3	; bank-0 R3
C_REG_A0_0		.EQU	C_CMD_0<<8 | C_CMD_4	; bank-0 A0
C_REG_A1_0		.EQU	C_CMD_0<<8 | C_CMD_5	; bank-0 A1
C_REG_FB_0		.EQU	C_CMD_0<<8 | C_CMD_6	; bank-0 FB
;
C_REG_R0_1		.EQU	C_CMD_0<<8 | C_CMD_7	; bank-1 R0
C_REG_R1_1		.EQU	C_CMD_0<<8 | C_CMD_8	; bank-1 R1
C_REG_R2_1		.EQU	C_CMD_0<<8 | C_CMD_9	; bank-1 R2
C_REG_R3_1		.EQU	C_CMD_0<<8 | C_CMD_A	; bank-1 R3
C_REG_A0_1		.EQU	C_CMD_0<<8 | C_CMD_B	; bank-1 A0
C_REG_A1_1		.EQU	C_CMD_0<<8 | C_CMD_C	; bank-1 A1
C_REG_FB_1		.EQU	C_CMD_0<<8 | C_CMD_D	; bank-1 FB
;
C_REG_USP		.EQU	C_CMD_0<<8 | C_CMD_E	; USP
C_REG_ISP		.EQU	C_CMD_0<<8 | C_CMD_F	; ISP
C_REG_FLG		.EQU	C_CMD_1<<8 | C_CMD_0	; FLG
C_REG_PC		.EQU	C_CMD_1<<8 | C_CMD_1	; PC
C_REG_SB		.EQU	C_CMD_1<<8 | C_CMD_2	; SB
C_REG_INTB		.EQU	C_CMD_1<<8 | C_CMD_3	; INTB
;--------------------------------------------
;	for moniter program
;--------------------------------------------
; ---- SFR -----
C_PM0			.EQU	00000111B	; PM0(Micorprocesser,RD/WRH/WRL,BCLK-ON)
C_PM0_S			.EQU	00000100B	; PM0(Sinlge chip mode,RD/WRH/WRL,BCLK-ON)
C_PM1			.EQU	00000000B	; PM1(No-wait)
C_CM0			.EQU	00001000B	; CM0(Xcin-HIGH)
C_CM1			.EQU	00100000B	; CM1(Xin-HIGH)
; ---- ް֘A -----
C_ISP_INI		.EQU	0044FFH		; ISP
C_USP_INI		.EQU	0H			; USP
C_REG_INI		.EQU	0H			; register initial value
; -----  <-> հI/F֘A-----
C_LED_OFF		.EQU	0H			; LED OFF(SAMPLIMG mode)
C_LED_ON		.EQU	0FFH		; LED ON(FREE mode)
; ----- wrst_inf -----
C_RSTINF_UREST	.EQU	4321H		; user(command)RESET request
C_RSTINF_COMPLT	.EQU	8765H		; complate of moniter initialize
; ----- bcmd_type -----
C_CTYPE_CHANGE	.EQU	0			; Change
C_CTYPE_VIEW	.EQU	1			; View
C_CTYPE_SET		.EQU	2			; Set
C_CTYPE_EXE1	.EQU	3			; Execute1
C_CTYPE_EXE2	.EQU	4			; Execute2
C_CTYPE_SERCH1	.EQU	5			; Serch1
C_CTYPE_SERCH2	.EQU	6			; Serch2
C_CTYPE_FREE	.EQU	7			; Free
C_CTYPE_VIEW1	.EQU	8			; View1
C_CTYPE_VIEW2	.EQU	9			; View2
C_CTYPE_TYPE1	.EQU	10			; Type1
C_CTYPE_TYPE2	.EQU	11			; Type2
C_CTYPE_TYPE3	.EQU	12			; Type3
; ----- bbrk_inf -----
C_BRKINF_FE		.EQU	1			; Forced Break by Front/End
C_BRKINF_PB		.EQU	2			; Program break
C_BRKINF_HB		.EQU	3			; Hard ware break(no-use)
; ----- bdump_size -----
C_SIZE_BYTE		.EQU	C_CMD_0		; Byte select(ASCII)
C_SIZE_WORD		.EQU	C_CMD_1		; Word select(ASCII)
; ----- bpb_cntl -----
C_PB_MAX		.EQU	3			; PB0/PB1 PB 
; ----- brcv_buf -----
C_RCV_MAX		.EQU	12			; Size pf receive data buffer(Byte)
; ----- bfm_mod -----
C_FM_SAMPLE		.EQU	C_CMD_0		; sampling mode
C_FM_FREE		.EQU	C_CMD_1		; FREE mode
; ----- bspc_stepmd -----
C_STEP_SPC		.EQU	1			; Special page(STEP)(1)
; ----- Judgement of area -----
C_AREA_NONMON	.EQU	0FH			; User program execute
C_AREA_SPC		.EQU	40H			; Special page execute	F3FFF>
C_AREA_USRSPCH	.EQU	01H			; User's special page execute(H) ?FFE0
; ----- Opecode -----
C_OPE_REIT		.EQU	0FBH		; opecode "REIT"
C_OPE_JMPS		.EQU	0EEH		; opecode "JMPS"
C_OPE_JSRS		.EQU	0EFH		; opecode "JSRS"
; ----- E.T.C -----
C_IPL_DEFLT		.EQU	60H			; IPL = #7 ;ham  7->6
;----------------------------------------
;	Flage defind (bit No.)
;----------------------------------------
; ----- wrcv_cntl -----
F_RCVMD_ASCII	.EQU	0			; ASCII/BINARY(0:1)
F_RCVMD_XOFF	.EQU	1			; XOFF receive(1)
F_RCVMD_XON		.EQU	2			; (no-use) XON receive(1)
F_RCVMD_SINGLE	.EQU	3			; receive mode (1)
F_RCVMD_ESC		.EQU	4			; ESC sequancc(1)
F_RCVMD_CMD1	.EQU	5			; CMD1 wait(1)
F_RCVMD_CMD2	.EQU	6			; CMD2 wait(1)
F_RCVMD_CMDON	.EQU	7			; CMD get(1)
F_RCVMD_INIT	.EQU	8			; INIT execute(1)
F_RCVMD_STEP	.EQU	9			; STEP interrupt execute(1)
; ----- wsnd_cntl -----
F_SNDMD_ASCII	.EQU	0			; ASCII/BINARY(0:1)
F_SNDMD_XOFF	.EQU	1			; XOFF send(1)
F_SNDMD_XON		.EQU	2			; (no-use) XON send(1)
F_SNDMD_SINGLE	.EQU	3			; send mode (1)
F_SNDMD_SNDREQ	.EQU	14			; Send request(main - NMI)(1)
F_SNDMD_RPLY	.EQU	15			; Send reply wait(1)
; ----- wmoj_req -----
F_MOJ_CHK		.EQU	0			; Date annalize module
F_MOJ_CNTL		.EQU	1			; Receive control module
F_MOJ_CMD		.EQU	2			; command process module
F_MOJ_USR		.EQU	3			; user program
F_MOJ_SPC		.EQU	4			; Special page control module
F_MOJ_LED		.EQU	5			; LED contol module
F_MOJ_ERR		.EQU	6			; ERR module
; ----- werr_inf -----
F_ERRINF_UND	.EQU	0			; UND 				not user 
F_ERRINF_OVRF	.EQU	1			; OVERF 			not user 
F_ERRINF_BRK	.EQU	2			; BRK 				not	user 
F_ERRINF_ADDR	.EQU	3			; Address match		not user 
F_ERRINF_STEP	.EQU	4			; STEP				not	user 
F_ERRINF_NMI	.EQU	5			; NMI				not user 


DEF_CM0		.EQU	01FH			;user save area for CM0
DEF_CM1		.EQU	03FH			;user save area for CM1
;
;********************************************************
;														*
;	FILENAME: mon30def.h								*
;														*
; 	Copyright(c) 1995-1999 MITSUBISHI ELECTRIC Co. 		*
; 	and MITSUBISHI ELECTRIC SEMICONDUCTOR SYSTEM Co.	*
;	All Rights Reserved.								*
;														*
;********************************************************
