;********************************************************
;*														*
;*	file name	: definition of M16C/62's SFR			*
;*														*
;*	Copyright	: MITSUBISHI ELECTRIC CORPORATION		*
;*														*
;*	Version		: 1.00 ( 1997- 6- 9 )					*
;*				: 1.01 ( 1998-11-13 )					*
;*				flash control register 03b7h add 		*
;*				UART2 Special mode register2 0376h add	*
;*				pm1 add pm13							*
;*				u2smr modify iicm						*
;*				u0rb,u1rb,u2rb add abt					*
;*				dm0sl,dm1sl add dms						*
;*				: 1.02 ( 1999-01-08 )					*
;*				fer	-> fmcr	modify						*
;*														*
;********************************************************
;
;  note:
;	This data is a freeware that SFR for M16C/62 is discribeed.
;	Mitsubishi Electric Corporation assumes no responsibility for any damage
;	that occurred by this data.
;
;-------------------------------------------------------
;	Processor mode register 0
;-------------------------------------------------------
PM0			.EQU		0004H
;
PM00		.BTEQU		0,PM0		; PROCESSOR MODE BIT
PM01		.BTEQU		1,PM0		; PROCESSOR MODE BIT
PM02		.BTEQU		2,PM0		; R/W MODE SELECT BIT
PM03		.BTEQU		3,PM0		; SOFTWARE RESET BIT
PM04		.BTEQU		4,PM0		; MULTIPLEXED BUS SPACE SELECT BIT
PM05		.BTEQU		5,PM0		; MULTIPLEXED BUS SPACE SELECT BIT
PM06		.BTEQU		6,PM0		; PORT P40 TO P43 FUNCTION SELECT BIT
PM07		.BTEQU		7,PM0		; BCLK OUTPUT DISABLE BIT
;
;-------------------------------------------------------
;	PROCESSOR MODE REGISTER 1
;-------------------------------------------------------
PM1			.EQU		0005H
;
PM13		.BTEQU		3,PM1		;
PM14		.BTEQU		4,PM1		;
PM15		.BTEQU		5,PM1		;
PM16		.BTEQU		6,PM1		; RESERVED BIT
PM17		.BTEQU		7,PM1		; WAIT BIT
;
;-------------------------------------------------------
;	SYSTEM CLOCK CONTROL REGISTER 0
;-------------------------------------------------------
CM0			.EQU		0006H
;
CM00		.BTEQU		0,CM0		; CLOCK OUTPUT FUNCTION SELECT BIT
CM01		.BTEQU		1,CM0		; CLOCK OUTPUT FUNCTION SELECT BIT
CM02		.BTEQU		2,CM0		; WAIT PERIPHERAL FUNCTION CLOCK STOP BIT
CM03		.BTEQU		3,CM0		; XCIN-XCOUT DRIVE CAPACITY SELECT BIT
CM04		.BTEQU		4,CM0		; PORT XC SELECT BIT
CM05		.BTEQU		5,CM0		; MAIN CLOCK STOP BIT
CM06		.BTEQU		6,CM0		; MAIN CLOCK DIVISION SELECTBIT0
CM07		.BTEQU		7,CM0		; SYSTEM CLOCK SELECT BIT
;
;-------------------------------------------------------
;	SYSTEM CLOCK CONTROL REGISTER 1
;-------------------------------------------------------
CM1			.EQU		0007H
;
CM10		.BTEQU		0,CM1		; ALL CLOCK STOP CONTROL BIT
CM15		.BTEQU		5,CM1		; XIN-XOUT DRIVE CAPACITY SELECT BIT
CM16		.BTEQU		6,CM1		; MAIN CLOCK DIVISION SELECT BIT
CM17		.BTEQU		7,CM1		; MAIN CLOCK DIVISION SELECT BIT
;
;-------------------------------------------------------
;	CHIP SELECT CONTROL REGISTER
;-------------------------------------------------------
CSR			.EQU		0008H
;
CS0			.BTEQU		0,CSR		; CS0 OUTPUT ENABLE BIT
CS1			.BTEQU		1,CSR		; CS1 OUTPUT ENABLE BIT
CS2			.BTEQU		2,CSR		; CS2 OUTPUT ENABLE BIT
CS3			.BTEQU		3,CSR		; CS3 OUTPUT ENABLE BIT
CS0W		.BTEQU		4,CSR		; CS0 WAIT BIT
CS1W		.BTEQU		5,CSR		; CS1 WAIT BIT
CS2W		.BTEQU		6,CSR		; CS2 WAIT BIT
CS3W		.BTEQU		7,CSR		; CS3 WAIT BIT
;
;-------------------------------------------------------
;	ADDRESS MATCH INTERRUPT ENABLE REGISTER
;-------------------------------------------------------
AIER		.EQU		0009H
;
AIER0		.BTEQU		0,AIER		; ADDRESS MATCH INTERRUPT 0 ENABLE BIT
AIER1		.BTEQU		1,AIER		; ADDRESS MATCH INTERRUPT 1 ENABLE BIT
;
;-------------------------------------------------------
;	PROTECT REGISTER
;-------------------------------------------------------
PRCR		.EQU		000AH
;
PRC0		.BTEQU		0,PRCR		; ENABLE WRITTING TO SYSTEM CLOCK CONTROL REGISTER
PRC1		.BTEQU		1,PRCR		; ENABLE WRITTING TO PROCESSOR MODE REGISTER
PRC2		.BTEQU		2,PRCR		; ENABLE WRITTING TO PORT P9 DIRECTION REGISTER
;
;-------------------------------------------------------
;	DATA BANK REGISTER
;-------------------------------------------------------
DBR			.EQU		000BH
;
OFS			.BTEQU		2,DBR
BSR0		.BTEQU		3,DBR
BSR1		.BTEQU		4,DBR
BSR2		.BTEQU		5,DBR
;
;-------------------------------------------------------
;	WATCHDOG TIMER
;-------------------------------------------------------
WDTS		.EQU		000EH		; WATCHDOG TIMER START REGISTER
;
WDC			.EQU		000FH		; WATCHDOG TIMER CONTROL REGISTER
;
WDC7		.BTEQU		7,WDC		; PRESCALER SELECT BIT
;
;-------------------------------------------------------
;	ADDRESS MATCH INTERRUPT REGISTER 0
;-------------------------------------------------------
RMAD0		.EQU		0010H
RMAD0L		.EQU		RMAD0		; ADDRESS MATCH INTERRUPT REGISTER 0L
RMAD0M		.EQU		RMAD0+1		; ADDRESS MATCH INTERRUPT REGISTER 0M
RMAD0H		.EQU		RMAD0+2		; ADDRESS MATCH INTERRUPT REGISTER 0H
;
;-------------------------------------------------------
;	ADDRESS MATCH INTERRUPT REGISTER 1
;-------------------------------------------------------
RMAD1		.EQU		0014H
RMAD1L		.EQU		RMAD1		; ADDRESS MATCH INTERRUPT REGISTER 1L
RMAD1M		.EQU		RMAD1+1		; ADDRESS MATCH INTERRUPT REGISTER 1M
RMAD1H		.EQU		RMAD1+2		; ADDRESS MATCH INTERRUPT REGISTER 1H
;
;-------------------------------------------------------
;	DMA0 SOURCE POINTER
;-------------------------------------------------------
SAR0		.EQU		0020H
SAR0L		.EQU		SAR0		; DMA0 SOURCE POINTER L
SAR0M		.EQU		SAR0+1		; DMA0 SOURCE POINTER M
SAR0H		.EQU		SAR0+2		; DMA0 SOURCE POINTER H
;
;-------------------------------------------------------
;	DMA0 DESTINATION POINTER
;-------------------------------------------------------
DAR0		.EQU		0024H
DAR0L		.EQU		DAR0		; DMA0 DESTINATION POINTER L
DAR0M		.EQU		DAR0+1		; DMA0 DESTINATION POINTER M
DAR0H		.EQU		DAR0+2		; DMA0 DESTINATION POINTER H
;
;-------------------------------------------------------
;	DMA0 TRANSFER COUNTER
;-------------------------------------------------------
TCR0		.EQU		0028H
TCR0L		.EQU		TCR0		; DMA0 TRANSFER COUNTER L
TCR0H		.EQU		TCR0+1		; DMA0 TRANSFER COUNTER H
;
;-------------------------------------------------------
;	DMA0 CONTROL REGISTER
;-------------------------------------------------------
DM0CON		.EQU		002CH
;
DMBIT_DM0CON	.BTEQU	0,DM0CON	; TRANSFER UNIT BIT SELECT BIT
DMASL_DM0CON	.BTEQU	1,DM0CON	; REPEAT TRANSFER MODE SELECT BIT
DMAS_DM0CON	.BTEQU		2,DM0CON	; DMA REQUEST BIT
DMAE_DM0CON	.BTEQU		3,DM0CON	; DMA ENABLE BIT
DSD_DM0CON	.BTEQU		4,DM0CON	; SOURCE ADDRESS DIRECTION SELECT BIT
DAD_DM0CON	.BTEQU		5,DM0CON	; DESTINATION ADDRESS DIRECTION SELECT BIT
;
;-------------------------------------------------------
;	DMA1 SOURCE POINTER
;-------------------------------------------------------
SAR1		.EQU		0030H
SAR1L		.EQU		SAR1		; DMA1 SOURCE POINTER L
SAR1M		.EQU		SAR1+1		; DMA1 SOURCE POINTER M
SAR1H		.EQU		SAR1+2		; DMA1 SOURCE POINTER H
;
;-------------------------------------------------------
;	DMA1 DESTINATION POINTER
;-------------------------------------------------------
DAR1		.EQU		0034H
DAR1L		.EQU		DAR1		; DMA1 DESTINATION POINTER L
DAR1M		.EQU		DAR1+1		; DMA1 DESTINATION POINTER M
DAR1H		.EQU		DAR1+2		; DMA1 DESTINATION POINTER H
;
;-------------------------------------------------------
;	DMA1 TRANSFER COUNTER
;-------------------------------------------------------
TCR1		.EQU		0038H
TCR1L		.EQU		TCR1		;DMA1 TRANSFER COUNTER L
TCR1H		.EQU		TCR1+1		;DMA1 TRANSFER COUNTER H
;
;-------------------------------------------------------
;	DMA1 CONTROL REGISTER
;-------------------------------------------------------
DM1CON		.EQU		003CH
;
DMBIT_DM1CON	.BTEQU	0,DM1CON	; TRANSFER UNIT BIT SELECT BIT
DMASL_DM1CON	.BTEQU	1,DM1CON	; REPEAT TRANSFER MODE SELECT BIT
DMAS_DM1CON	.BTEQU		2,DM1CON	; DMA REQUEST BIT
DMAE_DM1CON	.BTEQU		3,DM1CON	; DMA DISABLE BIT
DSD_DM1CON	.BTEQU		4,DM1CON	; SOURCE ADDRESS DIRECTION SELECT BIT
DAD_DM1CON	.BTEQU		5,DM1CON	; DESTINATION ADDRESS DIRECTION SELECT BIT
;
;-------------------------------------------------------
;	INTERRUPT CONTROL REGISTER
;-------------------------------------------------------
INT3IC			.EQU	0044H		; INT3
ILVL0_INT3IC	.BTEQU	0,INT3IC	; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_INT3IC	.BTEQU	1,INT3IC	;
ILVL2_INT3IC	.BTEQU	2,INT3IC	;
IR_INT3IC		.BTEQU	3,INT3IC	; INTERRUPT REQUEST BIT
POL_INT3IC		.BTEQU	4,INT3IC	; POLARITY SELECT BIT
;
TB5IC			.EQU	0045H		; TIMERB5
ILVL0_TB5IC		.BTEQU	0,TB5IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TB5IC		.BTEQU	1,TB5IC		;
ILVL2_TB5IC		.BTEQU	2,TB5IC		;
IR_TB5IC		.BTEQU	3,TB5IC		; INTERRUPT REQUEST BIT
;
TB4IC			.EQU	0046H		; TIMERB4
ILVL0_TB4IC		.BTEQU	0,TB4IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TB4IC		.BTEQU	1,TB4IC		;
ILVL2_TB4IC		.BTEQU	2,TB4IC		;
IR_TB4IC		.BTEQU	3,TB4IC		; INTERRUPT REQUEST BIT
;
TB3IC			.EQU	0047H		; TIMERB3
ILVL0_TB3IC		.BTEQU	0,TB3IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TB3IC		.BTEQU	1,TB3IC		;
ILVL2_TB3IC		.BTEQU	2,TB3IC		;
IR_TB3IC		.BTEQU	3,TB3IC		; INTERRUPT REQUEST BIT
;
S4IC			.EQU	0048H		; SI/O4
ILVL0_S4IC		.BTEQU	0,S4IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S4IC		.BTEQU	1,S4IC		;
ILVL2_S4IC		.BTEQU	2,S4IC		;
IR_S4IC			.BTEQU	3,S4IC		; INTERRUPT REQUEST BIT
POL_S4IC		.BTEQU	4,S4IC		; POLARITY SELECT BIT
;
S3IC			.EQU	0049H		; SI/O3
ILVL0_S3IC		.BTEQU	0,S3IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S3IC		.BTEQU	1,S3IC		;
ILVL2_S3IC		.BTEQU	2,S3IC		;
IR_S3IC			.BTEQU	3,S3IC		; INTERRUPT REQUEST BIT
POL_S3IC		.BTEQU	4,S3IC		; POLARITY SELECT BIT
;
INT5IC			.EQU	0048H		; INT5
ILVL0_INT5IC	.BTEQU	0,INT5IC	; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_INT5IC	.BTEQU	1,INT5IC	;
ILVL2_INT5IC	.BTEQU	2,INT5IC	;
IR_INT5IC		.BTEQU	3,INT5IC	; INTERRUPT REQUEST BIT
POL_INT5IC		.BTEQU	4,INT5IC	; POLARITY SELECT BIT
;
INT4IC			.EQU	0049H		; INT4
ILVL0_INT4IC	.BTEQU	0,INT4IC	; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_INT4IC	.BTEQU	1,INT4IC	;
ILVL2_INT4IC	.BTEQU	2,INT4IC	;
IR_INT4IC		.BTEQU	3,INT4IC	; INTERRUPT REQUEST BIT
POL_INT4IC		.BTEQU	4,INT4IC	; POLARITY SELECT BIT
;
BCNIC			.EQU	004AH		; BUS COLLISION DETECTION INTERRUPT CONTROL REGISTER
ILVL0_BCNIC		.BTEQU	0,BCNIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_BCNIC		.BTEQU	1,BCNIC		;
ILVL2_BCNIC		.BTEQU	2,BCNIC		;
IR_BCNIC		.BTEQU	3,BCNIC		; INTERRUPT REQUEST BIT
;
DM0IC			.EQU	004BH		; DMA0 INTERRUPT CONTROL REGISTER
ILVL0_DM0IC		.BTEQU	0,DM0IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_DM0IC		.BTEQU	1,DM0IC		;
ILVL2_DM0IC		.BTEQU	2,DM0IC		;
IR_DM0IC		.BTEQU	3,DM0IC		; INTERRUPT REQUEST BIT
;
DM1IC			.EQU	004CH		; DMA1 INTERRUPT CONTROL REGISTER
ILVL0_DM1IC		.BTEQU	0,DM1IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_DM1IC		.BTEQU	1,DM1IC		;
ILVL2_DM1IC		.BTEQU	2,DM1IC		;
IR_DM1IC		.BTEQU	3,DM1IC		; INTERRUPT REQUEST BIT
;
KUPIC			.EQU	004DH		; KEY INPUT INTERRUPT CONTROL REGISTER
ILVL0_KUPIC		.BTEQU	0,KUPIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_KUPIC		.BTEQU	1,KUPIC		;
ILVL2_KUPIC		.BTEQU	2,KUPIC		;
IR_KUPIC		.BTEQU	3,KUPIC		; INTERRUPT REQUEST BIT
;
ADIC			.EQU	004EH		; A-D INTERRUPT CONTROL REGISTER
ILVL0_ADIC		.BTEQU	0,ADIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_ADIC		.BTEQU	1,ADIC		;
ILVL2_ADIC		.BTEQU	2,ADIC		;
IR_ADIC			.BTEQU	3,ADIC		; INTERRUPT REQUEST BIT
;
S2TIC			.EQU	004FH		; UART2 TRANSMIT INTERRUPT CONTROL REGISTER
ILVL0_S2TIC		.BTEQU	0,S2TIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S2TIC		.BTEQU	1,S2TIC		;
ILVL2_S2TIC		.BTEQU	2,S2TIC		;
IR_S2TIC		.BTEQU	3,S2TIC		; INTERRUPT REQUEST BIT
;
S2RIC			.EQU	0050H		; UART2 RECEIVE INTERRUPT CONTROL REGISTER
ILVL0_S2RIC		.BTEQU	0,S2RIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S2RIC		.BTEQU	1,S2RIC		;
ILVL2_S2RIC		.BTEQU	2,S2RIC		;
IR_S2RIC		.BTEQU	3,S2RIC		; INTERRUPT REQUEST BIT
;
S0TIC			.EQU	0051H		; UART0 TRANSMIT INTERRUPT CONTROL REGISTER
ILVL0_S0TIC		.BTEQU	0,S0TIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S0TIC		.BTEQU	1,S0TIC		;
ILVL2_S0TIC		.BTEQU	2,S0TIC		;
IR_S0TIC		.BTEQU	3,S0TIC		; INTERRUPT REQUEST BIT
;
S0RIC			.EQU	0052H		; UART0 RECEIVE INTERRUPT CONTROL REGISTER
ILVL0_S0RIC		.BTEQU	0,S0RIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S0RIC		.BTEQU	1,S0RIC		;
ILVL2_S0RIC		.BTEQU	2,S0RIC		;
IR_S0RIC		.BTEQU	3,S0RIC		; INTERRUPT REQUEST BIT
;
S1TIC			.EQU	0053H		; UART1 TRANSMIT INTERRUPT CONTROL REGISTER
ILVL0_S1TIC		.BTEQU	0,S1TIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S1TIC		.BTEQU	1,S1TIC		;
ILVL2_S1TIC		.BTEQU	2,S1TIC		;
IR_S1TIC		.BTEQU	3,S1TIC		; INTERRUPT REQUEST BIT
;
S1RIC			.EQU	0054H		; UART1 RECEIVE INTERRUPT CONTROL REGISTER
ILVL0_S1RIC		.BTEQU	0,S1RIC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_S1RIC		.BTEQU	1,S1RIC		;
ILVL2_S1RIC		.BTEQU	2,S1RIC		;
IR_S1RIC		.BTEQU	3,S1RIC		; INTERRUPT REQUEST BIT
;
TA0IC			.EQU	0055H		; TIMER A0
ILVL0_TA0IC		.BTEQU	0,TA0IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TA0IC		.BTEQU	1,TA0IC		;
ILVL2_TA0IC		.BTEQU	2,TA0IC		;
IR_TA0IC		.BTEQU	3,TA0IC		; INTERRUPT REQUEST BIT
;
TA1IC			.EQU	0056H		; TIMER A1
ILVL0_TA1IC		.BTEQU	0,TA1IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TA1IC		.BTEQU	1,TA1IC		;
ILVL2_TA1IC		.BTEQU	2,TA1IC		;
IR_TA1IC		.BTEQU	3,TA1IC		; INTERRUPT REQUEST BIT
;
TA2IC			.EQU	0057H		; TIMER A2
ILVL0_TA2IC		.BTEQU	0,TA2IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TA2IC		.BTEQU	1,TA2IC		;
ILVL2_TA2IC		.BTEQU	2,TA2IC		;
IR_TA2IC		.BTEQU	3,TA2IC		; INTERRUPT REQUEST BIT
;
TA3IC			.EQU	0058H		; TIMER A3
ILVL0_TA3IC		.BTEQU	0,TA3IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TA3IC		.BTEQU	1,TA3IC		;
ILVL2_TA3IC		.BTEQU	2,TA3IC		;
IR_TA3IC		.BTEQU	3,TA3IC		; INTERRUPT REQUEST BIT
;
TA4IC			.EQU	0059H		; TIMER A4
ILVL0_TA4IC		.BTEQU	0,TA4IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TA4IC		.BTEQU	1,TA4IC		;
ILVL2_TA4IC		.BTEQU	2,TA4IC		;
IR_TA4IC		.BTEQU	3,TA4IC		; INTERRUPT REQUEST BIT
;
TB0IC			.EQU	005AH		; TIMER B0
ILVL0_TB0IC		.BTEQU	0,TB0IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TB0IC		.BTEQU	1,TB0IC		;
ILVL2_TB0IC		.BTEQU	2,TB0IC		;
IR_TB0IC		.BTEQU	3,TB0IC		; INTERRUPT REQUEST BIT
;
TB1IC			.EQU	005BH		; TIMER B1
ILVL0_TB1IC		.BTEQU	0,TB1IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TB1IC		.BTEQU	1,TB1IC		;
ILVL2_TB1IC		.BTEQU	2,TB1IC		;
IR_TB1IC		.BTEQU	3,TB1IC		; INTERRUPT REQUEST BIT
;
TB2IC			.EQU	005CH		; TIMER B2
ILVL0_TB2IC		.BTEQU	0,TB2IC		; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_TB2IC		.BTEQU	1,TB2IC		;
ILVL2_TB2IC		.BTEQU	2,TB2IC		;
IR_TB2IC		.BTEQU	3,TB2IC		; INTERRUPT REQUEST BIT
;
INT0IC			.EQU	005DH		; INT0
ILVL0_INT0IC	.BTEQU	0,INT0IC	; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_INT0IC	.BTEQU	1,INT0IC	;
ILVL2_INT0IC	.BTEQU	2,INT0IC	;
IR_INT0IC		.BTEQU	3,INT0IC	; INTERRUPT REQUEST BIT
POL_INT0IC		.BTEQU	4,INT0IC	; POLARITY SELECT BIT
;
INT1IC			.EQU	005EH		; INT1
ILVL0_INT1IC	.BTEQU	0,INT1IC	; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_INT1IC	.BTEQU	1,INT1IC	;
ILVL2_INT1IC	.BTEQU	2,INT1IC	;
IR_INT1IC		.BTEQU	3,INT1IC	; INTERRUPT REQUEST BIT
POL_INT1IC		.BTEQU	4,INT1IC	; POLARITY SELECT BIT
;
INT2IC			.EQU	005FH		; INT2
ILVL0_INT2IC	.BTEQU	0,INT2IC	; INTERRUPT PRIORITY LEVEL SELECT BIT
ILVL1_INT2IC	.BTEQU	1,INT2IC	;
ILVL2_INT2IC	.BTEQU	2,INT2IC	;
IR_INT2IC		.BTEQU	3,INT2IC	; INTERRUPT REQUEST BIT
POL_INT2IC		.BTEQU	4,INT2IC	; POLARITY SELECT BIT
;
;-------------------------------------------------------
;	ADDITIONAL TIMER B3,B4,B5
;-------------------------------------------------------
TBSR		.EQU		0340H
TB3S		.BTEQU		5,TBSR
TB4S		.BTEQU		6,TBSR
TB5S		.BTEQU		7,TBSR
;
TA11		.EQU		0342H
TA11L		.EQU		TA11
TA11H		.EQU		TA11+1
;
TA21		.EQU		0344H
TA21L		.EQU		TA21
TA21H		.EQU		TA21+1
;
TA41		.EQU		0346H
TA41L		.EQU		TA41
TA41H		.EQU		TA41+1
;
INVC0		.EQU		0348H
INV00		.BTEQU		0,INVC0
INV01		.BTEQU		1,INVC0
INV02		.BTEQU		2,INVC0
INV03		.BTEQU		3,INVC0
INV04		.BTEQU		4,INVC0
INV05		.BTEQU		5,INVC0
INV06		.BTEQU		6,INVC0
INV07		.BTEQU		7,INVC0
;
INVC1		.EQU		0349H
INV10		.BTEQU		0,INVC1
INV11		.BTEQU		1,INVC1
INV12		.BTEQU		2,INVC1
;
IDB0		.EQU		034AH
DU0			.BTEQU		0,IDB0
DUB0		.BTEQU		1,IDB0
DV0			.BTEQU		2,IDB0
DVB0		.BTEQU		3,IDB0
DW0			.BTEQU		4,IDB0
DWB0		.BTEQU		5,IDB0
;
IDB1		.EQU		034BH
DU1			.BTEQU		0,IDB0
DUB1		.BTEQU		1,IDB1
DV1			.BTEQU		2,IDB1
DVB1		.BTEQU		3,IDB1
DW1			.BTEQU		4,IDB1
DWB1		.BTEQU		5,IDB1
;
DTT			.EQU		034CH
;
ICTB2		.EQU		034DH
;
TB3			.EQU		0350H
TB3L		.EQU		TB3
TB3H		.EQU		TB3+1
;
TB4			.EQU		0352H
TB4L		.EQU		TB4
TB4H		.EQU		TB4+1
;
TB5			.EQU		0354H
TB5L		.EQU		TB5
TB5H		.EQU		TB5+1
;
TB3MR		.EQU		035BH
TMOD0_TB3MR	.BTEQU		0,TB3MR		; OPERATION MODE SELECT BIT
TMOD1_TB3MR	.BTEQU		1,TB3MR		;
MR0_TB3MR	.BTEQU		2,TB3MR		;
MR1_TB3MR	.BTEQU		3,TB3MR		;
MR2_TB3MR	.BTEQU		4,TB3MR		;
MR3_TB3MR	.BTEQU		5,TB3MR		;
TCK0_TB3MR	.BTEQU		6,TB3MR		; COUNT SOURCE SELECT BIT
TCK1_TB3MR	.BTEQU		7,TB3MR		;
;
TB4MR		.EQU		035CH
TMOD0_TB4MR	.BTEQU		0,TB4MR		; OPERATION MODE SELECT BIT
TMOD1_TB4MR	.BTEQU		1,TB4MR		;
MR0_TB4MR	.BTEQU		2,TB4MR		;
MR1_TB4MR	.BTEQU		3,TB4MR		;
MR2_TB4MR	.BTEQU		4,TB4MR		;
MR3_TB4MR	.BTEQU		5,TB4MR		;
TCK0_TB4MR	.BTEQU		6,TB4MR		; COUNT SOURCE SELECT BIT
TCK1_TB4MR	.BTEQU		7,TB4MR		;
;
TB5MR		.EQU		035DH
TMOD0_TB5MR	.BTEQU		0,TB5MR		; OPERATION MODE SELECT BIT
TMOD1_TB5MR	.BTEQU		1,TB5MR		;
MR0_TB5MR	.BTEQU		2,TB5MR		;
MR1_TB5MR	.BTEQU		3,TB5MR		;
MR2_TB5MR	.BTEQU		4,TB5MR		;
MR3_TB5MR	.BTEQU		5,TB5MR		;
TCK0_TB5MR	.BTEQU		6,TB5MR		; COUNT SOURCE SELECT BIT
TCK1_TB5MR	.BTEQU		7,TB5MR		;
;
;-------------------------------------------------------
;	INTERRUPT REQUEST CAUSE SELECT REGISTER
;-------------------------------------------------------
IFSR		.EQU		035FH
IFSR0		.BTEQU		0,IFSR
IFSR1		.BTEQU		1,IFSR
IFSR2		.BTEQU		2,IFSR
IFSR3		.BTEQU		3,IFSR
IFSR4		.BTEQU		4,IFSR
IFSR5		.BTEQU		5,IFSR
IFSR6		.BTEQU		6,IFSR
IFSR7		.BTEQU		7,IFSR
;
;-------------------------------------------------------
;	SI/O 3
;-------------------------------------------------------
S3TRR		.EQU		0360H
S3TRRL		.EQU		S3TRR
S3TRRH		.EQU		S3TRR+1
;
S3C			.EQU		0362H
SM30		.BTEQU		0,S3C
SM31		.BTEQU		1,S3C
SM32		.BTEQU		2,S3C
SM33		.BTEQU		3,S3C
SM35		.BTEQU		5,S3C
SM36		.BTEQU		6,S3C
SM37		.BTEQU		7,S3C
;
S3BRG		.EQU		0363H
;
;-------------------------------------------------------
;	SI/O 4
;-------------------------------------------------------
S4TRR		.EQU		0364H
S4TRRL		.EQU		S4TRR
S4TRRH		.EQU		S4TRR+1
;
S4C			.EQU		0366H
SM40		.BTEQU		0,S4C
SM41		.BTEQU		1,S4C
SM42		.BTEQU		2,S4C
SM43		.BTEQU		3,S4C
SM45		.BTEQU		5,S4C
SM46		.BTEQU		6,S4C
SM47		.BTEQU		7,S4C
;
S4BRG		.EQU		0367H
;
;-------------------------------------------------------
;	UART2
;-------------------------------------------------------
U2SMR2			.EQU		0376H 		; UART2 SPECIAL MODE REGISTER 2
IICM2_U2SMR2	.BTEQU		0,U2SMR2	; IIC MODE SELECTION BIT2
CSC_U2SMR2		.BTEQU		1,U2SMR2	; CLOCK-SYNCHRONOUS BIT
SWC_U2SMR2		.BTEQU		2,U2SMR2	; SCL WAIT OUTPUT BIT
ALS_U2SMR2		.BTEQU		3,U2SMR2	; SDA OUTPUT STOP BIT
STAC_U2SMR2		.BTEQU		4,U2SMR2	; UART2 INITIALIZATION BIT
SWC2_U2SMR2		.BTEQU		5,U2SMR2	; SCL WAIT OUTPUT BIT 2
SDHI_U2SMR2		.BTEQU		6,U2SMR2	; SDA OUTPUT DISABLE BIT
SHTC_U2SMR2		.BTEQU		7,U2SMR2	; START/STOP CONDITION CONTROL BIT
;
U2SMR		.EQU		0377H		; UART2 SPECIAL MODE REGISTER 
IICM_U2SMR	.BTEQU		0,U2SMR		; IIC MODE SELECTION BIT 
ABC_U2SMR	.BTEQU		1,U2SMR		; ARBITRATION LOST DETECTING FLAG CONTROL BIT
BBS_U2SMR	.BTEQU		2,U2SMR		; BUS BUSY FLAG
LSYN_U2SMR	.BTEQU		3,U2SMR		; SCLL SYNC OUTPUT ENABLE BIT
ABSCS_U2SMR	.BTEQU		4,U2SMR		; BUS COLLISION DETECT SAMPRING CLOCK SELECT BIT
ACSE_U2SMR	.BTEQU		5,U2SMR		; AUTO CLEAR FUNCTION SELECT BIT OF TRANSMIT ENABLE BIT
SSS_U2SMR	.BTEQU		6,U2SMR		; TRANSMIT START CONDITION SELECT BIT
;
U2MR		.EQU		0378H		; UART2 TRANSMIT/RECEIVE MODE REGISTER
SMD0_U2MR	.BTEQU		0,U2MR		; SERIAL I/O MODE SELECT BIT
SMD1_U2MR	.BTEQU		1,U2MR		;
SMD2_U2MR	.BTEQU		2,U2MR		;
CKDIR_U2MR	.BTEQU		3,U2MR		; INTERNAL/EXTERNAL CLOCK SELECT BIT
STPS_U2MR	.BTEQU		4,U2MR		; STOP BIT LENGTH SELECTBIT
PRY_U2MR	.BTEQU		5,U2MR		; ODD/EVEN PARITY SELECT BIT
PRYE_U2MR	.BTEQU		6,U2MR		; PARITY ENABLE BIT
IOPOL_U2MR	.BTEQU		7,U2MR		; TXD,RXD I/O POLARITY REVERSE BIT
;
U2BRG		.EQU		0379H		; UART2 BIT RATE GENERATOR
;
U2TB		.EQU		037AH		; UART2 TRANSMIT BUFFER REGISTER
U2TBL		.EQU		U2TB		; 		LOW
U2TBH		.EQU		U2TB+1		;		HIGH
;
U2C0		.EQU		037CH		; UART2 TRANSMIT/RECEIVE CONTROL REGISTER 0
CLK0_U2C0	.BTEQU		0,U2C0		; BRG COUNT SOURCE SELECT BIT
CLK1_U2C0	.BTEQU		1,U2C0		;
CRS_U2C0	.BTEQU		2,U2C0		; CTS/RTS FUNCTION SELECT BIT
TXEPT_U2C0	.BTEQU		3,U2C0		; TRANSMIT REGISTER EMPTY FLAG
CRD_U2C0	.BTEQU		4,U2C0		; CTS/RTS DISABLE BIT
CKPOL_U2C0	.BTEQU		6,U2C0		; CLK POLARITY SELECT BIT
UFORM_U2C0	.BTEQU		7,U2C0		; TRANSFER FORMAT SELECT BIT
;
U2C1		.EQU		037DH		; UART2 TRANSMIT/RECEIVE CONTROL REGISTER 1
TE_U2C1		.BTEQU		0,U2C1		; TRANSMIT ENABLE BIT
TI_U2C1		.BTEQU		1,U2C1		; TRANSMIT BUFFER EMPTY FLAG
RE_U2C1		.BTEQU		2,U2C1		; RECEIVE ENABLE BIT
RI_U2C1		.BTEQU		3,U2C1		; RECEIVE COMPLETE FLAG
U2IRS		.BTEQU		4,U2C1		; UART2 TRANSMIT INTERRUPT CAUSE SELECT BIT
U2RRM		.BTEQU		5,U2C1		; UART2 CONTINUOUS RECEIVE MODE ENABLE BIT
U2LCH		.BTEQU		6,U2C1		; DATA LOGIC SELECT BIT
U2ERE		.BTEQU		7,U2C1		; ERROR SIGNAL OUTPUT ENABLE BIT
U2IRS_U2C1	.BTEQU		4,U2C1
U2RRM_U2C1	.BTEQU		5,U2C1
U2LCH_U2C1	.BTEQU		6,U2C1
U2ERE_U2C1	.BTEQU		7,U2C1
;
U2RB		.EQU		037EH		; UART2 RECEIVE BUFFER REGISTER
U2RBL		.EQU		U2RB		;		LOW
U2RBH		.EQU		U2RB+1		;		HIGH
ABT_U2RB	.BTEQU		3,U2RBH		; ARBITRASTION LOST DETECTING FLAG
OER_U2RB	.BTEQU		4,U2RBH		; OVERRUN ERROR FLAG
FER_U2RB	.BTEQU		5,U2RBH		; FRAMING ERROR FLAG
PER_U2RB	.BTEQU		6,U2RBH		; PARITY ERROR FLAG
SUM_U2RB	.BTEQU		7,U2RBH		; ERROR SUM FLAG
;
;-------------------------------------------------------
;	COUNT START FLAG
;-------------------------------------------------------
TABSR		.EQU		0380H
;
TA0S		.BTEQU		0,TABSR		; TIMER A0 COUNT START FLAG
TA1S		.BTEQU		1,TABSR		; TIMER A1 COUNT START FLAG
TA2S		.BTEQU		2,TABSR		; TIMER A2 COUNT START FLAG
TA3S		.BTEQU		3,TABSR		; TIMER A3 COUNT START FLAG
TA4S		.BTEQU		4,TABSR		; TIMER A4 COUNT START FLAG
TB0S		.BTEQU		5,TABSR		; TIMER B0 COUNT START FLAG
TB1S		.BTEQU		6,TABSR		; TIMER B1 COUNT START FLAG
TB2S		.BTEQU		7,TABSR		; TIMER B2 COUNT START FLAG
;
;-------------------------------------------------------
;	CLOCK PRESCALER RESET FLAG
;-------------------------------------------------------
CPSRF		.EQU		0381H
;
CPSR		.BTEQU		7,CPSRF		; CLOCK PRESCALER RESET FLAG
;
;-------------------------------------------------------
;	ONE-SHOT START FLAG
;-------------------------------------------------------
ONSF		.EQU		0382H
;
TA0OS		.BTEQU		0,ONSF		; TIMER A0 ONE-SHOT START FLAG
TA1OS		.BTEQU		1,ONSF		; TIMER A1 ONE-SHOT START FLAG
TA2OS		.BTEQU		2,ONSF		; TIMER A2 ONE-SHOT START FLAG
TA3OS		.BTEQU		3,ONSF		; TIMER A3 ONE-SHOT START FLAG
TA4OS		.BTEQU		4,ONSF		; TIMER A4 ONE-SHOT START FLAG
TA0TGL		.BTEQU		6,ONSF		; TIMER A0 EVENT/TRIGGER SELECT BIT
TA0TGH		.BTEQU		7,ONSF		;
;
;-------------------------------------------------------
;	TRIGGER SELECT REGISTER
;-------------------------------------------------------
TRGSR		.EQU		0383H
;
TA1TGL		.BTEQU		0,TRGSR		; TIMER A1 EVENT/TRIGGER SELECT BIT
TA1TGH		.BTEQU		1,TRGSR		;
TA2TGL		.BTEQU		2,TRGSR		; TIMER A2 EVENT/TRIGGER SELECT BIT
TA2TGH		.BTEQU		3,TRGSR		;
TA3TGL		.BTEQU		4,TRGSR		; TIMER A3 EVENT/TRIGGER SELECT BIT
TA3TGH		.BTEQU		5,TRGSR		;
TA4TGL		.BTEQU		6,TRGSR		; TIMER A4 EVENT/TRIGGER SELECT BIT
TA4TGH		.BTEQU		7,TRGSR		;
;
;-------------------------------------------------------
;	UP/DOWN FALG
;-------------------------------------------------------
UDF		.EQU		0384H
;
TA0UD		.BTEQU		0,UDF		; TIMER A0 UP/DOWN FALG
TA1UD		.BTEQU		1,UDF		; TIMER A1 UP/DOWN FALG
TA2UD		.BTEQU		2,UDF		; TIMER A2 UP/DOWN FALG
TA3UD		.BTEQU		3,UDF		; TIMER A3 UP/DOWN FALG
TA4UD		.BTEQU		4,UDF		; TIMER A4 UP/DOWN FALG
TA2P		.BTEQU		5,UDF		; TIMER A2 TWO-PHASE PULSE SIGNAL PROCESSING SELECT BIT
TA3P		.BTEQU		6,UDF		; TIMER A3 TWO-PHASE PULSE SIGNAL PROCESSING SELECT BIT
TA4P		.BTEQU		7,UDF		; TIMER A4 TWO-PHASE PULSE SIGNAL PROCESSING SELECT BIT
;
;-------------------------------------------------------
;	TIMER
;-------------------------------------------------------
TA0			.EQU		0386H		; TIMER A0
TA0L		.EQU		TA0			; 		LOW
TA0H		.EQU		TA0+1		; 		HIGH
;
TA1			.EQU		0388H		; TIMER A1
TA1L		.EQU		TA1			; 		LOW
TA1H		.EQU		TA1+1		;		HIGH
;
TA2			.EQU		038AH		; TIMER A2
TA2L		.EQU		TA2			; 		LOW
TA2H		.EQU		TA2+1		;		HIGH
;
TA3			.EQU		038CH		; TIMER A3
TA3L		.EQU		TA3			; 		LOW
TA3H		.EQU		TA3+1		;		HIGH
;
TA4			.EQU		038EH		; TIMER A4
TA4L		.EQU		TA4			; 		LOW
TA4H		.EQU		TA4+1		;		HIGH
;
TB0			.EQU		0390H		; TIMER B0
TB0L		.EQU		TB0			; 		LOW
TB0H		.EQU		TB0+1		;		HIGH
;
TB1			.EQU		0392H		; TIMER B1
TB1L		.EQU		TB1			; 		LOW
TB1H		.EQU		TB1+1		;		HIGH
;
TB2			.EQU		0394H		; TIMERB2
TB2L		.EQU		TB2			; 		LOW
TB2H		.EQU		TB2+1		;		HIGH
;
TA0MR		.EQU		0396H		; TIMER A0 MODE REGISTER
TMOD0_TA0MR	.BTEQU		0,TA0MR		; OPERATION MODE SELECT BIT
TMOD1_TA0MR	.BTEQU		1,TA0MR		;
MR0_TA0MR	.BTEQU		2,TA0MR		;
MR1_TA0MR	.BTEQU		3,TA0MR		;
MR2_TA0MR	.BTEQU		4,TA0MR		;
MR3_TA0MR	.BTEQU		5,TA0MR		;
TCK0_TA0MR	.BTEQU		6,TA0MR		; COUNT SOURCE SELECT BIT
TCK1_TA0MR	.BTEQU		7,TA0MR		;
;
TA1MR		.EQU		0397H		; TIMER A1 MODE REGISTER
TMOD0_TA1MR	.BTEQU		0,TA1MR		; OPERATION MODE SELECT BIT
TMOD1_TA1MR	.BTEQU		1,TA1MR		;
MR0_TA1MR	.BTEQU		2,TA1MR		;
MR1_TA1MR	.BTEQU		3,TA1MR		;
MR2_TA1MR	.BTEQU		4,TA1MR		;
MR3_TA1MR	.BTEQU		5,TA1MR		;
TCK0_TA1MR	.BTEQU		6,TA1MR		; COUNT SOURCE SELECT BIT
TCK1_TA1MR	.BTEQU		7,TA1MR		;
;
TA2MR		.EQU		0398H		; TIMER A2 MODE REGISTER
TMOD0_TA2MR	.BTEQU		0,TA2MR		; OPERATION MODE SELECT BIT
TMOD1_TA2MR	.BTEQU		1,TA2MR		;
MR0_TA2MR	.BTEQU		2,TA2MR		;
MR1_TA2MR	.BTEQU		3,TA2MR		;
MR2_TA2MR	.BTEQU		4,TA2MR		;
MR3_TA2MR	.BTEQU		5,TA2MR		;
TCK0_TA2MR	.BTEQU		6,TA2MR		; COUNT SOURCE SELECT BIT
TCK1_TA2MR	.BTEQU		7,TA2MR		;
;
TA3MR		.EQU		0399H		; TIMER A3 MODE REGISTER
TMOD0_TA3MR	.BTEQU		0,TA3MR		; OPERATION MODE SELECT BIT
TMOD1_TA3MR	.BTEQU		1,TA3MR		;
MR0_TA3MR	.BTEQU		2,TA3MR		;
MR1_TA3MR	.BTEQU		3,TA3MR		;
MR2_TA3MR	.BTEQU		4,TA3MR		;
MR3_TA3MR	.BTEQU		5,TA3MR		;
TCK0_TA3MR	.BTEQU		6,TA3MR		; COUNT SOURCE SELECT BIT
TCK1_TA3MR	.BTEQU		7,TA3MR		;
;
TA4MR		.EQU		039AH		; TIMER A4 MODE REGISTER
TMOD0_TA4MR	.BTEQU		0,TA4MR		; OPERATION MODE SELECT BIT
TMOD1_TA4MR	.BTEQU		1,TA4MR		;
MR0_TA4MR	.BTEQU		2,TA4MR		;
MR1_TA4MR	.BTEQU		3,TA4MR		;
MR2_TA4MR	.BTEQU		4,TA4MR		;
MR3_TA4MR	.BTEQU		5,TA4MR		;
TCK0_TA4MR	.BTEQU		6,TA4MR		; COUNT SOURCE SELECT BIT
TCK1_TA4MR	.BTEQU		7,TA4MR		;
;
TB0MR		.EQU		039BH		; TIMER B0 MODE REGISTER
TMOD0_TB0MR	.BTEQU		0,TB0MR		; OPERATION MODE SELECT BIT
TMOD1_TB0MR	.BTEQU		1,TB0MR		;
MR0_TB0MR	.BTEQU		2,TB0MR		;
MR1_TB0MR	.BTEQU		3,TB0MR		;
MR2_TB0MR	.BTEQU		4,TB0MR		;
MR3_TB0MR	.BTEQU		5,TB0MR		;
TCK0_TB0MR	.BTEQU		6,TB0MR		; COUNT SOURCE SELECT BIT
TCK1_TB0MR	.BTEQU		7,TB0MR		;
;
TB1MR		.EQU		039CH		; TIMER B1 MODE REGISTER
TMOD0_TB1MR	.BTEQU		0,TB1MR		; OPERATION MODE SELECT BIT
TMOD1_TB1MR	.BTEQU		1,TB1MR		;
MR0_TB1MR	.BTEQU		2,TB1MR		;
MR1_TB1MR	.BTEQU		3,TB1MR		;
MR2_TB1MR	.BTEQU		4,TB1MR		;
MR3_TB1MR	.BTEQU		5,TB1MR		;
TCK0_TB1MR	.BTEQU		6,TB1MR		; COUNT SOURCE SELECT BIT
TCK1_TB1MR	.BTEQU		7,TB1MR		;
;
TB2MR		.EQU		039DH		; TIMER B2 MODE REGISTER
TMOD0_TB2MR	.BTEQU		0,TB2MR		; OPERATION MODE SELECT BIT
TMOD1_TB2MR	.BTEQU		1,TB2MR		;
MR0_TB2MR	.BTEQU		2,TB2MR		;
MR1_TB2MR	.BTEQU		3,TB2MR		;
MR2_TB2MR	.BTEQU		4,TB2MR		;
MR3_TB2MR	.BTEQU		5,TB2MR		;
TCK0_TB2MR	.BTEQU		6,TB2MR		; COUNT SOURCE SELECT BIT
TCK1_TB2MR	.BTEQU		7,TB2MR		;
;
;-------------------------------------------------------
;	UART0
;-------------------------------------------------------
U0MR		.EQU		03A0H		; UART0 TRANSMIT/RECEIVE MODE REGISTER
SMD0_U0MR	.BTEQU		0,U0MR		; SERIAL I/O MODE SELECT BIT
SMD1_U0MR	.BTEQU		1,U0MR		;
SMD2_U0MR	.BTEQU		2,U0MR		;
CKDIR_U0MR	.BTEQU		3,U0MR		; INTERNAL/EXTERNAL CLOCK SELECT BIT
STPS_U0MR	.BTEQU		4,U0MR		; STOP BIT LENGTH SELECT BIT
PRY_U0MR	.BTEQU		5,U0MR		; ODD/EVEN PARITY SELECT BIT
PRYE_U0MR	.BTEQU		6,U0MR		; PARITY ENABLE BIT
SLEP_U0MR	.BTEQU		7,U0MR		; SLEEP  SELECT BIT
;
U0BRG		.EQU		03A1H		; UART0 BIT RATE GENERATOR
;
U0TB		.EQU		03A2H		; UART0 TRANSMIT BUFFER REGISTER
U0TBL		.EQU		U0TB		; 		LOW
U0TBH		.EQU		U0TB+1		;		HIGH
;
U0C0		.EQU		03A4H		; UART0 TRANSMIT/RECEIVE CONTROL REGISTER 0
CLK0_U0C0	.BTEQU		0,U0C0		; BRG COUNT SOURCE SELECT BIT
CLK1_U0C0	.BTEQU		1,U0C0		; 
CRS_U0C0	.BTEQU		2,U0C0		; CTS/RTS FUNCTION SELECT BIT
TXEPT_U0C0	.BTEQU		3,U0C0		; TRANSMIT REGISTER EMPTY FLAG
CRD_U0C0	.BTEQU		4,U0C0		; CTS/RTS ENABLE BIT
NCH_U0C0	.BTEQU		5,U0C0		; DATA OUTPUT SELECT BIT
CKPOL_U0C0	.BTEQU		6,U0C0		; CLK POLARITY SELECT BIT
UFORM_U0C0	.BTEQU		7,U0C0		; TRANSFER FORMAT SELECT BIT
;
U0C1		.EQU		03A5H		; UART0 TRANSMIT/RECEIVE CONTROL REGISTER 1
TE_U0C1		.BTEQU		0,U0C1		; TRANSMIT ENABLE BIT
TI_U0C1		.BTEQU		1,U0C1		; TRANSMIT BUFFER EMPTY FLAG
RE_U0C1		.BTEQU		2,U0C1		; RECEIVE ENABLE BIT
RI_U0C1		.BTEQU		3,U0C1		; RECEIVE COMPLETE FLAG
;
U0RB		.EQU		03A6H		; UART0 RECEIVE BUFFER REGISTER
U0RBL		.EQU		U0RB		;		LOW
U0RBH		.EQU		U0RB+1		;		HIGH
ABT_U0RB	.BTEQU		3,U0RBH		; ARBITRASTION LOST DETECTING FLAG
OER_U0RB	.BTEQU		4,U0RBH		; OVERRUN ERROR FLAG
FER_U0RB	.BTEQU		5,U0RBH		; FRAMING ERROR FLAG
PER_U0RB	.BTEQU		6,U0RBH		; PARITY ERROR FLAG
SUM_U0RB	.BTEQU		7,U0RBH		; ERROR SUM FLAG
;
;-------------------------------------------------------
;	UART1					
;-------------------------------------------------------
U1MR		.EQU		03A8H		; UART1 TRANSMIT/RECEIVE MODE REGISTER
SMD0_U1MR	.BTEQU		0,U1MR		; SERIAL I/O MODE SELECT BIT
SMD1_U1MR	.BTEQU		1,U1MR		;
SMD2_U1MR	.BTEQU		2,U1MR		;
CKDIR_U1MR	.BTEQU		3,U1MR		; INTERNAL/EXTERNAL CLOCK SELECT BIT
STPS_U1MR	.BTEQU		4,U1MR		; STOP BIT LENGTH SELECT BIT
PRY_U1MR	.BTEQU		5,U1MR		; ODD/EVEN PARITY SELECT BIT
PRYE_U1MR	.BTEQU		6,U1MR		; PARITY ENABLE BIT
SLEP_U1MR	.BTEQU		7,U1MR		; SLEEP SELECT BIT
;
U1BRG		.EQU		03A9H		; UART1 BIT RATE GENERATOR
;
U1TB		.EQU		03AAH		; UART1 TRANSMIT BUFFER REGISTER
U1TBL		.EQU		U1TB		; 		LOW
U1TBH		.EQU		U1TB+1		;		HIGH
;
U1C0		.EQU		03ACH		; UART1 TRANSMIT/RECEIVE CONTROL REGISTER 0
CLK0_U1C0	.BTEQU		0,U1C0		; BRG COUNT SOURCE SELECT BIT
CLK1_U1C0	.BTEQU		1,U1C0		; 
CRS_U1C0	.BTEQU		2,U1C0		; CTS/RTS FUNCTION SELECT BIT
TXEPT_U1C0	.BTEQU		3,U1C0		; TRANSMIT REGISTER EMPTY FLAG
CRD_U1C0	.BTEQU		4,U1C0		; CTS/RTS DISABLE BIT
NCH_U1C0	.BTEQU		5,U1C0		; DATA OUTPUT SELECT BIT
CKPOL_U1C0	.BTEQU		6,U1C0		; CLK POLARITY  SELECT BIT
UFORM_U1C0	.BTEQU		7,U1C0		; TRANSFER FORMAT SELECT BIT
;
U1C1		.EQU		03ADH		; UART1 TRANSMIT/RECEIVE CONTROL REGISTER 1
TE_U1C1		.BTEQU		0,U1C1		; TRANSMIT ENABLE BIT
TI_U1C1		.BTEQU		1,U1C1		; TRANSMIT BUFFER EMPTY FLAG
RE_U1C1		.BTEQU		2,U1C1		; RECEIVE ENABLE BIT
RI_U1C1		.BTEQU		3,U1C1		; RECEIVE COMPLETE FLAG
;
U1RB		.EQU		03AEH		; UART1 RECEIVE REGISTER
U1RBL		.EQU		U1RB		;		LOW
U1RBH		.EQU		U1RB+1		;		HIGH
ABT_U1RB	.BTEQU		3,U1RBH		; ARBITRASTION LOST DETECTING FLAG
OER_U1RB	.BTEQU		4,U1RBH		; OVERRUN ERROR FLAG
FER_U1RB	.BTEQU		5,U1RBH		; FRAMING ERROR FLAG
PER_U1RB	.BTEQU		6,U1RBH		; PARITY ERROR FLAG
SUM_U1RB	.BTEQU		7,U1RBH		; ERROR SUM FLAG
;
UCON		.EQU		03B0H		; UART TRANSMIT/RECEIVE CONTROL REGISTER 2
U0IRS		.BTEQU		0,UCON		; UART0 TRANSMIT INTERRUPT CAUSE SELECTBIT
U1IRS		.BTEQU		1,UCON		; UART1 TRANSMIT INTERRUPT CAUSE SELECTBIT
U0RRM		.BTEQU		2,UCON		; UART0 CONTINUOUS RECEIVE MODE DISABLE BIT
U1RRM		.BTEQU		3,UCON		; UART1 CONTINUOUS RECEIVE MODE DISABLE BIT
CLKMD0		.BTEQU		4,UCON		; CLK/CLKS SELECT BIT
CLKMD1		.BTEQU		5,UCON		;
RCSP		.BTEQU		6,UCON		; SEPARATE RTS/CTS BIT
;
;-------------------------------------------------------
;   FLASH CONTROL REGISTER 
;-------------------------------------------------------
FMCR     .EQU    03B7H
;
FMCR0        .BTEQU  0,FMCR       ; RY/BY STATUS BIT
FMCR1        .BTEQU  1,FMCR       ; FLASH ENTRY BIT
FMCR2        .BTEQU  2,FMCR       ; LOCK DISABLE BIT
FMCR3        .BTEQU  3,FMCR       ; FLASH RESET BIT
;
;--------------------------------------------------------
;	DMA REQUEST CAUSE SELECT REGISTER
;--------------------------------------------------------
DM0SL		.EQU		03B8H		; DMA0 REQUEST CAUSE SELECT REGISTER
DSEL0_DM0SL	.BTEQU		0,DM0SL		; DMA REQUEST CAUSE SELECT BIT
DSEL1_DM0SL	.BTEQU		1,DM0SL		;
DSEL2_DM0SL	.BTEQU		2,DM0SL		;
DSEL3_DM0SL	.BTEQU		3,DM0SL		;
DMS_DM0SL	.BTEQU		6,DM0SL		;
DSR_DM0SL	.BTEQU		7,DM0SL		; SOFTWARE DMA REQUEST BIT
;
DM1SL		.EQU		03BAH		; DMA1 REQUEST CAUSE SELECT REGISTER
DSEL0_DM1SL	.BTEQU		0,DM1SL		; DMA REQUEST CAUSE SELECT BIT
DSEL1_DM1SL	.BTEQU		1,DM1SL		;
DSEL2_DM1SL	.BTEQU		2,DM1SL		;
DSEL3_DM1SL	.BTEQU		3,DM1SL		;
DMS_DM1SL	.BTEQU		6,DM1SL		;
DSR_DM1SL	.BTEQU		7,DM1SL		; SOFTWARE DMA REQUEST BIT
;
;-------------------------------------------------------
;	CRC
;-------------------------------------------------------
CRCD		.EQU		03BCH		; CRC DATA REGISTER
CRCDL		.EQU		CRCD		;		LOW
CRCDH		.EQU		CRCD+1		;		HIGH
;
CRCIN		.EQU		03BEH		; CRC INPUT REGISTER
;
;-------------------------------------------------------
;	A-D, D-A
;-------------------------------------------------------
AD0			.EQU		03C0H		; AD REGISTER 0
AD0L		.EQU		AD0			;		LOW
AD0H		.EQU		AD0+1		;		HIGH
;
AD1			.EQU		03C2H		; AD REGISTER 1
AD1L		.EQU		AD1			;		LOW
AD1H		.EQU		AD1+1		;		HIGH
;
AD2			.EQU		03C4H		; AD REGISTER 2
AD2L		.EQU		AD2			;		LOW
AD2H		.EQU		AD2+1		;		HIGH
;
AD3			.EQU		03C6H		; AD REGISTER 3
AD3L		.EQU		AD3			;		LOW
AD3H		.EQU		AD3+1		;		HIGH
;
AD4			.EQU		03C8H		; AD REGISTER 4
AD4L		.EQU		AD4			;		LOW
AD4H		.EQU		AD4+1		;		HIGH
;
AD5			.EQU		03CAH		; AD REGISTER 5
AD5L		.EQU		AD5			;		LOW
AD5H		.EQU		AD5+1		;		HIGH
;
AD6			.EQU		03CCH		; AD REGISTER 6
AD6L		.EQU		AD6			;		LOW
AD6H		.EQU		AD6+1		;		HIGH
;
AD7			.EQU		03CEH		; AD REGISTER 7
AD7L		.EQU		AD7			;		LOW
AD7H		.EQU		AD7+1		;		HIGH
;
ADCON2		.EQU		03D4H		; AD CONTROL REGISTER 2
SMP			.BTEQU		0,ADCON2	; AD CONVERSION METHOD SELECT BIT
;
ADCON0		.EQU		03D6H		; AD CONTROL REGISTER 0
CH0			.BTEQU		0,ADCON0	; ANALOG INPUT SELECT BIT
CH1			.BTEQU		1,ADCON0	;
CH2			.BTEQU		2,ADCON0	;
MD0			.BTEQU		3,ADCON0	; AD OPERATION MODE SELECT BIT 0
MD1			.BTEQU		4,ADCON0	;
TRG			.BTEQU		5,ADCON0	; TRIGGER SELECT BIT
ADST		.BTEQU		6,ADCON0	; AD CONVERSION START FLAG
CKS0		.BTEQU		7,ADCON0	; FREQUENCY SELECT BIT 0
;
ADCON1		.EQU		03D7H		; AD CONTROL REGISTER 1
SCAN0		.BTEQU		0,ADCON1	; AD SWEEP PIN SELECT BIT
SCAN1		.BTEQU		1,ADCON1	;
MD2			.BTEQU		2,ADCON1	; AD OPERATION MODE SELECT BIT 1
BITS		.BTEQU		3,ADCON1	; 8/10 BIT MODE SELECT BIT
CKS1		.BTEQU		4,ADCON1	; FREQUENCY SELECT BIT1
VCUT		.BTEQU		5,ADCON1	; VREF CONNECT BIT
OPA0		.BTEQU		6,ADCON1	; EXTERNAL OP-AMP CONNECTION MODE BIT
OPA1		.BTEQU		7,ADCON1	;
;
;-----------------------------------------------
;
DA0			.EQU		03D8H		; DA REGISTER 0
;
DA1			.EQU		03DAH		; DA REGISTER1
;
DACON		.EQU		03DCH		; DA CONTROL REGISTER
DA0E		.BTEQU		0,DACON		; DA0 OUTPUT ENABLE BIT
DA1E		.BTEQU		1,DACON		; DA1 OUTPUT ENABLE BIT
;
;
;-------------------------------------------------------
;	PORT						
;-------------------------------------------------------
P0			.EQU		03E0H		; PORT P0
P0_0		.BTEQU		0,P0
P0_1		.BTEQU		1,P0
P0_2		.BTEQU		2,P0
P0_3		.BTEQU		3,P0
P0_4		.BTEQU		4,P0
P0_5		.BTEQU		5,P0
P0_6		.BTEQU		6,P0
P0_7		.BTEQU		7,P0
;
P1			.EQU		03E1H		; PORT P1
P1_0		.BTEQU		0,P1
P1_1		.BTEQU		1,P1
P1_2		.BTEQU		2,P1
P1_3		.BTEQU		3,P1
P1_4		.BTEQU		4,P1
P1_5		.BTEQU		5,P1
P1_6		.BTEQU		6,P1
P1_7		.BTEQU		7,P1
;
PD0			.EQU		03E2H		; PORT P0 DIRECTION REGISTER
PD0_0		.BTEQU		0,PD0
PD0_1		.BTEQU		1,PD0
PD0_2		.BTEQU		2,PD0
PD0_3		.BTEQU		3,PD0
PD0_4		.BTEQU		4,PD0
PD0_5		.BTEQU		5,PD0
PD0_6		.BTEQU		6,PD0
PD0_7		.BTEQU		7,PD0
;
PD1			.EQU		03E3H		; PORT P1 DIRECTION REGISTER
PD1_0		.BTEQU		0,PD1
PD1_1		.BTEQU		1,PD1
PD1_2		.BTEQU		2,PD1
PD1_3		.BTEQU		3,PD1
PD1_4		.BTEQU		4,PD1
PD1_5		.BTEQU		5,PD1
PD1_6		.BTEQU		6,PD1
PD1_7		.BTEQU		7,PD1
;
P2			.EQU		03E4H		; PORT P2
P2_0		.BTEQU		0,P2
P2_1		.BTEQU		1,P2
P2_2		.BTEQU		2,P2
P2_3		.BTEQU		3,P2
P2_4		.BTEQU		4,P2
P2_5		.BTEQU		5,P2
P2_6		.BTEQU		6,P2
P2_7		.BTEQU		7,P2
;
P3			.EQU		03E5H		; PORT P3
P3_0		.BTEQU		0,P3
P3_1		.BTEQU		1,P3
P3_2		.BTEQU		2,P3
P3_3		.BTEQU		3,P3
P3_4		.BTEQU		4,P3
P3_5		.BTEQU		5,P3
P3_6		.BTEQU		6,P3
P3_7		.BTEQU		7,P3
;
PD2			.EQU		03E6H		; PORT P2 DIRECTION REGISTER
PD2_0		.BTEQU		0,PD2
PD2_1		.BTEQU		1,PD2
PD2_2		.BTEQU		2,PD2
PD2_3		.BTEQU		3,PD2
PD2_4		.BTEQU		4,PD2
PD2_5		.BTEQU		5,PD2
PD2_6		.BTEQU		6,PD2
PD2_7		.BTEQU		7,PD2
;
PD3			.EQU		03E7H		; PORT P3 DIRECTION REGISTER
PD3_0		.BTEQU		0,PD3
PD3_1		.BTEQU		1,PD3
PD3_2		.BTEQU		2,PD3
PD3_3		.BTEQU		3,PD3
PD3_4		.BTEQU		4,PD3
PD3_5		.BTEQU		5,PD3
PD3_6		.BTEQU		6,PD3
PD3_7		.BTEQU		7,PD3
;
P4			.EQU		03E8H		; PORT P4
P4_0		.BTEQU		0,P4
P4_1		.BTEQU		1,P4
P4_2		.BTEQU		2,P4
P4_3		.BTEQU		3,P4
P4_4		.BTEQU		4,P4
P4_5		.BTEQU		5,P4
P4_6		.BTEQU		6,P4
P4_7		.BTEQU		7,P4
;
P5			.EQU		03E9H		; PORT P5
P5_0		.BTEQU		0,P5
P5_1		.BTEQU		1,P5
P5_2		.BTEQU		2,P5
P5_3		.BTEQU		3,P5
P5_4		.BTEQU		4,P5
P5_5		.BTEQU		5,P5
P5_6		.BTEQU		6,P5
P5_7		.BTEQU		7,P5
;
PD4			.EQU		03EAH		; PORT P4 DIRECTION REGISTER
PD4_0		.BTEQU		0,PD4
PD4_1		.BTEQU		1,PD4
PD4_2		.BTEQU		2,PD4
PD4_3		.BTEQU		3,PD4
PD4_4		.BTEQU		4,PD4
PD4_5		.BTEQU		5,PD4
PD4_6		.BTEQU		6,PD4
PD4_7		.BTEQU		7,PD4
;
PD5			.EQU		03EBH		; PORT P5 DIRECTION REGISTER
PD5_0		.BTEQU		0,PD5
PD5_1		.BTEQU		1,PD5
PD5_2		.BTEQU		2,PD5
PD5_3		.BTEQU		3,PD5
PD5_4		.BTEQU		4,PD5
PD5_5		.BTEQU		5,PD5
PD5_6		.BTEQU		6,PD5
PD5_7		.BTEQU		7,PD5
;
P6			.EQU		03ECH		; PORT P6
P6_0		.BTEQU		0,P6
P6_1		.BTEQU		1,P6
P6_2		.BTEQU		2,P6
P6_3		.BTEQU		3,P6
P6_4		.BTEQU		4,P6
P6_5		.BTEQU		5,P6
P6_6		.BTEQU		6,P6
P6_7		.BTEQU		7,P6
;
P7			.EQU		03EDH		; PORT P7
P7_0		.BTEQU		0,P7
P7_1		.BTEQU		1,P7
P7_2		.BTEQU		2,P7
P7_3		.BTEQU		3,P7
P7_4		.BTEQU		4,P7
P7_5		.BTEQU		5,P7
P7_6		.BTEQU		6,P7
P7_7		.BTEQU		7,P7
;
PD6			.EQU		03EEH		; PORT P6 DIRECTION REGISTER
PD6_0		.BTEQU		0,PD6
PD6_1		.BTEQU		1,PD6
PD6_2		.BTEQU		2,PD6
PD6_3		.BTEQU		3,PD6
PD6_4		.BTEQU		4,PD6
PD6_5		.BTEQU		5,PD6
PD6_6		.BTEQU		6,PD6
PD6_7		.BTEQU		7,PD6
;
PD7			.EQU		03EFH		; PORT P7 DIRECTION REGISTER
PD7_0		.BTEQU		0,PD7
PD7_1		.BTEQU		1,PD7
PD7_2		.BTEQU		2,PD7
PD7_3		.BTEQU		3,PD7
PD7_4		.BTEQU		4,PD7
PD7_5		.BTEQU		5,PD7
PD7_6		.BTEQU		6,PD7
PD7_7		.BTEQU		7,PD7
;
P8			.EQU		03F0H		; PORT P8
P8_0		.BTEQU		0,P8
P8_1		.BTEQU		1,P8
P8_2		.BTEQU		2,P8
P8_3		.BTEQU		3,P8
P8_4		.BTEQU		4,P8
P8_5		.BTEQU		5,P8
P8_6		.BTEQU		6,P8
P8_7		.BTEQU		7,P8
;
P9			.EQU		03F1H		; PORT P9
P9_0		.BTEQU		0,P9
P9_1		.BTEQU		1,P9
P9_2		.BTEQU		2,P9
P9_3		.BTEQU		3,P9
P9_4		.BTEQU		4,P9
P9_5		.BTEQU		5,P9
P9_6		.BTEQU		6,P9
P9_7		.BTEQU		7,P9
;
PD8			.EQU		03F2H		; PORT P8 DIRECTION REGISTER
PD8_0		.BTEQU		0,PD8
PD8_1		.BTEQU		1,PD8
PD8_2		.BTEQU		2,PD8
PD8_3		.BTEQU		3,PD8
PD8_4		.BTEQU		4,PD8
PD8_5		.BTEQU		5,PD8
PD8_6		.BTEQU		6,PD8
PD8_7		.BTEQU		7,PD8
;
PD9			.EQU		03F3H		; PORT P9 DIRECTION REGISTER
PD9_0		.BTEQU		0,PD9
PD9_1		.BTEQU		1,PD9
PD9_2		.BTEQU		2,PD9
PD9_3		.BTEQU		3,PD9
PD9_4		.BTEQU		4,PD9
PD9_5		.BTEQU		5,PD9
PD9_6		.BTEQU		6,PD9
PD9_7		.BTEQU		7,PD9
;
P10			.EQU		03F4H		; PORT P10
P10_0		.BTEQU		0,P10
P10_1		.BTEQU		1,P10
P10_2		.BTEQU		2,P10
P10_3		.BTEQU		3,P10
P10_4		.BTEQU		4,P10
P10_5		.BTEQU		5,P10
P10_6		.BTEQU		6,P10
P10_7		.BTEQU		7,P10
;
PD10		.EQU		03F6H		; PORT P10 DIRECTION REGISTER
PD10_0		.BTEQU		0,PD10 
PD10_1		.BTEQU		1,PD10
PD10_2		.BTEQU		2,PD10
PD10_3		.BTEQU		3,PD10
PD10_4		.BTEQU		4,PD10
PD10_5		.BTEQU		5,PD10
PD10_6		.BTEQU		6,PD10
PD10_7		.BTEQU		7,PD10
;
;-------------------------------------------------------
;	PULL-UP CONTROL REGISTER
;-------------------------------------------------------
PUR0		.EQU		03FCH		; PULL-UP CONTROL REGISTER 0
;
PU00		.BTEQU		0,PUR0		; PULL-UP REGISTER 00
PU01		.BTEQU		1,PUR0		; PULL-UP REGISTER 01
PU02		.BTEQU		2,PUR0		; PULL-UP REGISTER 02
PU03		.BTEQU		3,PUR0		; PULL-UP REGISTER 03
PU04		.BTEQU		4,PUR0		; PULL-UP REGISTER 04
PU05		.BTEQU		5,PUR0		; PULL-UP REGISTER 05
PU06		.BTEQU		6,PUR0		; PULL-UP REGISTER 06
PU07		.BTEQU		7,PUR0		; PULL-UP REGISTER 07
;
PUR1		.EQU		03FDH		; PULL-UP CONTROL REGISTER 1
;
PU10		.BTEQU		0,PUR1		; PULL-UP REGISTER 10
PU11		.BTEQU		1,PUR1		; PULL-UP REGISTER 11
PU12		.BTEQU		2,PUR1		; PULL-UP REGISTER 12
PU13		.BTEQU		3,PUR1		; PULL-UP REGISTER 13
PU14		.BTEQU		4,PUR1		; PULL-UP REGISTER 14
PU15		.BTEQU		5,PUR1		; PULL-UP REGISTER 15
PU16		.BTEQU		6,PUR1		; PULL-UP REGISTER 16
PU17		.BTEQU		7,PUR1		; PULL-UP REGISTER 17
;
PUR2		.EQU		03FEH		; PULL-UP CONTROL REGISTER 2
;
PU20		.BTEQU		0,PUR2		; PULL-UP REGISTER 20
PU21		.BTEQU		1,PUR2		; PULL-UP REGISTER 21
PU22		.BTEQU		2,PUR2		; PULL-UP REGISTER 22
PU23		.BTEQU		3,PUR2		; PULL-UP REGISTER 23
PU24		.BTEQU		4,PUR2		; PULL-UP REGISTER 24
PU25		.BTEQU		5,PUR2		; PULL-UP REGISTER 25
;
;-------------------------------------------------------
;	PORT CONTROL REGISTER
;-------------------------------------------------------
PCR			.EQU		03FFH
;

