program jedec(input,output);

const namelen=20;(*Maximum length of filename*)
      csumlen=4;(*Length of file checksum*)
      rfldlen=8;cfldlen=4;(*Lengths of the resulting vector and
                            check sum fields respectively*)
      gfldlen=1;ffldlen=1;(*Lengths of the security fuse and default
                            fuse state fields respectively*)
      pnamelen=8;(*Maximum length of a PAL name*)
      (*List of ascii codes that will have to be modified to run
        the program under another coding scheme*)
      zerocode=48;onecode=49;
      stx=2;etx=3;linefeed=10;newline=13;blank=32;asterisk=42;
      ccode=67;dcode=68;fcode=70;gcode=71;lcode=76;mcode=77;
      pcode=80;qcode=81;rcode=82;scode=83;tcode=84;vcode=86;

type fnamestr=string[namelen];
     csumstr=packed array[1..csumlen]of char;
     pnametype=packed array[1..pnamelen]of char;
     codes=0..127;

var filein,fileout:text;
    linenum,msdigits,checksum,errcount:integer;
    bindigits,decdigits,hexdigits,delimiters,fieldchars,
    fieldids,options,valfields,testconds,pseqfields,
    flistfields,printables:set of codes;

{$I iostuff.pas}

(****************************************************************)

procedure createsets;

begin
  (*This set of assignments is for the ascii set of codes only.
    The asterisk,etx, and delimiters are allowed as elements
    of all fields*)
  bindigits:=[3,9,10,13,32,42,48,49];
  decdigits:=[3,9,10,13,32,42,48..57];
  hexdigits:=[3,9,10,13,32,42,48..57,65..70];
  delimiters:=[9,10,13,32];
  fieldchars:=[3,9,10,13,32..126];
  fieldids:=[67,68,70,71,76,77,80..84,86];
  options:=[3,42,71,77,81..84];
  valfields:=[70,80,86];
  testconds:=[3,32,42,48..57,67,70,72,75,76,78,80,88,90];
  pseqfields:=[3,9,10,13,32,42,48..57];
  flistfields:=[3,9,10,13,32,42,48,49];
end;

(****************************************************************)

procedure errmsg(errnumber,linenumber:integer);

const questmark=63;

begin
  writeln;
  if errnumber<>23 then
  begin
    errcount:=errcount+1;
    writeln('Error number ',errnumber,' in line ',linenumber);
    write(fileout,chr(questmark));
  end;
  case errnumber of
    0:begin
        writeln('Input file does not begin with start-of-text.');
        writeln('Output file will contain garbage.');
      end;
    1:writeln('Invalid non-printable character in header.');
    2:writeln('Invalid field identifier.');
    3:writeln('Checksum character is not a hex digit.');
    4:writeln('Unprintable character in the device field.');
    5:writeln('Default fuse state is not a binary digit.');
    6:writeln('Security fuse state is not a binary digit.');
    7:writeln('Fuse list field doesn"t begin with a decimal number.');
    8:writeln('Invalid fuse list field element.');
    9:writeln('Unprintable character in the option field.');
    10:writeln('Invalid name in pin sequence.');
    11:writeln('Undefined option in the value field.');
    12:writeln('Non-decimal number in the value field.');
    13:writeln('Resulting vector field character isn"t a hex digit.');
    14:writeln('Invalid test condition for starting vector.');
    15:writeln('Non-decimal number in the test cycles field.');
    16:writeln('Test vector field doesn"t begin with decimal number.');
    17:writeln('Invalid test condition for a test vector.');
    18:writeln('Checksum field is not 4 characters long.');
    19:writeln('Resulting vector field is not 8 characters long.');
    20:writeln('Security fuse does not have one state defined.');
    21:writeln('Default fuse state does not have one state defined.');
    22:writeln('Input file does not end with end-of-text.');
    23:writeln('Warning:Invalid PAL name. 20-pin default assumed.');
    24:writeln('Incorrect number of names in the pin sequence list.');
    25:writeln('Starting vector is of incorrect length.');
    26:writeln('Test vector is of incorrect length.');
  end;
  writeln;
end;

(***************************************************************)

procedure hexconvert(var msd,chksum:integer;var hexchksum:csumstr);

const base=16;


var i,tempnum:integer;
    hexdata:packed array[1..16]of char;

begin
  hexdata:='0123456789ABCDEF';
  tempnum:=(msd mod base)+1;
  hexchksum[1]:=hexdata[tempnum];
  for i:=cfldlen downto 2 do
  begin
    tempnum:=(chksum mod base)+1;
    hexchksum[i]:=hexdata[tempnum];
    chksum:=chksum div base;
  end;
end;

(***************************************************************)

function strchecksum(var anystring:csumstr):integer;

var i,tempchecksum:integer;
    tempchar:char;

begin
  tempchecksum:=0;
  for i:=1 to csumlen do
  begin
    tempchar:=anystring[i];
    tempchecksum:=tempchecksum+ord(tempchar);
  end;
  strchecksum:=tempchecksum;
end;

(***************************************************************)

function intchecksum(anyint:integer):integer;

var remainder,tempchecksum,tempint:integer;

begin
  tempchecksum:=0;
  tempint:=anyint;
  while tempint>0 do
  begin
    remainder:=tempint mod 10;
    tempint:=tempint div 10;
    tempchecksum:=tempchecksum+zerocode+remainder;
  end;
  intchecksum:=tempchecksum;
end;

(***************************************************************)

procedure palinfo(pname:pnametype;var numofpins,numoffuses:integer);

const numofpals=29;numof20=15;(*Current count of 20-pin PAL's*)

type palspecs=record
                paltype:string[5];
                pinnum,fusenum:integer;
              end;

var i,j:integer;
    palnumstr:packed array[1..5]of char;
    paldata:array[1..numofpals]of palspecs;

begin
  (*Remove the prefix "PAL" from the PAL name*)
  for i:=1 to 5 do palnumstr[i]:=pname[i+3];
  (*Store the PAL names and associated information in the array
    of records*)
  paldata[1].paltype:='10H8 ';
  paldata[2].paltype:='12H6 ';
  paldata[3].paltype:='14H4 ';
  paldata[4].paltype:='16H2 ';
  paldata[5].paltype:='16C1 ';
  paldata[6].paltype:='10L8 ';
  paldata[7].paltype:='12L6 ';
  paldata[8].paltype:='14L4 ';
  paldata[9].paltype:='16L2 ';
  paldata[10].paltype:='16L8 ';
  paldata[11].paltype:='16R8 ';
  paldata[12].paltype:='16R6 ';
  paldata[13].paltype:='16R4 ';
  paldata[14].paltype:='16X4 ';
  paldata[15].paltype:='16A4 ';
  paldata[16].paltype:='12L10';
  paldata[17].paltype:='14L8 ';
  paldata[18].paltype:='16L6 ';
  paldata[19].paltype:='18L4 ';
  paldata[20].paltype:='20L2 ';
  paldata[21].paltype:='20C1 ';
  paldata[22].paltype:='20L10';
  paldata[23].paltype:='20X10';
  paldata[24].paltype:='20X8 ';
  paldata[25].paltype:='20X4 ';
  paldata[26].paltype:='20L8 ';
  paldata[27].paltype:='20R8 ';
  paldata[28].paltype:='20R6 ';
  paldata[29].paltype:='20R4 ';
  for i:=1 to numof20 do paldata[i].pinnum:=20;
  for i:=16 to numofpals do paldata[i].pinnum:=24;
  (*Default of 2560 fuses per PAL assumed*)
  for i:=1 to numofpals do paldata[i].fusenum:=2560;
  i:=1;
  j:=1;
  while ((j<=5)and(i<=numofpals)) do
  if palnumstr[j]=paldata[i].paltype[j] then j:=j+1 else
  begin
    i:=i+1;
    j:=1;
  end;
  j:=j-1;(*To allow for the extra time that "j" was incremented after
           the match is discovered*)
  if j=5 then
  begin
    (*"i" now contains the position of the PAL named*)
    numofpins:=paldata[i].pinnum;
    numoffuses:=paldata[i].fusenum;
  end
  else
  begin
    numofpins:=20;
    numoffuses:=2560;
  end;
end;

(***************************************************************)

procedure reformat;

const cubed16=4096;seventh2=128;

(******************************)

procedure checkheader(var endfield,endoffile:boolean;var pins,fuses:integer);

var i,errcode,tempcode:integer;
    palname:pnametype;
    tempchar:char;
    validchar,eolflag:boolean;

begin
  errcode:=0;
  validchar:=false;
  read(filein,tempchar);
  while ((ord(tempchar)<>stx)and(ord(tempchar)<>etx)
  and(not(eof(filein)))) do
    read(filein,tempchar);
  validchar:=ord(tempchar)=stx;
  endoffile:=((ord(tempchar)=etx)or(eof(filein)));
  if validchar then write(fileout,tempchar)
  else errmsg(errcode,linenum);
  if not endoffile then
  begin
    checksum:=checksum+ord(tempchar);
    eolflag:=eoln(filein);
    read(filein,tempchar);
    tempcode:=ord(tempchar);
    endfield:=tempcode=asterisk;
    while tempcode in delimiters do
    begin
      if eolflag then
      begin
        linenum:=linenum+1;
        checksum:=checksum+linefeed+newline;
        write(fileout,chr(newline));
      end
      else
      begin
        write(fileout,tempchar);
        if(tempcode<>linefeed) then checksum:=checksum+tempcode;
      end;
      eolflag:=eoln(filein);
      read(filein,tempchar);
      tempcode:=ord(tempchar);
    end;
    write(fileout,tempchar);
    checksum:=checksum+ord(tempchar);
    i:=1;
    if not endfield then
    begin
      while((i<=pnamelen)and(not endfield)) do
      begin
        palname[i]:=tempchar;
        eolflag:=eoln(filein);
        read(filein,tempchar);
        tempcode:=ord(tempchar);
        if eolflag then
        begin
          linenum:=linenum+1;
          checksum:=checksum+linefeed+newline;
          write(fileout,chr(newline));
        end
        else
        begin
          write(fileout,tempchar);
          if(tempcode<>linefeed) then checksum:=checksum+tempcode;
        end;
        endfield:=((tempcode=asterisk)or(tempcode=etx));
        endoffile:=((eof(filein))or(tempcode=etx));
        i:=i+1;
      end;
    end;
    errcode:=23;
    if endfield then errmsg(errcode,linenum);
    palinfo(palname,pins,fuses);
    errcode:=1;
  end;
  while not((endfield)or(endoffile)) do
  begin
    validchar:=false;
    eolflag:=eoln(filein);
    read(filein,tempchar);
    tempcode:=ord(tempchar);
    if checksum>cubed16 then
    begin
      msdigits:=msdigits+1;
      checksum:=checksum-cubed16;
    end;
    validchar:=tempcode in fieldchars;
    endfield:=((tempcode=asterisk)or(tempcode=etx));
    endoffile:=((eof(filein))or(tempcode=etx));
    if eolflag then
    begin
      linenum:=linenum+1;
      checksum:=checksum+linefeed+newline;
      write(fileout,chr(newline));
    end
    else
    begin
      if validchar then write(fileout,tempchar)
      else errmsg(errcode,linenum);
      if(tempcode<>linefeed) then checksum:=checksum+tempcode;
    end;
  end;
end;

(******************************)

procedure checkfields(var endfield,endoffile:boolean;pins,fuses:integer);

var validchar,firstfusefld,beginfields,endnumber,addedline:boolean;
    fieldidok,cfieldok,rfieldok,gfieldok,ffieldok,sfieldok:boolean;
    pfieldok,vfieldok,allok1,allok2,allok,fusesover,eolflag:boolean;
    pinlabel:boolean;
    tempchar:char;
    hexfusecsum:csumstr;
    fieldlen,errcode,tempcode,currfield,fusecsum,fusemsd:integer;
    labels,veclen,currlvalue,oldlvalue,count,oldfield,i:integer;

begin
  beginfields:=true;
  fusesover:=false;
  count:=1;
  currfield:=0;
  currlvalue:=0;
  errcode:=2;
  fusecsum:=0;
  fusemsd:=0;
  writeln;
  write('Reformatting - please wait  ');
  while not endoffile do
  begin
    write('.');
    addedline:=false;
    eolflag:=eoln(filein);
    read(filein,tempchar);
    tempcode:=ord(tempchar);
    while tempcode in delimiters do
    begin
      if eolflag then
      begin
        addedline:=true;
        write(fileout,chr(newline));
        linenum:=linenum+1;
        checksum:=checksum+linefeed+newline;
      end
      else
      begin
        write(fileout,tempchar);
        if(tempcode<>linefeed) then checksum:=checksum+tempcode;
      end;
      eolflag:=eoln(filein);
      read(filein,tempchar);
      tempcode:=ord(tempchar);
    end;
    if not addedline then
    begin
      write(fileout,chr(linefeed),chr(newline));
      checksum:=checksum+linefeed+newline;
      addedline:=false;
    end;
    if beginfields then
    begin
      writeln(fileout,'QP',pins:2,'*');
      writeln(fileout,'QF',fuses:4,'*');
      writeln;
      writeln('**** QP',pins:2,' and QF',fuses:4,' inserted. ****');
      checksum:=checksum+2*(asterisk+linefeed+newline);
      checksum:=checksum+2*qcode+pcode+fcode;
      checksum:=checksum+intchecksum(pins)+intchecksum(fuses);
      beginfields:=false;
    end;
    oldfield:=currfield;
    currfield:=tempcode;
    firstfusefld:=((currfield=lcode)and(oldfield<>lcode));
    if firstfusefld then
    begin
      writeln(fileout,'F0*');
      writeln;
      writeln('**** Default fuse state F0 inserted ****');
      checksum:=checksum+fcode+zerocode+asterisk+linefeed+newline;
      firstfusefld:=false;
    end;
    endoffile:=tempcode=etx;
    fusesover:=(oldfield=lcode)and(currfield<>lcode);
    if fusesover then
    begin
      hexconvert(fusemsd,fusecsum,hexfusecsum);
      write(fileout,'C');
      for i:=1 to csumlen do write(fileout,hexfusecsum[i]);
      write(fileout,'*');
      write(fileout,chr(linefeed),chr(newline));
      writeln;
      write('**** Fuse link check sum C');
      for i:=1 to csumlen do write(hexfusecsum[i]);
      writeln(' inserted. ****');
      fusesover:=false;
      checksum:=checksum+ccode+asterisk+linefeed+newline;
      checksum:=checksum+strchecksum(hexfusecsum);
    end;
    fieldidok:=currfield in fieldids;
    write(fileout,tempchar);
    endfield:=false;
    endnumber:=false;
    pinlabel:=false;
    fieldlen:=0;
    veclen:=0;
    labels:=0;
    oldlvalue:=0;
    checksum:=checksum+currfield;
    if checksum>cubed16 then
    begin
      msdigits:=msdigits+1;
      checksum:=checksum-cubed16;
    end;
    while not((endfield)or(endoffile)) do
    begin
      validchar:=false;
      eolflag:=eoln(filein);
      read(filein,tempchar);
      tempcode:=ord(tempchar);
      endfield:=((tempcode=asterisk)or(tempcode=etx));
      endoffile:=((eof(filein))or(tempcode=etx));
      if checksum>cubed16 then
      begin
        msdigits:=msdigits+1;
        checksum:=checksum-cubed16;
      end;
      if fieldidok then
      begin
        case currfield of
          ccode,rcode:validchar:=tempcode in hexdigits;
          dcode,mcode:validchar:=tempcode in fieldchars;
          fcode,gcode:validchar:=tempcode in bindigits;
          lcode:
            begin
              if not endnumber then
              begin
                if not(tempcode in delimiters) then
                  oldlvalue:=10*oldlvalue+tempcode-zerocode
                else
                begin
                  if oldlvalue>currlvalue then
                    for i:=1 to oldlvalue-currlvalue do
                    begin
                      count:=2*(count mod seventh2);
                      if count=0 then count:=1;
                    end;
                  currlvalue:=oldlvalue;
                end;
                endnumber:=tempcode in delimiters;
                validchar:=((tempcode in decdigits)or(endnumber));
              end
              else
              begin
                validchar:=tempcode in flistfields;
                if((tempcode=zerocode)or(tempcode=onecode)) then
                begin
                  currlvalue:=currlvalue+1;
                  if tempcode=onecode then fusecsum:=fusecsum+count;
                  count:=2*(count mod seventh2);
                  if count=0 then count:=1;
                end;
                if fusecsum>cubed16 then
                begin
                  fusemsd:=fusemsd+1;
                  fusecsum:=fusecsum-cubed16;
                end;
              end;
            end;
          pcode:
            begin
              validchar:=tempcode in pseqfields;
              if not(tempcode in delimiters) then pinlabel:=true;
              if ((pinlabel)and(tempcode in delimiters)) then
              begin
                labels:=labels+1;
                pinlabel:=false;
              end;
              if((pinlabel)and(tempcode=asterisk))
              then labels:=labels+1;
            end;
          qcode:validchar:=((fieldlen=0) and (tempcode in valfields))
            or ((fieldlen>0) and (tempcode in decdigits));
          scode:validchar:=tempcode in bindigits;
          tcode:validchar:=tempcode in decdigits;
          vcode:
            begin
              if not endnumber then
              begin
                endnumber:=tempcode in delimiters;
                validchar:=((tempcode in decdigits)or(endnumber));
              end
              else
              begin
                validchar:=tempcode in testconds;
                if tempcode<>blank then veclen:=veclen+1;
              end;
            end;
        end;
      end else errmsg(errcode,linenum);
      if eolflag then
      begin
        linenum:=linenum+1;
        checksum:=checksum+linefeed+newline;
        write(fileout,chr(newline));
      end
      else
      begin
        checksum:=checksum+tempcode;
        if validchar then write(fileout,tempchar)
        else
        begin
          case currfield of
            ccode:errcode:=3;
            dcode:errcode:=4;
            fcode:errcode:=5;
            gcode:errcode:=6;
            lcode:if not endnumber then errcode:=7 else errcode:=8;
            mcode:errcode:=9;
            pcode:errcode:=10;
            qcode:if fieldlen=0 then errcode:=11 else errcode:=12;
            rcode:errcode:=13;
            scode:errcode:=14;
            tcode:errcode:=15;
            vcode:if not endnumber then errcode:=16 else errcode:=17;
          end;
          if fieldidok then errmsg(errcode,linenum);
        end;
      end;
      fieldlen:=fieldlen+1;
    end;
    fieldlen:=fieldlen-1;(*To compensate for the extra time that
                           "fieldlen" was incremented after the end
                           of the field was detected*)
    veclen:=veclen-1;(*Same reasoning as above*)
    if endfield then
    begin
      cfieldok:=(((fieldlen=cfldlen)and(currfield=ccode))
      or(currfield<>ccode));
      rfieldok:=(((fieldlen=rfldlen)and(currfield=rcode))
      or(currfield<>rcode));
      gfieldok:=(((fieldlen=gfldlen)and(currfield=gcode))
      or(currfield<>gcode));
      ffieldok:=(((fieldlen=ffldlen)and(currfield=fcode))
      or(currfield<>fcode));
      pfieldok:=(((labels=pins)and(currfield=pcode))
      or(currfield<>pcode));
      sfieldok:=(((fieldlen=pins)and(currfield=scode))
      or(currfield<>scode));
      vfieldok:=(((veclen=pins)and(currfield=vcode))
      or(currfield<>vcode));
      allok1:=cfieldok and rfieldok and gfieldok and ffieldok;
      allok2:=pfieldok and sfieldok and vfieldok;
      allok:=allok1 and allok2;
      if not allok then
      begin
        case currfield of
          ccode:errcode:=18;
          rcode:errcode:=19;
          gcode:errcode:=20;
          fcode:errcode:=21;
          pcode:errcode:=24;
          scode:errcode:=25;
          vcode:errcode:=26;
        end;
        errmsg(errcode,linenum);
      end;
    end
    else
    begin
      errcode:=22;
      if tempcode<>etx then errmsg(errcode,linenum);
      endoffile:=true;
    end;
  end;
end;

(******************************)

procedure consolidate;

var fieldend,fileend:boolean;
    numpins,numfuses:integer;

begin
  fieldend:=false;
  fileend:=false;
  (*Number of pins and fuses not initialized here*)
  checkheader(fieldend,fileend,numpins,numfuses);
  checkfields(fieldend,fileend,numpins,numfuses);
end;

(******************************)

begin
  consolidate;
end;

(****************************************************************)

procedure setupngo;

var filename:fnamestr;
    hexchecksum:csumstr;
    success,abort:boolean;
    letter,reply:char;
    i:integer;

begin
  repeat
    linenum:=1;
    msdigits:=0;
    checksum:=0;
    errcount:=0;
    reply:='n';
    abort:=false;
    writeln;
    writeln('MMI Jedec Reformatter Vers.1.1 - Ranjit Padmanabhan.');
    writeln;
    repeat
      reply:='n';
      i:=0;
      writeln;
      write('Enter name of input file [source.jed] <ret> : ');
      readln(filename);
      readio(filename,filein,success);
      if not success then
      begin
        writeln;
        writeln('Error in opening input file - ',filename);
        write('Do you want to name another input file? [y/n] <ret> : ');
        readln(reply);
        abort:=reply<>'y';
      end;
    until ((success)or(abort));
    if success then
    begin
      repeat
        reply:='n';
        i:=0;
        writeln;
        write('Enter name of output file [target.jed] <ret> : ');
        readln(filename);
        writeio(filename,fileout,success);
        if not success then
        begin
          writeln;
          writeln('Error in creating output file - ',filename);
          write('Do you want to name another output file? [y/n] <ret> : ');
          readln(reply);
          abort:=reply<>'y';
        end;
      until ((success)or(abort));
    end;
    if success then
    begin
      reformat;
      hexconvert(msdigits,checksum,hexchecksum);
      for i:=1 to 4 do write(fileout,hexchecksum[i]);
      writeln;
      write('**** Transmit check sum ');
      for i:=1 to 4 do write(hexchecksum[i]);
      writeln(' appended. ****');
      writeln;
      if errcount=0 then writeln('Reformatting successfully done.')
      else writeln('Reformatting completed with ',errcount,' errors.');
      writeln;
    end;
    if not abort then
    begin
      closeio(filein,success);
      if not success then writeln('Error in closing input file.');
      closeio(fileout,success);
      if not success then writeln('Error in closing output file.');
    end;
    write('Do you want to reformat another file? [y/n] <ret> : ');
    readln(reply);
  until reply<>'y';
end;

(****************************************************************)

begin
  createsets;
  setupngo;
end.

(****************************************************************)
