C
      INTEGER FUNCTION MOD(A,B)
      INTEGER A,B
      MOD=A-(A/B)*B
      RETURN
      END
C
      INTEGER FUNCTION KCLOS(LUN)
      INTEGER*1 LUN
      LOGICAL FLAG
      FLAG=IOCLOS (LUN)
      KCLOS=0
      IF (FLAG) KCLOS=1
      RETURN
      END
C
      INTEGER FUNCTION KREAD(LUN,L1,L2,FILE)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 FILE(20)
      LOGICAL FLAG
      J=21
10    J=J-1
      IF (J .EQ. 0) GOTO 20
      IF (FILE(J) .NE. ' ') GOTO 20
      FILE(J)=0
      GOTO 10
20    FLAG=IOREAD (LUN,L1,L2,FILE)
      KREAD=0
      IF (FLAG) KREAD=1
      RETURN
      END
C
      INTEGER FUNCTION KWRIT(LUN,L1,L2,FILE)
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 FILE(20)
      LOGICAL FLAG
      J=21
10    J=J-1
      IF (J .EQ. 0) GOTO 20
      IF (FILE(J) .NE. ' ') GOTO 20
      FILE(J)=0
      GOTO 10
20    FLAG=IOWRIT (LUN,L1,L2,FILE)
      KWRIT=0
      IF (FLAG) KWRIT=1
      RETURN
      END
C
C**PALASM20**PALASM20**PALASM20**PALASM20**PALASM20**PALASM20**PALASM20
C
C  PALASM 20  -  TRANSLATES SYMBOLIC EQUATIONS INTO PAL OBJECT & TSTVEC CODE  
C                FORMATTED FOR DIRECT INPUT TO STANDARD PROM PROGRAMMERS.
C
C REV LEVEL: VERSION 1.7D 6/25/84 (C) COPYRIGHT 1983,1984 MONOLITHIC MEMORIES
C
C V1.7A - 2/1/84 - INITIAL RELEASE - PRELIMINARY VERSION
C V1.7B - 3/8/84 - FIX ERRORS IN RUNNING TEST SUITE, MANY SMALL BUGS
C V1.7C - 5/11/84 - 16RP6 PROBLEMS, ANOTATION OF FUSE PLOT
C V1.7D - 6/25/84 - CONDENSATION OF CPM FILE STORAGE
C
C INPUT:       PAL DESIGN SPECIFICATION ASSIGNED TO RPD.
C              OPERATION CODES ARE ASSIGNED TO ROC.
C
C OUTPUT:      ECHO, SIMULATION, AND FUSE PATTERN ARE ASSIGNED TO POF.
C              HEX AND BINARY PROGRAMMING FORMATS ARE ASSIGNED TO PDF.
C              PROMPTS AND ERROR MESSAGES ARE ASSIGNED TO PMS.
C
C PART NUMBER: THE PAL PART NUMBER MUST APPEAR IN COLUMN ONE OF LINE ONE.
C
C PIN LIST:    20 SYMBOLIC PIN NAMES MUST APPEAR STARTING ON LINE FIVE.
C
C EQUATIONS:   STARTING FIRST LINE AFTER THE PIN LIST IN THE FOLLOWING FORMS:
C
C              A = B*C + D
C              A := B*C + D
C              IF( A*B )  C = D + E
C              A2 := (A1:*:B1) + /C
C
C              ALL CHARACTERS FOLLOWING ';' ARE IGNORED UNTIL THE NEXT LINE.
C              BLANKS ARE IGNORED.
C
C OPERATORS:   ( IN HIERARCHY OF EVALUATION )
C
C              ;    COMMENT FOLLOWS
C              /    COMPLEMENT
C              *    AND (PRODUCT)
C              +    OR (SUM)
C              :+:   XOR (EXCLUSIVE OR)
C              :*:   XNOR (EXCLUSIVE NOR)
C              ( )   CONDITIONAL THREE-STATE
C              OR FIXED SYMBOL
C              =    EQUALITY
C              :=    REPLACED BY (AFTER CLOCK)
C
C FIXED SYMBOLS FOR PAL16X4 AND PAL16A4 ONLY:
C
C              (AN+/BN)     WHERE N = 0,1,2,3
C              (AN+BN)      FOR OUTPUT PINS
C              (AN)         17,16,15,14, RESP
C              (/AN+/BN)    A IS OUTPUT
C              (/BN)        B IS INPUT
C              (AN:+:BN)
C              (AN*/BN)
C              (/AN+BN)
C              (AN:*:BN)
C              (BN)
C              (AN*BN)
C              (/AN)
C              (/AN*/BN)
C              (/AN*BN)
C
C FUNCTION     L, H, X, Z, AND C ARE VALID
C   TABLE:     FUNCTION TABLE VECTOR ENTRIES.
C
C REFERENCE:   A COMPLETE USERS GUIDE TO DESIGNING WITH PALS USING PALASM
C              IS PROVIDED IN THE MONOLITHIC MEMORIES PAL HANDBOOK.
C
C SUBROUTINES: INITLZ,GETSYM,INCR,MATCH,FIXSYM,IXLATE,ECHO,CAT,PINOUT,
C              PLOT,TWEEK,HEX,SLIP,FANTOM,TEST,FIXTST,JEDEC,SUMCHK,INTEL
C
C AUTHORS:     JOHN BIRKNER AND VINCENT COLI
C              FAULT TESTING BY IMTIAZ BENGALI
C              JEDEC FORMAT  BY MANO VAFAI 
C              MONOLITHIC MEMORIES INC.
C              2175 MISSION COLLEGE BLVD.
C              SANTA CLARA, CA 95050
C              (408) 970-9700
C
C FINE PRINT:  MONOLITHIC MEMORIES TAKES NO RESPONSIBILITY FOR THE OPERATION
C              OR MAINTENANCE OF THIS PROGRAM. THE SOURCE CODE AS PRINTED HERE
C              PRODUCED THE OBJECT CODE OF THE EXAMPLES IN THE APPLICATIONS
C              SECTION ON A VAX/VMS 11/780 COMPUTER AND A NATIONAL CSS IBM
C              SYSTEM/370 FORTRAN IV(G).
C
C****************
C
C     MAIN PROGRAM
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80),ISAVE(64,32)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
C
      INTEGER*1 FILE1(20),FILE2(20)
C
      INTEGER IC,IL,IC1,I,J,K,ILE,ILL,COUNT,ISAF,I8PRO,I88PRO,IONE
      INTEGER IPROD,IBLOW,ILERR,IPCTR,IPCTR0,IPCTR1,ISA0,ISA1,IFAULT
C
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR,
     1        LFX,LFIRST,LFUSES(32,64),LPHASE(20),LBUF(20),LPOLAR(20),
     2        LPROD(80),LSAME,LACT,LOPERR,LINP,LPRD,LERR,LSA11,LSA01,
     3        LPHANT(32,64),DOIT
      INTEGER*1 IBUF(8,20),ISYM(8,20)
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      COMMON /FPLOT/ ISAVE
      COMMON /LFUZ/LFUSES,LPHANT
      INTEGER IFUNCT,IDESC,IEND,IINPUT,IMATCH,SINGLE
      COMMON /FTEST/ IFUNCT,IDESC,IEND
C
      DATA E/'E'/,O/'O'/,T/'T'/,P/'P'/,B/'B'/,H/'H'/,S/'S'/,L/'L'/,
     1     N/'N'/,C/'C'/,Q/'Q'/,U/'U'/,F/'F'/,R/'R'/,A/'A'/,JJ
     2     /'J'/,X/'X'/,D/'D'/,IBLANK/' '/,CHY/'Y'/,CHN/'N'/
      DATA BB/'B'/,CC/'C'/,DD/'D'/,EE/'E'/,FF/'F'/,II/'I'/,NN/'N'/,
     1     OO/'O'/,PP/'P'/,RR/'R'/,SS/'S'/,TT/'T'/,UU/'U'/
      DATA BEL /007/, FFEED /012/,IONE/1/,TAB/09/
C
C
      CALL IOINIT
      ROC=CONINP
      PMS=CONOUT
    8 WRITE(CONOUT,1)
    1 FORMAT(/,' MONOLITHIC MEMORIES 20-PIN PALASM (tm) VERSION 1.7D',
     1       /' (C) COPYRIGHT 1983,1984 MONOLITHIC MEMORIES')
C
C     ASSIGNMENT OF DATA SET REFERENCES
C     RPD - PAL DESIGN SPECIFICATION (INPUT FROM DATA FILE)
C     ROC - OPERATION CODE (INPUT FROM TERMINAL)
C     POF - ECHO, SIMULATION AND TRUTH TABLES (OUTPUT)
C     PDF - HEX AND BINARY PROGRAMMING FORMATS (OUTPUT)
C     PMS - PROMPTS AND ERROR MESSAGES (OUTPUT TO TERMINAL)
C
    4 WRITE(CONOUT,2)
    2 FORMAT(/,' WHAT IS THE SOURCE FILENAME (d:filename.ext) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
    3 FORMAT(20A1)
      IF(KREAD(FILINP,2,0,FILE1) .NE. 0) GO TO 130
    5 WRITE(CONOUT,333)
  333 FORMAT(/,' OUTPUT FILENAME -',
     1         ' PRESS <ENTER> FOR NO OUTPUT FILE ?: '$)
      READ(CONINP,3) (FILE2(I),I=1,20)
      LUN=CONOUT
      IF(FILE2(1).EQ.IBLANK) GO TO 9
      IF(KWRIT(FILOUT,2,0,FILE2) .NE. 0) GO TO 130
      LUN=FILOUT
    9 RPD=FILINP
      POF=LUN
      PDF=LUN
C
C     INITIALIZE FUSE PLOT INFORMATION
      DO 334 I=1,80
  334 LPROD(I)=.FALSE.
      DO 335 I=1,64
      DO 335 J=1,32
  335 ISAVE(I,J)=IBLANK
C     INITIALIZE LSAME AND LACT TO FALSE (ACTIVE HIGH/LOW ERROR)
      LSAME=.FALSE.
      DO 39 I=1,20
C     INITIALIZE LPOLAR (OUTPUT POLARITY BLOWN)
39    LPOLAR(I)=.FALSE.
      LACT=.FALSE.
C     INTIALIZE SECURITY FUSE OPTION
      DOIT =.FALSE.
C     INITIALIZE LOPERR TO FALSE (OUTPUT PIN ERROR)
      LOPERR=.FALSE.
C     INITIALIZE LINP TO FALSE (INPUT PIN ERROR)
      LINP=.FALSE.
C     INITIALIZE LPRD TO FALSE (PRODUCT LINE ERROR)
      LPRD=.FALSE.
C
      WRITE(CONOUT,9000)
9000  FORMAT(/,1X,'READING INPUT FILE ',/)
C     READ IN FIRST 4 LINES OF THE PAL DESIGN SPECIFICATION
      READ(RPD,38) (IPAL(J),J=1,4),INOAI,IOT,INOO,INOO1,
     1 (REST(J),J=1,72),(PATNUM(J),J=1,79),(TITLE(J),J=1,79),
     2 (COMP(J),J=1,79)
  38  FORMAT(4A1,A1,A1,A1,A1,72A1,/,79A1,/,79A1,/,79A1)
C     READ IN PIN LIST (LINE 5) THROUGH THE END OF THE PAL DESIGN
C      SPECIFICATION
      DO 1115 J=1,72
C     SECURITY FUSE 
1115      IF ((REST(J).EQ.SS).AND.(REST(J+1).EQ.EE)
     1 .AND.(REST(J+2).EQ.CC))     DOIT =.TRUE. 
C
      IFUNCT=0
      IDESC=0
C
C     READ IN PAL DESIGN SPECIFICATION
C
      LNPTR=0
      LNMAX=0
10    READ(RPD,14,ENDFILE=15) (CLN(IC),IC=1,80)
14    FORMAT(80A1)
      WRITE(CONOUT,9001)
      LNMAX=LNMAX+1
C
      CLN(80)=IBLANK
      J=81
11    J=J-1
      IF (CLN(J) .EQ. TAB) CLN(J)=IBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=IBLANK
      IF (J.GT. 1 .AND. CLN(J).EQ.IBLANK) GOTO 11
C
      LOF(LNMAX)=LNPTR
      LLN(LNMAX)=J
      J=0
      SINGLE=0
12    J=J+1
      IF (CLN(J) .EQ. TAB) CLN(J)=IBLANK
      IF (CLN(J) .EQ. FFEED) CLN(J)=IBLANK
      IF (CLN(J) .NE. IBLANK) SINGLE=0
      IF (CLN(J) .EQ. IBLANK) SINGLE=SINGLE+1
C      IF (SINGLE .GE. 2) GOTO 12
      LNPTR=LNPTR+1
      CPG(LNPTR)=CLN(J)
      IF (J.LT. LLN(LNMAX)) GOTO 12
C      IF (J.LT. LLN(LNMAX) .AND. CLN(J) .NE. ';') GOTO 12
C
      LNPTR=LNPTR+1
      CPG(LNPTR)=IBLANK
      LLN(LNMAX)=LNPTR-LOF(LNMAX)
C
      IF (LNPTR .GT. 9999) WRITE (PMS,13)
13    FORMAT (' ',/,1X,'TOO MANY CHARACTERS IN INPUT FILE')
C
C     CHECK FOR 'FUNCTION TABLE' AND SAVE ITS LINE NUMBER
C
      IF(.NOT.(CLN(1).EQ.FF.OR.CLN(1).EQ.DD)) GO TO 10
      IF(   IFUNCT.EQ.0 .AND.CLN(1).EQ.FF.AND.
     1    CLN(2).EQ.UU.AND.CLN(3).EQ.NN.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.TT.AND.
     3    CLN(6).EQ.II.AND.CLN(7).EQ.OO.AND.
     4    CLN(8).EQ.NN.AND.CLN(10).EQ.TT.AND.
     5    CLN(12).EQ.BB.AND.CLN(14).EQ.EE ) IFUNCT=LNMAX
C
C     CHECK FOR 'DESCRIPTION' AND SAVE ITS LINE NUMBER
C
      IF(    IDESC.EQ.0 .AND.CLN(1).EQ.DD.AND.
     1    CLN(2).EQ.EE.AND.CLN(3).EQ.SS.AND.
     2    CLN(4).EQ.CC.AND.CLN(5).EQ.RR.AND.
     3    CLN(6).EQ.II.AND.CLN(7).EQ.PP.AND.
     4    CLN(8).EQ.TT.AND.CLN(9).EQ.II.AND.
     5    CLN(10).EQ.OO.AND.CLN(11).EQ.NN ) IDESC=LNMAX
C
      GOTO 10
C
C     SAVE THE LAST LINE NUMBER OF THE PAL DESIGN SPECIFICATION
C
9001  FORMAT(1X,'.'$)
   15 IEND=LNMAX
      WRITE(PMS,16) LNMAX,LNPTR
16    FORMAT(' ',/,' PAL DESIGN FILE READ - ',I5,' LINES',I6,
     2 ' CHARACTERS (MAXIMUM 9999)' )
C
      WRITE(CONOUT,9003)
9003  FORMAT(/,1X,'ASSEMBLING INPUT FILE ',/)
      CALL INITLZ(ITYPE,IC,IL,IBLOW,LFX,IPCTR,ITRM)
      ILE=IL+1
C     PRINT ERROR MESSAGE FOR INVALID PAL PART TYPE
      IF(ITYPE.NE.0) GO TO 17
          WRITE(PMS,18) (IPAL(I),I=1,4),INOAI,IOT,INOO,INOO1
C
   18     FORMAT(/,' PAL PART TYPE ',4A1,A1,A1,A1,A1,' IS INCORRECT')
          STOP
C     GET 20 PIN NAMES
   17 DO 20 J=1,20
   20     CALL GETSYM(LPHASE,ISYM,J,IC,IL,LFX)
          IF(.NOT.(LEQUAL.OR.LLEFT.OR.LAND.OR.LOR.OR.LRIGHT)) GO TO 24
              WRITE(PMS,23)
   23         FORMAT(/,' LESS THAN 20 PIN NAMES IN PIN LIST')
              STOP
   24 ILE=IL
C     BYPASS FUSE PLOT ASSEMBLY IF HAL (H IN COLUMN 1, LINE 1)
      IF( IPAL(1).EQ.H ) GO TO 108
   25 CALL GETSYM(LBUF,IBUF,IONE,IC,IL,LFX)
   28     IF(.NOT.LEQUAL) GO TO 25
          WRITE(CONOUT,9004)
          COUNT=0
          ILL=IL
          CALL MATCH(IMATCH,IBUF,ISYM)
          IF( IMATCH.EQ.0 ) GO TO 100
          IPRD=IMATCH
C         CHECK FOR VALID POLARITY
          LSAME = ( (     LPHASE(IMATCH)).AND.(     LBUF(1)).OR.
     1              (.NOT.LPHASE(IMATCH)).AND.(.NOT.LBUF(1)) )
         IF((IOT.EQ.P).AND.LSAME) LPOLAR(IMATCH) =.TRUE.
         IF((INOO.EQ.P).AND.LSAME) LPOLAR(IMATCH) =.TRUE.
          IF( IOT.EQ.H.AND.(.NOT.LSAME) )                 LACT=.TRUE.
          IF( (.NOT.(IOT.EQ.H.OR.IOT.EQ.C.OR.IOT.EQ.P.OR.INOO.EQ.P))
     1    .AND.(LSAME) ) LACT=.TRUE.
C         CHECK FOR VALID OUTPUT PIN
          IF( (ITYPE.EQ.1.OR.ITYPE.EQ.5.OR.ITYPE.EQ.6).AND.IOT.NE.A
     1    .AND.(IMATCH.LT.12.OR.IMATCH.GT.19) ) LOPERR=.TRUE.
          IF(  ITYPE.EQ.2.AND.(IMATCH.LT.13.OR.IMATCH.GT.18) )
     1                                         LOPERR=.TRUE.
          IF(  ITYPE.EQ.3.AND.(IMATCH.LT.14.OR.IMATCH.GT.17) )
     1                                         LOPERR=.TRUE.
          IF(  ITYPE.EQ.4.AND.(IMATCH.LT.15.OR.IMATCH.GT.16) )
     1                                         LOPERR=.TRUE.
          IF( (LACT).OR.(LOPERR) ) GO TO 100
          I88PRO=(19-IMATCH)*8 + 1
C         START PAL16C1 ON PRODUCT LINE 24 (I88PRO=25)
          IF(IOT.EQ.C) I88PRO=25
          IC=0
   30       CALL INCR(IC,IL,LFX)
            IF( .NOT.(LEQUAL.OR.LLEFT) ) GO TO 30
            LPROD(I88PRO)=.TRUE.
            IF( (.NOT.LLEFT).AND.(REST(1).NE.PP) )
     1     CALL SLIP(I88PRO,IBLOW)
          DO 70 I8PRO=1,16
              COUNT = COUNT + 1
              IF( (LXOR).AND.I8PRO.NE.5 ) GO TO 70
              IPROD = I88PRO + I8PRO - 1
              LPROD(IPROD)=.TRUE.
              LFIRST=.TRUE.
   50           ILL=IL
                CALL GETSYM(LBUF,IBUF,IONE,IC,IL,LFX)
              IF( (ITYPE.EQ.1.OR.ITYPE.EQ.2.AND.IPRD.GT.13
     1             .AND.IPRD.LT.18).AND.COUNT.GT.2 ) LPRD=.TRUE.
              IF( (ITYPE.EQ.3.OR.ITYPE.EQ.2.AND.(IPRD.EQ.13.OR.
     1             IPRD.EQ.18)).AND.COUNT.GT.4 ) LPRD=.TRUE.
C
              IF( IOT.NE.A.AND.IOT.NE.C.AND.COUNT.GT.8 ) LPRD=.TRUE.
              IF( .NOT.LPRD ) GO TO 69
              IF(IL.NE.IFUNCT.AND.IL.NE.IDESC) ILL=IL
              IPROD = IPROD - 1
              GO TO 118
   69           IF(LFX) GO TO 59
                CALL MATCH(IMATCH,IBUF,ISYM)
C               CHECK FOR INVALID INPUT PIN
C
      IF( ITYPE.EQ.1.AND.(IMATCH.GE.12.AND.IMATCH.LE.19) ) LINP=.TRUE.
      IF( ITYPE.EQ.2.AND.(IMATCH.GE.13.AND.IMATCH.LE.18) ) LINP=.TRUE.
      IF( ITYPE.EQ.3.AND.(IMATCH.GE.14.AND.IMATCH.LE.17) ) LINP=.TRUE.
      IF( ITYPE.EQ.4.AND.(IMATCH.EQ.15.OR. IMATCH.EQ.16) ) LINP=.TRUE.
      IF( ITYPE.EQ.5.AND.(IMATCH.EQ.12.OR. IMATCH.EQ.19) ) LINP=.TRUE.
      IF( ITYPE.EQ.6.AND.(IMATCH.EQ.1 .OR. IMATCH.EQ.11) ) LINP=.TRUE.
C
                ILL=IL
                IF(LINP) GO TO 100
                IF( IMATCH.EQ.0 ) GO TO 100
                IF( IMATCH.EQ.10.OR.IMATCH.EQ.99 ) GO TO 64
                IF(.NOT.LFIRST) GO TO 58
                    LFIRST=.FALSE.
                    DO 56 I=1,32
                        IBLOW = IBLOW + 1
   56                   LFUSES(I,IPROD)=.TRUE.
   58           CALL IXLATE(IINPUT,IMATCH,LPHASE,LBUF,ITYPE)
                IF(IINPUT.LE.0) GO TO 60
                IBLOW = IBLOW - 1
                LFUSES(IINPUT,IPROD)=.FALSE.
                CALL PLOT(LBUF,IBUF,IPROD,.FALSE.,ITYPE,
     1                    LPROD,IOP,IBLOW,IPCTR,LPOLAR,DOIT) 
                GO TO 60
   59  IF (ITYPE.EQ.6 .AND. (IOT.EQ.X.OR.IOT.EQ.A)) GOTO 61
       WRITE (PMS,8059) (CPG(I),I=(LOF(IL)+1),(LOF(IL)+LLN(IL)))
8059   FORMAT (1X,'ERROR: PARENS NOT ALLOWED IN THIS TYPE',/,1X,80A1)
61     CALL FIXSYM(LBUF,IBUF,IC,IL,LFIRST,IBLOW,IPROD,LFX)
   60           IF(LAND) GO TO 50
   64         IF(.NOT.LRIGHT) GO TO 68
   66           CALL INCR(IC,IL,LFX)
                IF(.NOT.LEQUAL)  GO TO 66
   68         IF( .NOT.(LOR.OR.LEQUAL) ) GO TO 74
   70         CONTINUE
   74     ILL=IL
          CALL GETSYM(LBUF,IBUF,IONE,IC,IL,LFX)
          IF(LLEFT.OR.LEQUAL) GO TO 28
9004  FORMAT(1X,'.'$)
  100 IF( ILL.EQ.IFUNCT.OR.ILL.EQ.IDESC ) GO TO 102
C     PRINT AN ERROR MESSAGE IF UNRECOGNIZABLE SYMBOL
      ILERR=ILL+4
      WRITE(PMS,99) BEL
   99 FORMAT(1X,A1)
      WRITE(PMS,101) (IBUF(I,1),I=1,8),ILERR,
     1 (CPG(I),I=(LOF(ILL)+1),(LOF(ILL)+LLN(ILL)))
  101 FORMAT(/,' ERROR SYMBOL = ',8A1,'      IN LINE NUMBER ',I4,
     1       /,1X,80A1)
C
C     PRINT AN ERROR MESSAGE FOR ACTIVE HIGH/LOW PART
      IF( (LACT).AND.(     LSAME).AND.(.NOT.LOPERR) )
     1         WRITE(PMS,103) (IPAL(I),I=1,4),INOAI,IOT,INOO
  103 FORMAT(' OUTPUT MUST BE INVERTED SINCE ',4A1,A1,A1,A1,
     1       ' IS AN ACTIVE LOW DEVICE')
      IF( (LACT).AND.(.NOT.LSAME).AND.(.NOT.LOPERR) )
     1         WRITE(PMS,1191) (IPAL(I),I=1,4),INOAI,IOT,INOO
 1191 FORMAT(' OUTPUT CANNOT BE INVERTED SINCE ',4A1,A1,A1,A1,
     1       ' IS AN ACTIVE HIGH DEVICE')
C     PRINT AN ERROR MESSAGE FOR AN INVALID OUTPUT PIN
      IF( (LOPERR).AND.IMATCH.NE.0 )
     1   WRITE(PMS,105) IMATCH,(IPAL(I),I=1,4),INOAI,IOT,INOO,INOO1
  105 FORMAT(' THIS PIN NUMBER ',I2,' IS AN INVALID OUTPUT PIN',
     1       ' FOR ',4A1,A1,A1,A1,A1)
C     PRINT AN ERROR MESSAGE FOR AN INVALID INPUT PIN
      IF(LINP) WRITE(PMS,115) IMATCH,(IPAL(I),I=1,4),INOAI,IOT,INOO,INOO1
  115 FORMAT(' THIS PIN NUMBER ',I2,' IS AN INVALID INPUT PIN',
     1       ' FOR ',4A1,A1,A1,A1,A1)
C     PRINT AN ERROR MESSAGE FOR INVALID PRODUCT LINE
  118 ILERR=ILL+4
      IF(LPRD) WRITE(PMS,119) (ISYM(I,IPRD),I=1,8),IPRD,ILERR,
     1 (CPG(I),I=(LOF(ILL)+1),(LOF(ILL)+LLN(ILL)))
  119 FORMAT(/,' OUTPUT PIN NAME = ',8A1,'  OUTPUT PIN NUMBER = ',I2,
     1       /,' MINTERM IN LINE NUMBER ',I4,/,1X,80A1)
      IF( LPRD.AND.COUNT.LT.8 )
     1      WRITE(PMS,116) IPROD,(IPAL(I),I=1,4),INOAI,IOT,INOO,INOO1
  116 FORMAT(' THIS PRODUCT LINE NUMBER ',I2,' IS NOT VALID',
     1       ' FOR ',4A1,A1,A1,A1,A1)
      IF( LPRD.AND.COUNT.GT.8 )
     1         WRITE(PMS,117) (IPAL(I),I=1,4),INOAI,IOT,INOO,INOO1
  117 FORMAT(' MAXIMUM OF 8 PRODUCT LINES ARE VALID FOR ',4A1,A1,A1,A1,
     1     /A1,' TOO MANY MINTERMS ARE SPECIFIED IN THIS EQUATION')
      STOP
  102 IF(ITYPE.LE.4) CALL TWEEK(ITYPE,IOT)
C
108   WRITE(PMS,107)
  107 FORMAT(' ',/,' E=ECHO     O=PINOUT  S=SIMULATE   P=PLOT ',
     1           /,' B=BRIEF    H=HEX     I=INTEL HEX  D=DOCUMENT',
     2           /,' J=JEDEC    F=FAULT   TESTING',
     3           /,' C=CATALOG  Q=QUIT')
      WRITE(PMS,110)
  110 FORMAT(/,' ENTER OPERATION CODE: '$)
      IOP=IBLANK
C      REWIND(ROC)    
      READ(ROC,120,ENDFILE=350) IOP
  350 CONTINUE
  120 FORMAT(A1)
      IF (IOP .GT. CHY) IOP=IOP-32
      IF((IOP.EQ.SS.OR.IOP.EQ.JJ).AND.(POF.NE.CONOUT))
     1 WRITE(CONOUT,9005)
9005  FORMAT(/,1X,'SIMULATING',/)
      IF(IOP.EQ.F.AND.POF.NE.CONOUT) WRITE(CONOUT,9007)
9006  FORMAT(/,1X,'GENERATING FUSE ARRAYS',/)
9007  FORMAT(/,1X,'PERFORMING FAULT TESTING',/)
      IF(IOP.EQ.E) CALL ECHO
      IF(IOP.EQ.O) CALL PINOUT
      IF(IOP.EQ.SS) CALL TEST(LPHASE,LBUF,IC,IL,ILE,ISYM,IBUF,ITYPE,
     1   LFX,IPCTR,LERR,ISAF,IPCTR1,.FALSE.,.FALSE.,IOP.NE.JJ,LPOLAR)
C     THE FOLLOWING IS ADDED FOR SA1 TEST
      
C
C     INITIALIZING THE TOTAL FAULTS. CALLING FOR SA1/SA0 TEST 
      ISAF=0
      IF(IOP.EQ.F) GO TO 200
C     END OF ADDITION
C
C        ADDITIONS MADE  TO GENERATE TEST VECTORS
C        FOR JEDEC FORMAT
C
         IF (IOP.NE.JJ) GOTO 135 
              CALL TEST(LPHASE,LBUF,IC,IL,ILE,ISYM,IBUF,ITYPE
     1 ,LFX,IPCTR,LERR,ISAF,IPCTR1,.FALSE.,.FALSE.,IOP.NE.JJ,LPOLAR)
                  CALL JEDEC(ITYPE,DOIT,ITRM,LPOLAR)
C
C        
C
  135 IF(IOP.EQ.P) CALL PLOT(LBUF,IBUF,IPROD,.TRUE.,
     1                  ITYPE,LPROD,IOP,IBLOW,IPCTR0,LPOLAR,DOIT)
      IF(IOP.EQ.B) CALL PLOT(LBUF,IBUF,IPROD,.TRUE.,
     1                  ITYPE,LPROD,IOP,IBLOW,IPCTR0,LPOLAR,DOIT) 
      IF(IOP.NE.D) GO TO 126
      WRITE(POF,1266) FFEED
      CALL ECHO
      WRITE(POF,1266) FFEED
      CALL PINOUT
      WRITE(POF,1266) FFEED
      CALL PLOT(LBUF,IBUF,IPROD,.TRUE.,ITYPE,
     1                       LPROD,P,IBLOW,IPCTR0,LPOLAR,DOIT)
      WRITE(POF,1266) FFEED
1266  FORMAT(1X,A1)
126   IF(IOP.EQ.H) CALL HEX(H)
      IF(IOP.EQ.II) CALL HEX(II)
      IF(IOP.EQ.C) CALL CAT
      IF(IOP.NE.Q ) GO TO 108
C
C     LEAVE THE PROGRAM?
C
  133 I=KCLOS(FILINP)
      IF(LUN.NE.CONOUT) I=KCLOS(FILOUT)
  127 WRITE(PMS,128)
  128 FORMAT(1X,'RESTART PALASM (Y/N) ?: '$)
      READ(CONINP,3) (FILE1(I),I=1,20)
      IF(FILE1(1).EQ.CHY) GO TO 4
      IF(FILE1(1).EQ.IBLANK) STOP
      IF(FILE1(1).NE.CHN) GO TO 127
      STOP
  130 WRITE(PMS,136)
  136 FORMAT(/,' DISK I/O ERROR - MAYBE WRONG FILENAME ???')
      GO TO 127
C
C     ADDITION FOR SA1/SA0 TESTS
C     SETTING THE PARAMETERS FOR SA1/SA0 TESTS
  200 IPCTR=0
      CALL TEST(LPHASE,LBUF,IC,IL,ILE,ISYM,IBUF,ITYPE,
     1   LFX,IPCTR,LERR,ISAF,IPCTR1,.FALSE.,.FALSE.,IOP.NE.JJ,LPOLAR)
      IF(IFUNCT.EQ.0) GO TO 135
      IPCTR0=IPCTR
C     LOOPING FOR SA1 TEST
      DO 210 IPCTR1=1,IPCTR0
      CALL TEST(LPHASE,LBUF,IC,IL,ILE,ISYM,IBUF,ITYPE,
     1   LFX,IPCTR,LERR,ISAF,IPCTR1,.TRUE.,.FALSE.,IOP.NE.JJ,LPOLAR)
  210 CONTINUE
      ISA1=ISAF
C     LOOPING FOR SA0 TEST
      DO 215 IPCTR1=1,IPCTR0
      CALL TEST(LPHASE,LBUF,IC,IL,ILE,ISYM,IBUF,ITYPE,
     1  LFX,IPCTR,LERR,ISAF,IPCTR1,.FALSE.,.TRUE.,IOP.NE.JJ,LPOLAR)
  215 CONTINUE
      ISA0=ISAF-ISA1  
      IFAULT=(ISAF*100)/(IPCTR0*2)
C
      WRITE(POF,220) ISA1
  220 FORMAT(/,' NUMBER OF STUCK AT ONE (SA1)  FAULTS ARE =',I3)
      WRITE(POF,225) ISA0
  225 FORMAT(/,' NUMBER OF STUCK AT ZERO (SA0) FAULTS ARE =',I3)
      WRITE(POF,230) IFAULT
  230 FORMAT(/,' PRODUCT  TERM   COVERAGE                 =',I3,'%',//)
      GO TO 135 
C     END OF ADDITION FOR SA1/SA0 TEST 
      END
C
C****************
C
      SUBROUTINE IOINIT
C
C     THIS SUBROUTINE ALLOWS CUSTOMER CHANGES OF ARRAY SIZE
C     ALLOCATIONS & I/O UNIT NUMBERS WITHOUT RECOMPILING MAIN
C     PROGRAM - TO BE SUPPLIED TO ALL MMI CUSTOMERS
C
C     AUTHOR NICK SCHMITZ - 1/22/84
C
      IMPLICIT INTEGER*1 (A-Z)
C
C     9999 CHARACTERS    MAX IN PAL DEFINITIONS FILE
C     250 LINES           MAX IN PAL DEFINITIONS FILE
C     80 CHARACTERS/LINE  MAX IN PAL DEFINITIONS FILE
C
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
C     I/O UNIT ASSIGNMENTS
C
      CONINP=1
      CONOUT=1
      FILINP=10
      FILOUT=11
C
      RETURN
      END
C
C****************
C
      SUBROUTINE INITLZ(ITYPE,IC,IL,IBLOW,LFX,IPCTR,ITRM)
C     THIS SUBROUTINE INITIALIZES VARIABLES AND MATCHES PAL PART
C     NUMBER WITH ITYPE
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
C
      LOGICAL LFUSES(32,64),LPHANT(32,64)
      COMMON /LFUZ/LFUSES,LPHANT
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR,
     1        LFX
      INTEGER IC,IL,I,J,IBLOW,IPCTR,NTEST
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      INTEGER*1 TSTVEC(20, 109 )
      COMMON  /TSTVEC/ NTEST, TSTVEC
      DATA H/'H'/,L/'L'/,C/'C'/,R/'R'/,X/'X'/,A/'A'/,
     1     I0/'0'/,I2/'2'/,I4/'4'/,I6/'6'/,I8/'8'/,P/'P'/
C
C     INITIALIZE LFUSES ARRAY (FUSE ARRAY)
C
      DO 20 J=1,64
         DO 20 I=1,32
            LFUSES(I,J)=.FALSE.
            LPHANT(I,J)=.FALSE.
C        INITIALIZE NUMBER OF TEST VECTORS FOR JEDEC FORMAT
20          NTEST = 0
C     INITIALIZE IBLOW (NUMBER OF FUSES BLOWN)
      IBLOW=0
C     INITIALIZE IPCTR (NUMBER OF PRODUCT TERMS)
      IPCTR=0
C     INITIALIZE IC AND IL (COLUMN AND LINE POINTERS)
      IC=0
      IL=1
C     INITIALIZE ITYPE,ITRM (PAL PART TYPE)
      ITYPE=0
      ITRM=0
C     ITYPE IS ASSIGNED THE FOLLOWING VALUES FOR THESE PAL TYPES:
C          PAL10H8,PAL10L8                          ITYPE=1
C          PAL12H6,PAL12L6                          ITYPE=2
C          PAL14H4,PAL14L4                          ITYPE=3
C          PAL16H2,PAL16L2,PAL16C1                  ITYPE=4
C          PAL16L8,PAL16P8                          ITYPE=5
C          PAL16R4,PAL16R6,PAL16R8,PAL16X4,PAL16A4  ITYPE=6
C          PAL16RP8,PAL16RP6,PAL16RP4               ITYPE=6
C     DETERMINE ITYPE
      IF(  INOAI.EQ.I0 )                            ITYPE=1
      IF(  INOAI.EQ.I2 )                            ITYPE=2
      IF(  INOAI.EQ.I4 )                            ITYPE=3
      IF( (INOAI.EQ.I6) )                           ITYPE=4
      IF( (INOAI.EQ.I6).AND.(INOO.EQ.I8) )          ITYPE=5
      IF( (IOT.EQ.R).OR.(IOT.EQ.X).OR.(IOT.EQ.A))   ITYPE=6
      IF( (IOT.EQ.P).AND.(INOO.EQ.I8) )             ITYPE=5
      IF( .NOT.(IOT.EQ.H.OR.IOT.EQ.L.OR.IOT.EQ.C
     1      .OR.IOT.EQ.R.OR.IOT.EQ.X.OR.IOT.EQ.P.OR.
     2   IOT.EQ.A) ) ITYPE=0
C    ITRM A VARIABLE FOR PALS WITH OUTPUT POLARITY
      IF( (IOT.EQ.P).OR.(INOO.EQ.P) )               ITRM=1
      CALL INCR(IC,IL,LFX)
      RETURN
      END
C
C***************************************
C
      SUBROUTINE GETSYM(LPHASE,ISYM,J,IC,IL,LFX)
C     THIS SUBROUTINE GETS THE PIN NAME, / IF COMPLEMENT LOGIC, AND
C      THE FOLLOWING OPERATION SYMBOL IF ANY
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER IC,IL,I
      INTEGER*1 ISYM(8,20)
      LOGICAL LX1,LFX,LPHASE(20),LXOR1
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      DATA IBLANK/' '/,ILEFT/'('/,IAND/'*'/,IOR/'+'/,COMENT/';'/,
     1     ISLASH/'/'/,IEQUAL/'='/,IRIGHT/')'/,ICOLON/':'/,TAB/009/
C
      LFX=.FALSE.
      IF( .NOT.(LLEFT.OR.LAND.OR.LOR.OR.LEQUAL.OR.LRIGHT) ) GO TO 910
      CALL INCR(IC,IL,LFX)
      IF(LLEFT) GO TO 960
  910 LPHASE(J)=( .NOT.LSLASH )
      IF(LPHASE(J)) GO TO 915
      CALL INCR(IC,IL,LFX)
C
  915 DO 920 I=1,8
  920     ISYM(I,J)=IBLANK
  925 DO 930 I=1,7
  930     ISYM(I,J)=ISYM(I+1,J)
      ISYM(8,J)=CPG(LOF(IL)+IC)
C
C     CODE TRANSPLANTED FROM INCR (FOR SPEED) NAS 2/17/1984
C
      LBLANK=.FALSE.
      LXOR=.FALSE.
      LXNOR=.FALSE.
      LX1=.FALSE.
      LRIGHT=.FALSE.
   10 IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      IF(IC .LE.LLN(IL) .AND. CTMP.NE.COMENT) GO TO 30
      IL=IL+1
      IC=0
      GO TO 10
   30 IF( CTMP.EQ.ICOLON.AND.(LFX) ) GOTO 929
      IF(( CTMP.NE.IBLANK ).AND.( CTMP.NE.TAB)) GOTO 31
          LBLANK=.TRUE.
          GO TO 10
   31 IF( CTMP.NE.ICOLON ) GO TO 32
      IF( (LXOR).OR.(LXNOR) )  GO TO 33
      LX1=.TRUE.
      GO TO 10
   33 IF(LXOR)  LOR=.TRUE.
      IF(LXNOR) LAND=.TRUE.
      GOTO 929
   32 IF( .NOT.(LX1.AND.(CTMP.EQ.IOR.OR.CTMP.EQ.IAND)) ) GO TO 34
C
      IF( CTMP.EQ.IOR  ) LXOR=.TRUE.
      IF( CTMP.EQ.IAND ) LXNOR=.TRUE.
      GO TO 10
   34 LLEFT =( CTMP.EQ.ILEFT  )
      LAND  =( CTMP.EQ.IAND   )
      LOR   =( CTMP.EQ. IOR   )
      LSLASH=( CTMP.EQ.ISLASH )
      LEQUAL=( CTMP.EQ.IEQUAL )
      LRIGHT=( CTMP.EQ.IRIGHT )
929   IF( LLEFT.OR.LBLANK.OR.LAND.OR.LOR.OR.LRIGHT.OR.LEQUAL ) RETURN
      GO TO 925
  960 LFX=.TRUE.
      RETURN
      END
C
C***************************************
C
      SUBROUTINE INCR(IC,IL,LFX)
C     THIS SUBROUTINE INCREMENTS COLUMN AND LINE POINTERS
C      BLANKS AND CHARACTERS AFTER ';' ARE IGNORED
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
C
      INTEGER*1 ISYM(8,20)
      INTEGER I,IC,IL
      LOGICAL LFX,LX1,LXOR1
C
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      DATA IBLANK/' '/,ILEFT/'('/,IAND/'*'/,IOR/'+'/,COMENT/';'/,
     1     ISLASH/'/'/,IEQUAL/'='/,IRIGHT/')'/,ICOLON/':'/,TAB/009/
C
      LBLANK=.FALSE.
      LXOR=.FALSE.
      LXNOR=.FALSE.
      LX1=.FALSE.
      LRIGHT=.FALSE.
   10 IC=IC+1
      CTMP=CPG(LOF(IL)+IC)
      IF(IC .LE.LLN(IL) .AND. CTMP.NE.COMENT) GO TO 30
      IL=IL+1
      IC=0
      GO TO 10
   30 IF( CTMP.EQ.ICOLON.AND.(LFX) ) RETURN
      IF(( CTMP.NE.IBLANK ).AND.( CTMP.NE.TAB)) GOTO 31
          LBLANK=.TRUE.
          GO TO 10
   31 IF( CTMP.NE.ICOLON ) GO TO 32
      IF( (LXOR).OR.(LXNOR) )  GO TO 33
      LX1=.TRUE.
      GO TO 10
   33 IF(LXOR)  LOR=.TRUE.
      IF(LXNOR) LAND=.TRUE.
      RETURN
   32 IF( .NOT.(LX1.AND.(CTMP.EQ.IOR.OR.CTMP.EQ.IAND)) ) GO TO 34
C
      IF( CTMP.EQ.IOR  ) LXOR=.TRUE.
      IF( CTMP.EQ.IAND ) LXNOR=.TRUE.
      GO TO 10
   34 LLEFT =( CTMP.EQ.ILEFT  )
      LAND  =( CTMP.EQ.IAND   )
      LOR   =( CTMP.EQ. IOR   )
      LSLASH=( CTMP.EQ.ISLASH )
      LEQUAL=( CTMP.EQ.IEQUAL )
      LRIGHT=( CTMP.EQ.IRIGHT )
      RETURN
      END
C
C***************************************
C
      SUBROUTINE MATCH(IMATCH,IBUF,ISYM)
C
C      REWRITTEN FOR SPEED - NICK SCHMITZ - 2/16/84
C
C     THIS SUBROUTINE FINDS A MATCH BETWEEN THE PIN NAME IN THE EQUATION
C      AND THE PIN NAME IN THE PIN LIST OR FUNCTION TABLE PIN LIST
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 IBUF(8,20),ISYM(8,20)
      INTEGER I,J,IMATCH
      LOGICAL LMATCH
      DATA C/'C'/,A/'A'/,R/'R'/,Y/'Y'/
C
      J=0
5     J=J+1
      LMATCH=.TRUE.
      I=9
10    I=I-1
      IF (I .LE. 0) GOTO 30
      IF (IBUF(I,1).EQ.ISYM(I,J)) GOTO 10
      IF (J .LT. 20) GOTO 5
      IMATCH=0
      IF( IBUF(3,1).EQ.C.AND.IBUF(4,1).EQ.A.AND.IBUF(5,1).EQ.R.AND.
     1    IBUF(6,1).EQ.R.AND.IBUF(7,1).EQ.Y ) IMATCH=99
      RETURN
C
   30 IMATCH=J
      IF( IBUF(3,1).EQ.C.AND.IBUF(4,1).EQ.A.AND.IBUF(5,1).EQ.R.AND.
     1    IBUF(6,1).EQ.R.AND.IBUF(7,1).EQ.Y ) IMATCH=99
      RETURN
      END
C
C******************************************************
C
      SUBROUTINE IXLATE(IINPUT,IMATCH,LPHASE,LBUF,ITYPE)
C     THIS SUBROUTINE FINDS A MATCH BETWEEN THE INPUT PIN NUMBER AND
C      THE INPUT LINE NUMBER FOR A SPECIFIC PAL.  ADD 1 TO THE INPUT
C      LINE NUMBER IF THE PIN IS A COMPLEMENT
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ITABLE(20,6)
      INTEGER IINPUT,IBUBL,IMATCH
      LOGICAL LPHASE(20),LBUF(20)
      DATA    ITABLE/
     1   3, 1, 5, 9,13,17,21,25,29,-10,31,-1,-1,-1,-1,-1,-1,-1,-1,-20,
     2   3, 1, 5, 9,13,17,21,25,29,-10,31,27,-1,-1,-1,-1,-1,-1, 7,-20,
     3   3, 1, 5, 9,13,17,21,25,29,-10,31,27,23,-1,-1,-1,-1,11, 7,-20,
     4   3, 1, 5, 9,13,17,21,25,29,-10,31,27,23,19,-1,-1,15,11, 7,-20,
     5   3, 1, 5, 9,13,17,21,25,29,-10,31,-1,27,23,19,15,11, 7,-1,-20,
     6  -1, 1, 5, 9,13,17,21,25,29,-10,-1,31,27,23,19,15,11, 7, 3,-20/
      IINPUT=0
      IBUBL=0
      IF (((   LPHASE(IMATCH))
     1 .AND.(.NOT.LBUF(1))).OR.
     3 ((.NOT.LPHASE(IMATCH)).AND.(LBUF(1)))) IBUBL= 1       
      IF( ITABLE(IMATCH,ITYPE).GT.0 ) IINPUT=ITABLE(IMATCH,ITYPE)+IBUBL
C
C      IF (LCPOLAR(IMATCH).AND.(IBUBL.EQ.1)) IINPUT=IINPUT-1
C      IF (LCPOLAR(IMATCH).AND.(IBUBL.EQ.0)) IINPUT=IINPUT+1
      IBUBL = 0
      RETURN
      END
C
C****************
C
      SUBROUTINE FIXSYM(LBUF,IBUF,IC,IL,LFIRST,IBLOW,IPROD,LFX)
C     THIS SUBROUTINE EVALUATES THE FIXED SYMBOLS FOUND IN THE
C      PAL16X4 AND PAL16A4
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      LOGICAL LFUSES(32,64),LPHANT(32,64)
      COMMON /LFUZ/LFUSES,LPHANT
      LOGICAL LBUF(20),LFIRST,LMATCH,LFX
      INTEGER IC,IL,IBLOW,IPROD,I,IINPUT,J,ISUM1,IMATCH
      INTEGER*1 TABLE(5,14),IBUF(8,20),FIXBUF(8)
C
      DATA A/'A'/,B/'B'/,ISLASH/'/'/,IOR/'+'/,IBLANK/' '/,IRIGHT/')'/,
     1        IAND/'*'/,N/'N'/,Q/'Q'/,N0/'0'/,N1/'1'/,N2/'2'/,N3/'3'/,
     2      ICOLON/':'/,
     3        TABLE      /      ' ','A','+','/','B',' ',' ','A','+','B',
     4      ' ',' ',' ',' ','A','/','A','+','/','B',' ',' ',' ','/','B',
     5      'A',':','+',':','B',' ','A','*','/','B',' ','/','A','+','B',
     6      'A',':','*',':','B',' ',' ',' ',' ','B',' ',' ','A','*','B',
     7      ' ',' ',' ','/','A','/','A','*','/','B',' ','/','A','*','B'/
C
      IINPUT=0
      DO 20 I=1,8
          IBUF(I,1)=IBLANK
   20     FIXBUF(I)=IBLANK
   21 CALL INCR(IC,IL,LFX)
      CI=CPG(LOF(IL)+IC)
      IF(CI.EQ.IRIGHT) GO TO 40
      IF(CI.EQ.N0) IINPUT=8
      IF(CI.EQ.N1) IINPUT=12
      IF(CI.EQ.N2) IINPUT=16
      IF(CI.EQ.N3) IINPUT=20
      DO 24 J=1,7
   24     IBUF(J,1)=IBUF(J+1,1)
      IBUF(8,1)=CI
      IF(.NOT. ( (CI.EQ.A).OR.(CI.EQ.B).OR.(CI.EQ.ISLASH).OR.(CI.EQ.IOR)
     1       .OR.(CI.EQ.IAND).OR.(CI.EQ.ICOLON) ) )  GO TO 21
      DO 30 I=1,4
   30     FIXBUF(I)=FIXBUF(I+1)
      FIXBUF(5)=CPG(LOF(IL)+IC)
      GO TO 21
   40 IMATCH=0
      DO 60 J=1,14
          LMATCH=.TRUE.
          DO 50 I=1,5
   50         LMATCH=LMATCH .AND. ( FIXBUF(I).EQ.TABLE(I,J) )
   60     IF(LMATCH) IMATCH=J
      IF(IMATCH.EQ.0) GO TO 100
      IF(.NOT.LFIRST) GO TO 85
          LFIRST=.FALSE.
          DO 80 I=1,32
              LFUSES(I,IPROD)=.TRUE.
   80         IBLOW = IBLOW + 1
C
   85 DO 90 I=1,4
          IF( (IMATCH-7).LE.0 ) GO TO 90
          ISUM1=IINPUT+I
          LFUSES(ISUM1,IPROD)=.FALSE.
          IBLOW = IBLOW - 1
          IMATCH=IMATCH-8
   90 IMATCH=IMATCH+IMATCH
      LBUF(1)=.TRUE.
      CALL PLOT(LBUF,IBUF,IPROD,.FALSE.,ITYPE,
     1          LPROD,IOP,IBLOW,IPCTR,LPOLAR,DOIT)
  100 LFX=.FALSE.
      CALL INCR(IC,IL,LFX)
      RETURN
      END
C
C****************
C
      SUBROUTINE ECHO
C     THIS SUBROUTINE PRINTS THE PAL DESIGN SPECIFICATION INPUT FILE
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
      INTEGER IC,IL,J,K,L
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      WRITE (POF,5) (IPAL(J),J=1,4),INOAI,IOT,INOO,INOO1,
     1 (REST(J),J=1,71),(PATNUM(J),J=1,79),(TITLE(J),J=1,79),
     2 (COMP(J),J=1,79)
    5 FORMAT(/,1X,4A1,A1,A1,A1,A1,71A1,/,1X,79A1,/,1X,79A1,/,1X,
     1             79A1)
C
15    DO 200 K=1,LNMAX
200   WRITE(POF,205) (CPG(L),L=(LOF(K)+1),(LOF(K)+LLN(K)))
205   FORMAT (1X,79A1)
C
      RETURN
      END
C
C****************
C
      SUBROUTINE CAT
C     THIS SUBROUTINE PRINTS THE PALASM CATOLOG
C
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      DATA BEL/007/
      WRITE(PMS,10)
   10 FORMAT(/,'  MONOLITHIC MEMORIES 20-PIN PALASM VERSION 1.7D')
      WRITE(PMS,15) BEL
   15 FORMAT(' (C) COPYRIGHT 1983,1984 MONOLITHIC MEMORIES',A1)
      WRITE(PMS,20)
   20 FORMAT(/,'    DOCUMENT (D) - PRINTS THE PAL DEVICE DOCUMENTATION',   
     2       /,'    ECHO (E)     - PRINTS THE PAL DESIGN SPECIFICATION',
     3       /,'    PINOUT (O)   - PRINTS THE PINOUT OF THE PAL',
     4       /,'    SIMULATE (S) - EXERCISES THE FUNCTION TABLE VECTORS',
     5       /,'                   AND GENERATES TEST VECTORS',
     6       /,'    PLOT (P)     - PRINTS THE ENTIRE FUSE PLOT')
C
      WRITE(PMS,30)
   30 FORMAT(  '    BRIEF (B)    - FUSE PLOT OF THE USED PRODUCT LINES',
     2       /,'                   (PHANTOM FUSES ARE OMITTED',
     3       /,'    HEX (H)      - GENERATES HEX PROGRAMMING FORMAT',
     4       /,'    INTEL (I)    - INTEL HEX PROGRAMMING FORMAT',
     5       /,'    JEDEC (J)    - JEDEC FORMAT - DATA I/O PROGRAMMER',
     6       /,'    FAULT (F)    - FAULT TESTING ')
      WRITE(PMS,35)
   35 FORMAT(  '    CATALOG (C)  - PRINTS THIS LIST OF COMMANDS',
     1       /,'    QUIT (Q)     - EXIT THE PROGRAM')
      RETURN
      END
C
C****************
C
      SUBROUTINE PLOT(LBUF,IBUF,
     1 IPROD,LDUMP,ITYPE,LPROD,IOP,IBLOW,IPCTR0,LPOLAR,DOIT)
C     THIS THIS SUBROUTINE PRODUCES THE FUSE PLOT
C
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      INTEGER*1 ISAVE(64,32)
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /FPLOT/ ISAVE
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
      INTEGER IBLOW,IPCTR0,IPROD,IBLOW1,I,J,I8PRO,I88PRO
      INTEGER*1 IBUF(8,20),IOUT(64),PWORD(20)
      LOGICAL LBUF(20),LDUMP,LPROD(80),LPOLAR(20),DOIT
      LOGICAL LFUSES(32,64),LPHANT(32,64)
      COMMON /LFUZ/LFUSES,LPHANT
C
      DATA IAND/'*'/,IOR/'+'/,ISLASH/'/'/,HIFANT/'O'/,L/'L'/,H/'H'/,
     1     IDASH/'-'/,X/'X'/,IBLANK/' '/,P/'P'/,B/'B'/
C
      IF(LDUMP) GO TO 60
      IF(ISAVE(IPROD,1).NE.IBLANK) RETURN
      IF( LBUF(1) ) GO TO 5
      DO 30 J=1,31
   30     ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
      ISAVE(IPROD,32)=ISLASH
    5 DO 20 I=1,8
         IF( ISAVE(IPROD,1).NE.IBLANK ) RETURN
          IF( IBUF(I,1).EQ.IBLANK ) GO TO 20
          DO 10 J=1,31
   10         ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
          ISAVE(IPROD,32)=IBUF(I,1)
   20     CONTINUE
      IF(ISAVE(IPROD,1).NE.IBLANK) RETURN
   40 DO 50 J=1,31
   50     ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
      ISAVE(IPROD,32)=IAND
      RETURN
C
C     PRINT FUSE PLOT
C
   60 WRITE(POF,62) IPAL,INOAI,IOT,INOO,INOO1,(TITLE(I),I=1,79)
      IF(POF.NE.CONOUT) WRITE(CONOUT,9000)
9000  FORMAT(/,1X,'CREATING FUSE PLOT ',/)
   62 FORMAT(/,' PAL20 V1.7D - ',4A1,A1,A1,A1,A1,' - ',79A1,//,
     1 '                11 1111 1111 2222 2222 2233',/,
     2 '    0123 4567 8901 2345 6789 0123 4567 8901',/)
C      WRITE(POF,887)(IPAL(I),I=1,4),INOAI,IOT,INOO,INOO1
C  887     FORMAT(/,1X,4A1,A1,A1,A1,A1)
      DO 100 I88PRO=1,57,8
      IF(POF.NE.CONOUT) WRITE(CONOUT,9001)
          DO 94 I8PRO=1,8
              IPROD=I88PRO+I8PRO-1
              ISAVE(IPROD,32)=IBLANK
              DO 70 I=1,32
                  IF( ISAVE(IPROD,1).NE.IBLANK ) GO TO 70
                  DO 65 J=1,31
                      ISAVE(IPROD,J)=ISAVE(IPROD,J+1)
   65                 CONTINUE
                  ISAVE(IPROD,32)=IBLANK
   70         CONTINUE
              DO 80 I=1,32
                  IOUT(I)=X
                  IF( LFUSES(I,IPROD) ) IOUT(I)=IDASH
C                  WRITE(POF,888) LFUSES(I,IPROD)
C  888             FORMAT(1X,L1)
                  IOUT(I+32)=ISAVE(IPROD,I)
   80         CONTINUE
              IF(ITYPE.LE.4) CALL FANTOM(ITYPE,IOUT,IPROD,I8PRO)
              IPROD=IPROD-1
              DO 85 J=1,32
                  IF( IOP.EQ.B.AND.IOUT(J).EQ.HIFANT ) IOUT(J)=IBLANK
  85          CONTINUE
              IF( (IOP.EQ.P).OR.(IOP.EQ.B.AND.(LPROD(IPROD+1))) )
     1        WRITE(POF,90) IPROD,IOUT
   90         FORMAT(1X,I2,8(1X,4A1),1X,32A1)
   94         CONTINUE
          WRITE(POF,96)
C
   96     FORMAT(1X)
  100     CONTINUE
        IBLOW1 = 0
       DO 102 I=1,20
       IF ( .NOT.LPOLAR(I)) PWORD(I) = X
       IF (LPOLAR(I)) PWORD(I) = IDASH
       IF (LPOLAR(I)) IBLOW1 = IBLOW1 + 1
  102  CONTINUE
       WRITE(POF,103) (PWORD(I),I=12,19)
  103  FORMAT(' OUTPUT POLARITY WORD ',8A1)
       WRITE(POF,110) 
  110 FORMAT(/,
     1' LEGEND:  X : FUSE NOT BLOWN (L,N,0)   - : FUSE BLOWN   (H,P,1)')
      IF( IOP.EQ.P.AND.ITYPE.LE.4 ) WRITE(POF,111)
  111 FORMAT(
     1'          0 : PHANTOM FUSE   (L,N,0)   O : PHANTOM FUSE (H,P,1)')
      WRITE(POF,112) IBLOW+IBLOW1
  112 FORMAT(/,' NUMBER OF FUSES BLOWN = ',I4)
      IF (DOIT) WRITE(POF,1122)
 1122 FORMAT(/,' SECURITY FUSE --')
      IF (.NOT.DOIT) WRITE(POF,1123)
 1123 FORMAT(/,' SECURITY FUSE XX')
9001  FORMAT(1X,'.'$)
      RETURN
      END
C
C****************
C
      SUBROUTINE TWEEK(ITYPE,IOT)
C     THIS SUBROUTINE TWEEKS LFUSES (THE PROGRAMMING FUSE PLOT)
C      FOR HIGH AND LOW PHANTOM FUSES
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER IPROD,IINPUT
      LOGICAL LFUSES(32,64),LPHANT(32,64)
      COMMON /LFUZ/LFUSES,LPHANT
      DATA L/'L'/,C/'C'/,P/'P'/
C
      IF(ITYPE.GE.4) GO TO 20
      DO 10 IPROD=1,64
          LFUSES(15,IPROD)=.TRUE.
          LFUSES(16,IPROD)=.TRUE.
          LFUSES(19,IPROD)=.TRUE.
          LFUSES(20,IPROD)=.TRUE.
          LPHANT(15,IPROD)=.TRUE.
          LPHANT(16,IPROD)=.TRUE.
          LPHANT(19,IPROD)=.TRUE.
          LPHANT(20,IPROD)=.TRUE.
          IF(ITYPE.GE.3) GO TO 10
          LFUSES(11,IPROD)=.TRUE.
          LFUSES(12,IPROD)=.TRUE.
          LFUSES(23,IPROD)=.TRUE.
          LFUSES(24,IPROD)=.TRUE.
          LPHANT(11,IPROD)=.TRUE.
          LPHANT(12,IPROD)=.TRUE.
          LPHANT(23,IPROD)=.TRUE.
          LPHANT(24,IPROD)=.TRUE.
          IF(ITYPE.GE.2) GO TO 10
          LFUSES( 7,IPROD)=.TRUE.
          LFUSES( 8,IPROD)=.TRUE.
          LFUSES(27,IPROD)=.TRUE.
          LFUSES(28,IPROD)=.TRUE.
          LPHANT( 7,IPROD)=.TRUE.
          LPHANT( 8,IPROD)=.TRUE.
          LPHANT(27,IPROD)=.TRUE.
          LPHANT(28,IPROD)=.TRUE.
   10     CONTINUE
      DO 18 IINPUT=7,28
C
          DO 12 IPROD=1,57,8
              LFUSES(IINPUT,IPROD+4)=.FALSE.
              LFUSES(IINPUT,IPROD+5)=.FALSE.
              LFUSES(IINPUT,IPROD+6)=.FALSE.
              LFUSES(IINPUT,IPROD+7)=.FALSE.
              LPHANT(IINPUT,IPROD+4)=.TRUE.
              LPHANT(IINPUT,IPROD+5)=.TRUE.
              LPHANT(IINPUT,IPROD+6)=.TRUE.
   12         LPHANT(IINPUT,IPROD+7)=.TRUE.
          IF(ITYPE.GE.3) GO TO 18
          DO 14 IPROD=17,41,8
              LFUSES(IINPUT,IPROD+2)=.FALSE.
              LFUSES(IINPUT,IPROD+3)=.FALSE.
              LPHANT(IINPUT,IPROD+2)=.TRUE.
   14         LPHANT(IINPUT,IPROD+3)=.TRUE.
          IF(ITYPE.GE.2) GO TO 18
          DO 16 IPROD=1,57,8
              LFUSES(IINPUT,IPROD+2)=.FALSE.
              LFUSES(IINPUT,IPROD+3)=.FALSE.
              LPHANT(IINPUT,IPROD+2)=.TRUE.
   16         LPHANT(IINPUT,IPROD+3)=.TRUE.
   18 CONTINUE
   20 IF( ITYPE.EQ.1 ) RETURN
      DO 99 IINPUT=1,32
          DO 30 IPROD=1,8
              LFUSES(IINPUT,IPROD+ 0)= (IOT.NE.L)
              LPHANT(IINPUT,IPROD+ 0)= .TRUE.
              IF(IOT.EQ.C) GO TO 30
              LFUSES(IINPUT,IPROD+56)= (IOT.NE.L)
              LPHANT(IINPUT,IPROD+56)= .TRUE.
   30         CONTINUE
          IF(ITYPE.LE.2) GO TO 99
          DO 40 IPROD=1,8
              LFUSES(IINPUT,IPROD+ 8)= (IOT.NE.L)
              LPHANT(IINPUT,IPROD+ 8)= .TRUE.
              IF(IOT.EQ.C) GO TO 40
              LFUSES(IINPUT,IPROD+48)= (IOT.NE.L)
              LPHANT(IINPUT,IPROD+48)= .TRUE.
   40         CONTINUE
          IF(ITYPE.LE.3) GO TO 99
          DO 50 IPROD=1,8
              LFUSES(IINPUT,IPROD+16)= (IOT.NE.L)
              LPHANT(IINPUT,IPROD+16)= .TRUE.
              IF(IOT.EQ.C) GO TO 50
              LFUSES(IINPUT,IPROD+40)= (IOT.NE.L)
              LPHANT(IINPUT,IPROD+40)= .TRUE.
   50         CONTINUE
   99     CONTINUE
      RETURN
      END
C
C****************
C
      SUBROUTINE SLIP(I88PRO,IBLOW)
C     THIS SUBROUTINE WILL BLOW THE ENTIRE CONDITIONAL THREE-STATE
C     PRODUCT LINE WHEN 'IF(VCC)' CONDITION IS USED FOR THE
C     CORRESPONDING OUTPUT PIN
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
      INTEGER I,IBLOW,I88PRO
      LOGICAL LFUSES(32,64),LPHANT(32,64)
      COMMON /LFUZ/LFUSES,LPHANT
      DATA R/'R'/,P/'P'/,I1/'1'/,I2/'2'/,I4/'4'/,I6/'6'/,I8/'8'/
C
C  THE NEXT LINE IS FOR THE 16RP6
      IF ((IOT.EQ.R).AND.(INOO.EQ.P)) RETURN
C
      IF( (INOAI.NE.I6) .OR. (INOO.EQ.I1) .OR.  (INOO.EQ.I2) .OR.
     1 ( ((IOT.EQ.R).OR.(IOT.EQ.P)).AND.((INOO.EQ.I8).OR.(INOO1.EQ.I8)))
     2    .OR.( (I88PRO.GE. 9).AND.(I88PRO.LE.49).AND.(INOO.EQ.I6) ).OR.
     3    ( (I88PRO.GE.17).AND.(I88PRO.LE.41).AND.(INOO.EQ.I4)) ) RETURN
      DO 10 I=1,32
      IBLOW = IBLOW + 1
   10 LFUSES(I,I88PRO) = .TRUE.
      I88PRO = I88PRO + 1
      RETURN
      END
C
C****************
C
      SUBROUTINE FANTOM(ITYPE,IOUT,IPROD,I8PRO)
C     THIS SUBROUTINE UPDATES IOUT (THE PRINTED FUSE PLOT)
C      FOR HIGH AND LOW PHANTOM FUSES
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER I,I8PRO,IPROD
      INTEGER*1 IOUT(64)
      DATA X/'X'/,IDASH/'-'/,LOFANT/'0'/,HIFANT/'O'/
C
      DO 10 I=1,32
          IF( IOUT(I).EQ.IDASH ) IOUT(I)=HIFANT
          IF( IOUT(I).EQ.X )     IOUT(I)=LOFANT
   10 CONTINUE
      IF((ITYPE.EQ.4).AND.((IPROD.LE.24).OR.(IPROD.GE.41))) RETURN
      IF((ITYPE.EQ.3).AND.((IPROD.LE.16).OR.(IPROD.GE.45))) RETURN
      IF((ITYPE.EQ.2).AND.((IPROD.LE. 8).OR.(IPROD.GE.53))) RETURN
      IF((ITYPE.LE.3).AND.(I8PRO.GE.5)) RETURN
      IF((ITYPE.LE.2).AND.(IPROD.GE.19).AND.(IPROD.LE.48).AND.
     1   (I8PRO.GE.3)) RETURN
      IF((ITYPE.EQ.1).AND.(I8PRO.GE.3)) RETURN
      DO 50 I=1,32
        IF(((I.EQ.15).OR.(I.EQ.16).OR.(I.EQ.19).OR.(I.EQ.20)).AND.
     1   (ITYPE.LE.3)) GO TO 50
        IF(((I.EQ.11).OR.(I.EQ.12).OR.(I.EQ.23).OR.(I.EQ.24)).AND.
     1   (ITYPE.LE.2)) GO TO 50
        IF(((I.EQ. 7).OR.(I.EQ. 8).OR.(I.EQ.27).OR.(I.EQ.28)).AND.
     1   (ITYPE.LE.1)) GO TO 50
        IF( IOUT(I).EQ.HIFANT ) IOUT(I)=IDASH
        IF( IOUT(I).EQ.LOFANT ) IOUT(I)=X
   50 CONTINUE
      RETURN
      END
C
C****************
C
      SUBROUTINE TEST (LPHASE,LBUF,IC,IL,ILE,ISYM,IBUF,ITYPE,
     1     LFX,IPCTR,LERR,ISAF,IPCTR1,LSA11,LSA01,LPRINT,LPOLAR)
C     THIS SUBROUTINE PERFORMS THE FUNCTION TABLE SIMULATION
C      AND GENERATES TEST VECTORS
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
C
      INTEGER IC,IL,IEQN,I,J,NVECT,IPCTR3,IC1,IL1,ILL,IINP,IMESS
      INTEGER IEQN1,IPCTR4,ISAF,ISA0,ISA1,IPCTR1,IOUT,IOUTP
      INTEGER NTEST,NERR,ITRST,IPCTR,IMAX,IONE,IIFB,PLOAD,ICLOCK
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR,
     1        LFX,LSAME,XORFND,LERR,LPHASE(20),LPHAS1(20),LBUF(20),
     2        LOUT(20),LOUTP(20),LCLOCK,LPTRST,LCTRST,LENABL(20),NREG,
     3        LSA11,LSA12,LSA01,LSA02,LPRINT,LLPOL(20),LPOLAR(20),
     4        LOADIT
      INTEGER*1 IPROD,ISUM,XORSUM,ITEST 
      INTEGER*1  ISYM(8,20),ISYM1(8,20),IBUF(8,20),IVECT(20),IPIN(20)
      INTEGER*1  TSTVEC(20, 109 ),ISTATT(20),ISTATE(20),IVECTP(20)
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      INTEGER ILEQ,IFUNCT,IDESC,IEND,ILE,ILERR,IMATCH
      COMMON /FTEST/ IFUNCT,IDESC,IEND
      COMMON /TSTVEC/ NTEST,TSTVEC
C
      DATA IDASH/'-'/,L/'L'/,H/'H'/,X/'X'/,P/'P'/,Z/'Z'/,N0/'0'/,
     1     N1/'1'/,ERR/'?'/,IBLANK/' '/,COMENT/';'/,I4/'4'/,I6/'6'/,
     2      NN/'N'/,I8/'8'/,C/'C'/
      DATA BEL/007/,IONE/1/
C
         NTEST = 0
C     PRINT AN ERROR MESSAGE IF NO FUNCTION TABLE IS SUPPLIED
      IF(IFUNCT.NE.0) GO TO 3
      IF (LPRINT) WRITE(PMS,2)
    2 FORMAT(/,' FUNCTION TABLE MUST BE SUPPLIED IN ORDER TO PERFORM',
     1         ' SIMULATION')
      RETURN
C     PRINT TITLE
    3 IF((.NOT.LSA11).AND.(.NOT.LSA01).AND.LPRINT)
     1 WRITE(POF,4) (TITLE(I),I=1,79)
    4 FORMAT(/,1X,79A1,/)
C     INITIALIZE LERR (FUNCTION TABLE ERROR FLAG) TO NO ERROR
      LERR=.FALSE.
C     INITIALIZE NERR (NUMBER OF FUNCTION TABLE ERRORS) TO NO ERRORS
      NERR=0
C     INITIALIZE ITRST (THREE-STATE ENABLE FUNCTION TABLE PIN NUMBER)
      ITRST=0
C     INITILALIZE LOADIT (PRELOAD FEATURE)
      LOADIT=.FALSE.
C     SET THE STARTING POINT OF THE FUNCTION TABLE TO COLUMN 0
C     AND IFUNCT + 1
      IC=0
      IL=IFUNCT + 1
C     INITIALIZE SA1/SA0 PARAMETERS
      IPCTR3=0
      IEQN=0
      IPCTR=0
C
C     MAKE A DUMMY CALL TO INCR
      CALL INCR(IC,IL,LFX)
C     GET THE FUNCTION TABLE PIN LIST (UP TO 18)
C      GO ONE MORE THAN MAX TO LOOK FOR DASHED LINE
C
      DO 101 I=1,20
      LLPOL(I) =.FALSE.
  101 CONTINUE
      DO 10 I=1,19
      CALL GETSYM(LPHAS1,ISYM1,I,IC,IL,LFX)
         DO 5 J=1,8
    5    IBUF(J,1)=ISYM1(J,I)
      IF(IBUF(8,1).EQ.IDASH) GO TO 12
      CALL MATCH(IMATCH,IBUF,ISYM)
      IF(IMATCH.NE.0) GO TO 7 
      WRITE(PMS,6) (IBUF(J,1),J=1,8)
    6 FORMAT(/,' FUNCTION TABLE PIN LIST ERROR AT', 8A1) 
      RETURN
    7 IF (LPOLAR(IMATCH))  LLPOL(I) =.TRUE.
      LOUT(I)=.FALSE.
      ISTATT(I)=X
      IVECTP(I)=X
C     IF APPROPIATE PAL TYPE, REMEMBER LOCATION OF CLOCK AND THREE-STATE    
C      ENABLE PIN IN FUNCTION TABLE PIN LIST
      IF(ITYPE.NE.6) GO TO 10
      IF(IMATCH.EQ.1)  ICLOCK=I
      IF(IMATCH.EQ.11) ITRST=I
      IF (IMATCH.EQ.1) PLOAD = I
   10 IPIN(I)=IMATCH 
C     ALL SIGNAL NAMES FOR THE FUNCTIONAL TEST HAVE BEEN READ IN
C      ADJUST COUNT
   12 IMAX=I-1
      NVECT=0
C
C*****START OF MAIN LOOP FOR SIMULATION*****
C
C     * SA1/SA0  TESTS
C     INITIALLY THERE ARE NO FAULTS. IPCTR2 IS THE POINTER FOR
C     TOTAL NUMBER OF PRODUCT TERMS. IEQN IS EQUATION COUNT.
C     IPCTR3 IS THE PRODUCT TERM POINTER IN A PARTICULAR EQN.
   90 IPCTR2=0
      IF(POF.NE.CONOUT) WRITE(CONOUT,9001)
      IEQN=0
      IPCTR3=0
      LSA12=.FALSE.
      LSA02=.FALSE.
C*************END OF ADDITION***********
      NVECT=NVECT+1
      IC1=0
      IL1=ILE
C     GO PASSED COMMENT LINES
   23 IF(CPG(LOF(IL)+1).NE.COMENT) GO TO 24
      IL=IL+1
      GO TO 23
   24 CONTINUE
C     GETS VECTORS FROM FUNCTION TABLE
      DO 20 I=1,IMAX
        IF(CPG(LOF(IL)+IC).EQ.IBLANK) GO TO 21
        GO TO 22
   21   IC=IC+1
        IF(CPG(LOF(IL)+IC).EQ.IBLANK) GO TO 21
   22   IVECT(I)=CPG(LOF(IL)+IC)
        IC=IC+1
   20 CONTINUE
C     ADVANCE LINE COUNT TO SKIP FUNCTION TABLE COMMENTS
      IL=IL+1
C
      IC=0
      IF(IVECT(1).EQ.IDASH) GO TO 95
C     CHECK FOR VALID FUNCTION TABLE VALUES (L,H,X,Z,C,P)
      DO 11 I=1,IMAX
         IF( IVECT(I).EQ.L.OR.IVECT(I).EQ.H.OR.IVECT(I).EQ.X.OR.
     1   ( (IVECT(I).EQ.P).AND.(INOO.EQ.P))
     2   .OR.IVECT(I).EQ.Z.OR.IVECT(I).EQ.C) GO TO 11
         WRITE(PMS,8) IVECT(I),NVECT
    8    FORMAT(/,1X,A1,' IS NOT AN ALLOWED FUNCTION TABLE ENTRY',
     1                   ' IN VECTOR ',I4)
         RETURN
   11 CONTINUE
C
C     INITIALIZE CLOCK AND THREE-STATE ENABLE FLAGS
      LCLOCK=.FALSE.
      LCTRST=.TRUE.
      LPTRST=.TRUE.
      DO 13 I=1,IMAX
   13    LENABL(I)=.TRUE.
C     INITIALIZE NREG (NOT REGISTERED OUTPUT) TO FALSE
      NREG=.FALSE.
C     INITIALIZE ISTATE ARRAY TO ALL X'S
      DO 15 I=1,20
      ISTATE(I)=X
   15 CONTINUE
      IF (PLOAD.NE.0 .AND. IVECT(PLOAD).EQ.P) GO TO 505
C     CHECK IF THIS PAL TYPE HAS REGISTERS
      IF(ITYPE.NE.6) GO TO 25
C     CHECK CLOCK AND THREE-STATE ENABLE PINS AND CHANGE FLAG IF NEEDED
      IF(IVECT(ICLOCK).EQ.C) LCLOCK=.TRUE.
      IF(ITRST.EQ.0) GO TO 25
      LSAME=( (     LPHASE(11)).AND.(     LPHAS1(ITRST)).OR.
     1        (.NOT.LPHASE(11)).AND.(.NOT.LPHAS1(ITRST)) )
      IF( IVECT(ITRST).EQ.L.AND.(.NOT.LSAME).OR.
     1    IVECT(ITRST).EQ.H.AND.(     LSAME) ) LPTRST=.FALSE.
      IF(LPTRST) GO TO 25
C     DISABLE REGISTERED OUTPUTS IF APPROPRIATE
      DO 46 I=1,IMAX
         J=IPIN(I)
         IF(J.EQ.14.OR.J.EQ.15.OR.J.EQ.16.OR.J.EQ.17) LENABL(I)=.FALSE.
         IF( INOO.EQ.I6.AND.(J.EQ.13.OR.J.EQ.18) )    LENABL(I)=.FALSE.
         IF( (INOO.EQ.P.AND.INOO1.EQ.I6).AND.(J.EQ.13.OR.J.EQ.18) )
     1   LENABL(I)=.FALSE.
         IF( INOO.EQ.I8.AND.(J.EQ.12.OR.J.EQ.13
     1                   .OR.J.EQ.18.OR.J.EQ.19) )    LENABL(I)=.FALSE.
         IF ( (INOO.EQ.P.AND.INOO1.EQ.I8).AND.(J.EQ.12.OR.J.EQ.13
     1                   .OR.J.EQ.18.OR.J.EQ.19) )    LENABL(I)=.FALSE.
   46 CONTINUE
C
C*****SCAN THROUGH THE LOGIC EQUATIONS*****
C
C     MAKE A DUMMY CALL TO INCR
   25 CALL INCR(IC1,IL1,LFX)
   26 CALL GETSYM(LBUF,IBUF,IONE,IC1,IL1,LFX)
      IF(LLEFT) GO TO 29
   27 IF(.NOT.LEQUAL) GO TO 26
C*************ADDED FOR EQN CONT**********
      IF(LEQUAL) IEQN=IEQN+1
C*******************  
C     EVALUATE CONDITIONAL THREE-STATE PRODUCT LINE
   29 IF(LEQUAL) GO TO 35
      NREG=.TRUE.
   33 CALL GETSYM(LBUF,IBUF,IONE,IC1,IL1,LFX)
C
      CALL MATCH(IINP,IBUF,ISYM1)
C     CHECK FOR GND, VCC, /GND, OR /VCC IN CONDITIONAL THREE-STATE
C      PRODUCT LINE
      IF(IINP.NE.0) GO TO 32
      CALL MATCH(IMATCH,IBUF,ISYM)
      ILL=IL1
      IF( IINP.EQ.0.AND.IMATCH.NE.10.AND.IMATCH.NE.20 ) GO TO 100
      IF( IMATCH.EQ.10.AND.(LBUF(1)).OR.
     1    IMATCH.EQ.20.AND.(.NOT.LBUF(1)) ) LCTRST=.FALSE.
      GO TO 34
   32 ITEST=IVECT(IINP)
      IF(  ITEST.EQ.L.AND.(     LPHAS1(IINP)).AND.(     LBUF(1)) 
     1.OR. ITEST.EQ.H.AND.(     LPHAS1(IINP)).AND.(.NOT.LBUF(1))
     2.OR. ITEST.EQ.H.AND.(.NOT.LPHAS1(IINP)).AND.(     LBUF(1))
     3.OR. ITEST.EQ.L.AND.(.NOT.LPHAS1(IINP)).AND.(.NOT.LBUF(1))
     4  )  LCTRST=.FALSE.
      IF(ITEST.EQ.X.OR.ITEST.EQ.Z) LCTRST=.FALSE.
   34 IF(LAND) GO TO 33
      GO TO 27
C
C     EVALUATE THE LOGIC EQUATION
C
C     FIND THE PIN NUMBER OF THE OUTPUT VECTORS
C     *ADDTION FOR SA0/SA1 TEST
   35  IPCTR3=0
C     *END OF ADDITION
      CALL MATCH(IOUTP,IBUF,ISYM1)
C     FLAG UNREGISTERED OUTPUTS
      CALL MATCH(IOUT,IBUF,ISYM)
      IF(ITYPE.LE.5) NREG=.TRUE.
      IF( (INOO.EQ.I4.OR.INOO.EQ.I6).AND.(IOUT.EQ.12.OR.IOUT.EQ.19) )
     1     NREG=.TRUE.
      IF( (INOO1.EQ.I4.OR.INOO1.EQ.I6).AND.(IOUT.EQ.12.OR.IOUT.EQ.19))
     1     NREG=.TRUE.
      IF( (INOO.EQ.I4).AND.(IOUT.EQ.13.OR.IOUT.EQ.18) ) NREG=.TRUE.
      IF( (INOO1.EQ.I4).AND.(IOUT.EQ.13.OR.IOUT.EQ.18)) NREG=.TRUE.
      ILL=IL1
      IF(IOUTP.EQ.0) GO TO 100
      IF(NREG) LENABL(IOUTP)=LCTRST
      LOUT(IOUTP)=.TRUE.
      IF( .NOT.LCTRST ) LOUT(IOUTP)=.FALSE.
      LCTRST=.TRUE.
      LOUTP(IOUTP)=LBUF(1)
C
C     DETERMINE PRODUCT TERM AND EVENTUALLY SUM FOR OUTPUT KEEPING 
C      TRACK TO SEE IF AN XOR (EXCLUSIVE OR) HAS BEEN FOUND
      XORSUM=H
      XORFND=.FALSE.
      ISUM=L
C*********THE FOLLOWING IS THE ADDITION FOR SA1/SA0  TESTS***
   28 IPCTR2=IPCTR2+1
      IPCTR3=IPCTR3+1
C*********END OF ADDITION*********
      IPCTR=IPCTR+1
      IPROD=H
   30 ILL=IL1
      CALL GETSYM(LBUF,IBUF,IONE,IC1,IL1,LFX)
      IF( .NOT.LFX ) GO TO 39
C     EVALUATE THE FIXED SYMBOLS FOUND IN THE PAL16X4 AND PAL16A4
C
          LFX=.FALSE.
          CALL FIXTST(LPHAS1,LBUF,IC1,IL1,ISYM,ISYM1,IBUF,
     1                IVECT,IVECTP,ITEST,LCLOCK,NREG,LFX)
          IF(IPROD.EQ.H) IPROD=ITEST
          GO TO 38
   39 CALL MATCH(IINP,IBUF,ISYM1)
      IF(IINP.NE.0) GO TO 47
      CALL MATCH(IMATCH,IBUF,ISYM)
      IF(IMATCH.NE.10.AND.IMATCH.NE.20) GO TO 100
C     TWEEK FOR GND AND VCC IN PRODUCT LINE
      IF(IMATCH.EQ.10) ITEST=L
      IF(IMATCH.EQ.20) ITEST=H
      IINP=19
      LPHAS1(19)=.TRUE.
      GO TO 37
   47 IF (IINP .NE. 99) ITEST=IVECT(IINP)
C     GET REGISTERED FEED BACK VALUES
      IF (NREG) GO TO 37
      CALL MATCH(IIFB,IBUF,ISYM)
      IF( (INOO.EQ.I4.OR.INOO.EQ.I6.OR.INOO.EQ.I8).AND.
     1    (IIFB.EQ.14.OR.IIFB.EQ.15.OR.IIFB.EQ.16.OR.IIFB.EQ.17) )
     2     ITEST=IVECTP(IINP)
      IF( (INOO1.EQ.I4.OR.INOO1.EQ.I6.OR.INOO1.EQ.I8).AND.
     1    (IIFB.EQ.14.OR.IIFB.EQ.15.OR.IIFB.EQ.16.OR.IIFB.EQ.17) )
     2     ITEST=IVECTP(IINP)
      IF( (INOO.EQ.I6.OR.INOO.EQ.I8).AND.(IIFB.EQ.13.OR.IIFB.EQ.18) )
     1     ITEST=IVECTP(IINP)
      IF( (INOO1.EQ.I6.OR.INOO1.EQ.I8).AND.(IIFB.EQ.13.OR.IIFB.EQ.
     1     18) ) ITEST=IVECTP(IINP)

      IF(  INOO.EQ.I8.AND.(IIFB.EQ.12.OR.IIFB.EQ.19) )
     1     ITEST=IVECTP(IINP)
      IF(  INOO1.EQ.I8.AND.(IIFB.EQ.12.OR.IIFB.EQ.19) )
     1     ITEST=IVECTP(IINP)
   37 IF( ITEST.EQ.X.OR.ITEST.EQ.Z ) ITEST=L
      IF(  ITEST.EQ.L.AND.(     LPHAS1(IINP)).AND.(     LBUF(1)) 
     1.OR. ITEST.EQ.H.AND.(     LPHAS1(IINP)).AND.(.NOT.LBUF(1))
     2.OR. ITEST.EQ.H.AND.(.NOT.LPHAS1(IINP)).AND.(     LBUF(1))
     3.OR. ITEST.EQ.L.AND.(.NOT.LPHAS1(IINP)).AND.(.NOT.LBUF(1)) 
     4  )  IPROD=L
C     *THE FOLLOWING ADDITION IS FOR SA1 TEST
C     CHECK FOR A PARTICULAR PRODUCT TERM AND GO FOR SA1 TEST
      IF((IPCTR2.EQ.IPCTR1).AND.(LSA11))GO TO 110
C     *END OF ADDITION
   38 IF(LRIGHT) CALL INCR(IC1,IL1,LFX)
      IF(LAND) GO TO 30
C     *SA0 ADDITION
C     CHECK FOR A PARTICULAR PRODUCT TERM AND GO FOR SA0 TEST
      IF((IPCTR2.EQ.IPCTR1).AND.(LSA01))GO TO 120
C     *END OF ADDITION 
  121 IF(ISUM.EQ.L.AND.IPROD.EQ.X) ISUM=X
      IF( (ISUM.NE.H).AND.IPROD.EQ.H ) ISUM=H
C     CHECK FOR XOR (EXCLUSIVE OR) AND SAVE INTERMEDIATE VALUE 
      IF(.NOT.LXOR) GO TO 31
      XORSUM=ISUM
      XORFND=.TRUE.
      ISUM=L
      GO TO 28
   31 IF(LOR) GO TO 28
      IPCTR3=0
C     IF END OF EQUATION HAS BEEN FOUND, DETERMINE FINAL SUM AND SAVE IT    
      IF(.NOT.XORFND)    ISTATT(IOUTP)=ISUM
      IF( (XORFND).AND.((ISUM.EQ.L.AND.XORSUM.EQ.L).OR.
     1                  (ISUM.EQ.H.AND.XORSUM.EQ.H)) ) ISTATT(IOUTP)=L
      IF( (XORFND).AND.((ISUM.EQ.H.AND.XORSUM.EQ.L).OR.
     1                  (ISUM.EQ.L.AND.XORSUM.EQ.H)) ) ISTATT(IOUTP)=H
      IF( (XORFND).AND. (ISUM.EQ.X.OR. XORSUM.EQ.X) )  ISTATT(IOUTP)=X
C     REGISTER DOES NOT CHANGE STATE IF NO CLOCK PULSE IS RECEIVED
      IF( (LCLOCK).OR.(NREG) ) GO TO 36
      LSAME = ( (     LOUTP(IOUTP)).AND.(     LPHAS1(IOUTP)).OR.
     1          (.NOT.LOUTP(IOUTP)).AND.(.NOT.LPHAS1(IOUTP)) )
      IF( IVECTP(IOUTP).EQ.L.AND.(     LSAME) ) ISTATT(IOUTP)=L
      IF( IVECTP(IOUTP).EQ.H.AND.(     LSAME) ) ISTATT(IOUTP)=H
      IF( IVECTP(IOUTP).EQ.L.AND.(.NOT.LSAME) ) ISTATT(IOUTP)=H
      IF( IVECTP(IOUTP).EQ.H.AND.(.NOT.LSAME) ) ISTATT(IOUTP)=L
   36 NREG=.FALSE.
C     CHECK IF ALL EQUATIONS HAVE BEEN PROCESSED BY COMPARING CURRENT
C      LINE NUMBER WITH FUNCTION TABLE LINE NUMBER
       IF(IDESC.NE.0.AND.IL1.LT.IFUNCT.AND.IL1.LT.IDESC.OR.
     1   IDESC.EQ.0.AND.IL1.LT.IFUNCT) GO TO 27
C     DETERMINE OUTPUT LOGIC VALUES
C      COMPARE OUTPUTS TO SEE IF VECTOR AGREES WITH RESULTS
      DO 50 I=1,IMAX
      IF( .NOT.LOUT(I) ) GO TO 50
      IF( ISTATT(I).EQ.X.AND.IVECT(I).EQ.X ) GO TO 50
      LSAME = ( (     LOUTP(I)).AND.(     LPHAS1(I)).OR.
     1          (.NOT.LOUTP(I)).AND.(.NOT.LPHAS1(I)) )
      IMESS=40
      IF(ISTATT(I).EQ.L.AND.IVECT(I).EQ.L.AND.(.NOT.LSAME)) 
     1         IMESS=41
      IF(ISTATT(I).EQ.H.AND.IVECT(I).EQ.H.AND.(.NOT.LSAME)) 
     1         IMESS=42
      IF(ISTATT(I).EQ.L.AND.IVECT(I).EQ.H.AND.(     LSAME)) 
     1          IMESS=42
      IF(ISTATT(I).EQ.H.AND.IVECT(I).EQ.L.AND.(     LSAME)) 
     1          IMESS=41
      IF( (     LENABL(I)).AND.IVECT(I).EQ.Z )              IMESS=43
      IF( (.NOT.LENABL(I)).AND.(LOUT(I)).AND.IVECT(I).NE.Z) IMESS=44
      IF(IMESS.NE.40) LERR=.TRUE.
C     *THIS IS AN ADDITION FOR SA1/SA0  TESTS
C     IF NO FAULT GO FOR NEXT VECTOR ELSE GET OUT OF SIMULATION AND
C     START SIMULATION FOR THE NEXT PRODUCT TERM. 
      IF((.NOT.LERR).AND.((LSA11).OR.(LSA01))) GO TO 50
      IF((LERR).AND.((LSA11).OR.(LSA01))) GO TO 115
C*******************
      IF(IMESS.EQ.41) WRITE(PMS,41) NVECT,(ISYM1(J,I),J=1,8)
   41 FORMAT(/,' FUNCTION TABLE ERROR IN VECTOR',I4,'  PIN =',8A1,
     1         '  EXPECT = H  ACTUAL = L')
      IF(IMESS.EQ.42) WRITE(PMS,42) NVECT,(ISYM1(J,I),J=1,8)
   42 FORMAT(/,' FUNCTION TABLE ERROR IN VECTOR',I4,'  PIN =',8A1,
     1         '  EXPECT = L  ACTUAL = H')
      IF(IMESS.EQ.43) WRITE(PMS,43) NVECT,(ISYM1(J,I),J=1,8)
   43 FORMAT(/,' FUNCTION TABLE ERROR IN VECTOR',I4,'  PIN =',8A1, 
     1       /,'  EXPECT  = OUTPUT ENABLE  ACTUAL = Z')
      IF(IMESS.EQ.44) WRITE(PMS,44) NVECT,(ISYM1(J,I),J=1,8),IVECT(I)
   44 FORMAT(/,' FUNCTION TABLE ERROR IN VECTOR',I4,'  PIN =',8A1,
     1         '  EXPECT = Z  ACTUAL = ',A1)
      IF( (IMESS.NE.40).AND.(PMS.EQ.6) ) WRITE(PMS,45) BEL
   45 FORMAT(1X,A1)
      IF(IMESS.NE.40) IVECT(I)=ERR
      IF(IMESS.NE.40) NERR=NERR+1
   50 CONTINUE
      GO TO 510
C
C     CHANGE THE ORDER OF VECTORS FROM THE ORDER OF APPEARANCE IN THE
C      FUNCTION TABLE TO THAT OF THE PIN LIST AND TWEEK FOR OUTPUT
  505    LOADIT =.TRUE.
  510    DO 66 I=1,20
         DO 55 J=1,IMAX
         IF(IPIN(J).NE.I) GO TO 55
         IF( IVECT(J).EQ.L.OR.IVECT(J).EQ.H ) GO TO 51
         ISTATE(I)=IVECT(J)
         GO TO 65
   51    LSAME=( (     LPHASE(I)).AND.(     LPHAS1(J)).OR.    
     1           (.NOT.LPHASE(I)).AND.(.NOT.LPHAS1(J)) )
         IF( INOO.EQ.N1.AND.(I.EQ.15.OR.I.EQ.16) )  LOUT(J)=.TRUE.
         IF(INOO1.EQ.N1.AND.(I.EQ.15.OR.I.EQ.16) )  LOUT(J)=.TRUE.
         IF( (.NOT.LOUT(J)).AND.(     LSAME).AND.
     1         IVECT(J).EQ.L )                      ISTATE(I)=N0
         IF( (.NOT.LOUT(J)).AND.(     LSAME).AND.
     1         IVECT(J).EQ.H )                      ISTATE(I)=N1
         IF( (.NOT.LOUT(J)).AND.(.NOT.LSAME).AND.
     1         IVECT(J).EQ.L )                      ISTATE(I)=N1
         IF( (.NOT.LOUT(J)).AND.(.NOT.LSAME).AND.
     1         IVECT(J).EQ.H )                      ISTATE(I)=N0
         IF( (     LOUT(J)).AND.(     LSAME).AND.
     1         IVECT(J).EQ.L.AND.(     LENABL(J)) ) ISTATE(I)=L
         IF( (     LOUT(J)).AND.(     LSAME).AND.
     1         IVECT(J).EQ.H.AND.(     LENABL(J)) ) ISTATE(I)=H
         IF( (     LOUT(J)).AND.(.NOT.LSAME).AND.
     1         IVECT(J).EQ.L.AND.(     LENABL(J)) ) ISTATE(I)=H
         IF( (     LOUT(J)).AND.(.NOT.LSAME).AND.
     1         IVECT(J).EQ.H.AND.(     LENABL(J)) ) ISTATE(I)=L
         IF ( (LOADIT).AND.
     1      (LSAME).AND.IVECT(J).EQ.H)              ISTATE(I)=N1
         IF ( (LOADIT).AND.
     1       (LSAME).AND.IVECT(J).EQ.L)              ISTATE(I)=N0
         IF ( (LOADIT).AND.
     1      (.NOT.LSAME).AND.IVECT(J).EQ.H )        ISTATE(I)=N0
         IF ( (LOADIT).AND.
     1      (.NOT.LSAME).AND.IVECT(J).EQ.L )        ISTATE(I)=N1
         IF ((J.EQ.PLOAD).AND.(IVECT(J).EQ.P))      ISTATE(1) = P
         IF( IVECT(J).EQ.ERR )                      ISTATE(I)=ERR
         GO TO 65
   55 CONTINUE
C     SAVE PRESENT VECTORS FOR FEED BACK USED WITH NEXT SET OF VECTORS
C      IF CLOCK PULSE AND NOT Z (HI-Z IS ASYNCHRONOUS)
   65 IF( (LCLOCK).AND.IVECT(J).NE.Z) IVECTP(J)=IVECT(J)
      IF (ISTATE(1).EQ.P) IVECTP(J)=IVECT(J)
   66 CONTINUE
C     ASSIGN X TO GROUND PIN AND 1 TO VCC PIN
      ISTATE(10)=X
      ISTATE(20)=N1
      LOADIT=.FALSE.
C     PRINT TEST VECTORS
      IF((.NOT.LSA11).AND.(.NOT.LSA01).AND.LPRINT)
     1 WRITE(POF,60) NVECT,(ISTATE(I),I=1,20)
   60 FORMAT(1X,I4,1X,20A1)
C
C         GENERATE TEST VECTORS FOR
C         JEDEC FORMAT OUTPUT
C
         IF (NVECT.GE. 109 ) WRITE(PMS,1000)
 1000    FORMAT(' WARNING: MORE THAN  109  TEST VECTORS.  JEDEC DATA')
         IF (NVECT.GT. 109 ) GO TO 90
         NTEST = NTEST + 1
         DO 1010 I = 1,20
            TSTVEC(I,NTEST) = ISTATE(I)
 1010    CONTINUE
C
                TSTVEC(10,NTEST) = NN
                TSTVEC(20,NTEST) = NN
C
C                  END OF ADDITIONS 
C
      GO TO 90
C     TERMINATE SIMULATION
C     *ADITION FOR SA0/SA1 TESTS
   95 IF((.NOT.LERR).AND.(LSA11).AND.LPRINT)
     1 WRITE(POF,150) IPCTR4,IEQN1
  150 FORMAT(1X,' PRODUCT: ',I3,' OF ','EQUATION.',I3,'
     1 UNTESTED(SA1)FAULT')
      IF((.NOT.LERR).AND.(LSA01).AND.LPRINT)
     1 WRITE(POF,155) IPCTR4,IEQN1
  155 FORMAT(1X,' PRODUCT: ',I3,' OF ','EQUATION.',I3,'
     1 UNTESTED(SA0)FAULT')  
C     *END OF ADDITION
      IF((.NOT.LERR).AND.((.NOT.LSA11).AND.(.NOT.LSA01)).AND.LPRINT)
     1 WRITE(POF,67)
   67 FORMAT(/,' PASS SIMULATION')
      IPCTR=IPCTR/(NVECT-1)
      IF((     LERR).AND.((.NOT.LSA11).AND.(.NOT.LSA01)).AND.LPRINT)
     1 WRITE(POF,68) NERR
   68 FORMAT(/,' NUMBER OF FUNCTION TABLE ERRORS =',I4)
      RETURN
C     PRINT AN ERROR MESSAGE FOR AN UNDEFINED PIN NAME
  100 ILERR=ILL+4
      WRITE(PMS,1012) (IBUF(I,1),I=1,8),ILERR,
     1 (CPG(I),I=(LOF(ILL)+1),(LOF(ILL)+LLN(ILL)))
 1012 FORMAT('ERROR SYMBOL = ',8A1,' IN LINE NUMBER ',I4,/,1X,80A1)
      WRITE (PMS,1013)
 1013 FORMAT(' PIN NAME IS NOT DEFINED IN THE FUNCTION TABLE PIN LIST')
      RETURN
C     *THIS IS AN ADDITION FOR SA1 TEST
C     THE PRODUCT TERM IS PULLED HIGH AND THE PRODUCT NUMBER
C     AND EQN NUMBER IS REMEMBERED
  110 IPROD=H
      LSA12=.TRUE.
      IEQN1=IEQN
      IPCTR4=IPCTR3
      GO TO 38
C     *END OF ADDITION
C
C     *SA0 ADDITION
C     THE PRODUCT TERM IS TESTED FOR SA0 FAULT AND ALSO REMEMBERED
  120 IPROD=L
      LSA02=.TRUE.
      IEQN1=IEQN
      IPCTR4=IPCTR3
      GO TO 121
C     *END OF ADDITION
C
C     *ADDITION FOR SA1/SA0  TESTS
C     IF NO FAULT THEN NEXT PRODUCT TERM
  115 ISAF=ISAF+1
C
      LERR=.FALSE.
9001  FORMAT(1X,'.'$)
      RETURN
C     *END OF ADDITION
      END
C
C****************
C
      SUBROUTINE FIXTST(LPHAS1,LBUF,IC1,IL1,ISYM,ISYM1,IBUF,
     1                  IVECT,IVECTP,ITEST,LCLOCK,NREG,LFX)
C     THIS SUBROUTINE EVALUATES THE FIXED SYMBOLS FOUND IN THE
C      PAL16X4 AND PAL16A4 FOR THE FUNCTION TABLE
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
C
      LOGICAL LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR,
     1        LFX,LPHAS1(20),LBUF(20),LCLOCK,NREG,TOR,TXOR,TXNOR,TAND,
     2        LPHASA,LPHASB
      INTEGER IC,IL,IC1,IL1,IONE,IINP,IIFB
      INTEGER*1 ISYM(8,20),ISYM1(8,20),IBUF(8,20),IVECT(20),IVECTP(20)
      INTEGER*1 ITESTA,ITESTB
      COMMON  LBLANK,LLEFT,LAND,LOR,LSLASH,LEQUAL,LRIGHT,LXOR,LXNOR
      DATA L/'L'/,H/'H'/,X/'X'/,Z/'Z'/,IONE/1/
C
C     GET OUTPUT PIN AN (WHERE N=0,1,2,3)
      CALL GETSYM(LBUF,IBUF,1,IC1,IL1,LFX)
      CALL MATCH(IINP,IBUF,ISYM1)
      ITESTA=IVECT(IINP)
      LPHASA = ( (     LBUF(1)).AND.(     LPHAS1(IINP)).OR.
     1           (.NOT.LBUF(1)).AND.(.NOT.LPHAS1(IINP)) )
C     GET REGISTERED FEED BACK VALUES
      IF(NREG) GO TO 5
      CALL MATCH(IIFB,IBUF,ISYM)
      IF( IIFB.EQ.14.OR.IIFB.EQ.15.OR.IIFB.EQ.16.OR.IIFB.EQ.17 )
     1    ITESTA=IVECTP(IINP)
    5 IF( (.NOT.LPHASA).AND.ITESTA.EQ.L ) GO TO 10
      IF( (.NOT.LPHASA).AND.ITESTA.EQ.H ) GO TO 15
      GO TO 20
   10 ITESTA=H
      GO TO 20
   15 ITESTA=L
   20 IF( .NOT.LRIGHT ) GO TO 25
           ITEST=ITESTA
           RETURN
C     SAVE THE FIXED SYMBOL OPERATORS
   25 TOR   = (LOR.AND.(.NOT.LXOR))
      TXOR  = (LXOR)
      TXNOR = (LXNOR)
      TAND  = (LAND.AND.(.NOT.LXNOR))
C     GET INPUT BN (WHERE N=0,1,2,3)
      CALL GETSYM(LBUF,IBUF,1,IC1,IL1,LFX)
      CALL MATCH(IINP,IBUF,ISYM1)
      ITESTB=IVECT(IINP)
      LPHASB = ( (     LBUF(1)).AND.(     LPHAS1(IINP)).OR.
     1           (.NOT.LBUF(1)).AND.(.NOT.LPHAS1(IINP)) )
      IF( (.NOT.LPHASB).AND.ITESTB.EQ.L ) GO TO 30
      IF( (.NOT.LPHASB).AND.ITESTB.EQ.H ) GO TO 35
      GO TO 40
   30 ITESTB=H
C
      GO TO 40
   35 ITESTB=L
C     EVALUATE THE FIXED SYMBOL EXPRESSION
   40 ITEST=L
      IF(   (TOR).AND.(ITESTA.EQ.H.OR. ITESTB.EQ.H) )      ITEST=H
      IF(  (TXOR).AND.((ITESTA.EQ.H.AND.ITESTB.NE.H).OR.
     1                 (ITESTA.NE.H.AND.ITESTB.EQ.H) ))    ITEST=H
      IF( (TXNOR).AND.((ITESTA.EQ.ITESTB).OR.
     1                 (ITESTA.EQ.X.OR.ITESTB.EQ.X) ))     ITEST=H
      IF(  (TAND).AND.(ITESTA.NE.L.AND.ITESTB.NE.L) )      ITEST=H
      IF( (ITESTA.EQ.X.OR.ITESTA.EQ.Z).AND.(ITESTB.EQ.X) ) ITEST=X
      RETURN
      END
C
C********************
C
      SUBROUTINE HEX(IOP)
C     THIS SUBROUTINE GENERATES INTEL & HEX PROGRAMMING FORMATS
C
      IMPLICIT INTEGER*1 (A-Z)
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      LOGICAL LFUSES(32,64),LPHANT(32,64)
      COMMON /LFUZ/LFUSES,LPHANT
      INTEGER IHEX,ADDR,ISUM2,IPROD,CSUM,I,J,INC,IINPUT,HSUM,ZCSUM(4)
      INTEGER*1   ZTABLE(16),ITEMP(32)
      DATA ZTABLE/'0','1','2','3','4','5','6','7','8','9',
     1  'A','B','C','D','E','F'/
      DATA BEL/007/,SOH/1/,STX/2/,ETX/3/,IBLANK/' '/
      DATA CH/'H'/,CI/'I'/
C
      HSUM=0
      ADDR = 0
C
      IF(PDF.NE.CONOUT) WRITE(CONOUT,9000)
9000  FORMAT(/,1X,'GENERATING PROGRAMMING FORMAT ',/)
      IF (IOP .EQ. CH) WRITE (PDF,10) BEL,BEL,BEL,STX,SOH
10    FORMAT (/,32X,'.',/,1X,5A1)
      DO 40 I=1,33,32
      INC=I-1
        DO 40 IPROD=1,8
          IF(PDF.NE.CONOUT) WRITE(CONOUT,9001)
          CSUM = MOD(ADDR/256+MOD(ADDR,256)+32,256)
          DO 20 IINPUT=1,32
              IHEX=0
              ISUM2=IPROD + INC
              IF(LFUSES(IINPUT,ISUM2 +  0 )) IHEX=IHEX+1
              IF(LFUSES(IINPUT,ISUM2 +  8 )) IHEX=IHEX+2
              IF(LFUSES(IINPUT,ISUM2 + 16 )) IHEX=IHEX+4
              IF(LFUSES(IINPUT,ISUM2 + 24 )) IHEX=IHEX+8
              HSUM=HSUM+IHEX
              CSUM=MOD(CSUM+IHEX,256)
              ITEMP(IINPUT)=ZTABLE(IHEX+1)
   20     CONTINUE
          IF(CSUM.NE.0) CSUM=256-CSUM
C
          IF (IOP .EQ.CH) WRITE(PDF,35) ITEMP
35            FORMAT (1X,32(A1,1X),'.')
          IF (IOP .EQ. CI) WRITE(PDF,60)
     1        ZTABLE(ADDR/4096+1),ZTABLE(MOD(ADDR/256,16)+1),
     1        ZTABLE(MOD(ADDR/16,16)+1),
     2        ZTABLE(MOD(ADDR,16)+1),ITEMP,
     3        ZTABLE(CSUM/16+1),ZTABLE(MOD(CSUM,16)+1)
          ADDR = ADDR + 32
   40   CONTINUE
60    FORMAT(' :20',4A1,'00',32('0',A1),2A1)
      IF (IOP .EQ.CI) WRITE(PDF,70)
70    FORMAT(' :00000001FF')
C
      DO 80 J=1,4
         IHEX=HSUM-16*(HSUM/16)
         ZCSUM(5-J)=ZTABLE(IHEX+1)
80       HSUM=HSUM/16
      IF (ZCSUM(1).EQ.ZTABLE(1)) ZCSUM(1)=IBLANK
      IF (IOP .EQ.CH) WRITE(PDF,85) ETX
85    FORMAT (1X,/,32X,'.',/,1X,A1)
      IF (IOP .EQ.CH) WRITE(PDF,90) (ZCSUM(J),J=1,4)
90    FORMAT (/,'  HEX CHECK SUM = ',4A1)
9001  FORMAT(1X,'.'$)
      RETURN
      END
C
C****************
C
      SUBROUTINE PINOUT
C     THIS SUBROUTINE PRINTS THE PINOUT OF THE PAL
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 CPG(9999),CLN(80)
      INTEGER*2 LOF(250),LLN(250),LNPTR,LNMAX
      COMMON /PDS/ LNMAX,LOF,LLN
      COMMON /LINBUF/ CLN,CPG
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
C
      INTEGER I,J,IC,IL,II
      INTEGER*1 IIN(7,2),PIN(12,20)
      DATA IBLANK/' '/,ISTAR/'*'/
C
      DO 10 J=1,20
          DO 5 I=1,12
    5         PIN(I,J)=IBLANK
   10 CONTINUE
   15 DO 25 J=1,2
          DO 20 I=1,7
   20         IIN(I,J)=IBLANK
   25 CONTINUE
      IIN(2,1)=IPAL(1)
      IIN(4,1)=IPAL(2)
      IIN(6,1)=IPAL(3)
      IIN(1,2)=IPAL(4)
      IIN(3,2)=INOAI
      IIN(5,2)=IOT
      IIN(6,2)=INOO
      IIN(7,2)=INOO1
      J=0
      IL=0
   30 IC=0
      IL=IL+1
   35 IC=IC+1
   40 IF( IC.GT.LLN(IL) ) GO TO 30
      IF( CPG(LOF(IL)+IC).EQ.IBLANK ) GO TO 35
      J=J+1
      IF(J.GT.20) GO TO 60
      DO 55 I=1,12
          PIN(I,J)=CPG(LOF(IL)+IC)
          IC=IC+1
          IF( IC.GT.LLN(IL) ) GO TO 40
          IF( CPG(LOF(IL)+IC).EQ.IBLANK ) GO TO 40
C
   55 CONTINUE
   60 DO 75 J=1,10
          II=0
   65     II=II+1
          IF(II.EQ.13) GO TO 75
          IF( PIN(II,J).NE.IBLANK ) GO TO 65
          I=13
   70     I=I-1
          II=II-1
          PIN(I,J)=PIN(II,J)
          PIN(II,J)=IBLANK
          IF(II.NE.1) GO TO 70
   75 CONTINUE
      WRITE(POF,76) (TITLE(I),I=1,79)
   76 FORMAT(/,1X,79A1)
      WRITE(POF,78)
   78 FORMAT(/,1X,18X,14('*'),3X,14('*'),
     1       /,1X,18X,'*',13X,'*',1X,'*',13X,'*')
      JJ=20
      DO 88 J=1,10
      IF(CONOUT.NE.POF) WRITE(POF,80)
   80     FORMAT(1X,15X,4('*'),29X,4('*'))
          WRITE(POF,81) (PIN(I,J),I=1,12),ISTAR,J,ISTAR,
     1         (IIN(I,1),I=1,7),ISTAR,JJ,ISTAR,(PIN(I,JJ),I=1,12)
   81     FORMAT(1X,12A1,3X,A1,I2,A1,11X,7A1,11X,A1,I2,A1,3X,12A1)
      IF(CONOUT.NE.POF) WRITE(POF,80)
          WRITE(POF,84) ISTAR,(IIN(I,2),I=1,7),ISTAR
   84     FORMAT(1X,18X,A1,11X,7A1,11X,A1)
          DO 86 II=1,2
              DO 85 I=1,7
   85             IIN(I,II)=IBLANK
   86     CONTINUE
          JJ=JJ-1
   88 CONTINUE
      WRITE(POF,90)
   90 FORMAT(1X,18X,31('*'))
      RETURN
      END
C
C****************
C
      SUBROUTINE JEDEC(ITYPE,DOIT,ITERM,LPOLAR)
C     THIS SUBROUTINE GENERATES THE JEDEC PROGRAMMING FORMAT WHICH IS
C      COMPATIBLE WITH THE DATA I/O PROGRAMMABLE LOGIC PAK (PLDS)
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 IPAL(4),INOAI,IOT,INOO,INOO1
      INTEGER*1 REST(72),PATNUM(80),TITLE(80),COMP(80)
      COMMON /SPEC/ IPAL,INOAI,IOT,INOO,INOO1,REST,PATNUM,TITLE,COMP
      COMMON /LUNIT/ CONINP,CONOUT,FILINP,FILOUT,PMS,POF,PDF,ROC,RPD
C
      LOGICAL LFUSES(32,64),LPHANT(32,64),LPOLAR(20),DOIT
      INTEGER*1 IPBUF(32),IDECIO(4)
      INTEGER NFUSE,NTEST,IADR,IPT,IINP,PINOUT,I,J,J1,J2,IGH
      COMMON /LFUZ/LFUSES,LPHANT
      INTEGER*1 TSTVEC(20, 109 )
      COMMON /TSTVEC/ NTEST,TSTVEC
      DATA ZERO/'0'/,ONE/'1'/,STX/2/,ETX/3/,CH/'H'/,STAR/'*'/
C
      IADR=0
      IGH=0
C
      IF (ITYPE.NE.6) GOTO 24
      PINOUT = 24
      GOTO 30
   24 IF(IOT.NE.L) GOTO 28
      PINOUT = ITYPE + 12
      GOTO 30
   28 PINOUT = ITYPE + 17
      IF ((ITYPE.EQ.4).AND.(IOT.EQ.CH)) PINOUT = PINOUT + 1
30    WRITE(PDF,32) STX
32    FORMAT (1X,A1)
C
      WRITE (POF,8) (IPAL(J),J=1,4),INOAI,IOT,INOO,INOO1,
     1 (REST(J),J=1,71),(PATNUM(J),J=1,79),(TITLE(J),J=1,79),
     2 (COMP(J),J=1,79)
8     FORMAT(1X,4A1,A1,A1,A1,A1,71A1,/,1X,79A1,/,1X,79A1,/,1X,
     1             79A1)
C
      WRITE(PDF,10) PINOUT
   10 FORMAT(1X,'*D22',I2,'*')
C
C     SECURITY FUSE CONDITION (DOIT)
      IF (DOIT) WRITE(PDF,101)
  101 FORMAT(1X,'G1*F0*')
      IF (.NOT.DOIT) WRITE(PDF,102)
  102 FORMAT(1X,'G0*F0*')
C
      DO 300 IPT=1,64
      IF (LPHANT(9,IPT)) GOTO 300
      NFUSE = 0
      DO 50 IINP=1,32
      IF (LPHANT(IINP,IPT)) GO TO 50
      NFUSE = NFUSE + 1
      IF(LFUSES(IINP,IPT)) IPBUF(NFUSE)=ONE
      IF(.NOT.(LFUSES(IINP,IPT))) IPBUF(NFUSE)=ZERO
   50 CONTINUE
      IF(LFUSES(1,IPT)) GO TO 100
      IF(.NOT.LFUSES(2,IPT)) GO TO 250
C
100   CALL ENCD(IDECIO,IADR)
      WRITE(PDF,201) IDECIO,(IPBUF(I),I=1,NFUSE),STAR
  201 FORMAT(' L',4A1,1X,33A1)
  250 IADR=IADR+NFUSE
  300 CONTINUE
C
C     * OUTPUT POLARITY VERSION 1.7A - MSB TO LSB*
      IF (ITERM.EQ.0) GOTO 365
      CALL ENCD(IDECIO,IADR)
C
      DO 3650 NFUSE=1,8
      IGH=NFUSE+11
      IF (LPOLAR(IGH)) IPBUF(9-NFUSE)=ONE
3650  IF (.NOT.LPOLAR(IGH)) IPBUF(9-NFUSE)=ZERO
      WRITE(PDF,2010)IDECIO,(IPBUF(I),I=1,8)
2010  FORMAT(' L',4A1,1X,8A1,'*')
C
365   IF (NTEST.EQ.0) GOTO 380
C     IF(NTEST.GT.50) NTEST = 50
      DO 370 J = 1,NTEST
C
      CALL ENCD(IDECIO,J)
      WRITE(PDF,410) IDECIO,(TSTVEC(I,J),I=1,20)
410   FORMAT(' V',4A1,1X,20A1,'*')
370   CONTINUE
380   WRITE(PDF,400) ETX
  400 FORMAT(1X,A1,'0000',/)
      RETURN
      END
C
C*****************
C
      SUBROUTINE ENCD(IDECIO,IADR)
C
      IMPLICIT INTEGER*1 (A-Z)
      INTEGER*1 ICNV(16),IDECIO(4)
      INTEGER IADR,IDEC(4),J
      DATA ICNV/'0','1','2','3','4','5','6','7','8','9',
     1  'A','B','C','D','E','F'/
C
C
      IDEC(4)=IADR 
      DO 150 J=4,2,-1
      IDEC(J-1)=IDEC(J)/10
      IDEC(J)=IDEC(J)-10*IDEC(J-1)
150   IDECIO(J)=ICNV(IDEC(J)+1)
      IDECIO(1)=ICNV(IDEC(1)+1)
      RETURN
      END
C
C****************
