module pinlst [public];
(* $INCLUDE:'TYPE.IBM' *)

(************************************************************)
(*Procedure reconstr_pin_list                               *)
(*  This procedure reconstructs the pinlist from the  chip  *)
(*  statement of the parsed tree . Since the way the parse  *)
(*  tree is generated and written on the file specstre.dat  *)
(*  the steps are as follows:                               *)
(*    1) read the file and build the pinlist for chipnode   *)
(*       corresponding to CHIP word.                        *)
(*    2) remember the latest level of the CHIP node         *)
(*    3) scan the file till the latest CHIP level is        *)
(*       reached                                            *)
(*    4) if it is plain id, then create a id_node and       *)
(*       attach to the pinlist, if invereted than  set the  *)
(*       polarity field of the id_node to false             *)
(*    5) if the id_is subscripted, then it is stored as     *)
(*       id_name [r1,r2,r3] in the id_name field of the     *)
(*       chip node.                                         *)
(*     6) repeat steps 2,3,5, till eof or the id_nodes  for *)
(*        current nodes are finished, and jump to the next  *)
(*        upward level.                                     *)
(*                                                          *)
(*   CHIP - a -array(b) - not                               *)
(*    |          |         |                                *)
(*    |         range(0)   c                                *)
(*    |          |                                          *)
(*    |         range(1)                                    *)
(*   CHIP - d - e - not                                     *)
(*                   |                                      *)
(*                  array(q)                                *)
(*                    |                                     *)
(*                  range(0)                                *)
(*                                                          *)
(*  pinlist==>> CHIP - a - b[0,1] - /c                      *)
(*               |                                          *)
(*              CHIP - d - e - /q[0]                        *)
(************************************************************)

function int_to_string (value1:integer):chstring;external;

{GLOBAL} procedure reconstr_pin_list (var pinlist : chip_ptr;
                             var f:text);


var   pres_level,prev_level,pres_level1,tk_kind,range,i,j:integer;
      chipnode,temptr,temptr1,tempinlst : chip_ptr;
      tempstr1:chstring;
      invflag:boolean;

procedure newchipnode (var chipnode:chip_ptr);

var     i:integer;

begin
 new(chipnode);
 with chipnode^ do
  begin
   pinflag:=false;
   polarity:=true;
   lsibling:=nil;
   rsibling:=nil;
   child:=nil;
   for i:=i to index do id_name[i]:=chr(0);
  end;
end;

(************************************************************)
(* procedure set_id_node creates a node representing an id. *)
(* If the id is negative then the polarity field is reset.  *)
(* this procedure only deals with non_subscripted id's      *)
(************************************************************)

procedure set_id_node;

var tempstr : chstring;
    ch:char;
     i:integer;

begin
 newchipnode(chipnode);
 for i:= 1 to index do tempstr[i]:=chr(0);
 i:=1;
 while (not eoln(f)) do
 begin
   repeat
     read(f,ch) until (ch<>' ') or (eoln(f));
   tempstr[i]:=ch;
   i:=i+1;
  end;
  if (invflag) then
   begin
    pres_level1:=pres_level-1;
    invflag:=false;
    chipnode^.polarity:=false;
   end
  else pres_level1:=pres_level;
  chipnode^.id_name := tempstr;
 if (not eof(f)) then
   readln(f);
 if (not eof(f))then   read(f,pres_level);
end;       (* end of procedure set_id_node *)

(**********************************************************)
(* procedure set_array_node creates a node for subscripted*)
(* id. e.g q[0], /q[1], q[0,3], etc. If inverted, then the*)
(* polarity field is reset false.                         *)
(**********************************************************)

procedure set_array_node;

var i,j:integer;
    tempstr,tempstr1:chstring;
    ch:char;

begin
 newchipnode(chipnode);
 if (invflag) then
  begin
   pres_level1:=pres_level-1;
   invflag:=false;
   chipnode^.polarity:=false;
  end
  else pres_level1:=pres_level;
  for i:=1 to index do tempstr[i]:=chr(0);
  i:=1;
  while (not eoln(f)) do
   begin
    repeat
     read(f,ch) until (ch<>' ') or (eoln(f));
    tempstr[i]:=ch;
    i:=i+1;
   end;
  if (not eof(f)) then
    readln(f);
  if (not eof(f)) then  read(f,pres_level);
  tempstr[i]:='[';
  i:=i+1;
 while(pres_level<>prev_level)
  and (pres_level<>pres_level1)
  and (not eof(f))and(pres_level<>-1) do
  begin
   read(f,tk_kind,range);
   tempstr1:=int_to_string(range);
   for j:=1 to index do
    begin
     if tempstr1[j]<> chr(0) then
      begin
       tempstr[i]:=tempstr1[j];
       i:=i+1;
      end;
    end;
  tempstr[i]:=',';
  i:=i+1;
  if not eof(f) then
    readln(f);
  if not eof(f) then read(f,pres_level);
 i:=i-1;
 tempstr[i]:=']';
end;
chipnode^.id_name:=tempstr;
end; (* end of procedure set_array_node *)

begin
 pinlist:=nil;
 pres_level:=0;
 prev_level:=0;
 pres_level1:=0;
 invflag:=false;
  read(f,pres_level,tk_kind);
   while (tk_kind<>55) and (tk_kind<>200) and (not eof(f))
       and (pres_level<>-1) and(tk_kind<>-1) do
    begin
     newchipnode(chipnode);
     if pinlist=nil then
      begin
       pinlist:=chipnode;
      temptr:=chipnode;
      temptr1:=chipnode;
     end
    else
     begin
      temptr^.child:=chipnode;
      chipnode^.father:=temptr;
      temptr:=chipnode;
      temptr1:=chipnode;
     end;
   if (not eof(f)) then
    begin
     readln(f);
     read(f,pres_level,tk_kind);
    end;
  end;
  prev_level:=pres_level-1;
  while (pres_level<>prev_level) and (not eof(f))
        and (pres_level<>-1)do
   begin
    readln(f);
    read(f,pres_level);
   end;
 prev_level:=pres_level-1;
 while (not eof(f))and(pres_level<>-1) do
  begin
   while (not eof(f)) and (pres_level<>prev_level)and(pres_level<>-1) do
    begin
     read(f,tk_kind);
     if tk_kind = 140 then
      begin
       invflag:=true;
       readln(f);
       read(f,pres_level,tk_kind);
      end;
     if tk_kind = 1 then set_id_node;
     if tk_kind = 131 then set_array_node;
     if tk_kind = 35 then
      begin
       newchipnode(chipnode);
       for i:=1 to index do tempstr1[i]:=chr(0);
       tempstr1[1]:='v';
       tempstr1[2]:='c';
       tempstr1[3]:='c';
       chipnode^.id_name:=tempstr1;
       chipnode^.polarity:=true;
       if (not eof(f)) then readln(f);
       if not eof(f) then read(f,pres_level);
      end;
     if tk_kind = 27 then
      begin
       newchipnode(chipnode);
       for i:=1 to index do tempstr1[i]:=chr(0);
       tempstr1[1]:='n';
       tempstr1[2]:='c';
       chipnode^.id_name:=tempstr1;
       chipnode^.polarity:=true;
       if(not eof(f)) then readln(f);
       if (not eof(f)) then read(f,pres_level);
      end;
     if tk_kind = 32 then
      begin
       newchipnode(chipnode);
       for i:=1 to index do chipnode^.id_name[i]:=chr(0);
       chipnode^.id_name[1]:='g';
       chipnode^.id_name[2]:='n';
       chipnode^.id_name[3]:='d';
       if (not eof(f)) then readln(f);
       if (not eof(f)) then read(f,pres_level);
      end;
   case (pres_level1 - prev_level) of
      1  : begin
            temptr1^.rsibling:=chipnode;
            temptr1:=chipnode;
           end;
      otherwise begin
                end;
    end;  (* end of case loop *)
  end;
 if (not eof(f)) then
  begin
   prev_level:=prev_level-1;
   temptr:=temptr^.father;
   temptr1:=temptr;
   end;
 end;
temptr:=pinlist;
i:=0;
while temptr<>nil do
 begin
   i:=i+1;
   temptr:=temptr^.rsibling;
  end;
temptr:=pinlist;
for j:= 1 to (i - 24) do
 temptr:=temptr^.rsibling;
i:=1;
while temptr<>nil do
 begin
  temptr^.level:=i;
  i:=i+1;
  temptr:=temptr^.rsibling;
 end;
end;
end.
sibling