module xplot[public];
(* $INCLUDE:'TYPE.IBM' *)

(***********************************************************)
(* This procedure generates the fuseplot for 20RA10 PAL.   *)
(* It outputs the data in the default file XPLOT.DAT.      *)
(* The basic steps in this procedure are as follows:       *)
(* For every equation do the following:                    *)
(*                                                         *)
(*      1) Determine the output id_name ,pin_num, polarity *)
(*         and whether registered or not.                  *)
(*                                                         *)
(*      2) If the particular equation is for special       *)
(*         product functions like SET,RESET,CLK and TRST   *)
(*         then set the corresponding flags in the LOGARR  *)
(*                                                         *)
(*      3) Knowing the pin_num, and the type of product    *)
(*         function, generate the start of the product     *)
(*         terms and the corresponding offset. For e.g.    *)
(*         pin_num 14 has product term starting from 73    *)
(*         and the offsets for TRST is 0, CLK is 1,        *)
(*         RESET is 2 ,SET 3 and DATA is 4                 *)
(*                                                         *)
(*      4) Once all the data in terms of output pin,       *)
(*         start of prodterm and the offsets, the program  *)
(*         scans the right side of equation and            *)
(*         creates a list of all OR gates. There can be 0  *)
(*         to 4 orgates.                                   *)
(*                                                         *)
(*      5) For each orgate, a list of and gate is created  *)
(*                                                         *)
(*      6) For each AND gate, a vert position is evaluated *)
(*         for all the signals attached to the andgate and *)
(*         a 'x' is placed in that particular prodterm/vert*)
(*         location. If this is the first time the prodterm*)
(*         is used than all the remaining locations along  *)
(*         that prodterm are filled with '-'               *)
(*                                                         *)
(*      7) repeat steps 5 and 6 till all the orgates are   *)
(*         finished. Repeat steps 1 to 6 for all the       *)
(*         equations.                                      *)
(*                                                         *)
(*   Fuse intact : 'x'  Fuse blown : '-'                   *)
(*   Default state : TRST line to be high                  *)
(*                   SET and RESET low, for REGISTERED out *)
(*                   SET and RESET high for COMB out       *)
(***********************************************************)
procedure error (eqnptr : tree_ptr;
                 errsym : chstring;
                 errnum : integer;
                var errflag : boolean); external;
                        
{GLOBAL} procedure fuseplot (var pinlist : chip_ptr;
                     eqnptr : tree_ptr;
                    var fusemap : fusearray;
                    var pol_map : polarray;
                    var errflag : boolean;
                    var f : text);

label 102;

type  logg = record
             out:boolean;
             sett,reset,trst,comb,clk : boolean;
            end;

var  pin_num, vert, offset, andgates,orgates,errnum,i : integer;
     prodterm,fuses,prodterm1,j:integer;
     orlst,templst:op_node;
     temptr:chip_ptr;
     temptr1,temptr2:tree_ptr;
     logarr : array [1..10] of logg;
     errsym : chstring;
(*******************************************************)
(* This procedure creates the list of all the and gates*)
(* attached to an or node. The top of the list points  *)
(* to the last AND gate.                               *)
(*******************************************************)
procedure create_andlst ( eqnptr : tree_ptr;
                          var andlst:op_node;
                          gates:integer);

var tempnode: op_node;

begin
 if eqnptr<>nil then
  begin
   if  (eqnptr^.kind=136) then
    begin
     new (tempnode);
     tempnode^.next:=andlst;
     tempnode^.ptr:=eqnptr;
     andlst:=tempnode;
     gates:=gates+1;
    end;
  create_andlst(eqnptr^.child,andlst,gates);
  create_andlst(eqnptr^.rsibling,andlst,gates);
 end;
end;

(***********************************************************)
(* This proceudre creates the list of all the OR gates  in *)
(* an equation. The top of the list points to the last OR  *)
(* gate.                                                   *)
(***********************************************************)

procedure create_orlst(eqnptr:tree_ptr;
                       var orlst:op_node;
                       gates:integer);

var tempnode:op_node;

begin
 if eqnptr<>nil then
  begin
   if (eqnptr^.kind=137) then
    begin
     new(tempnode);
     tempnode^.next:=orlst;
     tempnode^.ptr:=eqnptr;
     orlst:=tempnode;
     gates:=gates+1;
    end;
  create_orlst(eqnptr^.child,orlst,gates);
  create_orlst(eqnptr^.rsibling,orlst,gates);
 end;
end;

(**********************************************************)
(* This procedure evaluates the vertical location of the  *)
(* fuse for the particular signal. Once the vert and      *)
(* the prodterm is known, a 'x' is put in that position.  *)
(* If this was the first time this product term was used  *)
(* than all the fuses (40) in that prodterm are blown (-) *)
(* and then'x' is put. If the first two locations on the  *)
(* prodterm are 'x' then the prodterm was used for the    *)
(* first time. Since putting an 'x' is like keeping the   *)
(* fuse intact, a one is subtracted from FUSES for every  *)
(* 'x' added.                                             *)
(**********************************************************)

procedure blow_fuse (eqnptr:tree_ptr);

var vert,i:integer;

begin
 if (eqnptr^.chiptr^.level >= 2)
 and(eqnptr^.chiptr^.level <=11)
  then                                      (* vert evaluation for *)
   begin                                    (* pins 2 to 11        *)
    vert:= 4 * eqnptr^.chiptr^.level - 7;
    if ((eqnptr^.polarity)and(not(eqnptr^.chiptr^.polarity)))
       or ((not (eqnptr^.polarity))and(eqnptr^.chiptr^.polarity)) then
     vert:=vert+1;                          (* a 1 is added for -ve signal*)
     if (fusemap[prodterm,1]='x') and (fusemap[prodterm,2]='x')
     then                              (* if prodterm is visited for the *)
      begin                            (* first time than blow all the   *)
       for i:=1 to 40 do               (* fuses and then add a 'x' in    *)
        fusemap[prodterm,i]:='-';      (* the desired location.          *)
        fuses:=fuses+40;
       end;
     fusemap[prodterm,vert]:='x';      (* whenever 'x' is added FUSES is *)
     fuses:=fuses-1;                   (* decremented.                   *)
   end;
 if (eqnptr^.chiptr^.level >= 14)      (* same things for pins 14 to 23 *)
 and(eqnptr^.chiptr^.level <= 23)
  then
   begin
    vert:=95 - 4*eqnptr^.chiptr^.level;
    if ((eqnptr^.polarity)and(not (eqnptr^.chiptr^.polarity)))
       or((not(eqnptr^.polarity)) and (eqnptr^.chiptr^.polarity)) then
     vert:=vert+1;
    if (fusemap[prodterm,1]='x') and (fusemap[prodterm,2]='x')
    then
     begin
      for i:= 1 to 40 do fusemap[prodterm,i]:='-';
      fuses:=fuses+40;
     end;
    fusemap[prodterm,vert]:='x';
    fuses:=fuses-1;
   end;
  if (eqnptr^.chiptr^.level=24)   (* if the signal is VCC then blow *)
   then                           (* all the fuses.                 *)
    begin
     for i:=1 to 40 do fusemap[prodterm,i]:='-';
     fuses:=fuses+40;
    end;
end;

(************************************************************)
(* This procedure  creates the andlst for each sibling of   *)
(* the orgate. And for each signal attached to the AND gate *)
(* bloww the fuse.                                          *)
(************************************************************)

procedure product (andptr:tree_ptr);

var andlst,templst:op_node;
    temptr:tree_ptr;
    i:integer;

begin
 andptr^.rsibling:=nil;
 andlst:=nil;
 andgates:=0;
 create_andlst(andptr,andlst,andgates);
 if andlst<>nil then
  begin
   templst:=andlst;
   temptr:=templst^.ptr^.child;
   blow_fuse(temptr);
   temptr:=templst^.ptr^.child^.rsibling;
   blow_fuse(temptr);
   while templst<>nil do
    begin
     if templst^.ptr^.rsibling<>nil then
      blow_fuse(templst^.ptr^.rsibling);
     templst:=templst^.next;
    end;
  end;
 if andlst=nil then
  blow_fuse(andptr);
end;

begin  (* start of the procedure xplot *)
fuses:=0;
pin_num:=0;
vert:=0;
andgates:=0;
orgates:=0;
offset:=0;
prodterm:=0;
for i:= 1 to index do errsym[i]:= chr(0);
for i:=1 to 10 do
 begin
   logarr[i].clk:=false;
   logarr[i].out:=false;
   logarr[i].sett:=false;
   logarr[i].reset:=false;
   logarr[i].trst:=false;
   logarr[i].comb:=false;
 end;
(*temptr:=pinlist;
while temptr<>nil do            numbering the pins. Initially all
 begin                        the nodes in the pinlist are counted
  pin_num:=pin_num+1;         and then the extra nodes are toatl
  temptr:=temptr^.rsibling;   number of nodes -24 . These many
 end;                         are extra nodes in the front of the
                              pinlist. They are skipped before
temptr:=pinlist;                   actual pin_numbering is done
for i:=1 to (pin_num -24) do
 temptr:=temptr^.rsibling;
pin_num:=1;
while temptr<>nil do
 begin
   temptr^.level:=pin_num;
   pin_num:=pin_num+1;
   temptr:=temptr^.rsibling;
 end;*)
for i:=1 to 80 do      (* Initialise the fuse map and polar map to 'x' *)
for j:=1 to 40 do
 fusemap[i,j]:='x';
for i:=1 to 10 do pol_map[i]:='x';
while eqnptr<>nil do
 begin
  prodterm1:=0;                 (* the case statements detremines the *)
  temptr1:=eqnptr^.rsibling;    (* special product functions. Proper  *)
  eqnptr^.rsibling:=nil;        (* pin_num and offsets are determined.*)
  case eqnptr^.child^.kind of   (* Also the fkag in logarr are set or *)
                                (* reset depending on the situation.  *)
        56 : begin
              offset:=1;
              pin_num:=eqnptr^.child^.child^.chiptr^.level;
              logarr[pin_num - 13].clk := true;
             end;

        57 : begin
              offset :=0;
              pin_num:=eqnptr^.child^.child^.chiptr^.level;
              logarr[pin_num - 13].trst:=true;
             end;

        58 : begin
              offset := 2;
              pin_num:=eqnptr^.child^.child^.chiptr^.level;
              logarr[pin_num - 13].reset:=true;
            end;

        33 : begin
              offset:=3;
              pin_num:=eqnptr^.child^.child^.chiptr^.level;
              logarr[pin_num - 13].sett := true;
             end;

       otherwise begin
                  offset:=4;
                  pin_num:=eqnptr^.child^.chiptr^.level;
                  logarr[pin_num - 13].out:=true;
                  if eqnptr^.kind = 121 then
                   logarr[pin_num - 13].comb := true;
                  if((eqnptr^.child^.chiptr^.polarity)
                    and(eqnptr^.child^.polarity))
                    or ((not(eqnptr^.child^.chiptr^.polarity)) and
                       (not(eqnptr^.child^.polarity))) then
                  begin
                  pol_map[pin_num-13]:='-';
                  fuses:=fuses+1;
                 end;
                 end;
    end; (* end of case *)
  prodterm:=185 - 8 * pin_num + offset;     (* evaluating the prodterm *)
  orlst:=nil;
  orgates:=0;
  create_orlst(eqnptr^.child^.rsibling,orlst,orgates);
  if orlst <> nil then
   begin
     case eqnptr^.child^.kind of
        33 : error (eqnptr,errsym,6,errflag);
        56 : error (eqnptr,errsym,3,errflag);
        57 : error (eqnptr,errsym,4,errflag);
        58 : error (eqnptr,errsym,5,errflag);
       otherwise begin end;
     end;
    if errflag then goto 102;
   end;
  if orlst<>nil then
   begin                                      (* create a list of all the OR*)
    templst:=orlst;                           (* gates and for each leaf *)
    temptr2:=templst^.ptr^.child^.rsibling;   (* of the or gate create andlst*)
    templst^.ptr^.child^.rsibling:=nil;       (* and blow the fuses. When the*)
    product(templst^.ptr^.child);              (*next or gate is chosen the *)
    prodterm:=prodterm+1;                      (* offset is incremented.    *)
    prodterm1:=prodterm1+1;
    templst^.ptr^.child^.rsibling:=temptr2;    (* Certain errors like extra *)
    offset:=offset+1;                          (* prodterms can be caught *)
    product(templst^.ptr^.child^.rsibling);    (* and reported to the user*)
    prodterm:=prodterm+1;
    prodterm1:=prodterm1+1;
    offset:=offset+1;
    while templst^.next<>nil do
     begin
      if templst^.ptr^.rsibling<>nil then
      begin
       if (prodterm1 >= 4) then
        begin
         error (eqnptr,errsym,2,errflag);
         goto 102;
        end;
       product (templst^.ptr^.rsibling);
       prodterm:=prodterm+1;
       prodterm1:=prodterm1+1;
       offset:=offset+1;
      end;
       templst:=templst^.next;
     end;
   end;
 if orlst=nil then product(eqnptr^.child^.rsibling);
 eqnptr^.rsibling:=temptr1;     (* repeate for all equations *)
 eqnptr:=eqnptr^.rsibling;
end;
for i:= 1 to 10 do
 begin                          (* the default conditions are tested *)
  if(logarr[i].out) then        (* and if true then corr. action are *)
   begin                        (* taken. If TRST is false, then there*)
    if ( not logarr[i].trst) then (* is no trst function, and hence all*)
     begin                        (* the fuses are blown. THis is only *)
      prodterm:=81 - 8 * i;       (* done for the used output. If the  *)
      for j:= 1 to 40 do fusemap[prodterm,j]:='-';
      fuses:=fuses+40;            (* output is combinatorial, then all *)
     end;                         (* the fuses in SET and RESET prodterms*)
    if (logarr[i].comb) and (not logarr[i].sett)  (*are blown  *)
      and (not logarr[i].reset) then
       begin
        prodterm:=83 - 8*i;
        for j:=1 to 40 do fusemap[prodterm,j]:='-';
        fuses:=fuses+40;
        prodterm:=84 - 8 * i;
        for j:=1 to 40 do fusemap[prodterm,j]:='-';
        fuses:=fuses+40;
       end;
    if ((logarr[i].comb) and(logarr[i].sett)) or ((logarr[i].comb)
        and (logarr[i].reset)) or ((logarr[i].comb) and (logarr[i].clk))
    then
     begin
      temptr := pinlist;
      while temptr<>nil do
       begin
        if temptr^.level = i + 13 then
         begin
          errsym := temptr^.id_name;
          temptr:=nil;
         end
       else temptr:=temptr^.rsibling;
     end;
    error(nil,errsym,7,errflag);
    goto 102;
   end;
  end;
end;
writeln(f,'PALASM V1.9A - 20RA10');
writeln(f);
if (pinlist^.rsibling^.level<>1)
  then write(f,pinlist^.rsibling^.id_name,'        ');
if (pinlist^.rsibling^.rsibling^.level<>1) then
       write(f,pinlist^.rsibling^.rsibling^.id_name);
writeln(f);
writeln(f,'   ','            11 1111 1111 2222 2222 2233 3333 3333');
writeln(f,'   ','0123 4567 8901 2345 6789 0123 4567 8901 2345 6789');
writeln(f);
for i:=1 to 80 do
 begin
  if(i=9) or (i=17) or (i=25) or (i=33) or (i=41)
   or (i=49) or (i=57) or (i=65) or (i=73) then writeln(f);
  write(f,(i-1):2,' ');
 for vert := 1 to 40 do
  begin
   if (vert=5) or (vert=9) or (vert=13) or (vert=17) or (vert=21)
    or(vert=25) or (vert=29) or (vert=33) or (vert=37) then write(f,' ');
   write(f,fusemap[i,vert]);
  end;
writeln(f);
end;
writeln(f);
writeln(f,'Polarity Fuses ');
writeln(f);
writeln(f,'Output pin: ','1111112222');
writeln(f,'            ','4567890123');
writeln(f);
write(f,'            ');
for i:=1 to 10 do write(f,pol_map[i]);
writeln(f);
writeln(f);
writeln(f, 'Legend:  fuse blown: -   fuse intact: x');
writeln(f);
writeln(f, 'Fuses Blown :', fuses:5);
102: end;
end.

writeln(f, 'Legend:  fuse blown: -   fuse intact: x');
writeln(f);
writeln(f, 'Fuses Blown 