module reconstr1_eqn [public];
(**************************************************************)
(* This procedure reconstructs the equation tree. Each id_node*)
(* is represented by a single node whether it is an ordinary  *)
(* node, invert node or a subscripted node.                   *)
(* All other nodes are reconstructed the same way as they were*)
(* created.                                                   *)
(**************************************************************)
(* $INCLUDE:'TYPE.IBM' *)

function int_to_string (value1:integer):chstring;external;

procedure error (eqnptr : tree_ptr;
                 errsym : chstring;
                 errnum : integer;
                 var errflag : boolean); external;

{GLOBAL} procedure reconstr_eqn (var eqntree: tree_ptr;
                        var pinlist: chip_ptr;
                        var errflag:boolean;
                        var f:text);

label 101;

var  pres_level,prev_level,start,tk_kind,range,level:integer;
     treenode,temptr : tree_ptr;
     tempint,i:integer;
     invflag:boolean;

procedure neweqnode (var eqnode:tree_ptr);
var i:integer;

begin
 new(eqnode);
 with eqnode^ do
  begin
   father:=nil;
   child:=nil;
   rsibling:=nil;
   lsibling:=nil;
   chiptr:=nil;
   level:=0;
   kind:=0;
   polarity:=true;
  end;
 end;
(*******************************************************)
(* This procedure searches for a string in the pinlist *)
(* and the chiptr is pointed to the respctive node in  *)
(* pinlist.                                            *)
(*******************************************************)

procedure search (var tempstr: chstring;
                  var treenode:tree_ptr;
                  var pinlist: chip_ptr);

var temptr:chip_ptr;
    flag:boolean;
    i:integer;

begin
 temptr:=pinlist;
 flag:=false;
 while temptr<>nil do
  begin
   if (tempstr = temptr^.id_name) then
    begin
     if (temptr^.level = 1) then
       begin
        error(nil,tempstr,8,errflag);      (* Pin 1 not allowed in prod.term*)
        goto 101;
       end;
      if (temptr^.level = 13 ) then
       begin
        error (nil,tempstr,9,errflag);     (* pin 13 not allowed in eqn.*)
        goto 101;
       end;
     treenode^.chiptr:=temptr;
     temptr^.pinflag:=true;
     temptr:=nil;
     flag:=true;
    end
   else temptr:=temptr^.rsibling;
  end;
 if (not flag) then
  begin
   error (nil,tempstr,1,errflag);
   goto 101;
  end;
end;


(***********************************************************)
(* this procedure creates an id_node. If the id_is inveretd*)
(* then the polarity field is reset. The chiptr field      *)
(* points to a node in the pinlist which is the id_name    *)
(***********************************************************)
procedure create_id_node;

var tempstr:chstring;
    ch:char;
    i:integer;

begin
 neweqnode (treenode);
 if (invflag) then
  begin
   treenode^.polarity := false;
   treenode^.level:= pres_level -1;
   invflag:=false;
  end
  else treenode^.level:=pres_level;
 treenode^.kind:=tk_kind;
 for i:= 1 to index do tempstr[i]:=chr(0);
 i:=1;
if (tk_kind = 1) then
begin
 while (not eoln(f)) do
 begin
  repeat
   read (f,ch) until (ch<>' ') or (eoln(f));
   tempstr[i]:=ch;
   i:=i+1;
  end;
end;
if (tk_kind = 35 )
 then
  begin
   tempstr[1]:='v';
   tempstr[2]:='c';
   tempstr[3]:='c';
  end;
if (tk_kind = 32) then
 begin
  tempstr[1]:='g';
  tempstr[2]:='n';
  tempstr[3]:='d';
 end;
search(tempstr,treenode,pinlist);
if (not eof(f)) then
 begin
  readln(f);
  read(f,pres_level);
end;
end;

(************************************************************)
(* this procedure creates the node for subscripted id.      *)
(* the subscripted id is stored as single node.If it is     *)
(* inverted, then the polarity field is reset.              *)
(************************************************************)
procedure create_arr_node;

var tempstr,tempstr1:chstring;
    i,j,level :integer;
    ch:char;

begin
 neweqnode (treenode);
 if (invflag) then
  begin
   treenode^.polarity := false;
   treenode^.level:=pres_level-1;  (* decrement the level because *)
   invflag:=false;                 (* an extra node is not created*)
   level:=pres_level-1;            (* for an inversion            *)
  end
  else
   begin
    treenode^.level:=pres_level;
    level:=pres_level;
   end;
  treenode^.kind:=tk_kind;
  for i:= 1 to index do tempstr[i]:=chr(0);
  i:=1;
  while not eoln(f) do      (* read the signal name *)
   begin
    repeat
     read(f,ch) until (ch<>' ') or ( eoln(f));
    tempstr[i]:=ch;
    i:=i+1;
   end;
  if (not eof(f)) then
   begin
    readln(f);
    read(f,pres_level);
   end;
  tempstr[i]:='[';
  i:=i+1;
  while (not eof(f)) and (pres_level<> level)
   and  (pres_level<>prev_level) and (pres_level<>start) do
    begin                               (* read the ranges *)
     read(f,tk_kind,range);             (* and modify the signal*)
     tempstr1:=int_to_string (range);   (* name.                *)
     for j:=1 to index do               (* for e.g. if signal name*)
      if tempstr1[j]<>chr(0) then       (* is A and the ranges are *)
       begin                            (* 1 and 2, then the new signal*)
        tempstr[i]:= tempstr1[j];       (* name is A[1,2]              *)
        i:=i+1;
       end;
    tempstr[i]:=',';
    i:=i+1;
    if not eof(f) then
     begin
      readln(f);
      read(f,pres_level);
     end;
   end;
   i:=i-1;
  tempstr[i]:=']';
  search(tempstr,treenode,pinlist);
end;

procedure create_op_node;

begin
 neweqnode(treenode);
 treenode^.kind:=tk_kind;
 treenode^.level:=pres_level;
 if not eof(f) then readln(f);
 if not eof(f) then read(f,pres_level);
end;

(***********************************************************)
(* This procedure creates a node for special functions like*)
(* SET,RESET,CLK,TRST. The level is decremented if invflag *)
(* is set.                                                 *)
(***********************************************************)

procedure sp_node;

begin
neweqnode(treenode);
if (invflag) then
 treenode^.level:=pres_level-1
else treenode^.level:=pres_level;
treenode^.kind:=tk_kind;
if (not eof(f)) then readln(f);
if (not eof(f)) then read(f,pres_level);
end;

begin    (* start of procedure reconstr_eqn *)
 eqntree:=nil;
 pres_level:=0;
 prev_level:=0;
 start:=0;
 invflag:=false;
 read(f,pres_level,tk_kind);
 while (not eof(f)) and (tk_kind<>55) do   (* skip till the key word EQU *)
  begin
   readln(f);
   read(f,pres_level,tk_kind);
  end;
 neweqnode(treenode);           (* this section of the code *)
 treenode^.level:=pres_level;   (* creates a node for 'equ' *)
 treenode^.kind:=tk_kind;       (* token.                   *)
 eqntree:=treenode;
 temptr:=treenode;
 prev_level:=pres_level;
 start:=pres_level-1;
 if (not eof(f)) then           (* skip the file till the *)
  begin                         (* first equation is reached *)
   readln(f);
   read(f,pres_level);
  end;
 while (not eof(f)) and (pres_level<>prev_level) do
  begin
   readln(f);
   read(f,pres_level);
  end;
 while (not eof(f)) and (pres_level<>start) do
  begin
   read(f,tk_kind);          (* the tree is cretaed till the first *)
   if (tk_kind=140) then     (* signal name of CHIP declaration    *)
    begin                    (* is encountered. This is rememeberd *)
     invflag:=true;          (* by 'start' which indicates the level*)
     readln(f);              (* of the last CHIP node.              *)
     read(f,pres_level,tk_kind); (* If the token is inverted, set invflag *)
    end;                         (* and read the next line*)
  if (tk_kind = 58) or (tk_kind=56) or (tk_kind=57) or (tk_kind=33)
   then sp_node else                    (* cretae sp_node *)
  if (tk_kind = 1) or (tk_kind=35) or (tk_kind=32)
     then create_id_node  (* create id_node *)
  else
     if (tk_kind = 131) then
       create_arr_node
      else
       if (tk_kind <>1) and (tk_kind<>140) and (tk_kind<> 131)
         and (tk_kind<>33) and (tk_kind<>56) and (tk_kind<>57)
         and (tk_kind<>58) then
        create_op_node;
  tempint:=temptr^.level-treenode^.level;
  case tempint of

        0 : begin
             temptr^.rsibling := treenode;   (* attach a node at the same *)
             treenode^.lsibling:=temptr;     (* level                     *)
            end;
       -1 : begin                            (* attach a node one level below*)
             temptr^.child:=treenode;
             treenode^.father:=temptr;
            end;
     otherwise                              (* attach nodes at several levels*)
         for i:=1 to tempint do             (* above depending on the tempint*)
          begin
           while (temptr^.father = nil ) do
             temptr:=temptr^.lsibling;
           temptr:=temptr^.father;
           while (temptr^.rsibling<>nil) do
             temptr:=temptr^.rsibling;
           end;
          temptr^.rsibling:=treenode;
          treenode^.lsibling:=temptr;
     end;
  temptr:=treenode;
 end;
101: end;
end.




r^.rsibling:=treenode;
          treenode^.lsibling:=temptr;
     end;
  temptr:=treenode;
 end;
