        .list   000
;       *********************************************************
;       *                                                       *
;       *       National Semiconductor MicroController Group    *
;       *                                                       *
;       *       HPC C Compiler Support and Library Routines     *
;       *       Macros to Create Startup, Arithmetic Routines   *
;       *                                                       *
;       *********************************************************

;Copyright (c) 1986, National Semiconductor, Santa Clara Ca 95051

;Edit History
; 6/18/86 DKL   Create from RUNTIME.H
; 6/24/86 DKL   Change for Macro (ASM) problem, share DIV & REM
; 7/09/86 DKL   Add START and READY startup macros
; 7/14/86 DKL   Ready for BETASITE release
; 7/28/86 DKL   ******** Revision B0 ******** BetaSite Release
;

;These routines provide the standard RunTime Functions needed by the
;generated code of the CCHPC compiler.  They are defined within macros,
;which the compiler will invoke to produce the needed routines.  This
;also allows the user to provide alternate routines by redefining the
;appropriate macros.

;Also provided are three routines which are embedded into the C program
;Start-Up code.  These allow the end user to have control of the process
;at key moments, before the C code begins execution.  The macros used
;are START, READY, and HALT, in the following fashion:
;       ...
;start:
;       ld      sp,<stack>
;       START
;       <initialize ram>
;       READY
;       jsrl    <main>
;       HALT

;The compiler invokes RunTime Request macros.  These determine and record
;which data types are desired for each function.  The actual Generation
;is invoked after all Request have been logged.  This allows the generator
;to know all of what is expected of it and to take advantage of all the
;interactions between various routines and data types.
;The user can, with an included InLine Assembly module, redefine the macros
;and control variables involved to replace standard routines with special
;versions.

;Arguments are passed with the leftmost argument of the expression in
;the register(s) and the rightmost argument on the stack.  Arguments of
;8 or 16 bits are passed in A and in W(SP-4).  Arguments of 32 bits are
;passed in K:A and in W(SP-4):W(SP-6) with K and W(SP-4) high order, and
;A and W(SP-6) low order.  Results are returned in A and K:A.  A special
;case is shifts of longs, wherein only the low order word of the shift
;count is provided, as if it were a 16 bit quantity.

;In all cases, B and X must be preserved.  Location 0 is scratch.

;Also provided are some standard macro instructions.  Although the code
;generated by the compiler does not use them, it could.  The functions
;provided here do use them.

;Listing control
.if 1
 .macro codelis switch
 .ifc on eq switch
        .list   04d
 .endif
 .ifc off eq switch
        .list   041
 .endif
 .ifc normal eq switch
        .list   041
 .endif
 .endm  ;codelis
.else
 .macro codelis value
 .endm  ;codelis
.endif

        .form
;Bit positions indicating desired data types
codv    =       00
codvu8  =       01
codvs8  =       02
codvu16 =       04
codvs16 =       08
codvu32 =       010
codvs32 =       020
codvf32 =       040
codvf64 =       080
;
;Request tallies (so that none are left undefined)
.set    codels,0
.set    coders,0
.set    codemul,0
.set    codediv,0
.set    coderem,0
;
;Share masks are defined with (and outside of) Shared Creation macros,
; and users can adjust their definitions before the compiler invokes the
; library generation.

;Create a RunTime Request macro for compiler request
; The resulting macros merely process and record data types requested.
;
.macro  codvcre name
        codwcre code^name
.endm   ;codvcre
;
.macro  codwcre name
 .macro name    types                   ;Define Request macro
 .set   name,0
 .set   codvcnt,0                       ;Sets bits for types
  .do   @
  .set  codvcnt,codvcnt + 1
  .set  name,name ! codv^@codvcnt
  .enddo
 .endm  ;name
.endm   ;codwcre

;Create a Share mask
; This provides a value to indicate what requests are to be processed
; by a given Shared Creation macro.  The user may adjust this value
; to allow the use of alternate routines.
;
.macro  codvsha tag, share, types
.set    codv^tag^share,0                ;Initialize Shared mask
.set    codvcnt,2                       ;For each Shared data type
 .do    @ - 2
 .set   codvcnt,codvcnt + 1
 .set   codv^tag^share,codv^tag^share ! codv^@codvcnt   ;Tally each Shared
 .enddo
.endm   ;codvsha

;RunTime Function Generation
; Once all the library Requests are tallied, this is invoked to cause
; the generation of the code.  It is hardcoded to match the sub-macros
; and their potential sharing.  Then anything not picked up by a Shared
; macros is individually invoked, and all request should be then fulfilled.
;
.macro  codegen
        codelis off
        codvgen ls, l,  w               ;left shift s8, u8, s16, u16
        codvgen ls, l,  x               ;left shift s32, u32
        codvgen rs, r,  w               ;right shift s8, u8, s16, u16
        codvgen rs, r,  x               ;right shift s32, u32
        codvgen mul,m,  w               ;multiply s32, u32
        codwgen div,d,  w, rem,f,  w    ;divide & remainder s8, u8, s16, u16
        codwgen div,d,  x  rem,f,  x    ;divide & remainder s32, u32
        codeusr                         ;User's turn
        codxgen ls, l, s8,u8,s16,u16,s32,u32
        codxgen rs, r, s8,u8,s16,u16,s32,u32
        codxgen mul,m,               s32,u32
        codxgen div,d, s8,   s16,    s32,u32
        codxgen rem,f, s8,   s16,    s32,u32
        codelis normal
.endm   ;codegen
;
;Invoke Shared Creation if anything handled is requested
.macro  codvgen name, tag, share
.set    codvgen,code^name & codv^tag^share
.if codvgen
.set    code^name,code^name & ( % codv^tag^share )
        codelis on
        codv^tag^share  ^codvgen
        codelis off
.endif
.endm   ;codvgen
;
;Invoke Shared Functions Shared Creation if anything handled is requested
.macro  codwgen name1, tag1, share1, name2, tag2, share2
.set    codvgen,code^name1 & codv^tag1^share1
.set    codwgen,code^name2 & codv^tag2^share2
.if codvgen ! codwgen
.set    code^name1,code^name1 & ( % codv^tag1^share1 )
.set    code^name2,code^name2 & ( % codv^tag2^share2 )
        codelis on
        codv^tag1^share1        ^codvgen, ^codwgen
        codelis off
.endif
.endm   ;codwgen
;
;Invoke individual Creation macros for anything left over
.macro  codxgen name, tag, types
.if     code^name
        codelis on
        .error  Left-over requests for name in RunTime Functions.
        codelis off
.endif
.endm   ;codxgen
;
;Dummy macro which User can redefine for his own code Creation
.macro  codeusr
.endm   ;codeusr

        .form
;Left Shift (Signed or Unsigned are the same)
;16,8 bit
;       A       Value to be shifted
;       SP-4    Shift count
;       A       return
;32 bit
;       K:A     Value to be shifted
;       SP-4    Shift count
;       K:A     return
;
        codvcre ls
        codvsha l, w, s8, u8, s16, u16
        codvsha l, x, s32, u32
;
;Left shift s8, u8, s16, u16 (sign irrelevant)
.macro  codvlw  request
.if request & ( codvs8 ! codvu8 )
.set    codvcnt,8                       ;Eight shifts necessary
$lls8:                                  ;High byte irrelevant
.endif
.if request & ( codvs16 ! codvu16 )
.set    codvcnt,16                      ;Sixteen shifts necessary
$lls16:
.endif
        st      a,w(0)                  ;Get shift count
        ld      a,m(sp-4)
        ifgt    a,^codvcnt
        ld      a,^codvcnt              ;  more than all is all
        x       a,w(0)
        ifeq    m(0),0
        ret                             ;  nothing to do
$ls16l:
        shl     a                       ;Shift, moving in zeros
        decsz   m(0)
        jp      $ls16l
        ret
.endm   ;codvlw
;
;Left shift s32, u32 (sign irrelevant)
.macro  codvlx  request
.set    codvcnt,32                      ;Thirty two shifts necessary
$lls32:
        st      a,w(0)                  ;Get shift count
        ld      a,m(sp-4)
        ifgt    a,^codvcnt
        ld      a,^codvcnt              ;  more than all is all
        x       a,w(0)
        ifeq    m(0),0
        ret                             ;  nothing to do
$ls32l:
        shl     a                       ;Shift, moving in zeros
        adc     k,k
        decsz   m(0)
        jp      $ls32l
        ret
.endm   ;codvlx

;Right Shift
; Arithmatic (Signed)
; Logical (Unsigned)
;16,8 bit
;       A       Value to be shifted
;       SP-4    Shift count
;       A       return
;32 bit
;       K:A     Value to be shifted
;       SP-4    Shift count
;       K:A     return
;
        codvcre rs
        codvsha r, w, s8, u8, s16, u16
        codvsha r, x, s32, u32
;
;Right shift s8, u8, s16, u16
.macro  codvrw  request
.if request & codvs8
.set    codvcnt,7                       ;Seven shifts sufficient
$ars8:
        sex     a                       ;Extend sign, byte to word
.endif
.if request & codvs16
$ars16:
 .if request & codvu16
        set     c                       ;Extend sign into Carry
        ifmi    a
        jp      $rs16
 .endif
.endif
.if request & codvu8
.set    codvcnt,8                       ;Eight shifts necessary
$lrs8:                                  ;Aready zero extended
.endif
.if ( request & ( codvs8 ! codvs16 ! codvu16 ) ) = ( codvs8 ! codvu16 )
        ld      m(0),^codvcnt           ;Limit 8 bit seperately
        jp      $rs16
.endif
.if request & codvs16
.set    codvcnt,15                      ;Fifteen shifts sufficient
.endif
.if request & codvu16
.set    codvcnt,16                      ;Sixteen shifts necessary
$lrs16:
 .if request & codvs16
        reset   c                       ;Extend zero into Carry
$rs16:
 .endif
.endif
.if ( request & ( codvs8 ! codvs16 ! codvu16 ) ) = ( codvs8 ! codvu16 )
        ld      m(0),^codvcnt           ;Limit 16 bit
$rs16:
        x       a,w(0)                  ;Get shift count
        ifgt    a,m(sp-4)
        ld      a,m(sp-4)               ;  within limit
.else
        st      a,w(0)                  ;Get shift count
        ld      a,m(sp-4)
        ifgt    a,^codvcnt
        ld      a,^codvcnt              ;  more than all is all
.endif
        x       a,w(0)
        ifeq    m(0),0
        ret                             ;  nothing to do
$rs16l:
.if request & codvs16 ;If 8 bit, extend did it all
 .if request & codvu16
        rrc     a                       ;Shift moving in extended sign
        sexc    a                       ;Extend sign bit in C again
 .else
        sexc    a                       ;Extend sign bit in C
        rrc     a                       ;Shift moving in extended sign
 .endif
.else
        shr     a                       ;Shift, moving in zeros
.endif
        decsz   m(0)
        jp      $rs16l
        ret
.endm   ;codvrw
;
;Right shift s32, u32
.macro  codvrx  request
.if request & codvs32
.set    codvcnt,31                      ;Thirty one shifts sufficient
$ars32:
 .if request & codvu32
        set     c                       ;Extend sign into Carry
        ifmi    k
        jp      $rs32
 .endif
.endif
.if request & codvu32
.set    codvcnt,32                      ;Thirty two shifts necessary
$lrs32:
 .if request & codvs32
        reset   c                       ;Extend zero into Carry
$rs32:
 .endif
.endif
        st      a,w(0)                  ;Get shift count
        ld      a,m(sp-4)
        ifgt    a,^codvcnt
        ld      a,^codvcnt              ;  more than all is all
        x       a,w(0)
        ifeq    m(0),0
        ret                             ;  nothing to do
$rs32l:
.if request & codvs32 ;If 8 bit, extend did it all
 .if request & codvu32
        x       a,k                     ;Shift moving in extended sign
        rrc     a                       ;  high order (K) into low (A)
        x       a,k
        rrc     a
        sexc    k                       ;Extend sign bit in C again
 .else
        x       a,k                     ;Extend sign bit in C
        sexc    a
        rrc     a                       ;Shift moving in extended sign
        x       a,k
        rrc     a
 .endif
.else
        x       a,k
        shr     a                       ;Shift, moving in zeros
        x       a,k
        rrc     a
.endif
        decsz   m(0)
        jp      $rs32l
        ret
.endm   ;codvrx

;Multiply (Signed or Unsigned are the same)
;16,8 bit
;       Uses Inline Code
;32 bit
;       K:A     Multiplicand
;       SP-4:6  Multiplier
;       K:A     return
;
        codvcre mul
        codvsha m, w, s32, u32
;
;Multiply s32, u32 (sign irrelevant)
.macro  codvmw  request
$mul32:
        push    x                       ; (Argument now at SP-6:8)
        st      a,w(0)
        ld      a,k                     ;Multiply hi reg * lo stack
        mult    a,w(sp-8)
        x       a,w(0)                  ;hold, retrieve lo reg
        push    a                       ; (Argument now at SP-8:10)
        mult    a,w(sp-8)               ;Multiply lo reg * hi stack
        add     w(0),a                  ;add into hi partial
        pop     a                       ; (Argument now at SP-6:8)
        mult    a,w(sp-8)               ;Multiply lo reg * lo stack
        add     x,w(0)                  ;add in hi partial
        ld      k,x                     ;Position
        pop     x                       ;Restore
        ret
.endm   ;codvmw

;Division & Remainder
;16,8 bit (signed only, unsigned uses InLine code)
;       A       Dividend
;       SP-4    Divisor
;       A       return
;32 bit
;       K:A     Dividend
;       SP-4:6  Divisor
;       K:A     return
;
        codvcre div
        codvsha d, w, s8, s16
        codvsha d, x, s32, u32
;
        codvcre rem
        codvsha f, w, s8, s16
        codvsha f, x, s32, u32
;
;Division & Remainder s8, s16
.macro  codvdw  reqd, reqr
.if reqr & codvs16 ;16 bit remainder
 .if reqd = codvs8 ;8 bit but not 16 bit divide
$rems16:
        st      a,k                     ;Get arguments
        ld      a,w(sp-4)
        jsr     $dr16                   ;Uses shared routine
        ld      a,k                     ;Return remainder
        ret
 .endif
.endif
.if ( reqd & reqr ) & codvs8
$divs8:
        jsr     $drs8                   ;Uses shared routine
        ret
$rems8:
        jsr     $drs8                   ;Uses shared routine
        ld      a,k                     ;Return remainder
        ret
$drs8:
.else
 .if reqd & codvs8
$divs8:
 .endif
 .if reqr & codvs8
$rems8:
 .endif
.endif
.if ( reqd ! reqr ) & codvs8
 .if ( reqd ! reqr ) & codvs16
        sex     a
 .endif
        st      a,k                     ;Get arguments
 .if ( reqd & reqr ) & codvs8 ;Argument depth conditional
        ld      a,w(sp-6)
 .else
        ld      a,w(sp-4)
 .endif
 .if ( reqd ! reqr ) & codvs16
        sex     a
 .endif
 .if reqd = codvs16 ;8 bit remainder and 16 bit divide
        jsr     $dr16                   ;Uses shared routine
        ld      a,k                     ;Return remainder
        ret
 .else
  .if ( reqd ! reqr ) & codvs16
   .if reqr & codvs16 ;16 bit remainder
    .if reqd <> codvs8 ;8 bit but not 16 bit divide
        jp      $dr16
    .endif
   .else
        jp      $dr16
   .endif
  .endif
 .endif
.endif
.if ( reqd & reqr ) & codvs16
$divs16:
        jsr     $drs16                  ;Uses shared routine
        ret
$rems16:
        jsr     $drs16                  ;Uses shared routine
        ld      a,k                     ;Return remainder
        ret
$drs16:
.else
 .if reqd & codvs16
$divs16:
 .endif
 .if reqr & codvs16 ;16 bit remainder but not 16 bit divide
  .if reqd <> codvs8
$rems16:
  .endif
 .endif
.endif
.if ( reqd ! reqr ) & codvs16
 .if reqd <> codvs8
        st      a,k                     ;Get arguments
  .if ( reqd & reqr ) & codvs16 ;Argument depth conditional
        ld      a,w(sp-6)
  .else
        ld      a,w(sp-4)
  .endif
 .endif
 .if ( reqd ! reqr ) & codvs8
$dr16:
 .endif
.endif
.if reqd
        ifeq    a,0
        ret                             ;  division by zero
        push    x
 .if ( reqd ! reqr ) & codvs16
        ifmi    a
 .else
        ifmib   a
 .endif
        jp      $dr16n                  ;  unknown/negative
        x       a,k
.else
 .if reqr & codvs16
        abs     a                       ;Sign of divisor irrelevant
 .else
        absb    a                       ;Sign of divisor irrelevant
 .endif
        x       a,k
        ifeq    k,0
        ret                             ;  division by zero
        push    x
.endif
.if ( reqd ! reqr ) & codvs16
        ifmi    a
.else
        ifmib   a
.endif
        jp      $dr16p                  ;  negative/positive
.if reqr
        div     a,k                     ;Positive/positive is plus,plus
 .if reqd
        jp      $dr16y
 .else
        ld      a,x
        jp      $dr16x
 .endif
.else
        jp      $dr16e                  ;Positive/positive is plus,plus
.endif
.if reqd
;
$dr16n:                                 ;Unknown/negative
 .if ( reqd ! reqr ) & codvs16
        neg     a
 .else
        negb    a, nonzero
 .endif
        x       a,k
 .if ( reqd ! reqr ) & codvs16
        ifmi    a
 .else
        ifmib   a
 .endif
        jp      $dr16b                  ;  negative/negative
 .if reqr
        div     a,k                     ;Positive/negative is minus,plus
        neg     a
$dr16y:
        ld      k,x
        jp      $dr16x
 .else
        jp      $dr16m                  ;Positive/negative is minus,plus
 .endif
.endif
;
$dr16p:                                 ;Negative/positive is minus,minus
.if ( reqd ! reqr ) & codvs16
        neg     a
.else
        negb    a, nonzero
.endif
.if reqd
 .if reqr
 .else
$dr16m:
 .endif
.endif
        div     a,k
.if reqd
        neg     a
 .if reqr
        jp      $dr16r
 .else
        jp      $dr16x
 .endif
;
$dr16b:                                 ;Negative/negative is plus,minus
 .if reqd & codvs16
        neg     a
 .else
        negb    a, nonzero
 .endif
 .if reqr
 .else
$dr16e:
 .endif
        div     a,k
 .if reqr
$dr16r:
 .endif
.endif
.if reqr
 .if reqd
        x       a,x
        neg     a
        st      a,k
        ld      a,x
 .else
        ld      a,x
        neg     a
 .endif
.endif
$dr16x:
        pop     x
        ret
.endm   ;codvdw
;
;Divide s32, u32
;Stack frame as built and used consists of
;top:
;       0, initial subtrahend hi \  dividend shifts into subtrahend
;       0, initial subtrahend lo /  becomes remainder
;       k, dividend hi     \  dividend shifts into subtrahend, and
;       a, dividend lo     /  quotient shifts into dividend
;       b preserved
;       x preserved
;       return address
;       sp-4-12, divisor hi
;       sp-6-12, divisor lo
;Sign flag (0= negative, 1= positive, for test sense at exit)
; bit 0, divisor sign (1= negative)
; bit 1, dividend sign (1= positive)
; Inc of flag causes bit 1 = (bit 1 xor bit 0) by carry/nocarry out of bit 0
; so that two positives (010) or two negatives (001) indicate a positive
; quotient (011 or 010) in bit 1.  Bit 1 always indicates sign if remainder.
;Operation is indicated by bit 3 of the flag, 1= remainder.
.macro  codvdx  reqd, reqr
.if reqd & codvs32
$divs32:
        ld      m(1),002
 .if reqr & codvs32
        jp      $drs32
 .endif
.endif
.if reqr & codvs32
$rems32:
        ld      m(1),00a
 .if reqd & codvs32
$drs32:
 .endif
.endif
.if ( reqd ! reqr ) & codvs32
        ifmi    k                       ;Check dividend
        jsr     $dr32n                  ;Negate dividend and note sign
        ifmib   m(sp-6+3)               ;Check divisor
        jp      $dr32d
        jmp     $dr32
$dr32d:
        x       a,w(sp-6)               ;Negate divisor and note sign
        comp    a
        add     a,1
        x       a,w(sp-6)
        x       a,w(sp-4)
        comp    a
        adc     a,0
        x       a,w(sp-4)
 .if reqd
        set     m(1).0
 .endif
 .if ( reqd ! reqr ) & codvu32
        jp      $dr32
 .endif
.endif
.if reqd & codvu32
$divu32:
 .if (reqd & codvs32) ! reqr
        ld      m(1),002
 .endif
 .if reqr & codvu32
        jp      $dr32
 .endif
.endif
.if reqr & codvu32
$remu32:
 .if (reqr & codvs32) ! reqd
        ld      m(1),00a
.endif
.endif
.if ( reqr & codvs32 ) ! reqd
$dr32:
.endif
        push    x                       ;Preserve registers
        push    b
        ld      b,sp                    ;Place dividend, becomes quotient
        push    a
        push    k
        ld      x,sp                    ;Set subtrahend, becomes remainder
        clr     a
        push    a
        push    a
        ld      k,-18                   ;Access divisor argument
        add     k,sp
        ld      a,w(k)
        or      a,w(k+2)
        ifeq    a,0
        jmp     $dr32z                  ;  dividion by zero
        ld      m(0),32                 ;Set counter
$dr32l:
        ld      a,w(b)                  ;Shift Dividend:Quotient
        shl     a
        xs      a,w(b+)
        nop
        ld      a,w(b)
        rlc     a
        xs      a,w(b-)
        nop
        ld      a,w(x)
        rlc     a
        x       a,w(x+)
        ld      a,w(x)
        rlc     a
        x       a,w(x-)
        if      c
        jp      $dr32s                  ;Carry out - dividend > divisor
        set     c                       ;Check for dividend > divisor
        ld      a,w(x+)
        subc    a,w(k)
        ld      a,w(x-)
        subc    a,w(k+2)
        ifn     c
        jp      $dr32c                  ;  dividend < divisor
$dr32s:
        ld      a,w(x)                  ;Subtract out divisor (c is set)
        subc    a,w(k)
        x       a,w(x+)
        ld      a,w(x)
        subc    a,w(k+2)
        x       a,w(x-)
.if reqd
        set     m(b).0                  ;Set quotient bit
.endif
$dr32c:
        decsz   m(0)                    ;Count 32 shifts
        jmp     $dr32l
$dr32z:
        pop     k                       ;Get Remainder and/or Quotient
        pop     a                       ;and clear working off stack
.if reqr
        pop     x
        pop     b
.else
        pop     k
        pop     a
.endif
.if reqd
 .if reqr
        if      m(1).3
        jp      $dr32x                  ;  want remainder, have it
        ld      a,b                     ;Want Quotient
        ld      k,x
 .endif
 .if reqd & codvs32
        inc     m(1)                    ;Divisor's sign Xors Dividend's
 .endif
 .if reqr
$dr32x:
 .endif
.endif
        pop     b                       ;Restore registers
        pop     x
.if ( reqd ! reqr ) & codvs32
        if      m(1).1
        ret                             ;  positive result
$dr32n:
        comp    a                       ;Negate K:A
        add     a,1
        x       a,k
        comp    a
        adc     a,0
        x       a,k
        reset   m(1).1                  ;Note sign (for entrance)
.endif
        ret
.endm   ;codvdx

;Preinc/decrement & Postinc/decrement (Signed or Unsigned are the same)
;16,8 bit
;       Uses Inline Code
;32 bit
;       X+2:0   Operand
;       K:A     Amount of inc/decrement
;       K:A     return
;
;Preinc/decrement, s32, u32 (sign irrelevant)
.macro  codepre
$pre32:
        add     a,w(x)
        x       a,w(x+)
        ld      a,w(x)
        adc     a,k
        st      a,k
        x       a,w(x-)
        ld      a,w(x)
        ret
.endm   ;codepre
;
;Postinc/decrement, s32, u32 (sign irrelevant)
.macro  codepos
$pos32:
        x       a,w(x)
        push    a
        add     a,w(x)
        x       a,w(x+)
        ld      a,w(x)
        x       a,k
        adc     a,k
        x       a,w(x-)
        pop     a
        ret
.endm   ;codepos

        .form
;IFMI   IF MINUS
;       (destructive means A and C can be changed)
.macro  ifmi    z, note
.ifc destructive ne note
 .ifc a ne z
        if      h(z).7
 .else
        ifgt    a,07fff
 .endif
.else
 .ifc a ne z
        ld      a,z
 .endif
        shl     a
        if      c
.endif
.endm   ;ifmi
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator (non-destructive)                  3       7       0
;Accumulator (destructive)                      2       6       0
;Register (B) indirect (destructive)            3      10       1
;Register (X) indirect (destructive)            3      10       1
;Direct (non-destructive)                      3,4    10,12     1
;Direct (destructive) NOT BEST CHOICE          4,6    12,16     1
;Indirect (destructive)                         5      16       2
;Indexed (destructive)                         6,7    19,21     1 

;IFMIB  IF MINUS BYTE
.macro  ifmib   z
.ifc a ne z
        if      z.7
.else
        ifgt    a,07f
.endif
.endm   ;ifmib
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator                                    2       5       0
;Register (B) indirect                          1       6       1
;Register (X) indirect                          2       9       1
;Direct                                        3,4    10,12     1
;Indirect                                       3      12       2
;Indexed                                       4,5    15,17     2 

;SEX    SIGN EXTEND (byte into word)
.macro  sex     z
        ifmib   z
.ifc a ne z
        ld      h(z),0ff
.else
        or      a,0ff00
.endif
.endm   ;sex
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator                                    5      11       0
;Direct                                        6,9    18,22     2

;SEXC   SIGN EXTEND INTO CARRY (word)
.macro  sexc    z
        reset   c
        ifmi    z
        set     c
.endm   ;sexc
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator                                    5      11       0
;Direct                                        6,9    18,22     2

;NEG    NEGATE
.macro  neg     z
.ifc a ne z
        x       a,z
.endif
        comp    a
        inc     a
.ifc a ne z
        x       a,z
.endif
.endm   ;neg
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator                                    2       4       0
;Register (B) indirect                          4      14       4
;Register (X) indirect                          2      14       4
;Direct                                        6,10   18,26    2,4
;Indirect                                       8      26       6
;Indexed                                      10,12   32,36     6 

;NEGB   NEGATE BYTE
;       (nonzero means value cannot currently be zero)
.macro  negb    z, note
        xor     z,0ff
.ifc nonzero ne note
        inc     l(z)
.else
        inc     z
.endif
.endm   ;negb
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator (nonzero)                          3       6       0
;Accumulator (not non-zero)                     4      11       2
;Direct                                        7,10   20,26     4

;ABS    ABSOLUTE VALUE
.macro  abs     z
        .mloc   negativ,positiv
        ifmi    z
        jp      negativ
        jp      positiv
negativ:
        neg     z
positiv:
.endm   ;abs
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator                                    7      15       0
;Direct (positive)                            12,16   18,20     1
;       (negative)                                    34,42     5

;ABSB   ABSOLUTE BYTE
.macro  absb    z
        .mloc   negativ,positiv
        ifmib   z
        jp      negativ
        jp      positiv
negativ:
        negb    z, nonzero
positiv:
.endm   ;absb
;
;Addressing mode                              Bytes  Cycles Accesses
;
;Accumulator (positive)                         7      13       0
;            (negative)                                15       0
;Direct (positive)                            12,16   18,20     1
;       (negative)                                    34,42     5

        .form
;START  SET UP CHIP AT START OF C PROGRAM
.macro  start                           ;For End User definitions
.endm   ;start

;READY  SET UP ENVIRONMENT AFTER RAM IS INITIALIZED
.macro  ready                           ;For End User definitions
.endm   ;ready

;HALT   SUSPEND PROCESSING
.macro  halt
        jp      .
.endm   ;halt

        .form
        .list   041
