;;;*************************************************************************
;;; level0.s
;;; Level 0 Debug Monitor Code
;;; Copyright (C) 1991 Advanced RISC Machines Limited. All rights reserved.
;;;
;;; RCS $Revision: 1.15 $
;;; Checkin $Date: 93/12/16 10:28:13 $
;;; Revising $Author: irickard $
;;;*************************************************************************

                IMPORT  Level1Init
                IMPORT  FP_CopyAndInstall, WEAK

                KEEP

                AREA |!DemonLevel0|, CODE, READONLY

                INCLUDE level0_h.s

                ENTRY

                B   ROMReset
ROMResetV       DCD ROMReset
InstallRDPV     DCD InstallRDP
ResetChannelV   DCD ResetDriver
ChannelSpeedV   DCD DriverSpeed
GetByteV        DCD GetByte
PutByteV        DCD PutByte
ReadTimerV      DCD ReadTimer
SetLEDsV        DCD SetLEDs
 [ TARGET = "PID"
InstallIRQV     DCD InstallIRQ
InstallFIQV     DCD InstallFIQ
 ]

;************************************************************************
;*                             Reset Entry                              *
;************************************************************************

ROMReset
 [ {CONFIG} = 26
                ;MOV    r14, #Config26Bit
                ;MCR    MMUCP, 0, r14, MMUControlReg, c0 ; configure arm6x0 26-bit address & data + little endian
 |
                MRS     r14, CPSR
                TST     r14, #User32Mode
                MOVEQ   r14, #Config32Bit
                MCREQ   MMUCP, 0, r14, MMUControlReg, c0 ; configure arm6x0 32-bit address & data + little endian
                MRS     r14, CPSR
                BIC     r14, r14, #Mask32Mode
                ORR     r14, r14, #NoInt + SVC32Mode
                MSR     CPSR, r14
 ]
                LDR     pc, =HiReset ; not as silly as it looks !

HiReset
 [ TARGET = "PIE"
                STR     r14, [r14, -r14] ; This is absorbed by the PIE
 ]
                STR     r14, [r14, -r14] ; Store r14 in location 0
                MOV     r14, #SavedRegs ; get the reg save area
                STMIA   r14!, {r0-r13} ; store regs

                MOV     r0, #0
                LDR     r1, [r0] ; get r14 back again
                STR     r1, [r14] ; save r14 too

                ADR     r1, DummyMMU
                LDMIA   r1, {r2,r3}
                MOV     r0, #4
                STMIA   r0, {r2,r3}
                MRC     MMUCP, 0, r0, MMUIDReg, c0 ; get the MMU ID

                MOV     r1, #WorkBase
                STR     r0, [r1, #MMUType - WorkBase]
                MOV     r0, #0
                STR     r0, [r1, #TimerVal - WorkBase]

 [ {CONFIG} = 26
                TEQP    pc, #NoInt | FIQ26Mode
                NOP
                MOV     lr, #0
                MOV     sp, #FIQStackBase
                TEQP    pc, #NoInt | IRQ26Mode
                NOP
                MOV     lr, #0
                MOV     sp, #IRQStackBase
                TEQP    pc, #NoInt | SVC26Mode
                NOP
                MOV     lr, #0
                MOV     sp, #SVCStackBase
 |
                MRS     r0, CPSR
                BIC     r0, r0, #NoInt | ModeMask
                ORR     r1, r0, #NoInt | FIQ32Mode
                MSR     CPSR, r1
                MSR     SPSR, #User32Mode
                MOV     sp, #FIQStackBase
                ORR     r1, r0, #NoInt | IRQ32Mode
                MSR     CPSR, r1
                MSR     SPSR, #User32Mode
                MOV     sp, #IRQStackBase
                ORR     r1, r0, #NoInt | Undef32Mode
                MSR     CPSR, r1
                MSR     SPSR, #User32Mode
                MOV     sp, #UndefStackBase
                ORR     r1, r0, #NoInt | Abort32Mode
                MSR     CPSR, r1
                MSR     SPSR, #User32Mode
                MOV     sp, #AbortStackBase
                ORR     r1, r0, #NoInt | SVC32Mode
                MSR     CPSR, r1
                MSR     SPSR, #User32Mode
                MOV     sp, #SVCStackBase
 ]

 [ TARGET = "PID"
                ; Disable all interrupts first
                MOV     r0, #0                  ; no it
                LDR     r1, =IOBase             ; for INTC PGA :
                STRB    r0, [r1, #IRQMask]      ; disable IRQ0-6
                STRB    r0, [r1, #FIQMask]      ; disable FIQs
                ; since Mask register is write only,
                ; we keep a copy in ram
                LDR     r3, =WorkBase
                STRB    r0,[r3, #SavedIRQMask - WorkBase]
                STRB    r0,[r3, #SavedFIQMask - WorkBase]

 ]
                MOV     r0, #1
                BL      ResetDriver

                MOV     r0, #1
                BL      SetLEDs

 [ ForROM
                BL      FindRAMSize     ; Check and get the size of RAM
 |
                MOV     r0, #512*1024
 ]
                MOV     r1, #WorkBase
                STR     r0, [r1, #RAMSize - WorkBase]
                MOV     r12, r0         ; keep for later

                MOV     r0, #2
                BL      SetLEDs

 [ ForROM
                MOV     r4, #ROMBase    ; checksum the rom
                LDR     r5, ROMEndPtr
                MOV     r1, #0
01              LDR     r6, [r4], #4
                MOV     r0, r6 ; LSR #0
                BL      CheckSum
                MOV     r0, r6, LSR #8
                BL      CheckSum
                MOV     r0, r6, LSR #16
                BL      CheckSum
                MOV     r0, r6, LSR #24
                BL      CheckSum
                CMP     r4, r5
                BNE     %B01

                MOV     r11, r1, LSR #16
                LDR     r0, [r4, #0]
                LDR     r1, [r4, #1]
                AND     r0, r0, #&ff
                AND     r1, r1, #&ff
                ORR     r10, r1, r0, LSL #8
 |
; skip ROM checksum if testing under the ARMulator, but keep th code the
; same size, so that symbols don't shift around too much.
                MOV     r10, #0
                MOV     r11, #0
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
                NOP
 ]
                MOV     r0, #3
                BL      SetLEDs

                MOV     r0, #SoftVectors
                SUB     r0, r0, #8
                ORR     r0, r0, #&e5000000
                ORR     r0, r0, #&00900000
                ORR     r0, r0, #&000ff000
                STR     r0, [r14,-r14] ; restore reset vector
                LDR     r1, =ResetVectorCopy
                STR     r0, [r1]

; Install default soft vectors

                LDR     r0, =MyVectors
                LDR     r1, =SoftVectors
                MOV     r2, #8
SoftVectsLoop   LDR     r3, [r0], #4
                STR     r3, [r1], #4
                SUBS    r2, r2, #1
                BNE     SoftVectsLoop

; make the hardware vectors point there

                LDR     r0, =SoftVectors ; build a PC releative LDR
                SUB     r0, r0, #&8
                ORR     r0, r0, #&e0000000
                ORR     r0, r0, #&05900000
                ORR     r0, r0, #&000ff000
                MOV     r1, #&20
HardVectsLoop   STR     r0, [r1, #-4]!
                CMP     r1, #0
                BNE     HardVectsLoop

 [ TARGET = "PIE"
                LDR     r0, =SerialInt ; Install the interrupt handler
                MOV     r1, #WorkBase
                STR     r0, [r1, #SoftVectors - WorkBase + &18]
                STR     r0, [r1, #SoftVectors - WorkBase + &1c]
                MOV     r0, #0
                STR     r0, [r1, #NextIntHandler - WorkBase]
 ]

 [ TARGET = "PID"

                ; Vectors will point by default to the NoIRQ and NoFIQ routines
InitIRQFIQVectors
                LDR     r1, =IRQVectors         ; IRQ Vectors location
                LDR     r0, =IRQH               ; default IRQ routine
                MOV     r3, #8                  ; up to 8 IRQ vectors
01              STR     r0, [r1],#4             ; store pointer to IRQ routine
                SUBS    r3, r3, #1              ; next vector
                BNE     %B01                    ; another one ? yes : loop
                LDR     r0, =FIQH               ; default FIQ routine
                MOV     r3, #8                  ; up to 8 IRQ vectors
02              STR     r0, [r1],#4             ; store pointer to FIQ routine
                SUBS    r3, r3, #1              ; next vector
                BNE     %B02                    ; another one ? yes : loop

                ; install the IRQ0 handler code (Serial chip)
                MOV     r0, #0
                LDR     r1, =SerialInt
                BL      InstallIRQ

                ; install the IRQ1 (TIMER) handler code
                MOV     r0, #1
                LDR     r1, =TimerInt
                BL      InstallIRQ

                ; install the IRQ Handler
                LDR     r0, =IRQHandler         ; get the address of the
                                                ; interrupt routine
                LDR     r1, =SoftVectors        ; store it in SoftVectors area
                STR     r0, [r1, #IRQV]         ; ... at the IRQ place

                ; install the FIQ Handler
                LDR     r0, =FIQHandler         ; get the address of the
                                                ; interrupt routine
                LDR     r1, =SoftVectors        ; store it in SoftVectors area
                STR     r0, [r1, #FIQV]         ; ... at the FIQ place

 ]

                MOV     r0, #4
                BL      SetLEDs

                MOV     r0, #1 ; make sure we flush slow framing errors
                BL      ResetDriver

                MOV     r0, #&7f
                MOV     r4, #&100
01              BL      PutByte
                SUBS    r4, r4, #1
                BNE     %B01

                LDR     r0, =ARMBanner
                BL      PrintString
                MOV     r0, #WorkBase
                LDR     r0, [r0, #MMUType - WorkBase]
                BIC     r0, r0, #&ff000000
                BIC     r0, r0, #&00ff0000
                BL      PrintWord

                LDR     r0, =DemonBanner
                BL      PrintString

                MOV     r0, r12
                BL      PrintHexWord    ; output the memory size

                CMP     r10, r11
                BNE     %F01    ; checksum failure

                LDR     r0, =CRCOKBanner
                BL      PrintString
                B       %F02

01              LDR     r0, =CRCFailBanner
                BL      PrintString

                MOV     r0, r10
                BL      PrintHexWord    ; output the ROM checksum

                MOV     r0, r11
                BL      PrintHexWord    ; output the CRC checksum

02              MOV     r0, #&ff
                MOV     r1, #WorkBase
                STR     r0, [r1, #EndianWord - WorkBase]
                LDRB    r0, [r1, #EndianWord - WorkBase]
                CMP     r0, #&ff
                LDREQ   r0, =LitEndBanner
                LDRNE   r0, =BigEndBanner
                BL      PrintString

                LDR     r0, =FP_CopyAndInstall
                CMP     r0, #0
                BEQ     InstallMMU
                MOV     lr, pc
                MOV     pc, r0
                LDR     r0, =FPBanner
                BL      PrintString

InstallMMU      MOV     r0, #WorkBase
                LDR     r0, [r0, #MMUType - WorkBase]
                BIC     r0, r0, #&ff000000
                BIC     r1, r0, #&00ff0000
                CMP     r1, #&100
                BLGE    InitMMU
                CMP     r1, #&100
                LDRGE   r0, =MMUBanner
                BLGE    PrintString

EndBanner       MOV     r0, #&a         ; newline
                BL      PutByte

                BL      Level1Init

                MOV     r0, #0  ; O.K. I'm ready
                BL      PutByte

                MOV     r0, #15
                BL      SetLEDs

                MOV     r14, #SavedRegs ; get the reg save area
                LDMIA   r14, {r0-r12} ; restore regs
 [ {CONFIG} = 32
                MSR     CPSR, #User32Mode
 |
                TSTP    pc, #User26Mode
 ]
                B       .

DummyMMU
 [ {CONFIG} = 26
                MOV     r0, #&20
 |
                MOV     r0, #&60
 ]
                MOVS    pc, lr

ARMBanner       DCB     "ARM",0
DemonBanner     DCB     ", DEMON V1.1,",0
CRCOKBanner     DCB     " bytes RAM, ROM CRC OK",0
CRCFailBanner   DCB     " bytes RAM, ROM CRC Fail",0
LitEndBanner    DCB     ", Little endian",0
BigEndBanner    DCB     ", Big endian",0
FPBanner        DCB     ", FPE.",0
MMUBanner       DCB     &a,"MMU enabled, Cache enabled, Write buffer enabled.",0

                ALIGN

ROMEndPtr       DCD      ROMEnd

                ALIGN


;************************************************************************
;*                Dummy exception handlers that just loop               *
;************************************************************************

MyVectors       DCD ResetH
                DCD UndefInstrH
                DCD SWIH
                DCD PrefAbortH
                DCD DataAbortH
                DCD AddrExceptH
                DCD IRQH
                DCD FIQH

ResetH          MOV     r0, #1
                B       Flash
UndefInstrH     MOV     r0, #2
                B       Flash
SWIH            MOV     r0, #3
                B       Flash
PrefAbortH      MOV     r0, #4
                B       Flash
DataAbortH      MOV     r0, #5
                B       Flash
AddrExceptH     MOV     r0, #6
                B       Flash
IRQH            MOV     r0, #7
                B       Flash
FIQH            MOV     r0, #8
                B       Flash

Flash           MOV     r4, r0 ; save the initial flash counter
 [ {CONFIG} = 32
                MRS     r5, CPSR
                BIC     r5, r5, #NoInt | ModeMask
                ORR     r5, r5, #SVC32Mode
                MSR     CPSR, r5 ; make sure FIQ's work
 |
                TEQP    pc, #SVC26Mode
 ]
01              MOV     r5, r4 ; ready for a new loop
02              MOV     r0, #0 ; turn the LED off
                BL      SetLEDs
                MOV     r0, #100 ; wait a second
                BL      Wait
                MOV     r0, #1 ; turn the LED on
                BL      SetLEDs
                MOV     r0, #100 ; wait a second
                BL      Wait
                SUBS    r5, r5, #1 ; end of the loop ?
                BNE     %B02
                MOV     r0, #500 ; wait five seconds
                BL      Wait
                B       %B01 ; and do it again

;************************************************************************
;*                             Level 0 Code                             *
;************************************************************************

; Install a RDP handler

InstallRDP      STMFD   sp!, {r1,r2}
                LDR     r2, =RDPHandlerV
                LDR     r1, [r2]
                STR     r0, [r2]
                MOV     r0, r1
                LDMFD   sp!, {r1,r2}
                MOV     pc, lr

 [ TARGET = "PID"
                ; 8 different overide vectors
                ; r0 has the IRQ number, r1 has the address
InstallIRQ      STMDB   r13!, {r2-r4}           ; Save r2-r4 in Stack
                LDR     r2, =IRQVectors         ; get the IRQ Vectors list addr
                AND     r0, r0, #7              ; Fix r0 if out of range
                LDR     r3, [r2, r0, LSL #2]    ; get old IRQ Vector address
                STR     r1, [r2, r0, LSL #2]    ; replace with new address
                MOV     r1, r3                  ; r1 <- old Irq address
                LDR     r2, =SavedIRQMask       ; get Saved Irq mask addr
                LDRB    r3, [r2]                ; r3 <- old mask value
                MOV     r4, #1
                MOV     r0, r4, LSL r0          ; set mask bit in r0
                ORR     r3, r3, r0              ; r3 <- mask value
                AND     r3, r3, #&7F            ; bit6-0 only
                LDR     r2, =IOBase             ; get INTC base
                STRB    r3, [r2, #IRQMask]      ; save new mask
                LDR     r2, =SavedIRQMask
                STRB    r3, [r2]
                LDMIA   r13!, {r2-r4}           ; restore r2-r4
                MOV     r15, r14                ; returns


                ; 8 different overide vectors
                ; r0 has the FIQ number, r1 has the address
InstallFIQ      STMDB   r13!, {r2-r4}           ; Save r2 & r3 in Stack
                LDR     r2, =FIQVectors         ; get the FIQ Vectors list addr
                AND     r0, r0, #7              ; Fix r0 if out of range
                LDR     r3, [r2, r0, LSL #2]    ; get old FIQ Vector address
                STR     r1, [r2, r0, LSL #2]    ; replace with new address
                MOV     r1, r3                  ; r1 <- old FIQ address
                LDR     r2, =SavedFIQMask       ; get Saved Fiq mask addr
                LDRB    r3, [r2]                ; r3 <- old mask value
                MOV     r4, #1
                MOV     r0, r4, LSL r0          ; set mask bit in r0
                ORR     r3, r3, r0              ; r3 <- mask value
                LDR     r2, =IOBase             ; get INTC base
                STRB    r3, [r2, #FIQMask]      ; save new mask
                LDR     r2, =SavedFIQMask
                STRB    r3, [r2]
                LDMIA   r13!, {r2-r4}           ; restore r2 & r3
                MOV     r15, r14                ; returns
 ]

; Wait for the number of centiseconds in r0
; r0, r1 and r2 are corrupted

Wait            MOV     r2, lr
                MOV     r1, r0
                BL      ReadTimer
                ADD     r1, r1, r0
WaitLoop        BL      ReadTimer
                CMP     r0, r1
                BLO     WaitLoop
                MOV     pc, r2

; Print a zero terminated string

PrintString     MOV     r4, lr
                MOV     r5, r0
01              LDR     r0, [r5], #1
                TST     r0, #&ff
                MOVEQ   pc, r4
                BL      PutByte
                B       %B01

; Print a four byte word in hex, preceded by ' 0x'


PrintHexWord    MOV     r4, lr
                MOV     r5, r0
                MOV     r0, #&20 ; ' '
                BL      PutByte
                MOV     r0, #&30 ; '0'
                BL      PutByte
                MOV     r0, #&78 ; 'x'
                BL      PutByte
                B       PrintWord2

; Print a four byte word in hex

PrintWord       MOV     r4, lr
                MOV     r5, r0
PrintWord2      MOV     r6, #28
01              MOV     r0, r5, LSR r6
                ANDS    r0, r0, #&f
                BNE     %F02 ; the first non-zero
                SUBS    r6, r6, #4
                BNE     %B01 ; all but the last digit
02              CMP     r0, #10
                ADDLO   r0, r0, #&30 ; 0 - 9
                ADDHS   r0, r0, #&61 - 10 ; a - f
                BL      PutByte
                SUBS    r6, r6, #4
                MOV     r0, r5, LSR r6
                AND     r0, r0, #&f
                BPL     %B02
                MOV     pc, r4

; pass in the old crc in r1 (top 16 bits), and the character in r0
; return the new checksum in r1,

CheckSum        MOV     r2, #&50000
                ADD     r2, r2, #&80000000
CheckLoop
                TEQ     r1, r0, LSL #24 ; bit 7
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #25 ; bit 6
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #26 ; bit 5
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #27 ; bit 4
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #28 ; bit 3
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #29 ; bit 2
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #30 ; bit 1
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2

                TEQ     r1, r0, LSL #31 ; bit 0
                MOV     r1, r1, LSL #1
                EORMI   r1, r1, r2
                MOV     pc, lr

; Set up the ARM6x0 MMU with a simple flat page table

InitMMU         MCR     MMUCP, 0, r0, MMUFlushTLBReg, c0 ; Flush the TLB
                MCR     MMUCP, 0, r0, MMUFlushIDCReg, c0 ; Flush the cache
                LDR     r0, =&55555555
                MCR     MMUCP, 0, r0, MMUDomainAccessReg, c0 ; set domains
                LDR     r0, ROMEndPtr
                ADD     r0, r0, #2          ; real end-of ROM after checksum
                BIC     r0, r0, #&00ff
                BIC     r0, r0, #&3f00      ; find lower 16K boundary
                TST     r0, #&c0000000      ; 32 bit memory map
                ADDEQ   r0, r0, #&4000      ; Next 16K boundary
                ADDNE   r0, r0, #&8000      ; Next 32K boundary
                MCR     MMUCP, 0, r0, MMUPageTableBaseReg, c0 ; First level page table address
 [ {CONFIG} = 26
                LDR     r0, =EnableMMU26
 |
                LDR     r0, =EnableMMU32
 ]
                MCR     MMUCP, 0, r0, MMUControlReg, c0
                MOV     pc, lr

                GET     driver.s
                GET     checkmem.s

                AREA    LastArea
; use armlink -last to ensure this area goes last!

                ALIGN
; DCD 0
ROMEnd          ; the checksum will be here

                END
