/********************************************************************/
/* ports16.h C16 V2.04                                              */
/* Copyright (c) 1997 Texas Instruments Incorporated                */
/********************************************************************/

/********************************************************************/
/* System Module                                                    */
/********************************************************************/
struct sys
{ unsigned int reset               :2;
  unsigned int                     :6;
  union
  { unsigned char byte;
    struct
    { unsigned int clksrc          :2;
      unsigned int                 :2;
      unsigned int vccaon          :1;
      unsigned int                 :3;
    } bit;
  } scr1;
  union
  { unsigned char byte;
    struct
    { unsigned int porst           :1;
      unsigned int oscrst          :1;
      unsigned int                 :1;
      unsigned int illadr          :1;
      unsigned int illacc          :1;
      unsigned int swrst           :1;
      unsigned int wdrst           :1;
      unsigned int extrst          :1;
    } bit;
  } srsr;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :2;
      unsigned int hpo             :1;
      unsigned int                 :1;
      unsigned int vccaor          :1;
      unsigned int                 :3;
    } bit;
  } ssr;
  unsigned int                     :8;
  unsigned int                     :8;
  unsigned int psa;
};

struct wdt
{ unsigned int                     :8;
  unsigned char rticntr;
  unsigned int                     :8;
  unsigned char wdcntr;
  unsigned int                     :8;
  unsigned char wdkey;
  unsigned int                     :8;
  union
  { unsigned char byte;
    struct
    { unsigned int rti_flag        :1;
      unsigned int rti_ena         :1;
      unsigned int                 :3;
      unsigned int rtips           :3;
    } bit;
  } rticr;
  unsigned int                     :8;
  unsigned char wdcr;
};


/********************************************************************/
/*  Serial Communications Interface Module                          */
/********************************************************************/
struct sci
{ union
  { unsigned char byte;
    struct
    { unsigned int stop_bits       :1;
      unsigned int parity          :1;
      unsigned int parity_enable   :1;
      unsigned int async_isosync   :1;
      unsigned int addr_idle_mode  :1;
      unsigned int char_len        :3;
    } bit;
  } ccr;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int rx_err_int_enab :1;
      unsigned int sw_reset        :1;
      unsigned int clock           :1;
      unsigned int txwake          :1;
      unsigned int sleep           :1;
      unsigned int txena           :1;
      unsigned int rxena           :1;
    } bit;
  } ctl1;
  unsigned char msb_baud;
  unsigned char lsb_baud;
  union
  { unsigned char byte;
    struct
    { unsigned int txrdy           :1;
      unsigned int tx_empty        :1;
      unsigned int                 :4;
      unsigned int rx_bk_int_ena   :1;
      unsigned int tx_int_ena      :1;
    } bit;
  } ctl2;
  union
  { unsigned char byte;
    struct
    { unsigned int rx_error        :1;
      unsigned int rxrdy           :1;
      unsigned int brkdt           :1;
      unsigned int fe              :1;
      unsigned int oe              :1;
      unsigned int pe              :1;
      unsigned int rxwake          :1;
      unsigned int                 :1;
    } bit;
  } rxst;
  unsigned char rxemu;
  unsigned char rxbuf;
  unsigned int                     :8;
  unsigned char txbuf;
  unsigned int                     :8;
  unsigned int                     :8;
  unsigned int                     :8;

  union
  { unsigned char byte;
    struct
    { unsigned int                 :4;
      unsigned int clk_data_in     :1;
      unsigned int clk_data_out    :1;
      unsigned int clk_function    :1;
      unsigned int clk_data_dir    :1;
    } bit;
  } pc1;
  union
  { unsigned char byte;
    struct
    { unsigned int txd_data_in     :1;
      unsigned int txd_data_out    :1;
      unsigned int txd_function    :1;
      unsigned int txd_data_dir    :1;
      unsigned int rxd_data_in     :1;
      unsigned int rxd_data_out    :1;
      unsigned int rxd_function    :1;
      unsigned int rxd_data_dir    :1;
    } bit;
  } pc2;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int tx_priority     :1;
      unsigned int rx_priority     :1;
      unsigned int espen           :1;
      unsigned int                 :4;
    } bit;
  } pri;
};


/********************************************************************/
/*  Serial Peripheral Interface Module                              */
/********************************************************************/
struct spi
{ union
  { unsigned char byte;
    struct
    { unsigned int sw_reset        :1;
      unsigned int clock_polarity  :1;
      unsigned int                 :3;
      unsigned int char_len        :3;
    } bit;
  } ccr;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :3;
      unsigned int overrun_int_ena :1;
      unsigned int clock_phase     :1;
      unsigned int master_slave    :1;
      unsigned int talk            :1;
      unsigned int int_ena         :1;
    } bit;
  } ctl;
  union
  { unsigned char byte;
    struct
    { unsigned int receiver_overrun:1;
      unsigned int int_flag        :1;
      unsigned int                 :6;
    } bit;
  } sts;
  unsigned int                     :8;
  unsigned int                     :1;
  unsigned int brr                 :7;
  unsigned int                     :8;
  unsigned char emu;
  unsigned char buf;
  unsigned int                     :8;
  unsigned char dat;
  unsigned int                     :8;
  unsigned int                     :8;
  unsigned int                     :8;
 union
  { unsigned char byte;
    struct
    { unsigned int ste_data_in     :1;
      unsigned int ste_data_out    :1;
      unsigned int ste_function    :1;
      unsigned int ste_data_dir    :1;
      unsigned int clk_data_in     :1;
      unsigned int clk_data_out    :1;
      unsigned int clk_function    :1;
      unsigned int clk_data_dir    :1;
    } bit;
  } pc1;
  union
  { unsigned char byte;
    struct
    { unsigned int simo_data_in    :1;
      unsigned int simo_data_out   :1;
      unsigned int simo_function   :1;
      unsigned int simo_data_dir   :1;
      unsigned int somi_data_in    :1;
      unsigned int somi_data_out   :1;
      unsigned int somi_function   :1;
      unsigned int somi_data_dir   :1;
    } bit;
  } pc2;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int priority        :1;
      unsigned int espen           :1;
      unsigned int                 :5;
    } bit;
  } pri;
};


/********************************************************************/
/*  Analog to Digital Converter Module                              */
/********************************************************************/
struct a2d
{ unsigned int                     :8;
  union
  { unsigned char byte;
    struct
    { unsigned int conv_end        :1;
      unsigned int enab_int        :1;
      unsigned int conv_mode       :1;
      unsigned int single_chnl_sel :1;
      unsigned int single_dual_chnl:1;
      unsigned int                 :2;
      unsigned int start           :1;
    } bit;
  } csr;
  unsigned int                     :8;
  unsigned int                     :6;
  unsigned int ps                  :2;
  unsigned int                     :8;
  union
  { unsigned char byte;
    struct
    { unsigned int chnl1           :4;
      unsigned int chnl2           :4;
    } bit;
  } isr;
  unsigned int                     :8;
  unsigned char dr0;
  unsigned int                     :8;
  unsigned char dr1;
};

/********************************************************************/
/*  General Purpose Input Output Module                             */
/********************************************************************/
struct gpio
{ union
  { unsigned char byte;
    struct
    { unsigned int a7              :1;
      unsigned int a6              :1;
      unsigned int a5              :1;
      unsigned int a4              :1;
      unsigned int a3              :1;
      unsigned int a2              :1;
      unsigned int a1              :1;
      unsigned int a0              :1;
    } bit;
  } asel;    
  union
  { unsigned char byte;
    struct
    { unsigned int                 :4;
      unsigned int b3              :1;
      unsigned int b2              :1;
      unsigned int b1              :1;
      unsigned int b0              :1;
    } bit;
  } bsel;
  unsigned int                     :8;    
  unsigned int                     :8;    
  unsigned int                     :8;    
  unsigned int                     :8;    
  unsigned int                     :8;    
  unsigned int                     :8;    
 union
  { unsigned char byte;
    struct
    { unsigned int a7              :1;
      unsigned int a6              :1;
      unsigned int a5              :1;
      unsigned int a4              :1;
      unsigned int a3              :1;
      unsigned int a2              :1;
      unsigned int a1              :1;
      unsigned int a0              :1;
    } bit;
  } adir;    
  union
  { unsigned char byte;
    struct
    { unsigned int a7              :1;
      unsigned int a6              :1;
      unsigned int a5              :1;
      unsigned int a4              :1;
      unsigned int a3              :1;
      unsigned int a2              :1;
      unsigned int a1              :1;
      unsigned int a0              :1;
    } bit;
  } adata;    
  union
  { unsigned char byte;
    struct
    { unsigned int                 :4;
      unsigned int b3              :1;
      unsigned int b2              :1;
      unsigned int b1              :1;
      unsigned int b0              :1;
    } bit;
  } bdir;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :4;
      unsigned int b3              :1;
      unsigned int b2              :1;
      unsigned int b1              :1;
      unsigned int b0              :1;
    } bit;
  } bdata;
  union
  { unsigned char byte;
    struct
    { unsigned int c7              :1;
      unsigned int c6              :1;
      unsigned int c5              :1;
      unsigned int c4              :1;
      unsigned int c3              :1;
      unsigned int c2              :1;
      unsigned int c1              :1;
      unsigned int c0              :1;
    } bit;
  } cdir;    
  union
  { unsigned char byte;
    struct
    { unsigned int c7              :1;
      unsigned int c6              :1;
      unsigned int c5              :1;
      unsigned int c4              :1;
      unsigned int c3              :1;
      unsigned int c2              :1;
      unsigned int c1              :1;
      unsigned int c0              :1;
    } bit;
  } cdata;
};      

/********************************************************************/
/* Interrupt Module                                                 */
/********************************************************************/
struct intr
{ union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int data            :1;
      unsigned int nmi             :1;
      unsigned int                 :1;
      unsigned int                 :1;
      unsigned int polarity        :1;
      unsigned int priority        :1;
      unsigned int enable	   :1;
    } bit;
  } int1;
  unsigned int int1_flag           :1;
  unsigned int                     :7;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int data            :1;
      unsigned int nmi             :1;
      unsigned int dir             :1;
      unsigned int out             :1;
      unsigned int polarity        :1;
      unsigned int priority        :1;
      unsigned int enable	   :1;
    } bit;
  } int2;
  unsigned int int2_flag           :1;
  unsigned int                     :7;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int data            :1;
      unsigned int                 :1;
      unsigned int dir             :1;
      unsigned int out             :1;
      unsigned int polarity        :1;
      unsigned int priority        :1;
      unsigned int enable	   :1;
    } bit;
  } int3;
  unsigned int int3_flag           :1;
  unsigned int                     :7;
};


/********************************************************************/
/*  Timer 16A Module                                                */
/********************************************************************/
struct t16a
{ unsigned int cntra;
  union
  { unsigned int word;
    struct
    { unsigned int tstat           :1;
      unsigned int os              :2;
      unsigned int eo              :2;
      unsigned int cs              :3;
      unsigned int evta_data_in    :1;
      unsigned int evta_data_out   :1;
      unsigned int evta_out_ena    :1;
      unsigned int trig            :1;
      unsigned int pol             :1;
      unsigned int eb1_rst_ena     :1;
      unsigned int eb0_rst_ena     :1;
      unsigned int cnta_reset      :1;
    } bit;
  } cntracr1;
  union
  { unsigned int word;
    struct
    { unsigned int c16en           :1;
      unsigned int c12en           :1;
      unsigned int c8en            :1;
      unsigned int edc             :2;
      unsigned int ps              :3;
      unsigned int                 :8;
    } bit;
  } cntracr2;
  unsigned int                     :8;
  unsigned int                     :8;
  unsigned int cntrb;
  union
  { unsigned int word;
    struct
    { unsigned int tstat           :1;
      unsigned int os              :2;
      unsigned int eo              :2;
      unsigned int cs              :3;
      unsigned int evtb_data_in    :1;
      unsigned int evtb_data_out   :1;
      unsigned int evtb_out_ena    :1;
      unsigned int trig            :1;
      unsigned int pol             :1;
      unsigned int eb1_rst_ena     :1;
      unsigned int eb0_rst_ena     :1;
      unsigned int cntb_reset      :1;
    } bit;
  } cntrbcr1;
  union
  { unsigned int word;
    struct
    { unsigned int c16en           :1;
      unsigned int c12en           :1;
      unsigned int c8en            :1;
      unsigned int edc             :2;
      unsigned int ps              :3;
      unsigned int                 :8;
    } bit;
  } cntrbcr2;
  unsigned int                     :8;
  unsigned int                     :8;
  union
  { unsigned int word;
    struct
    { unsigned int                 :1;
      unsigned int eb6_int_ena     :1;
      unsigned int eb5_int_ena     :1;
      unsigned int eb4_int_ena     :1;
      unsigned int eb3_int_ena     :1;
      unsigned int eb2_int_ena     :1;
      unsigned int eb1_int_ena     :1;
      unsigned int eb0_int_ena     :1;
      unsigned int                 :1;
      unsigned int eb6_int_flag    :1;
      unsigned int eb5_int_flag    :1;
      unsigned int eb4_int_flag    :1;
      unsigned int eb3_int_flag    :1;
      unsigned int eb2_int_flag    :1;
      unsigned int eb1_int_flag    :1;
      unsigned int eb0_int_flag    :1;
    } bit;
  } intcr;
  union
  { unsigned char byte;
    struct
    { unsigned int                 :1;
      unsigned int eb6_force       :1;
      unsigned int eb5_force       :1;
      unsigned int eb4_force       :1;
      unsigned int eb3_force       :1;
      unsigned int eb2_force       :1;
      unsigned int eb1_force       :1;
      unsigned int eb0_force       :1;
    } bit;
  } efr;
  unsigned int                     :8;
  unsigned int cap1;
  union
  { unsigned int word;
    struct
    { unsigned int cp              :1;
      unsigned int cc              :1;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int sam             :1;
      unsigned int qen             :1;
      unsigned int cen             :1;
      unsigned int edge            :2;
    } bit;
  } cap1cr;
  unsigned int cap2;
  union
  { unsigned int word;
    struct
    { unsigned int cp              :1;
      unsigned int cc              :1;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int sam             :1;
      unsigned int qen             :1;
      unsigned int cen             :1;
      unsigned int edge            :2;
    } bit;
  } cap2cr;
  unsigned int cap3;
  union
  { unsigned int word;
    struct
    { unsigned int cp              :1;
      unsigned int cc              :1;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int sam             :1;
      unsigned int qen             :1;
      unsigned int cen             :1;
      unsigned int edge            :2;
    } bit;
  } cap3cr;
  unsigned int cap4;
  union
  { unsigned int word;
    struct
    { unsigned int cp              :1;
      unsigned int cc              :1;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int sam             :1;
      unsigned int qen             :1;
      unsigned int cen             :1;
      unsigned int edge            :2;
    } bit;
  } cap4cr;
  unsigned int cmp1;
  union
  { unsigned int word;
    struct
    { unsigned int sz              :2;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int odrv            :1;
      unsigned int ea              :2;
      unsigned int ca              :2;
    } bit;
  } cmp1cr;
  unsigned int cmp2;
  union
  { unsigned int word;
    struct
    { unsigned int sz              :2;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int odrv            :1;
      unsigned int ea              :2;
      unsigned int ca              :2;
    } bit;
  } cmp2cr;
  unsigned int cmp3;
  union
  { unsigned int word;
    struct
    { unsigned int sz              :2;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int odrv            :1;
      unsigned int ea              :2;
      unsigned int ca              :2;
    } bit;
  } cmp3cr;
  unsigned int cmp4;
  union
  { unsigned int word;
    struct
    { unsigned int sz              :2;
      unsigned int eo              :3;
      unsigned int ei              :3;
      unsigned int data_in         :1;
      unsigned int data_out        :1;
      unsigned int out_ena         :1;
      unsigned int odrv            :1;
      unsigned int ea              :2;
      unsigned int ca              :2;
    } bit;
  } cmp4cr;
};  


/********************************************************************/
/*  Define pointers to memory mapped peripherals                    */
/********************************************************************/
#define SYS  ((volatile struct sys *)  0x00018)
#define WDT  ((volatile struct wdt *)  0x00020)
#define A2D  ((volatile struct a2d *)  0x00030)
#define SPI  ((volatile struct spi *)  0x00040)
#define SCI  ((volatile struct sci *)  0x00050)
#define GPIO ((volatile struct gpio *) 0x00060)
#define INT  ((volatile struct intr *) 0x00070)
#define T16A ((volatile struct t16a *) 0x000C0)
