         .width 96
*;*****************************************************************************
*;                                                                            *
*;  FDIV v3.15                                                                *  
*;  Copyright (c) 1993-1998 Texas Instruments Incorporated                    *
*;  F$$DIV - divide two floating point numbers                                *
*;                                                                            *
*;*****************************************************************************
*;*****************************************************************************
*;                                                                            *
*;  revision:  original                                                       *
*;                                                                            *
*;*****************************************************************************
*;                                                                            *
*;       F$$DIV                               LO MEMORY          stack        *
*;                                                         +----------------+ *
*;       This routine divides two floating point      SP-->|  errno value   | *
*;       numbers.  Upon entry one operand (OP1) is         +----------------+ *
*;       in accumulator A and the other (OP2) is on the  1 |  res high mant | *
*;       stack as shown.  SP is moved to accomodate        +----------------+ *
*;       locals.  When division is finished the SP is    2 |  res low mant  | *
*;       returned to point at the return address.          +----------------+ *
*;                                                       3 |  res exponent  | *
*;       inputs:  OP1 - in acc. A, OP2 - in stack          +----------------+ *
*;                                                       4 |  res sign      | *
*;       implementation:  OP1 and OP2 are each unpacked    +----------------+ *
*;            into sign, exponent, and two words of      5 | OP2 high mant  | *
*;            mantissa.  If either exponent is zero        +----------------+ *
*;            special case processing is initiated.      6 | OP2 low mant   | *
*;            The difference of the exponents are taken.   +----------------+ *
*;            IF the result is less than zero underflow  7 | OP2 sign & exp | *
*;            has occurred.  If the result is zero,        +----------------+ *
*;            underflow may have occurred.  If the       8 | OP1 sign & exp | *
*;            result is equal to 254 overflow may          +----------------+ *
*;            have occurred.  If the result is           9 | OP1 high mant  | *
*;            greater than 254 overflow has occurred.      +----------------+ *
*;            Underflow processing returns a value      10 | OP1 low mant   | *
*;            of zero.  Overflow processing returns        +----------------+ *
*;            the largest magnitude value along with    11 |    not used    | *
*;            the appropriate sign.  If no special         +----------------+ *
*;            cases are detected, a 24x24-bit           12 |    T REG       | *
*;            divide is executed.  The result of           +----------------+ *
*;            the eXclusive OR of the sign bits, the    13 |    B_GUARD     | *
*;            difference of the exponents and the 24       +----------------+ *
*;            bit truncated mantissa are packed and     14 |    B_HIGH      | *
*;            returned.                                    +----------------+ *
*;                                                      15 | B_LOW          | *
*;       result:  returned in accumulator A                +----------------+ *
*;                                                      16 | (return addr)  |  
*;                                                         +----------------+ *
*;                                                      17 |   MSW of OP2   | *
*;                                                         +----------------+ *
*;                                            HI MEMORY 18 |   LSW of OP2   | *
*;                                                                            *
*;    NOTE: The ordering of the locals are placed to take advantage           *
*;          of long word loads and stores which require the hi and lo         *
*;          words to be at certain addresses. Any future modifications        *
*;          which involve the stack must take this quirk into account         *
*;                                                                            *
*;                                                                            *
*;*****************************************************************************
         .page
*;*****************************************************************************
*;                                                                            *
*;       resource utilization:  B accumulator                                 *
*;                              T-register                                    *
*;                              16 levels of C stack                          *
*;                                                                            *
*;       status bits affected: TC, C, SXM, OVM, C16                           *
*;                                                                            *
*;       entry requirements : CPL bit set,                                    *
*;                                                                            *
*;*****************************************************************************
         .page
*;*****************************************************************************
*;                                                                            *
*;  Floating Point Format - Single Precision                                  *
*;                                                                            *
*;                                                                            *
*;       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+    *
*;       |31 |30 |29 |28 |27 |26 |25 |24 |23 |22 |21 |20 |19 |18 |17 |16 |    *
*;       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+    *
*;       |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |    *
*;       | S |E7 |E6 |E5 |E4 |E3 |E2 |E1 |E0 |M22|M21|M20|M19|M18|M17|M16|    *
*;       |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |    *
*;       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+    *
*;                                                                            *
*;       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+    *
*;       |15 |14 |13 |12 |11 |10 | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |    *
*;       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+    *
*;       |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |    *
*;       |M15|M14|M13|M12|M11|M10|M9 |M8 |M7 |M6 |M5 |M4 |M3 |M2 |M1 |M0 |    *
*;       |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |    *
*;       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+    *
*;                                                                            *
*;                                                                            *
*;       Single precision floating point format is a 32 bit format            *
*;       consisting of a 1 bit sign field, an 8 bit exponent field, and a     *
*;       23 bit mantissa field.  The fields are defined as follows.           *
*;                                                                            *
*;            Sign <S>          : 0 = positive values; 1 = negative values    *
*;                                                                            *
*;            Exponent <E7-E0>  : offset binary format                        *
*;                                00 = special cases (i.e. zero)              *
*;                                01 = exponent value + 127 = -126            *
*;                                FE = exponent value + 127 = +127            *
*;                                FF = special cases (not implemented)        *
*;                                                                            *
*;            Mantissa <M22-M0> : fractional magnitude format with implied 1  *
*;                                1.M22M21...M1M0                             *
*;                                                                            *
*;            Range             : -1.9999998 e+127 to -1.0000000 e-126        *
*;                                +1.0000000 e-126 to +1.9999998 e+127        *
*;                                (where e represents 2 to the power of)      *
*;                                -3.4028236 e+38  to -1.1754944 e-38         *
*;                                +1.1754944 e-38  to +3.4028236 e+38         *
*;                                (where e represents 10 to the power of)     *
*;*****************************************************************************
         .page
         .global   F$$DIV
         .global   _f$$error
         .text

******************************************************************************
* If using extended addressing the return address occupies 2 words on stack 
******************************************************************************
	.if __far_mode
offset  .set 1
	.else
offset	.set 0
	.endif


F$$DIV 
        .asg    *SP(0),ERR_NO
        .asg    *SP(1),RES_EXP
        .asg    *SP(2),RES_HM
        .asg    *SP(3),RES_LM
        .asg    *SP(4),RES_SIGN
        .asg    *SP(5),OP1_SE
        .asg    *SP(6),OP2_SE
        .asg    *SP(8),OP2_HM
        .asg    *SP(9),OP2_LM
        .asg    *SP(10),OP1_HM
        .asg    *SP(11),OP1_LM
 
        .asg    *SP(18 + (2*offset)),OP2_MSW
        .asg    *SP(19 + (2*offset)),OP2_LSW
 
        .mmregs
	.c_mode
*
*;*****************************************************************************
*;       CONTEXT SAVE                                                         *
*;       Save contents of B accumulator, allocate stack space for locals      *
*;*****************************************************************************
*
	nop			; make sure read new value of B
        pshm    BL              ; Save B accumulator contents
        pshm    BH
	pshm	BG
        pshm    T               ; Save T register contents
        rsbx    C16             ; Insure long adds for later
        frame   (-13 - offset)  ; Allocate space for locals
*
*;*****************************************************************************
*;       CONVERSION OF FLOATING POINT FORMAT - UNPACK                         *
*;  Test OP1 for special case treatment of zero.                              *
*;  Split the MSW of A in the accumulator.                                    *
*;    Save the sign and exponent on the stack [xxxx xxxS EEEE EEEE].          *
*;    Add the implied one to the mantissa value.                              *
*;    Store entire mantissa with a long word store                            *
*;*****************************************************************************
*
        ssbx    SXM             ; insure that OP1 is sign-extended
        sfta    A,8
        sfta    A,-8
        bc      OP1_ZERO,AEQ    ; if op1 is 0, jump to special case
        sth     A,-7,OP1_SE     ; store sign and exponent to stack
        stl     A,OP1_LM        ; store low mantissa
        and     #07Fh,16,A      ; mask off sign & exp to get high mantissa
        add     #080h,16,A      ; add implied 1 to mantissa
        sth     A,OP1_HM        ; store mantissa to stack
*
*;*****************************************************************************
*;       CONVERSION OF FLOATING POINT FORMAT - UNPACK                         *
*;  Test OP1 for special case treatment of zero.                              *
*;  Split the MSW of A in the accumulator.                                    *
*;    Save the sign and exponent on the stack [xxxx xxxS EEEE EEEE].          *
*;    Add the implied one to the mantissa value.                              *
*;    Store entire mantissa with a long word store                            *
*;*****************************************************************************
*
        dld     OP2_MSW,A       ; load acc a with OP2
        bc      OP2_ZERO,AEQ    ; if OP2 is 0, divide by zero
        sth     A,-7,OP2_SE     ; store sign and exponent to stack
	stl	A,OP2_LM	; store low mantissa
        and     #07Fh,16,A      ; mask off sign & exp to get high mantissa
        add     #080h,16,A      ; add implied 1 to mantissa
        sth     A,OP2_HM        ; store mantissa to stack
*
*;*****************************************************************************
*;       SIGN EVALUATION                                                      *
*;  Exclusive OR sign bits of OP1 and OP2 to determine sign of result.        *
*;*****************************************************************************
*
        ld      OP1_SE,A        ; load sign and exp of op1 to acc
        xor     OP2_SE,A        ; xor with op2 to get sign of result
        and     #00100h,A       ; mask to get sign
        stl     A,RES_SIGN      ; save sign of result to stack
*
*;*****************************************************************************
*;       EXPONENT SUMMATION                                                   *
*;  Find difference between operand exponents to determine the result         *
*;  exponent.  Since the subtraction process removes the bias it must be      *
*;  re-added in.
*;                                                                            *
*;  Branch to one of three blocks of processing                               *
*;    Case 1:  exp OP1 + exp OP2 results in underflow (exp < 0)               *
*;    Case 2:  exp OP1 + exp OP2 results in overflow (exp >= 0FFh)            *
*;    Case 3:  exp OP1 + exp OP2 results are in range (exp >= 0 & exp < 0FFh) *
*;      NOTE:  Cases when result exp = 0 may result in underflow unless there *
*;             is a carry in the result that increments the exponent to 1.    *
*;             Cases when result exp = 0FEh may result in overflow if there   *
*;             is a carry in the result that increments the exponent to 0FFh. *
*;*****************************************************************************
*
         ld     OP1_SE,A        ; Load OP1 sign and exponent
         and    #0FFh,A         ; Mask OP1 exponent
*
         ld     OP2_SE,B        ; Load OP2 sign and exponent
         and    #0FFh,B         ; Mask OP2 exponent
*
         add    #07Fh,A         ; Add offset (difference eliminates offset) 
         sub    B,A             ; Take difference between exponents
         stl    A,RES_EXP       ; Save result exponent on stack
*
         bc     UNDERFLOW,ALT   ; branch to underflow handler if exp < 0
         sub    #0FFh,A          ; test for overflow
         bc     OVERFLOW,AGT    ; branch to overflow is exp > 127
*
*;*****************************************************************************
*;       DIVISION                                                             *
*;  Division is implemented by parts.  The mantissas for both OP1 and OP2 are *
*;  left shifted in the 32 bit field to reduce the effect of secondary and    *
*;  tertiary contributions to the final result.  The left shifted results     *
*;  are identified as OP1'HI, OP1'LO, OP2'HI, and OP2'LO where OP1'HI and     *
*;  OP2'HI have the xx most significant bits of the mantissas and OP1'LO      *
*;  and OP2'LO contain the remaining bits of each mantissa.  Let QHI and      *
*;  QLO represent the two portions of the resultant mantissa.  Then           *
*;                                                                            *
*;                 OP1'HI + OP1'LO     OP1'HI + OP1'LO          1             *
*;   QHI + QLO  =  ---------------  =  ---------------  * ----------------- . *
*;                 OP2'HI + OP2'LO         OP2'HI        (1 + OP2'LO/OP2'HI)  *
*;                                                                            *
*;   Now let   X = OP2'LO/OP2'HI.                                             *
*;                                                                            *
*;   Then by Taylor's Series Expansion,                                       *
*;                                                                            *
*;               1                2    3                                      *
*;             -----  =  1 - X + X  - X  +  ...                               *
*;             (1+X)                                                          *
*;                                                                            *
*;   Since OP2'HI contains the first xx significant bits of the OP2 mantissa, *
*;                                                                            *
*;                               -yy                                          *
*;          X = OP2'LO/OP2'HI < 2   .                                         *
*;                                                                            *
*;   Therefore the X**2 term and all subsequent terms are less than the       *
*;   least significant bit of the 24-bit result and can be dropped.           *
*;   The result then becomes                                                  *
*;                                                                            *
*;                 OP1'HI + OP1'LO          1                                 *
*;   QHI + QLO  =  ---------------  * ----------------                        *
*;                     OP2'HI        (1 + OP2'LO/OP2'HI)                      *
*;                                                                            *
*;                 OP1'HI + OP1'LO          OP2'LO                            *
*;              =  ---------------  * ( 1 - ------ )                          *
*;                     OP2'HI               OP2'HI                            *
*;                                                                            *
*;                                       OP2'LO                               *
*;               = (Q'HI + Q'LO) * ( 1 - ------ )                             *
*;                                       OP2'HI                               *
*;                                                                            *
*;    where Q'HI and Q'LO represent the first approximation of the result.    *
*;    Also since Q'LO and OP2'LO/OP2'HI are less significant the 24th bit of  *
*;    the result, this product term can be dropped so that                    *
*;                                                                            *
*;     QHI + QLO  =  Q'HI + Q'LO - (Q'HI * OP2'LO)/OP2'HI .                   *
*;                                                                            *
*;*****************************************************************************
*
        dld	OP1_HM,A	; Load dividend mantissa
        sftl  	A,6             ; Shift dividend in preparation for division

	dld	OP2_HM,B	; Load divisor mantissa
	sftl	B,7		; Shift divisor in preparation for division
	dst	B,OP2_HM	; Save off divisor

        rpt	#14             ; QHI = OP1'HI/OP2'HI
        subc	OP2_HM,A		
	stl	A,RES_HM	; Save QHI

        subs	RES_HM,A        ; Clear QHI from ACC
	rpt	#10		; Q'LO = OP1'LO / OP2'HI
	subc	OP2_HM,A
	stl	A,5,RES_LM	; Save Q'LO

	ld	RES_HM,T	; T = Q'HI
	mpyu	OP2_LM,A	; Store Q'HI * OP2'LO in acc A
	sftl	A,-1		;

	rpt	#11		; Calculate Q'HI * OP2'LO / OP2'HI
	subc	OP2_HM,A	;   (correction factor)
	sftl	A,4		; Left shift to bring it to proper range
	and	#0FFFFh,A	; Mask off correction factor
	sftl    A,1

	neg	A		; Subtract correction factor
	adds	RES_LM,A	; Add Q'LO
	add	RES_HM,16,A	; Add Q'HI	
*	
*;*****************************************************************************
*;       POST-NORMALIZATION ADJUSTMENT AND STORAGE                            *
*;  Set up to adjust the normalized result.                                   *
*;    The MSB may be in bit 31.  Test this case and increment the exponent    *
*;    and right shift mantissa 1 bit so result is in bits 30 through 7.       *
*;  Right shift mantissa by 7 bits.                                           *
*;  Store low mantissa on stack.                                              *
*;  Mask implied 1 and store high mantissa on stack.                          *
*;  Test result for underflow and overflow.                                   *
*;*****************************************************************************
*
	ld	RES_EXP,B	; Load result exponent
	exp	A		; Get amount to adjust exp for normaiization
	nop
	norm	A		; Normalize the result
	st	T,RES_EXP	; Store the exponent adjustment value
	sub	RES_EXP,B	; Adjust exponent (add either zero or one)

	sftl	A,-1		; Pre-scale adjustment for rounding
	add	#1,B 		; Adjust exponent 
	add	#020h,A		; Add rounding bit
	exp	A		; Normalize after rounding
	nop
	norm	A		;
	st	T,RES_EXP	; Adjust exponent for normalization
	sub	RES_EXP,B	;

	stl	B,RES_EXP	; Save exponent         
        bc      UNDERFLOW,BLEQ  ; process underflow if occurs
        sub     #0FFh,B         ; adjust to check for overflow
        bc      OVERFLOW,BGEQ   ; process overflow if occurs
        sftl    A,-7            ; Shift right to place mantissa for splitting
	stl	A,RES_LM	; Save result low mantissa
        and     #07F00h,8,A     ; Eliminate implied one
        sth     A,RES_HM        ; Save result mantissa on stack
*
*;*****************************************************************************
*;       CONVERSION OF FLOATING POINT FORMAT - PACK                           *
*;  Load sign.                                                                *
*;  Pack exponent.                                                            *
*;  Pack mantissa.                                                            *
*;*****************************************************************************
*
        ld      RES_SIGN,16,A   ; 0000 000S 0000 0000 0000 0000 0000 0000
        add     RES_EXP,16,A    ; 0000 000S EEEE EEEE 0000 0000 0000 0000
        sftl    A,7             ; SEEE EEEE E000 0000 0000 0000 0000 0000
        dadd    RES_HM,A        ; SEEE EEEE EMMM MMMM MMMM MMMM MMMM MMMM
*
*;*****************************************************************************
*;       CONTEXT RESTORE                                                      *
*;  Pop local floating point variables.                                       *
*;  Pop contents of B                                                         *
*;*****************************************************************************
*
* entry: A - final result
*
RETURN_VALUE
OP1_ZERO
        frame   (13 + offset)   ; Remove locals
	popm	T		; Restore contents of T register
	popm	BG		; Restore contents of b
        popm    BH              
        popm    BL

	.if __far_mode          ; Use far return for C548 in far mode
        fret                   
	.else
	ret
	.endif
 
      	.page
*;*****************************************************************************
*;       OVERFLOW PROCESSING                                                  *
*;  Push errno onto stack.                                                    *
*;  Call _f$$error.                                                           *
*;  Load accumulator with return value.                                       *
*;*****************************************************************************
*
OVERFLOW
        st      #2,ERR_NO       ; Load error no

	.if __far_mode          ; Use far call for C548 in far mode
        fcall   _f$$error    
	.else
        call   _f$$error        ; Call error handler
	.endif

        sat	A               ; Result exponent = 0FEh
        sub     #081h,16,  A    ; Result high mant = 07Fh
        ld	RES_SIGN,16,B   ; Calculate sign of result
	bc	RETURN_VALUE,BNEQ
	ld	#8000h,16,B
        bd      RETURN_VALUE    ; Branch delayed
	xor	B,A
	nop	
*
*;*****************************************************************************
*;       UNDERFLOW PROCESSING                                                 *
*;  Push errno onto stack.                                                    *
*;  Call _f$$error.                                                           *
*;  Load accumulator with return value.                                       *
*;*****************************************************************************
*
UNDERFLOW
        st      #1,ERR_NO     	; Load error no

	.if __far_mode          ; Use far call for C548 in far mode
        fcall   _f$$error    
	.else
        call   _f$$error        ; Call error handler
	.endif

        bd      RETURN_VALUE    ; Branch delayed
        sub     A,A             ; For underflow result = 0
        nop
*
*;*****************************************************************************
*;       DIVIDE BY ZERO                                                       *
*;  Push errno onto stack.                                                    *
*;  Call _f$$error.                                                           *
*;  Load accumulator with return value.                                       *
*;*****************************************************************************
*
OP2_ZERO
        st      #3,ERR_NO       ; Load error no

	.if __far_mode          ; Use far call for C548 in far mode
        fcall   _f$$error    
	.else
        call   _f$$error        ; Call error handler
	.endif

        ld      OP1_SE,16,B    	; Load sign and exponent of OP1
	and	#100h,16,B	; Mask to get sign of OP1
        sub     #081h,16,A      ; Result high mant = 7Fh
	xor	#8000h,16,A
        bd      RETURN_VALUE    ; Branch delayed
	or 	B,7,A		; Pack sign
        nop
