/****************************************************************************/
/* LNK16BE.CMD - V1.00  COMMAND FILE FOR LINKING THUMB C PROGRAMS             */
/*                                                                          */
/*   Usage:  armlnk <obj files...>    -o <out file> -m <map file> lnk16.cmd */
/*           armcl  <src files...> -z -o <out file> -m <map file> lnk16.cmd */
/*                                                                          */
/*   Description: This file is a sample command file that can be used       */
/*                for linking programs built with the ARM C                 */
/*                Compiler.   Use it as a guideline; you may want to change */
/*                the allocation scheme according to the size of your       */
/*                program and the memory layout of your target system.      */
/*                                                                          */
/*   Notes: (1)   You must specify the directory in which rts.lib is        */
/*                located.  Either add a "-i<directory>" line to this       */
/*                file, or use the system environment variable C_DIR to     */
/*                specify a search path for libraries.                      */
/*                                                                          */
/*          (2)   If the run-time support library you are using is not      */
/*                named rts16.lib, be sure to use the correct name here.    */
/*                                                                          */
/****************************************************************************/
-c                                         /* LINK USING C CONVENTIONS      */
-stack  0x8000                             /* SOFTWARE STACK SIZE           */
-heap   0x2000                             /* HEAP AREA SIZE                */

-l rts16be.lib                               /* GET RUN-TIME SUPPORT        */

/* SPECIFY THE SYSTEM MEMORY MAP */

MEMORY
{
    I_MEM    : org = 0x0000000   len = 0x00000020  /* INTERRUPT VECTORS */
    P_MEM    : org = 0x0000020   len = 0x0002ffe0  /* PROGRAM MEMORY (ROM) */
    D_MEM    : org = 0x0030020   len = 0x00050000  /* DATA MEMORY    (RAM) */
}

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY */

SECTIONS
{
    .intvecs : {} > I_MEM		   /* INTERUPT VECTOR TABLE		    */
    .bss     : {} > D_MEM              /* GLOBAL & STATIC VARS              */
    .data    : {} > D_MEM              /* INITIALIZED DATA                  */
    .sysmem  : {} > D_MEM              /* DYNAMIC MEMORY ALLOCATION AREA    */
    .stack   : {} > D_MEM              /* SOFTWARE SYSTEM STACK             */

    .text    : {} > P_MEM              /* CODE                              */
    .cinit   : {} > P_MEM              /* INITIALIZATION TABLES             */
    .const   : {} > P_MEM              /* CONSTANT DATA                     */
}
