/****************************************************************************/
/* COMMAND FILE FOR LINKING TMS370C16 C PROGRAMS                            */
/****************************************************************************/
-c					/* Link using C conventions         */
-stack 200h  				/* Stack size                       */
-heap 200h  				/* Heap size                        */
-l rts.lib                              /* Get Run-time support

/* SPECIFY THE SYSTEM MEMORY MAP  */

MEMORY
{
  RAM : origin = 02000h, length = 00400h
  ROM : origin = 08000h, length = 0C000h
}

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY */

SECTIONS
{
  .cinit   :  > ROM  			/* INITIALIZATION TABLES            */
  .const   :  > ROM  			/* CONSTANTS AND SWITCH TABLES      */
  .data    :  > ROM  			/* OTHER DATA (NOT USED BY COMPILER)*/
  .text    :  > ROM 			/* CODE                             */
  .intvecs :  load=08000h               /* INTERRUPT VECTOR TABLE           */
  .bss     :  > RAM  			/* VARIABLES                        */
  .heap    :  > RAM  			/* DYNAMIC MEMORY POOL              */
  .stack   :  > RAM  			/* SYSTEM STACK                     */
}
