************************************************************************
* - Event test (event.asm)                                             *
* - Logs 2 events: 1 non data-attached event and 1 data-attached event *
************************************************************************
        .mmregs
FP      .set      AR7
        .title    "Event Test for C54x"

************************ RTDX User layer *******************************
        .include  "rtdx.i"                 ; include RTDX macro library
************************************************************************

	.sect	".const"
SL1:	.string	13,"Test Completed",0
MAX_ITERATIONS  .set   0x4
DEFAULT_CLS     .set   0x0000
EVENT_CLS       .set   0x0001
EVENTB_CLS      .set   0x0002
	
        RTDX_event event,EVENT_CLS
        RTDX_event eventB,EVENTB_CLS
        RTDX_e_class_set eclass
       
        .sect   ".text"
        .ref    _puts
        .ref    _RTDX_writing
        .global _main
        .ref    _RTDX_Poll
        .def    i
        .bss    i,1,0,0

****************************************************************
* FUNCTION DEF: _main                                          *
****************************************************************
_main:
         PSHM      AR7
         ST        #0,*(i)              ; set counter to 0

TEST_COUNTER:
         STM       i,AR7
         SSBX      SXM                  ; set status bit for sign
                                        ;     extension mode
         LD        *(i),B               ; load counter into accumulator
                                        ;     B
         LD        *(BL),A              ; load LSB of accumulator B
                                        ;     into accumulator A
         SUB       #1,A,A               ; decrement accumulator by 1
         BC        SET_CLASS_EVENT,AEQ  ; branch to SET_CLASS_EVENT if
                                        ;     the contents of
                                        ;     accumulator A = 0
         LD        *(BL),A              ; load LSB of accumulator B
                                        ;     into accumulator A
         SUB       #2,A,A               ; decrement accumulator by 2
         BC        SET_CLASS_EVENTB,AEQ ; branch to SET_CLASS_EVENTB if
                                        ;     the contents of
                                        ;     accumulator A = 0
         BD        LOG_ALL_EVENTS       ; delayed branch to
                                        ;     LOG_ALL_EVENTS
         ST        DEFAULT_CLS,eclass   ; enable all classes

SET_CLASS_EVENTB:
         BD        LOG_ALL_EVENTS       ; delayed branch to
                                        ;      LOG_ALL_EVENTS
         ST        EVENTB_CLS,eclass    ; set eclass = EVENTB_CLASS

SET_CLASS_EVENT:
         ST        EVENT_CLS,eclass     ; set eclass = EVENT_CLASS

LOG_ALL_EVENTS:
         RTDX_Disable_Event_Class eclass
         RTDX_Log_Event event           ; log event
         RTDX_Log_Event_Data eventB,AR7,1  ; log eventb
         RTDX_Enable_Event_Class eclass

TEST_DATA_TRANSMITTED:
         LD      *(_RTDX_writing),A     ; load data transfer status
         CC      #_RTDX_Poll,ANEQ       ; poll if the contents of
                                        ;     register A NOT = NULL
         BC      TEST_DATA_TRANSMITTED,ANEQ    ; loop

RESET:
         LD        *(i),A               ; load counter into accumulator
                                        ;      A
         SSBX      SXM                  ; set status bit for sign
                                        ;      extension mode
         ADD       #1,A,A               ; increment accumulator A by 1
         STL       A,*(i)               ; store the contents of the
                                        ;      accumulator back into the
                                        ;      stack pointer
         SUB       #MAX_ITERATIONS,A,A  ; decrement accumulator by 4
         BC        TEST_COUNTER,ALT     ; branch if less than 0

         LD        #SL1,A               ; load closing message
         CALL      #_puts               ; print closing message

         POPM      AR7
         RET