/*----------------------------------------------------------------------------*/
/*  LINKER COMMAND FILE 								*/
/*  MEMORY SPECIFICATION for C240 used for Serial Boot Flash programming
/*  Last update 14 Nov 97									*/
/*----------------------------------------------------------------------------*/
MEMORY
{
    PAGE 0 :   	VECS	: origin =    0h , length =   040h	 /* PROGRAM */
		USER	: origin =   40h , length =  0C00h	 /*	    */
	    /*	PROG	: origin =01000h , length =  0400h  Test only !     */
		PROG	: origin =03800h , length =  0800h	 /* Segmt 7 */
                B0_PRG  : origin =0FE66h , length =  0100h       /*         */

    PAGE 1 :	MMRS	: origin =    0h , length =   05Fh	 /* MMRS    */
	       	B2	: origin = 0060h , length =   020h	 /* DARAM   */
	       	B0	: origin = 0100h , length =  0200h	 /* DARAM   */
	       	B1	: origin = 0300h , length =  0200h	 /* DARAM   */

  /*PAGE 2 :	B0_PRG	: origin =0FE6Ah , length =  0096h	    Overlay */

}

/*--------------------------------------------------------------------------*/
/* SECTIONS ALLOCATION                                                      */
/*--------------------------------------------------------------------------*/
SECTIONS
{
    .vectors : { } > VECS      PAGE 0	   /* INTERRUPT VECTOR TABLE	   */
    .text    : { } > PROG      PAGE 0	   /* CODE			   */
    .data    : { } > PROG      PAGE 0	   /* CODE			   */
    .alg     : { } > B0_PRG    PAGE 0	   /* CODE			   */
    .blk0    : { } > B0        PAGE 1	   /* Block B0 - page 4 	   */
    .blk2    : { } > B2        PAGE 1	   /* Block B2 - page 0 	   */
    .bss     : { } > B1        PAGE 1	   /* Block B1 - page 6 	   */

/*
    UNION: run = B0_PRG  PAGE 2
    {   
       clr_flsh    : load= B0_PRG PAGE 2
       er_flsh	   : load= PROG  PAGE 2
       prg_flsh    : load= PROG  PAGE 2

    }
*/
}

