;*****************************************************************************
; File Name:	C240APP.H
; Project:	C240 EVM Apps S/W suite
; Originator/s: Auto/Ind DSP Apps group - Texas Instruments (Houston)
;
; Description:	C240 Header file with all Peripheral Register declarations
;		+ other useful defines.
;
; Status:	Not complete yet, still need to make some additions
;
; Last Update:	3 Oct 96
; ____________________________________________________________________________
; Date of Mod | 		    DESCRIPTION
; ------------|---------------------------------------------------------------
; 3 Oct 96    | Added Event Manager Register declarations.
;	      |
;	      |
;	      |
;*****************************************************************************
;-----------------------------------------------------------------------------
; On Chip Periperal Register Definitions (DATA SPACE)
;-----------------------------------------------------------------------------
;C2xx Core Registers
;~~~~~~~~~~~~~~~~~~~~
IMR		.set	0004h		;Int Mask Register
GREG		.set	0005h		;Global memory allocation reg
IFR		.set	0006h		;Int Flag Register
ABRPT		.set	01fh		; Analysis BreakPoint Register

;System Module Registers
;~~~~~~~~~~~~~~~~~~~~~~~
SYSCR		.set	07018h		;System Module Control Register
SYSSR		.set	0701Ah		;System Module Status Register
DIN		.set	0701Ch		;Device Identification Register
SYSIVR		.set	0701Eh		;System Interrupt Vector Register

XINT1_CNTL	.set	07070h		;Int1 (type A) Control reg
NMI_CNTL	.set	07072h		;Non maskable Int (type A) Control reg
XINT2_CNTL	.set	07078h		;Int2 (type C) Control reg
XINT3_CNTL	.set	0707Ah		;Int3 (type C) Control reg
PDPINT_CNTL	.set	0742Ch		;Power Drive Protection Int cntl reg

;Digital I/O
;~~~~~~~~~~~
OPCRA		.set	07090h		;Output Control Reg A
OPCRB		.set	07092h		;Output Control Reg B
IPSRA		.set	07094h		;Input Status Reg A
IPSRB		.set	07096h		;Input Status Reg B
PADATDIR	.set	07098h		;I/O port A Data & Direction reg.
PBDATDIR	.set	0709Ah		;I/O port B Data & Direction reg.
PCDATDIR	.set	0709Ch		;I/O port C Data & Direction reg.
PDDATDIR	.set	0709Eh		;I/O port D Data & Direction reg.

;Watch-Dog(WD) / Real Time Int(RTI) / Phase Lock Loop(PLL) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
RTI_CNTR	.set	07021h		;RTI Counter reg
WD_CNTR 	.set	07023h		;WD Counter reg
WD_KEY		.set	07025h		;WD Key reg
RTI_CNTL	.set	07027h		;RTI Control reg
WD_CNTL 	.set	07029h		;WD Control reg
PLL_CNTL1	.set	0702Bh		;PLL control reg 1
PLL_CNTL2	.set	0702Dh		;PLL control reg 2

;Analog-to-Digital Converter(ADC) registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ADC_CNTL1	.set	07032h		;ADC Control reg 1
ADC_CNTL2	.set	07034h		;ADC Control reg 2
ADC_FIFO1	.set	07036h		;ADC FIFO data reg 1
ADC_FIFO2	.set	07038h		;ADC FIFO data reg 2

;Serial Peripheral Interface (SPI) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SPI_CCR 	.set	07040h		;SPI Config Control Reg 1
SPI_CTL 	.set	07041h		;SPI Operation Control Reg 2
SPI_STS 	.set	07042h		;SPI Status Reg
SPI_BRR 	.set	07044h		;SPI Baud rate control reg
SPI_EMU 	.set	07046h		;SPI Emulation buffer reg
SPI_BUF 	.set	07047h		;SPI Serial Input buffer reg
SPI_DAT 	.set	07049h		;SPI Serial Data reg
SPI_PC1 	.set	0704Dh		;SPI Port control reg1
SPI_PC2 	.set	0704Eh		;SPI Port control reg2
SPI_PRI 	.set	0704Fh		;SPI Priority control reg

;Serial Communications Interface (SCI) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SCI_CCNTL	.set	07050h		;SCI Comms Control Reg
SCI_CNTL1	.set	07051h		;SCI Control Reg 1
SCI_HBAUD	.set	07052h		;SCI Baud rate control
SCI_LBAUD	.set	07053h		;SCI Baud rate control
SCI_CNTL2	.set	07054h		;SCI Control Reg 2
SCI_RX_STAT	.set	07055h		;SCI Receive status reg
SCI_RX_EMU	.set	07056h		;SCI EMU data buffer
SCI_RX_BUF	.set	07057h		;SCI Receive data buffer
SCI_TX_BUF	.set	07059h		;SCI Transmit data buffer
SCI_PORT_C1	.set	0705Dh		;SCI Port control reg1
SCI_PORT_C2	.set	0705Eh		;SCI Port control reg2
SCI_PRI 	.set	0705Fh		;SCI Priority control reg

;Event Manager (EV) - EV Base Address = 0x7400
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
EV_BASE 	.set   7400h	       ; Event Manager Base Address.		DP 232)
GPTCON		.set   00h + EV_BASE   ; General Timer Controls
T1CNT		.set   01h + EV_BASE   ; T1 Counter Register
T1CMP		.set   02h + EV_BASE   ; T1 Compare Register
T1PER		.set   03h + EV_BASE   ; T1 Period Register
T1CON		.set   04h + EV_BASE   ; T1 Control Register
T2CNT		.set   05h + EV_BASE   ; T2 Counter Register
T2CMP		.set   06h + EV_BASE   ; T2 Compare Register
T2PER		.set   07h + EV_BASE   ; T2 Period Register
T2CON		.set   08h + EV_BASE   ; T2 Control Register
T3CNT		.set   09h + EV_BASE   ; T3 Counter Register
T3CMP		.set   0ah + EV_BASE   ; T3 Compare Register
T3PER		.set   0bh + EV_BASE   ; T3 Period Register
T3CON		.set   0ch + EV_BASE   ; T3 Control Register
COMCON		.set   11h + EV_BASE   ; Compare Unit Control
ACTR		.set   13h + EV_BASE   ; Compare Unit Output Action Control
SACTR		.set   14h + EV_BASE   ; S Comp Unit Output Action Control

DBTCON		.set   15h + EV_BASE   ; Dead Band Timer Control
CMPR1		.set   17h + EV_BASE   ; Compare Channel 1 Threshold
CMPR2		.set   18h + EV_BASE   ; Compare Channel 2 Threshold
CMPR3		.set   19h + EV_BASE   ; Compare Channel 3 Threshold
SCMPR1		.set   1ah + EV_BASE   ; S Comp Channel 1 Threshold
SCMPR2		.set   1bh + EV_BASE   ; S Comp Channel 2 Threshold
SCMPR3		.set   1ch + EV_BASE   ; S Comp Channel 3 Threshold
CAPCON		.set   20h + EV_BASE   ; Capture Unit Control
CAPFIFO 	.set   22h + EV_BASE   ; FIFO1-4 Status Register
FIFO1		.set   23h + EV_BASE   ; Capture Channel 1 FIFO Top
FIFO2		.set   24h + EV_BASE   ; Capture Channel 2 FIFO Top
FIFO3		.set   25h + EV_BASE   ; Capture Channel 3 FIFO Top
FIFO4		.set   26h + EV_BASE   ; Capture Channel 4 FIFO Top
IMRA		.set   2ch + EV_BASE   ; Group A Interrupt Mask Register
IMRB		.set   2dh + EV_BASE   ; Group B Interrupt Mask Register
IMRC		.set   2eh + EV_BASE   ; Group C Interrupt Mask Register
IFRA		.set   2fh + EV_BASE   ; Group A Interrupt Flag Register
IFRB		.set   30h + EV_BASE   ; Group B Interrupt Flag Register
IFRC		.set   31h + EV_BASE   ; Group C Interrupt Flag Register
IVRA		.set   32h + EV_BASE   ; Group A Int. Vector Offset(AD dec only)
IVRB		.set   33h + EV_BASE   ; Group B Int. Vector Offset(AD dec only)
IVRC		.set   34h + EV_BASE   ; Group C Int. Vector Offset(AD dec only)

;-----------------------------------------------------------------------------
; Constant defines
;-----------------------------------------------------------------------------
B0_SADDR	.set	00100h		;Block B0 start address
B0_EADDR	.set	001FFh		;Block B0 end address
B1_SADDR	.set	00300h		;Block B1 start address
B1_EADDR	.set	003FFh		;Block B1 end address
B2_SADDR	.set	00060h		;Block B2 start address
B2_EADDR	.set	0007Fh		;Block B2 end address

;Bit codes for Test bit instruction (BIT)
BIT15		.set	0000h		;Bit Code for 15
BIT14		.set	0001h		;Bit Code for 14
BIT13		.set	0002h		;Bit Code for 13
BIT12		.set	0003h		;Bit Code for 12
BIT11		.set	0004h		;Bit Code for 11
BIT10		.set	0005h		;Bit Code for 10
BIT9		.set	0006h		;Bit Code for 9
BIT8		.set	0007h		;Bit Code for 8
BIT7		.set	0008h		;Bit Code for 7
BIT6		.set	0009h		;Bit Code for 6
BIT5		.set	000Ah		;Bit Code for 5
BIT4		.set	000Bh		;Bit Code for 4
BIT3		.set	000Ch		;Bit Code for 3
BIT2		.set	000Dh		;Bit Code for 2
BIT1		.set	000Eh		;Bit Code for 1
BIT0		.set	000Fh		;Bit Code for 0

;External Data Space Registers
EXTDATA		.set	8000h
