#ifndef  __DSK_COFF
#define  __DSK_COFF
//---------------------------------------------------------
// DSK_COFF.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
#include "typedefs.h"
#if __DSKWINAPP
#include <windows.h>
#endif
#include "errormsg.h"
#define  MAGIC_FL    0x93  /* C3x/C4x     */
#define  MAGIC_FX    0x92  /* C1x/C2x/C5x */
#define  MAXSECTIONS   64
extern   char  section_name[];
extern   char  DASM_file[];   // Current loaded DSK filename
extern   char  HLL_file[];    // High Level Language file (C source)
extern   ulong section_start;
extern   ulong section_offs;
extern   int   CoffVer;       // COFF version of last loaded COFF file
extern   char  *DSKEXT;
extern   char  *OUTEXT;
extern   ulong  WSTATE;
//extern   ulong  IOSTRB;
extern   ulong  IOSTRB;
extern   ulong  STRB0;
extern   ulong  STRB1;
extern   ulong  DLLEXTEND_EX ENTRY;

typedef enum
{
  LOAD,       // Loads a file to the DSK target
  BOOT,       // Bootloads a file to the DSK target
  FILE2HEX,   // Writes bootable hex file to file.hex
  BOOTHEX,    // Writes loadable hex file to file.hex
  LOADHEX,    // Load/Boot hex files. Line 1 sets mode
  DSK2COFF,   // Convert ASCII DSK file to Binary COFF file
  MEM2COFF,   // Convert mem block to COFF file
  MEM2HEX,    // Convert mem block to HEX file
  SLOAD       // Load only symbols from file
}TASK;

void       Symbol_Clear(int level);
MSGS Save_File    (char *file,ulong start, ulong length,TASK task);
MSGS DLLEXTEND_EX Load_File(char *fileptr, TASK task);
MSGS LOADCOFF     (char *fileptr, TASK task);
MSGS LOADDSKA     (char *fileptr, TASK task);
MSGS CVT2COFF     (char *fileptr, ulong start, ulong length, TASK task);
MSGS Load_Hex_File(char *filename, TASK task);

typedef struct {
  ushort mgc;      //  2 coff magic number 0x93 (0x92 for fixed pt DSP)
  ushort sect;     //  2 number of sections in file
  ulong  date;     //  4 time and date stamp
  ulong  symb;     //  4 file pointer to symbol table
  ulong  nsym;     //  4 number of symbols in symbol table
  ushort optn;     //  2 length of optional header
  ushort flag;     //  2 Flags
}FILE_HDR0;        // 20 bytes long

typedef struct {
  ushort mgc;      // 2 coff magic number 0x93 (0x92 for fixed pt DSP)
  ushort sect;     // 2 number of sections in file
  ulong  date;     // 4 time and date stamp
  ulong  symb;     // 4 file pointer to symbol table
  ulong  nsym;     // 4 number of symbols in symbol table
  ushort optn;     // 2 length of optional header
  ushort flag;     // 2 Flags
  ushort mgc2;     // 2 COFF version 1,2,3,4... use this field
}FILE_HDR1;

typedef struct {
  ushort     mgc;  // options magic number 0x108
  ushort    vers;  // version stamp
  ulong  text_sz;  // size (in words) of .text
  ulong  data_sz;  // size (in words) of .data
  ulong   bss_sz;  // size (in bits) of .bss
  ulong    entry;  // entry point address
  ulong  text_ad;  // beginning address of .text
  ulong  data_ad;  // beginning address of .data
}OPTN_HDR;

typedef struct {   // +-----------Value is zero if unitilized section
  char   name[8];  // | 8 Section name
  ulong  radd;     // | 4 runtime address
  ulong  vadd;     // | 4 virtual address (load address)
  ulong  size;     // | 4 section size
  ulong  fptr;     // 0 4 file pointer to raw data
  ulong  rent;     // 0 4 file pointer to relocation entries
  ulong  lent;     // 0 4 file pointer to line number entries
  ushort nrel;     // 0 2 number of relocation entries
  ushort nlin;     // 0 2 number of line number entries
  ushort flag;     //   2 flags
  uchar  resv;     //   1 reserved
  uchar  page;     //   1 memory page number
}SECT_HDR0;        //  40 bytes long

typedef struct {   // +-----------Value is zero if unitilized section
  char   name[8];  // | 8 Section name
  ulong  radd;     // | 4 runtime address
  ulong  vadd;     // | 4 virtual address (load address)
  ulong  size;     // | 4 section size
  ulong  fptr;     // 0 4 file pointer to raw data
  ulong  rent;     // 0 4 file pointer to relocation entries
  ulong  lent;     // 0 4 file pointer to line number entries
  ulong  nrel;     // 0 4 number of relocation entries
  ulong  nlin;     // 0 4 number of line number entries
  ulong  flag;     //   4 flags
  short  resv;     //   2 reserved
  ushort page;     //   2 memory page number
}SECT_HDR1;        // 48 bytes long

//-------------------------------------------------------------
//typedef struct {
//  long   sleng;    //
//  uint   sreln;    //
//  uint   sline;    //
//  char   garb[10]; // not used
//}AUX_STBL;
//==============================================================
//======== Auxiliary Header definitions by Symbol Class ========
//==============================================================
typedef struct {      // Use this to create a null of all fields
  char   x[18];       //
}A_XX;                //
typedef struct {      // File Name format
  char   fname[14];   // File name
  char   nused[ 4];   // Not used
}A_18;                //
//- - - - - -- - - - - - - - - - - - - - - - - - - - -
typedef struct {      // File Name format COFF version 5.xx
  char   nused[ 4];   // Not used
  char   fname[14];   // File name
}A_18b;               //
//- - - - - -- - - - - - - - - - - - - - - - - - - - -
typedef struct {      // Section format
  long   sleng;       // length of section to follow
  uint   Nreloc;      // number of relocation entries
  uint   Nlines;      // number of line entries
  char   nused[10];   //
}A_19;                //
//- - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef struct {      // Tag name format
  char   nuse1[6];    //
  uint   SzStrct;     //
  char   nuse2[4];    //
  long   NxtIndex;    //
  char   nuse3[2];    //
}A_20;                //
//- - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef struct {      // End of Structure
  long   TagIndex;    //
  char   nuse1[2];    //
  uint   SzStrct;     //
  char   nuse3[10];   //
}A_21;                //
//- - - - - -- - - - - - - - - - - - - - - - - - - - -
typedef struct {      // Function format
  long   TagIndex;    // TAG index
  long   fnsize;      // Function size in bits
  long   fptr  ;      // File pointer to line number
  long   index ;      // Index of next entry past this function
}A_22;                //
//- - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef struct {      // Array format
  long   TagIndex;    //
  uint   LineNum;     //
  uint   SzArray;     //
  uint   Dim1;        //
  uint   Dim2;        //
  uint   Dim3;        //
  uint   Dim4;        //
  char   nused[2];    //
}A_23;                //
//- - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef struct {      // End of blocks and functions
  char   nused1[4];   //
  uint   cline;       // C source line number
  char   nused2[12];  //
}A_24;                //
//- - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef struct {      // Beginning of blocks and functions
  char   nused1[4];   //
  uint   cline;       // C source line number
  char   nused2[6];   //
  long   NxtIndex;    // Index to next entry past this block
  char   nused3[2];   //
}A_25;                //
//- - - - - - - - - - - - - - - - - - - - - - - - - - -
typedef struct {      // Beginning of blocks and functions
  long   TagIndex;    //
  char   nused1[2];   //
  uint   SzStrct;     // Size of structure or array
  char   nused2[10];  //
}A_26;                //
//==============================================================

enum SC_CLASS
{
  SC_NULL   =   0,
  SC_AUTO   =   1,
  SC_EXT    =   2,
  SC_STAT   =   3,
  SC_REG    =   4,
  SC_EXTDEF =   5,
  SC_LABEL  =   6,
  SC_ULABEL =   7,
  SC_MOS    =   8,
  SC_ARG    =   9,
  SC_STRTAG =  10,
  SC_MOU    =  11,
  SC_UNTAG  =  12,
  SC_TPDEF  =  13,
  SC_USTATIC=  14,
  SC_ENTAG  =  15,
  SC_MOE    =  16,
  SC_REGPARM=  17,
  SC_FIELD  =  18,
  SC_UEXT   =  19,
  SC_STATLAB=  20,
  SC_EXTLAB =  21,
  SC_BLOCK  = 100,
  SC_FCN    = 101,
  SC_EOS    = 102,
  SC_FILE   = 103,
  SC_LINE   = 104
};
enum TYPES      // Basic types.  Lower 4 bits of stype
{
  T_NULL  =0,  // 0 Type not assigned
  T_SCHAR =1,  // 1
  T_CHAR  =2,  // 2 Char...
  T_SHORT   ,  // 3
  T_INT     ,  // 4
  T_LONG    ,  // 5
  T_FLOAT   ,  // 6
  T_DOUBLE  ,  // 7
  T_STRUCT  ,  // 8
  T_UNION   ,  // 9
  T_ENUM    ,  // 10
  T_MOE     ,  // 11 Member of enumeration
  T_UCHAR   ,  // 12
  T_USHORT  ,  // 13
  T_UINT    ,  // 14
  T_ULONG      // 15
};
enum D_TYPES  // Derived types.  Upper 4 bits of stype
{
  DT_NON=0,   // No derived type
  DT_PTR=1,   // Pointer
  DT_FCN=2,   // Function
  DT_ARY=3    // Array
};

typedef union
{
  struct
  {
    long DSP_addr; // DSP Physical address
    uint HLL_line; // Line number in HLL source
  }xref;
  struct
  {
    ulong sym_offs; // File pointer to a symbol entry
    uint  zero2   ; // 0
  }sptr;
}LINE_TBL;

#define HLL_limit 1024    /* Limit for line entries */
extern LINE_TBL huge HLL[];
extern int lastHLL;

#endif

