#ifndef __SYMBOLS
#define __SYMBOLS
//---------------------------------------------------------
// SYMBOLS.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
#include "dsk.h"
#include "errormsg.h"

/*
  Note: By using 'NUM_TYPE' and 'SYM_TYPE' as the enumerated type name,
  the actual storage of these elements in an XREF_TABLE structure become
  sizeof(int), increasing data storage.

  By defining NUM_TYPE and SYM_TYPE as char, the allocation is sizeof(char)

*/
typedef enum SYM_TYPE
{
  SYM_FOO=0   ,
  SYM_VAR     ,
  SYM_GLBL    , // Global label (global variable)
  SYM_LLBL    , // Local lable  (ie variable on stack)
  SYM_DEF
}SYMTYPES;

typedef enum NUM_TYPE
{
  NT_NOREF=0,
  NT_INTEGER,  // signed int
  NT_FLOAT  ,  // float
  NT_SLONG  ,  // Signed long Changed from LONG for windows support
  NT_ULONG  ,  // unsgnd long
  NT_QFORM  ,  // Q format (can be any Q)
  NT_BASE2  ,  // Base 2 binary display
//NT_BASE8  ,  // Octal (not supported)
  NT_AUTO      // Auto detect
}ETYPES;
/*
struct XREF_TABLE    // structure to hold pointer to
{ char     *sptr;       // symbol string and also value
  long     value;       //
  NUM_TYPE  numt;       // Storage type Nothing INTEGER  FLOAT  DEFINE
  SYM_TYPE  symt;       // Addressable  0=Variable  1=Label  2=Define
};
*/
struct XREF_TABLE    // structure to hold pointer to
{ char     *sptr;       // symbol string and also value
  long     value;       //
  char     numt;       // Storage type Nothing INTEGER  FLOAT  DEFINE
  char     symt;       // Addressable  0=Variable  1=Label  2=Define
};

#define MAX_SEGMENTS 32  /* 32 segments max for DSK3A */
struct segments
{
  long start;     // start of segment - Used to calculate length
  long offs;      // current address offset
  long length;
  char name[16];  // 16 character length for section names
};
extern int  sym_str_tbl_sz; // allow apx 10 chars per symbol
extern int  MAX_SYMBOLS;    // Max alloced size of SYM table
extern int  current_seg;
extern int  post_boot_sym;  // Symbol pointer value at end of boot
extern int  last_ref;
extern int  last_segment;
extern char *post_boot_symbols;
extern char *symbol_ptr;
//extern char symbols[];               // large array of symbol strings
extern char *symbols;                  // large array of symbol strings
//extern DLLEXTEND_EX XREF_TABLE *SYM; // _Windows
extern XREF_TABLE *SYM;                // Compiles, but is not exported
extern XREF_TABLE SYM_START[];
extern segments SEG[];

int symb_defined(char *ptr);
char *argstart(char *ptr);
char *argend(char *ptr,char field);

NUM_TYPE  DLLEXTEND_EX SymbolNumType(int offs);
SYM_TYPE  DLLEXTEND_EX SymbolType(int offs);
NUM_TYPE  DLLEXTEND_EX ref_value(char *ptr, long *value);
int       DLLEXTEND_EX get_label(char *label,ulong addr, int lws);
int       DLLEXTEND_EX ref_offs  (char *ptr);
MSGS                   xref_add(char *ptr, ulong val, NUM_TYPE, SYM_TYPE);
MSGS                   ref_mod(char *ptr, ulong val);
MSGS                   xref_mod2(char *ptr, ulong val, NUM_TYPE, SYM_TYPE);
MSGS                   Create_SYM(void); // Create the symbol table SYM
void                   remove_defines(void);
void                   tabstrip(char *buf,int N);
#endif
