#ifndef __TEXTWIN
#define __TEXTWIN
//------------------------------------------------------------
// TEXTWIN.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
#include "errormsg.h"
#include "typedefs.h"
/*-------------------------------------------------------*/
/* Structure and union typedefs and enumerations         */
/*-------------------------------------------------------*/
typedef struct
{
  int   x,y,w,h;
  char *title;
  int   tattr;
  char *frame;
  int   fattr;
  char *buf;
}WINDOW;
/*------------------------------------------------*/
/* Function prototypes                            */
/*------------------------------------------------*/
/*
MSGS Help_Menu(char *banner, char huge *msg,
               int Xstart,int Xwidth, int Ystart, int Ywidth);

WINDOW *CreateWindow (int x, int y, int w, int h,
  		      char *title, char *frame,int tattr, int fattr);

MSGS    Disp_Menu    (char *banner,char huge *msg,
                      int Xstart,int Xwidth, int Ystart, int Ywidth);

int   EraseWindow      (WINDOW *win);
int   ports            (int base);
//int   strexact         (char *p1,char *p2);
MSGS  View_Manual      (char *app_name);
*/
MSGS  Help_Help        (void);  // DSK3DHLP.H ??
MSGS  Edit_Help        (void);
MSGS  About_Help       (void);
MSGS  Dasm_Help        (void);
MSGS  Mem_Help         (void);
MSGS  CPU_Help         (void);
/*
MSGS  Scan_Command_line(char *app_name);
MSGS  View_Manual      (char *app_name);
MSGS  Ext_Help         (MSGS err);
void  InitVideo        (void);
void  OpenWindow       (WINDOW *win);
void  CloseWindow      (WINDOW *win);
void  Pulse_Init       (void);
void  Edit_Help_Msg    (char *app_name, char *sw1, char *desc);
void  putcharxy        (int x,int y,char car);
*/
//*****************************************************
extern int       screenmode ;
extern float     DSK3_rev   ;
extern uint      port       ;
extern char      LO_PWR     ;
extern int       WINDOWS    ;
//extern int       BW_force   ;
//extern int       No_MTask   ;
extern int       timeout    ;
extern int       test_flag  ;
extern char huge   Cmd_Hlp[];
extern char huge  Hard_Hlp[];
extern char huge   Mem_Hlp[];
extern char       Exit_Hlp[];
extern char huge   CPU_Hlp[];
extern char huge  Dasm_Hlp[];
extern char huge About_Hlp[];
extern char          St_Sw[];
//---------------------------------------------------------------
typedef struct { char car; char attr; } TEXTEL;
typedef TEXTEL SCREEN[50][80]; /* screen: 50 lines & 80 columns */
typedef enum
{
  OLD, CAR, FOND, CARFOND, OLDCAR,
} PUT_MODES;
//---------------------------------------------------------------
//SCREEN   *PtrScreen;
//#define  Screen (*PtrScreen)
//extern int    screenmode =   C80;  // default debugger screen text mode
//extern int oldscreenmode =   C80;  // startup text mode
void Edit_Help_Msg(char *app_name, char *sw1, char *desc);
MSGS View_Manual(char *app_name);
void putcharxy(int x,int y,char car);
MSGS Disp_Menu(char *banner,char huge *msg,
               int Xstart,int Xwidth, int Ystart, int Ywidth);
MSGS Help_Menu(char *banner, char huge *msg,
               int Xstart,int Xwidth, int Ystart, int Ywidth);
MSGS Ext_Help(MSGS err);
void InitVideo(void);
void PutnChar(int x, int y, int n, char car, char Attr,int mode);
void PutString(int x, int y, int n, char *string, char Attr, int mode);
void ClrWin(WINDOW *win);
void WinTitle( char *p1, int x, int y );
void WinFrame(WINDOW *win);
int EraseWindow( WINDOW *win );
WINDOW *DSKCreateWindow( int x, int y, int w, int h, char *title,
                         char *frame, int tattr, int fattr);
void OpenWindow( WINDOW *win );
void CloseWindow( WINDOW *win );
void EnableWindow( WINDOW *win );
void DisableWindow( WINDOW *win );
WINDOW *GrowWindow(int x, int y, int w, int h, WINDOW *win);
#endif
