//---------------------------------------------------------
// TXT2SRC.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// NOTES: Use this program to convert ascii help files to formatted
//        C string statements.  Then, you can change the default char
//        pointer definitions.
//
//        TABS are NOT stripped in this version
//        Trailing white space characters are appended
//
// This program converts normal text files into properly formatted
// run-on C string statements.  That is, it reads each line, and then
// writes it back out with a prepended ", and a post \r\n" before
// going to the next line.  The \r and \n are individualy enabled
// using an R or N in the command line arguments.
//
// USE:   TXT2SRC INFILE.EXT [R] [N]
//
//        Output file is INFILE.CPP
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//
// TXT2SRC is the only file used to build this application
//---------------------------------------------------------
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int  CRETURN_flag  = 0;
int  NEWLINE_flag = 0;
char InFileName[80];
//----------------------------------------------------------
// Usage help screen
//----------------------------------------------------------
void usage(void)
{
  printf("Use: TXT2SRC FILENAME.TXT  [R][N]\n"
         "     R appends \\r to each line (carriage return)\n"
         "     N appends \\n to each line (newline)\n"
          );
  exit(0);
}
//-----------------------------------------------------------
// Scan_Command_Line() looks for command line arguments
//-----------------------------------------------------------
void Scan_Command_line(void)
{
  char *p;
  char MSG[80];
  if(_argc < 2) usage();
  for(int i=2; i<_argc;i++)
  {
    p = _argv[i];
    if(*p=='-' ) p++;  // Ignore '-' if it preceeds an argument
    if(*p=='/' ) p++;  // Ignore '/'
    if(*p=='\\') p++;  // Ignore '\'
    strcpy(MSG,p);
    strupr(MSG);
    if(strstr(MSG,"R")) CRETURN_flag = 1;
    if(strstr(MSG,"N")) NEWLINE_flag = 1;
    if(strstr(MSG,"?")) usage();
    if(strstr(MSG,"H")) usage();
  }
}
//-----------------------------------------------------------
// main program
//-----------------------------------------------------------
int main (void)
{
  #define Bufsize 256
  FILE *in;
  FILE *out;
  int x;
  int line = 0;         // Count the lines converted
  char *p;              // A dummy pointer used for testing
  char buf[Bufsize];    // Line buffer
  char InFile[80];
  char OutFile[80];
  clrscr();
  Scan_Command_line();
  strcpy(InFile,_argv[1]);
 /*---------------------------------------------*/
  if((in = fopen(InFile,"rb"))== NULL)
  {
    printf("FATAL: Cannot open input file -> %s\n",InFile);
    exit(0);
  }
  strcpy(OutFile,InFile);
  strupr(OutFile);
  if((p=strstr(OutFile,"."))!=NULL)  strcpy(p      ,".CPP");
  else                               strcat(OutFile,".CPP");

  if((out = fopen(OutFile,"wb"))== NULL)
  {
    printf("FATAL: Cannot open output file -> %s\n",OutFile);
    exit(0);
  }
  fputs("/************************************************/\r\n",out);
  fputs("/* TXT2SRC auto generated file                  */\r\n",out);
  fputs("/************************************************/\r\n",out);
  /*---------------------------------------------*/
  for(x=0;x<2000;x++)        /* 2000 line maximum */
  {
    p = fgets(buf+1,Bufsize-8,in); /* Get the string to convert     */
    if(p==NULL) break;             /* Exit if EOF                   */
    buf[0] = '\"';                 /* Prepend the " string operator */
    p = buf;                       /* roll back text terminators    */
    while(*p) p++;
    while((*p==0)||(*p=='\r')||(*p=='\n'))
      *p--=0;
    /* Append the specified \r\n" line termination   */
    if(CRETURN_flag) strcat(buf,"\\r");
    if(NEWLINE_flag) strcat(buf,"\\n");
    strcat(buf,"\"\r\n");

    fputs(buf,out);
    if(p==NULL) break;
    line++;
  }
  fputs(";\r\n",out);
  printf("%d lines converted\n",line);
  return(0); /* No Error */
}

