//------------------------------------------------------------
// MATHERR.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
#include <conio.h>
#include <math.h>
#include <signal.h>
#include "dsk.h"
#if     __DSKWINAPP
#else
#include "screen.h"  // Included if compiled for DSK3D
#endif
#include "assm_fun.h"
//---------------------------------------------------------------------
// A signal catcher has been implimented for division by zero and other
// errors.  The BC++ documentation is vague on exactly how a return
// from an error handler should be performed.  No adjustment is made of
// the value before returning.
//---------------------------------------------------------------------
#ifdef __cplusplus
   typedef void (*fptr)(int);
#else
   typedef void (*fptr)();
#endif
void Catcher(void)
{
  #if     __DSKWINAPP
  #else
  if(DSK3D)
    Cmd_Msg("Floating Point Error!",ERR_ATTR,1,1);
  #endif
//else
//  post_global_DSK_error(FP_ERR);
//-----------------------------------------------------------------
// re-installing the FP error catcher seems to be required each
// time the error occurs.  The reason is not clear.  Normaly the
// catcher should be installed at the beginning of the expression
// analyzer, main etc.. and forgotten.  However it appears to
// deinstall in some test code... Hence the re-install.
//-----------------------------------------------------------------
  signal(SIGFPE, (fptr)Catcher);
}

//---------------------------------------------------------------------
// Redefinition of the matherr function (IE functions that are called)
// keeps the assembler from aborting without any message other than
// the standard matherr exit provided by the parent compiler
//---------------------------------------------------------------------
#if _WIN32
#define Exception   _exception  // MSVC syntax
#define Exceptionl  _exception  // MSVC syntax
#else
#define Exception    exception   // Borland syntax
#define Exceptionl  _exceptionl  // Borland syntax
#endif

int matherr (struct Exception *a)
{
  if(DSK3D==0)
  {
    assm_error_msg(math_err,""); // math errors do not crash the assembler
    fprintf(dsk_file,">>>> Function generating error => %s\n>>>>\n",a->name);
    printf(">>>> Function generating error => %s\n>>>>\n",a->name);
  }
  a->retval = 0.0;
  return 1;              //
}

int _matherrl (struct Exceptionl *a)
{
  if(DSK3D==0)
  {
    assm_error_msg(math_err,""); // math errors do not crash the assembler
    fprintf(dsk_file,">>>> Function generating error => %s\n>>>>\n",a->name);
    printf(">>>> Function generating error => %s\n>>>>\n",a->name);
  }
  a->retval = 0.0;
  return 1;              //
}
