//------------------------------------------------------------
// OPCODES2.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
#include "opcodes.h"
INSTR_TABLE Instr[] =
{
//***********************************************
//          C3x/C4x INSTRUCTIONS
//***********************************************
//  Special cases for float arguments
//  ABSF  ADDF  CMPF   FLOAT  LDE  LDF   LDFI
//  LDM   MPYF  NEGF   RND    SUBF SUBRF
//
{__ABSF       ,"ABSF"          ,0xFF800000L,0x00000000L,AForm0,DForm0,S_absf },
{__ADDF       ,"ADDF"          ,0xFF800000L,0x01800000L,AForm0,DForm0,S_addf },
{__CMPF       ,"CMPF"          ,0xFF800000L,0x04000000L,AForm0,DForm0,S_cmpf },
{__FLOAT      ,"FLOAT"         ,0xFF800000L,0x05800000L,AForm0,DForm0,S_float},
{__LDE        ,"LDE"           ,0xFF800000L,0x06800000L,AForm0,DForm0,S_lde  },
{__LDF        ,"LDF"           ,0xFF800000L,0x07000000L,AForm0,DForm0,S_ldf  },
{__LDFI       ,"LDFI"          ,0xFF800000L,0x07800000L,AForm0,DForm0,S_ldfi },
{__LDM        ,"LDM"           ,0xFF800000L,0x09000000L,AForm0,DForm0,S_ldm  },
{__MPYF       ,"MPYF"          ,0xFF800000L,0x0A000000L,AForm0,DForm0,S_mpyf },
{__NEGF       ,"NEGF"          ,0xFF800000L,0x0B800000L,AForm0,DForm0,S_negf },
{__POPF       ,"POPF"          ,0xFFE0FFFFL,0x0EA00000L,AForm0,DForm0,S_popf },
{__PUSHF      ,"PUSHF"         ,0xFFE0FFFFL,0x0FA00000L,AForm0,DForm0,S_pushf},
{__RND        ,"RND"           ,0xFF800000L,0x11000000L,AForm0,DForm0,S_rnd  },
{__SUBF       ,"SUBF"          ,0xFF800000L,0x17800000L,AForm0,DForm0,S_subf },
{__SUBRF      ,"SUBRF"         ,0xFF800000L,0x19000000L,AForm0,DForm0,S_subrf},
{__NORM       ,"NORM"          ,0xFF800000L,0x0D000000L,AForm0,DForm0,S_norm },

{__ABSI       ,"ABSI"          ,0xFF800000L,0x00800000L,AForm1,DForm1,S_absi },
{__ADDC       ,"ADDC"          ,0xFF800000L,0x01000000L,AForm1,DForm1,S_addc },
{__ADDI       ,"ADDI"          ,0xFF800000L,0x02000000L,AForm1,DForm1,S_addi },
{__AND        ,"AND"           ,0xFF800000L,0x02800000L,AForm1,DForm1,S_and  },
{__ANDN       ,"ANDN"          ,0xFF800000L,0x03000000L,AForm1,DForm1,S_andn },
{__ASH        ,"ASH"           ,0xFF800000L,0x03800000L,AForm1,DForm1,S_ash  },
{__CMPI       ,"CMPI"          ,0xFF800000L,0x04800000L,AForm1,DForm1,S_cmpi },
{__FIX        ,"FIX"           ,0xFF800000L,0x05000000L,AForm0,DForm0,S_fix  },
//{__LDP      ,"LDP"           ,0xFFFF0000L,0x50700000L,AForm1,DForm1,S_ldp  },//C4x
{__LDP        ,"LDP"           ,0xFFFFFF00L,0x08700000L,AForm1,DForm1,S_ldp  },//C3x
{__LDI        ,"LDI"           ,0xFF800000L,0x08000000L,AForm1,DForm1,S_ldi  },
{__LDII       ,"LDII"          ,0xFF800000L,0x08800000L,AForm1,DForm1,S_ldii },
{__LSH        ,"LSH"           ,0xFF800000L,0x09800000L,AForm1,DForm1,S_lsh  },
{__MPYI       ,"MPYI"          ,0xFF800000L,0x0A800000L,AForm1,DForm1,S_mpyi },
{__NEGB       ,"NEGB"          ,0xFF800000L,0x0B000000L,AForm1,DForm1,S_negb },
{__NEGI       ,"NEGI"          ,0xFF800000L,0x0C000000L,AForm1,DForm1,S_negi },
{__NOP        ,"NOP"           ,0xFF9F0000L,0x0C800000L,AForm1,DForm1,S_nop  },
{__NOT        ,"NOT"           ,0xFF800000L,0x0D800000L,AForm1,DForm1,S_not  },
{__POP        ,"POP"           ,0xFFE0FFFFL,0x0E200000L,AForm1,DForm1,S_pop  },
{__PUSH       ,"PUSH"          ,0xFFE0FFFFL,0x0F200000L,AForm1,DForm1,S_push },
{__OR         ,"OR"            ,0xFF800000L,0x10000000L,AForm1,DForm1,S_or   },
{__ROL        ,"ROL"           ,0xFFE0FFFFL,0x11E00001L,AForm1,DForm1,S_rol  },
{__ROLC       ,"ROLC"          ,0xFFE0FFFFL,0x12600001L,AForm1,DForm1,S_rolc },
{__ROR        ,"ROR"           ,0xFFE0FFFFL,0x12E0FFFFL,AForm1,DForm1,S_ror  },
{__RORC       ,"RORC"          ,0xFFE0FFFFL,0x1360FFFFL,AForm1,DForm1,S_rorc },
{__RPTS       ,"RPTS"          ,0xFF9F0000L,0x139B0000L,AForm1,DForm1,S_rpts },
{__STF        ,"STF"           ,0xFF800000L,0x14000000L,AForm1,DForm1,S_stf  },
{__STFI       ,"STFI"          ,0xFF800000L,0x14800000L,AForm1,DForm1,S_stfi },

{__STIK       ,"STIK"          ,0xFFE00000L,0x15000000L,AForm1,DForm1,S_sti  },
{__STI        ,"STI"           ,0xFFE00000L,0x15200000L,AForm1,DForm1,S_sti  },
{__STI        ,"STI"           ,0xFFE00000L,0x15400000L,AForm1,DForm1,S_sti  },
{__STIK       ,"STIK"          ,0xFFE00000L,0x15600000L,AForm1,DForm1,S_sti  },

//{__STI      ,"STI"           ,0xFFE00000L,0x15200000L,AForm1,DForm1,S_sti  },
//{__STI      ,"STI"           ,0xFFE00000L,0x15400000L,AForm1,DForm1,S_sti  },
{__STII       ,"STII"          ,0xFF800000L,0x15800000L,AForm1,DForm1,S_stii },
{__SUBB       ,"SUBB"          ,0xFF800000L,0x16800000L,AForm1,DForm1,S_subb },
{__SUBC       ,"SUBC"          ,0xFF800000L,0x17000000L,AForm1,DForm1,S_subc },
{__SUBI       ,"SUBI"          ,0xFF800000L,0x18000000L,AForm1,DForm1,S_subi },
{__SUBRB      ,"SUBRB"         ,0xFF800000L,0x18800000L,AForm1,DForm1,S_subrb},
{__SUBRI      ,"SUBRI"         ,0xFF800000L,0x19800000L,AForm1,DForm1,S_subri},
{__TSTB       ,"TSTB"          ,0xFF800000L,0x1A000000L,AForm1,DForm1,S_tstb },
{__XOR        ,"XOR"           ,0xFF800000L,0x1A800000L,AForm1,DForm1,S_xor  },
{__IACK       ,"IACK"          ,0xFF9F0000L,0x1B000000L,AForm1,DForm1,S_iack },

{__MPYF3_ADDF3,"MPYF3 || ADDF3",0xFC000000L,0x80000000L,AForm3,DForm3,S_mpyf3_addf3},
{__MPYF3_SUBF3,"MPYF3 || SUBF3",0xFC000000L,0x84000000L,AForm3,DForm3,S_mpyf3_subf3},
{__MPYI3_ADDI3,"MPYI3 || ADDI3",0xFC000000L,0x88000000L,AForm3,DForm3,S_mpyi3_addi3},
{__MPYI3_SUBI3,"MPYI3 || SUBI3",0xFC000000L,0x8C000000L,AForm3,DForm3,S_mpyi3_subi3},
 {__MPYF3_ADDF3, "MPYF || ADDF" ,0xFC000000L,0x80000000L,AForm3,DForm3,S_mpyf3_addf3},
 {__MPYF3_SUBF3, "MPYF || SUBF" ,0xFC000000L,0x84000000L,AForm3,DForm3,S_mpyf3_subf3},
 {__MPYI3_ADDI3, "MPYI || ADDI" ,0xFC000000L,0x88000000L,AForm3,DForm3,S_mpyi3_addi3},
 {__MPYI3_SUBI3, "MPYI || SUBI" ,0xFC000000L,0x8C000000L,AForm3,DForm3,S_mpyi3_subi3},

{__STF_STF    ,"STF || STF"    ,0xFE380000L,0xC0000000L,AForm4,DForm4,S_stf_stf   },
{__STI_STI    ,"STI || STI"    ,0xFE380000L,0xC2000000L,AForm4,DForm4,S_sti_sti   },
{__LDF_LDF    ,"LDF || LDF"    ,0xFE070000L,0xC4000000L,AForm4,DForm4,S_ldf_ldf   },
{__LDI_LDI    ,"LDI || LDI"    ,0xFE070000L,0xC6000000L,AForm4,DForm4,S_ldi_ldi   },
{__ABSF_STF   ,"ABSF || STF"   ,0xFE380000L,0xC8000000L,AForm4,DForm4,S_absf_stf  },
{__ABSI_STI   ,"ABSI || STI"   ,0xFE380000L,0xCA000000L,AForm4,DForm4,S_absi_sti  },

{__ADDF3_STF  ,"ADDF3 || STF"  ,0xFE000000L,0xCC000000L,AForm4,DForm4,S_addf3_stf },
{__ADDI3_STI  ,"ADDI3 || STI"  ,0xFE000000L,0xCE000000L,AForm4,DForm4,S_addi3_sti },
{__AND3_STI   , "AND3 || STI"  ,0xFE000000L,0xD0000000L,AForm4,DForm4,S_and3_sti  },
{__ASH3_STI   , "ASH3 || STI"  ,0xFE000000L,0xD2000000L,AForm4,DForm4,S_ash3_sti  },
 {__ADDF3_STF  , "ADDF || STF"  ,0xFE000000L,0xCC000000L,AForm4,DForm4,S_addf3_stf },
 {__ADDI3_STI  , "ADDI || STI"  ,0xFE000000L,0xCE000000L,AForm4,DForm4,S_addi3_sti },
 {__AND3_STI   ,  "AND || STI"  ,0xFE000000L,0xD0000000L,AForm4,DForm4,S_and3_sti  },
 {__ASH3_STI   ,  "ASH || STI"  ,0xFE000000L,0xD2000000L,AForm4,DForm4,S_ash3_sti  },

{__FIX_STI    ,"FIX || STI"    ,0xFE380000L,0xD4000000L,AForm4,DForm4,S_fix_sti   },
{__FLOAT_STF  ,"FLOAT || STF"  ,0xFE380000L,0xD6000000L,AForm4,DForm4,S_float_stf },
{__LDF_STF    ,"LDF || STF"    ,0xFE380000L,0xD8000000L,AForm4,DForm4,S_ldf_stf   },
{__LDI_STI    ,"LDI || STI"    ,0xFE380000L,0xDA000000L,AForm4,DForm4,S_ldi_sti   },
{__LSH3_STI   ,"LSH3 || STI"   ,0xFE000000L,0xDC000000L,AForm4,DForm4,S_lsh3_sti  },

{__MPYF3_STF  ,"MPYF3 || STF"  ,0xFE000000L,0xDE000000L,AForm4,DForm4,S_mpyf3_stf },
{__MPYI3_STI  ,"MPYI3 || STI"  ,0xFE000000L,0xE0000000L,AForm4,DForm4,S_mpyi3_sti },
 {__MPYF3_STF  , "MPYF || STF"  ,0xFE000000L,0xDE000000L,AForm4,DForm4,S_mpyf3_stf },
 {__MPYI3_STI  , "MPYI || STI"  ,0xFE000000L,0xE0000000L,AForm4,DForm4,S_mpyi3_sti },

{__NEGF_STF   ,"NEGF || STF"   ,0xFE380000L,0xE2000000L,AForm4,DForm4,S_negf_stf  },
{__NEGI_STI   ,"NEGI || STI"   ,0xFE380000L,0xE4000000L,AForm4,DForm4,S_negi_sti  },
{__NOT_STI    ,"NOT || STI"    ,0xFE380000L,0xE6000000L,AForm4,DForm4,S_not_sti   },
{__OR3_STI    ,"OR3 || STI"    ,0xFE000000L,0xE8000000L,AForm4,DForm4,S_or3_sti   },
{__SUBF3_STF  ,"SUBF3 || STF"  ,0xFE000000L,0xEA000000L,AForm4,DForm4,S_subf3_stf },
{__SUBI3_STI  ,"SUBI3 || STI"  ,0xFE000000L,0xEC000000L,AForm4,DForm4,S_subi3_sti },
 {__SUBF3_STF  , "SUBF || STF"  ,0xFE000000L,0xEA000000L,AForm4,DForm4,S_subf3_stf },
 {__SUBI3_STI  , "SUBI || STI"  ,0xFE000000L,0xEC000000L,AForm4,DForm4,S_subi3_sti },

{__XOR3_STI   ,"XOR3 || STI"   ,0xFE000000L,0xEE000000L,AForm4,DForm4,S_xor3_sti  },
 {__XOR3_STI   , "XOR || STI"   ,0xFE000000L,0xEE000000L,AForm4,DForm4,S_xor3_sti  },
//{FRIEEE_STF ,"FRIEEE || STF" ,0xFE380000L,0xF2000000L,AForm4,DForm4,S_frieee_stf},
//{TOIEEE_STF ,"TOIEEE || STF" ,0xFE380000L,0xF0000000L,AForm4,DForm4,S_toieee_stf},
/*                TYPE 1 (FORM6 & FORM6B) ARE TMS320C3x/4x  */
{__ADDC3      ,"ADDC3"         ,0xFF800000L,0x20000000L,AForm5,DForm5,S_addc3     },
{__ADDI3      ,"ADDI3"         ,0xFF800000L,0x21000000L,AForm5,DForm5,S_addi3     },
{__AND3       ,"AND3"          ,0xFF800000L,0x21800000L,AForm5,DForm5,S_and3      },
{__ANDN3      ,"ANDN3"         ,0xFF800000L,0x22000000L,AForm5,DForm5,S_andn3     },
{__ASH3       ,"ASH3"          ,0xFF800000L,0x22800000L,AForm5,DForm5,S_ash3      },
{__CMPI3      ,"CMPI3"         ,0xFF9F0000L,0x23800000L,AForm5,DForm5,S_cmpi3     },
{__LSH3       ,"LSH3"          ,0xFF800000L,0x24000000L,AForm5,DForm5,S_lsh3      },
{__MPYI3      ,"MPYI3"         ,0xFF800000L,0x25000000L,AForm5,DForm5,S_mpyi3     },
{__OR3        ,"OR3"           ,0xFF800000L,0x25800000L,AForm5,DForm5,S_or3       },
{__SUBB3      ,"SUBB3"         ,0xFF800000L,0x26000000L,AForm5,DForm5,S_subb3     },
{__SUBI3      ,"SUBI3"         ,0xFF800000L,0x27000000L,AForm5,DForm5,S_subi3     },
{__TSTB3      ,"TSTB3"         ,0xFF9F0000L,0x27800000L,AForm5,DForm5,S_tstb3     },
{__XOR3       ,"XOR3"          ,0xFF800000L,0x28000000L,AForm5,DForm5,S_xor3      },
//{__MPYSHI3  ,"MPYSHI3"       ,0xFF800000L,0x28800000L,AForm5,DForm5,S_mpyshi3   },
//{__MPYUHI3  ,"MPYUHI3"       ,0xFF800000L,0x29000000L,AForm5,DForm5,S_mpyuhi3   },
{__ADDF3      ,"ADDF3"         ,0xFF800000L,0x20800000L,AForm5,DForm5b,S_addf3    },
{__CMPF3      ,"CMPF3"         ,0xFF9F0000L,0x23000000L,AForm5,DForm5b,S_cmpf3    },
{__MPYF3      ,"MPYF3"         ,0xFF800000L,0x24800000L,AForm5,DForm5b,S_mpyf3    },
{__SUBF3      ,"SUBF3"         ,0xFF800000L,0x26800000L,AForm5,DForm5b,S_subf3    },

{__SIGI       ,"SIGI"          ,0xFFFFFFFFL,0x16000000L,AFormA,DFormA,S_sigi      },
{__IDLE       ,"IDLE"          ,0xFFFFFFFFL,0x06000000L,AFormA,DFormA,S_idle      },
{__IDLE2      ,"IDLE2"         ,0xFFFFFFFFL,0x06000001L,AFormA,DFormA,S_idle2     },
{__LOPOWER    ,"LOPOWER"       ,0xFFFFFFFFL,0x10800001L,AFormA,DFormA,S_lopower   },
{__MAXSPEED   ,"MAXSPEED"      ,0xFFFFFFFFL,0x10800000L,AFormA,DFormA,S_maxspeed  },
{__SWI        ,"SWI"           ,0xFFFFFFFFL,0x66000000L,AFormA,DFormA,S_swi       },
//
//  Below are the 10 conditional opcodes supported by the C3x
//
//{__LDF_B    ,"LDF"           ,0xF0000000L,0x40000000L,AForm2,DForm2,S_ldf_B     },
//{__LDI_B    ,"LDI"           ,0xF0000000L,0x50000000L,AForm2,DForm2,S_ldi_B     },
//
//{__TRAP     ,"TRAP"          ,0xFFE0FE00L,0x74000000L,AForm9,DForm9,S_trap      },//C4x TRAP
{__TRAP       ,"TRAP"          ,0xFFFFFFE0L,0x74000020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPU"         ,0xFFFFFFE0L,0x74000020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPLO"        ,0xFFFFFFE0L,0x74010020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPC"         ,0xFFFFFFE0L,0x74010020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPLS"        ,0xFFFFFFE0L,0x74020020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPHI"        ,0xFFFFFFE0L,0x74030020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPHS"        ,0xFFFFFFE0L,0x74040020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNC"        ,0xFFFFFFE0L,0x74040020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPEQ"        ,0xFFFFFFE0L,0x74050020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPZ"         ,0xFFFFFFE0L,0x74050020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNE"        ,0xFFFFFFE0L,0x74060020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNZ"        ,0xFFFFFFE0L,0x74060020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPLT"        ,0xFFFFFFE0L,0x74070020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPN"         ,0xFFFFFFE0L,0x74070020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPLE"        ,0xFFFFFFE0L,0x74080020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPGT"        ,0xFFFFFFE0L,0x74090020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPP"         ,0xFFFFFFE0L,0x74090020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPGE"        ,0xFFFFFFE0L,0x740A0020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNN"        ,0xFFFFFFE0L,0x740A0020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNV"        ,0xFFFFFFE0L,0x740C0020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPV"         ,0xFFFFFFE0L,0x740D0020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNUF"       ,0xFFFFFFE0L,0x740E0020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPUF"        ,0xFFFFFFE0L,0x740F0020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNLV"       ,0xFFFFFFE0L,0x74100020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPLV"        ,0xFFFFFFE0L,0x74110020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPNLUF"      ,0xFFFFFFE0L,0x74120020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPLUF"       ,0xFFFFFFE0L,0x74130020L,AForm9,DForm9,S_trap      },
{__TRAP       ,"TRAPZUF"       ,0xFFFFFFE0L,0x74140020L,AForm9,DForm9,S_trap      },
//
{__TRAP4x     ,"TRAP4x"        ,0xFFFFFE00L,0x74000000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xU"       ,0xFFFFFE00L,0x74000000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xLO"      ,0xFFFFFE00L,0x74010000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xC"       ,0xFFFFFE00L,0x74010000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xLS"      ,0xFFFFFE00L,0x74020000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xHI"      ,0xFFFFFE00L,0x74030000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xHS"      ,0xFFFFFE00L,0x74040000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNC"      ,0xFFFFFE00L,0x74040000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xEQ"      ,0xFFFFFE00L,0x74050000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xZ"       ,0xFFFFFE00L,0x74050000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNE"      ,0xFFFFFE00L,0x74060000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNZ"      ,0xFFFFFE00L,0x74060000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xLT"      ,0xFFFFFE00L,0x74070000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xN"       ,0xFFFFFE00L,0x74070000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xLE"      ,0xFFFFFE00L,0x74080000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xGT"      ,0xFFFFFE00L,0x74090000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xP"       ,0xFFFFFE00L,0x74090000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xGE"      ,0xFFFFFE00L,0x740A0000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNN"      ,0xFFFFFE00L,0x740A0000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNV"      ,0xFFFFFE00L,0x740C0000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xV"       ,0xFFFFFE00L,0x740D0000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNUF"     ,0xFFFFFE00L,0x740E0000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xUF"      ,0xFFFFFE00L,0x740F0000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNLV"     ,0xFFFFFE00L,0x74100000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xLV"      ,0xFFFFFE00L,0x74110000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xNLUF"    ,0xFFFFFE00L,0x74120000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xLUF"     ,0xFFFFFE00L,0x74130000L,AForm9,DForm9,S_trap4x    },
{__TRAP4x     ,"TRAP4xZUF"     ,0xFFFFFE00L,0x74140000L,AForm9,DForm9,S_trap4x    },
//
{__LDFc       ,"LDFU"          ,0xFF800000L,0x40000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFLO"         ,0xFF800000L,0x40800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFC"          ,0xFF800000L,0x40800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFLS"         ,0xFF800000L,0x41000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFHI"         ,0xFF800000L,0x41800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFHS"         ,0xFF800000L,0x42000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNC"         ,0xFF800000L,0x42000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFEQ"         ,0xFF800000L,0x42800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFZ"          ,0xFF800000L,0x42800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNE"         ,0xFF800000L,0x43000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNZ"         ,0xFF800000L,0x43000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFLT"         ,0xFF800000L,0x43800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFN"          ,0xFF800000L,0x43800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFLE"         ,0xFF800000L,0x44000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFGT"         ,0xFF800000L,0x44800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFP"          ,0xFF800000L,0x44800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFGE"         ,0xFF800000L,0x45000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNN"         ,0xFF800000L,0x45000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNV"         ,0xFF800000L,0x46000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFV"          ,0xFF800000L,0x46800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNUF"        ,0xFF800000L,0x47000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFUF"         ,0xFF800000L,0x47800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNLV"        ,0xFF800000L,0x48000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFLV"         ,0xFF800000L,0x48800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFNLUF"       ,0xFF800000L,0x49000000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFLUF"        ,0xFF800000L,0x49800000L,AForm0,DForm0,S_ldfc      },
{__LDFc       ,"LDFZUF"        ,0xFF800000L,0x4A000000L,AForm0,DForm0,S_ldfc      },
//                                                                    /
{__LDIc       ,"LDIU"          ,0xFF800000L,0x50000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDILO"         ,0xFF800000L,0x50800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIC"          ,0xFF800000L,0x50800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDILS"         ,0xFF800000L,0x51000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIHI"         ,0xFF800000L,0x51800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIHS"         ,0xFF800000L,0x52000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINC"         ,0xFF800000L,0x52000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIEQ"         ,0xFF800000L,0x52800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIZ"          ,0xFF800000L,0x52800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINE"         ,0xFF800000L,0x53000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINZ"         ,0xFF800000L,0x53000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDILT"         ,0xFF800000L,0x53800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIN"          ,0xFF800000L,0x53800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDILE"         ,0xFF800000L,0x54000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIGT"         ,0xFF800000L,0x54800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIP"          ,0xFF800000L,0x54800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIGE"         ,0xFF800000L,0x55000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINN"         ,0xFF800000L,0x55000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINV"         ,0xFF800000L,0x56000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIV"          ,0xFF800000L,0x56800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINUF"        ,0xFF800000L,0x57000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIUF"         ,0xFF800000L,0x57800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINLV"        ,0xFF800000L,0x58000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDILV"         ,0xFF800000L,0x58800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDINLUF"       ,0xFF800000L,0x59000000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDILUF"        ,0xFF800000L,0x59800000L,AForm1,DForm1,S_ldic      },
{__LDIc       ,"LDIZUF"        ,0xFF800000L,0x5A000000L,AForm1,DForm1,S_ldic      },
//{__B_A      ,"B"             ,0xFDE00000L,0x68000000L,AForm7,DForm7,S_B_A     },
//{__B_B      ,"B"             ,0xFDE00000L,0x68200000L,AForm7,DForm7,S_B_B     },
//{__DB_A     ,"DB"            ,0xFC200000L,0x6C000000L,AForm7,DForm7,S_DB_A    },
//{__CALL_A   ,"CALL"          ,0xFDE00000L,0x70000000L,AForm7,DForm7,S_CALL_A  },
//{__DB_B     ,"DB"            ,0xFC200000L,0x6C200000L,AForm7,DForm7,S_DB_B    },
//{__RETIc    ,"RETI"          ,0xFFE0FFFFL,0x78200000L,AForm7,DForm7,S_RETIc   },
{__CALL       ,"CALL"          ,0xFF000000L,0x62000000L,AFormB,DFormB,S_call      },
{__RPTB       ,"RPTB"          ,0xFF000000L,0x64000000L,AFormB,DFormB,S_rptb      },
//
// RETS conditinal
//{__RETS     ,"RETS"          ,0xFFE0FFFFL,0x78800000L,AForm8,DForm8,S_RETS    },
//
// The following can be moved to AformA and DformA for simplicity
//   Note that the condition codes are no longer decoded
//
{__RETSc      ,"RETS"          ,0xFFFFFFFFL,0x78800000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSU"         ,0xFFFFFFFFL,0x78800000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSLO"        ,0xFFFFFFFFL,0x78810000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSC"         ,0xFFFFFFFFL,0x78810000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSLS"        ,0xFFFFFFFFL,0x78820000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSHI"        ,0xFFFFFFFFL,0x78830000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSHS"        ,0xFFFFFFFFL,0x78840000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNC"        ,0xFFFFFFFFL,0x78840000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSEQ"        ,0xFFFFFFFFL,0x78850000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSZ"         ,0xFFFFFFFFL,0x78850000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNE"        ,0xFFFFFFFFL,0x78860000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNZ"        ,0xFFFFFFFFL,0x78860000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSLT"        ,0xFFFFFFFFL,0x78870000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSN"         ,0xFFFFFFFFL,0x78870000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSLE"        ,0xFFFFFFFFL,0x78880000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSGT"        ,0xFFFFFFFFL,0x78890000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSP"         ,0xFFFFFFFFL,0x78890000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSGE"        ,0xFFFFFFFFL,0x788A0000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNN"        ,0xFFFFFFFFL,0x788A0000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNV"        ,0xFFFFFFFFL,0x788C0000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSV"         ,0xFFFFFFFFL,0x788D0000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNUF"       ,0xFFFFFFFFL,0x788E0000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSUF"        ,0xFFFFFFFFL,0x788F0000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNLV"       ,0xFFFFFFFFL,0x78900000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSLV"        ,0xFFFFFFFFL,0x78910000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSNLUF"      ,0xFFFFFFFFL,0x78920000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSLUF"       ,0xFFFFFFFFL,0x78930000L,AForm7,DForm7,S_retsc     },
{__RETSc      ,"RETSZUF"       ,0xFFFFFFFFL,0x78940000L,AForm7,DForm7,S_retsc     },
//                        RETI conditinal
//{__RETI     ,"RETI"          ,0xFFE0FFFFL,0x78000000L,AForm8,DForm8,S_reti      },
{__RETIc      ,"RETI"          ,0xFFFFFFFFL,0x78000000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIU"         ,0xFFFFFFFFL,0x78000000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETILO"        ,0xFFFFFFFFL,0x78010000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIC"         ,0xFFFFFFFFL,0x78010000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETILS"        ,0xFFFFFFFFL,0x78020000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIHI"        ,0xFFFFFFFFL,0x78030000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIHS"        ,0xFFFFFFFFL,0x78040000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINC"        ,0xFFFFFFFFL,0x78040000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIEQ"        ,0xFFFFFFFFL,0x78050000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIZ"         ,0xFFFFFFFFL,0x78050000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINE"        ,0xFFFFFFFFL,0x78060000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINZ"        ,0xFFFFFFFFL,0x78060000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETILT"        ,0xFFFFFFFFL,0x78070000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIN"         ,0xFFFFFFFFL,0x78070000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETILE"        ,0xFFFFFFFFL,0x78080000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIGT"        ,0xFFFFFFFFL,0x78090000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIP"         ,0xFFFFFFFFL,0x78090000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIGE"        ,0xFFFFFFFFL,0x780A0000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINN"        ,0xFFFFFFFFL,0x780A0000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINV"        ,0xFFFFFFFFL,0x780C0000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIV"         ,0xFFFFFFFFL,0x780D0000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINUF"       ,0xFFFFFFFFL,0x780E0000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIUF"        ,0xFFFFFFFFL,0x780F0000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINLV"       ,0xFFFFFFFFL,0x78100000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETILV"        ,0xFFFFFFFFL,0x78110000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETINLUF"      ,0xFFFFFFFFL,0x78120000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETILUF"       ,0xFFFFFFFFL,0x78130000L,AForm7,DForm7,S_retic     },
{__RETIc      ,"RETIZUF"       ,0xFFFFFFFFL,0x78140000L,AForm7,DForm7,S_retic     },
//
//              Call conditional
{__CALLc      ,"CALLU"         ,0xFDFF0000L,0x70000000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLLO"        ,0xFDFF0000L,0x70010000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLC"         ,0xFDFF0000L,0x70010000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLLS"        ,0xFDFF0000L,0x70020000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLHI"        ,0xFDFF0000L,0x70030000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLHS"        ,0xFDFF0000L,0x70040000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNC"        ,0xFDFF0000L,0x70040000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLEQ"        ,0xFDFF0000L,0x70050000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLZ"         ,0xFDFF0000L,0x70050000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNE"        ,0xFDFF0000L,0x70060000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNZ"        ,0xFDFF0000L,0x70060000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLLT"        ,0xFDFF0000L,0x70070000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLN"         ,0xFDFF0000L,0x70070000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLLE"        ,0xFDFF0000L,0x70080000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLGT"        ,0xFDFF0000L,0x70090000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLP"         ,0xFDFF0000L,0x70090000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLGE"        ,0xFDFF0000L,0x700A0000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNN"        ,0xFDFF0000L,0x700A0000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNV"        ,0xFDFF0000L,0x700C0000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLV"         ,0xFDFF0000L,0x700D0000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNUF"       ,0xFDFF0000L,0x700E0000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLUF"        ,0xFDFF0000L,0x700F0000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNLV"       ,0xFDFF0000L,0x70100000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLLV"        ,0xFDFF0000L,0x70110000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLNLUF"      ,0xFDFF0000L,0x70120000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLLUF"       ,0xFDFF0000L,0x70130000L,AForm7,DForm7,S_callc     },
{__CALLc      ,"CALLZUF"       ,0xFDFF0000L,0x70140000L,AForm7,DForm7,S_callc     },

//
//             Decrement and Branch conditional
{__DBc        ,"DB"            ,0xFC3F0000L,0x6C000000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBU"           ,0xFC3F0000L,0x6C000000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBLO"          ,0xFC3F0000L,0x6C010000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBC"           ,0xFC3F0000L,0x6C010000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBLS"          ,0xFC3F0000L,0x6C020000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBHI"          ,0xFC3F0000L,0x6C030000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBHS"          ,0xFC3F0000L,0x6C040000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNC"          ,0xFC3F0000L,0x6C040000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBEQ"          ,0xFC3F0000L,0x6C050000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBZ"           ,0xFC3F0000L,0x6C050000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNE"          ,0xFC3F0000L,0x6C060000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNZ"          ,0xFC3F0000L,0x6C060000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBLT"          ,0xFC3F0000L,0x6C070000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBN"           ,0xFC3F0000L,0x6C070000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBLE"          ,0xFC3F0000L,0x6C080000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBGT"          ,0xFC3F0000L,0x6C090000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBP"           ,0xFC3F0000L,0x6C090000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBGE"          ,0xFC3F0000L,0x6C0A0000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNN"          ,0xFC3F0000L,0x6C0A0000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNV"          ,0xFC3F0000L,0x6C0C0000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBV"           ,0xFC3F0000L,0x6C0D0000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNUF"         ,0xFC3F0000L,0x6C0E0000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBUF"          ,0xFC3F0000L,0x6C0F0000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNLV"         ,0xFC3F0000L,0x6C100000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBLV"          ,0xFC3F0000L,0x6C110000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBNLUF"        ,0xFC3F0000L,0x6C120000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBLUF"         ,0xFC3F0000L,0x6C130000L,AForm7,DForm7,S_dbc       },
{__DBc        ,"DBZUF"         ,0xFC3F0000L,0x6C140000L,AForm7,DForm7,S_dbc       },
//
//              Decrement and Branch conditional delayed
{__DBDc       ,"DBD"           ,0xFC3F0000L,0x6C200000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBUD"          ,0xFC3F0000L,0x6C200000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBLOD"         ,0xFC3F0000L,0x6C210000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBCD"          ,0xFC3F0000L,0x6C210000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBLSD"         ,0xFC3F0000L,0x6C220000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBHID"         ,0xFC3F0000L,0x6C230000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBHSD"         ,0xFC3F0000L,0x6C240000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNCD"         ,0xFC3F0000L,0x6C240000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBEQD"         ,0xFC3F0000L,0x6C250000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBZD"          ,0xFC3F0000L,0x6C250000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNED"         ,0xFC3F0000L,0x6C260000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNZD"         ,0xFC3F0000L,0x6C260000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBLTD"         ,0xFC3F0000L,0x6C270000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBND"          ,0xFC3F0000L,0x6C270000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBLED"         ,0xFC3F0000L,0x6C280000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBGTD"         ,0xFC3F0000L,0x6C290000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBPD"          ,0xFC3F0000L,0x6C290000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBGED"         ,0xFC3F0000L,0x6C2A0000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNND"         ,0xFC3F0000L,0x6C2A0000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNVD"         ,0xFC3F0000L,0x6C2C0000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBVD"          ,0xFC3F0000L,0x6C2D0000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNUFD"        ,0xFC3F0000L,0x6C2E0000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBUFD"         ,0xFC3F0000L,0x6C2F0000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNLVD"        ,0xFC3F0000L,0x6C300000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBLVD"         ,0xFC3F0000L,0x6C310000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBNLUFD"       ,0xFC3F0000L,0x6C320000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBLUFD"        ,0xFC3F0000L,0x6C330000L,AForm7,DForm7,S_dbdc      },
{__DBDc       ,"DBZUFD"        ,0xFC3F0000L,0x6C340000L,AForm7,DForm7,S_dbdc      },
//
//              Branch conditional standard
//
//              B <reg> and B <addr> assemble using BU cnd
//              Dasm is unaffected and will always result in BR
//
{__BR         ,"BR"            ,0xFF000000L,0x60000000L,AFormB,DFormB,S_br        },
{__BRD        ,"BRD"           ,0xFF000000L,0x61000000L,AFormB,DFormB,S_brd       },
//
//              The "B" mnemonic is not explicitly defined in the UG.
//              However the convention is to use "BU" in place of "B"
//              An alternate method would be to use "BR"
//
//{__BR       ,"B"             ,0xFF000000L,0x60000000L,AFormB,DFormB,S_br      },
{__Bc         ,"B"             ,0xFDFF0000L,0x68000000L,AForm7,DForm7,S_bcnd      },
//
{__Bc         ,"BU"            ,0xFDFF0000L,0x68000000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BLO"           ,0xFDFF0000L,0x68010000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BC"            ,0xFDFF0000L,0x68010000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BLS"           ,0xFDFF0000L,0x68020000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BHI"           ,0xFDFF0000L,0x68030000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BHS"           ,0xFDFF0000L,0x68040000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNC"           ,0xFDFF0000L,0x68040000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BEQ"           ,0xFDFF0000L,0x68050000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BZ"            ,0xFDFF0000L,0x68050000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNE"           ,0xFDFF0000L,0x68060000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNZ"           ,0xFDFF0000L,0x68060000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BLT"           ,0xFDFF0000L,0x68070000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BN"            ,0xFDFF0000L,0x68070000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BLE"           ,0xFDFF0000L,0x68080000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BGT"           ,0xFDFF0000L,0x68090000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BP"            ,0xFDFF0000L,0x68090000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BGE"           ,0xFDFF0000L,0x680A0000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNN"           ,0xFDFF0000L,0x680A0000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNV"           ,0xFDFF0000L,0x680C0000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BV"            ,0xFDFF0000L,0x680D0000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNUF"          ,0xFDFF0000L,0x680E0000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BUF"           ,0xFDFF0000L,0x680F0000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNLV"          ,0xFDFF0000L,0x68100000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BLV"           ,0xFDFF0000L,0x68110000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BNLUF"         ,0xFDFF0000L,0x68120000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BLUF"          ,0xFDFF0000L,0x68130000L,AForm7,DForm7,S_bcnd      },
{__Bc         ,"BZUF"          ,0xFDFF0000L,0x68140000L,AForm7,DForm7,S_bcnd      },
//
//              Branch conditional delayed
{__BDc        ,"BUD"           ,0xFDFF0000L,0x68200000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BD"            ,0xFDFF0000L,0x68200000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BLOD"          ,0xFDFF0000L,0x68210000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BCD"           ,0xFDFF0000L,0x68210000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BLSD"          ,0xFDFF0000L,0x68220000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BHID"          ,0xFDFF0000L,0x68230000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BHSD"          ,0xFDFF0000L,0x68240000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNCD"          ,0xFDFF0000L,0x68240000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BEQD"          ,0xFDFF0000L,0x68250000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BZD"           ,0xFDFF0000L,0x68250000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNED"          ,0xFDFF0000L,0x68260000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNZD"          ,0xFDFF0000L,0x68260000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BLTD"          ,0xFDFF0000L,0x68270000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BND"           ,0xFDFF0000L,0x68270000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BLED"          ,0xFDFF0000L,0x68280000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BGTD"          ,0xFDFF0000L,0x68290000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BPD"           ,0xFDFF0000L,0x68290000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BGED"          ,0xFDFF0000L,0x682A0000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNND"          ,0xFDFF0000L,0x682A0000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNVD"          ,0xFDFF0000L,0x682C0000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BVD"           ,0xFDFF0000L,0x682D0000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNUFD"         ,0xFDFF0000L,0x682E0000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BUFD"          ,0xFDFF0000L,0x682F0000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNLVD"         ,0xFDFF0000L,0x68300000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BLVD"          ,0xFDFF0000L,0x68310000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BNLUFD"        ,0xFDFF0000L,0x68320000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BLUFD"         ,0xFDFF0000L,0x68330000L,AForm7,DForm7,S_bdc       },
{__BDc        ,"BZUFD"         ,0xFDFF0000L,0x68340000L,AForm7,DForm7,S_bdc       },

//{__SIGI     ,"SIGI"          ,0xFF800000L,0x16000000L,AFormA,DFormA,S_SIGI      },
//{__STIK_A   ,"STIK"          ,0xFFE00000L,0x15000000L,AForm1,DForm1,S_stik_A    },
//{__STIK_B   ,"STIK"          ,0xFFE00000L,0x15600000L,AForm1,DForm1,S_stik_B    },
/*             TYPE 2 (FORM6 & FORM6B) ARE   TMS320C4X ONLY */
/*
{__ADDC3_B    ,"ADDC3"         ,0xFF800000L,0x30000000L,AForm6,DForm6,S_addc3_B   },
{__ADDI3_B    ,"ADDI3"         ,0xFF800000L,0x31000000L,AForm6,DForm6,S_addi3_B   },
{__AND3_B     ,"AND3"          ,0xFF800000L,0x31800000L,AForm6,DForm6,S_and3_B    },
{__ANDN3_B    ,"ANDN3"         ,0xFF800000L,0x32000000L,AForm6,DForm6,S_andN3_B   },
{__ASH3_B     ,"ASH3"          ,0xFF800000L,0x32800000L,AForm6,DForm6,S_ash3_B    },
{__CMPI3_B    ,"CMPI3"         ,0xFF9F0000L,0x33800000L,AForm6,DForm6,S_cmpi3_B   },
{__LSH3_B     ,"LSH3"          ,0xFF800000L,0x34000000L,AForm6,DForm6,S_lsh3_B    },
{__MPYI3_B    ,"MPYI3"         ,0xFF800000L,0x35000000L,AForm6,DForm6,S_mpyi3_B   },
{__OR3_B      ,"OR3"           ,0xFF800000L,0x35800000L,AForm6,DForm6,S_or3_B     },
{__SUBB3_B    ,"SUBB3"         ,0xFF800000L,0x36000000L,AForm6,DForm6,S_SUBB3_B   },
{__SUBI3_B    ,"SUBI3"         ,0xFF800000L,0x37000000L,AForm6,DForm6,S_SUBI3_B   },
{__TSTB3_B    ,"TSTB3"         ,0xFF9F0000L,0x37800000L,AForm6,DForm6,S_TSTB3_B   },
{__XOR3_B     ,"XOR3"          ,0xFF800000L,0x38000000L,AForm6,DForm6,S_XOR3_B    },
{__MPYSHI3_B  ,"MPYSHI3"       ,0xFF800000L,0x38800000L,AForm6,DForm6,S_MPYSHI3_B },
{__MPYUHI3_B  ,"MPYUHI3"       ,0xFF800000L,0x39000000L,AForm6,DForm6,S_MPYUHI3_B },
{__ADDF3_B    ,"ADDF3"         ,0xFF800000L,0x30800000L,AForm6b,DForm6,S_addf3_B  },
{__CMPF3_B    ,"CMPF3"         ,0xFF9F0000L,0x33000000L,AForm6b,DForm6,S_cmpf3_B  },
{__MPYF3_B    ,"MPYF3"         ,0xFF800000L,0x34800000L,AForm6b,DForm6,S_mpyf3_B  },
{__SUBF3_B    ,"SUBF3"         ,0xFF800000L,0x36800000L,AForm6b,DForm6,S_subf3_B  },
*/
//{__RPTBD_A  ,"RPTBD"         ,0xFF000000L,0x65000000L,AFormB,DFormB,S_RPTBD_A },//C40
//{__RPTBD_B  ,"RPTBD"         ,0xFFFFFFE0L,0x79800000L,AFormB,DFormB,S_RPTBD_B },//C40
//{__RPTB_B   ,"RPTB"          ,0xFFFFFFE0L,0x79000000L,AFormB,DFormB,S_RPTB_B  },//C40
//{__BAT_     ,"BAT_"          ,0xFDE00000L,0x68600000L,AForm7,DForm7,S_BAT_    },//C40
//{__BAF_     ,"BAF_"          ,0xFDE00000L,0x68A00000L,AForm7,DForm7,S_BAF_    },//C40
//{__LAJ_A    ,"LAJ" /*cnd*/   ,0xFDE00000L,0x70200000L,AForm7,DForm7,S_LAJ_A   },//C40
//{__LATc     ,"LATc"          ,0xFFE0FE00L,0x74800000L,AForm7,DForm7,S_LATc    },//C40
//{__LAJ      ,"LAJ"           ,0xFF000000L,0x63000000L,AFormB,DFormB,S_LAJ     },//C40
//
//{__LB       ,"LB0"           ,0xFF800000L,0xB0000000L,AForm1,DForm1,S_LB      },//C4x
//{__LB       ,"LB1"           ,0xFF800000L,0xB0800000L,AForm1,DForm1,S_LB      },//C4x
//{__LB       ,"LB2"           ,0xFF800000L,0xB1000000L,AForm1,DForm1,S_LB      },//C4x
//{__LB       ,"LB3"           ,0xFE000000L,0xB1800000L,AForm1,DForm1,S_LB      },//C4x
//{__LBU0     ,"LBU0"          ,0xFF800000L,0xB2000000L,AForm1,DForm1,S_LBU0    },
//{__LBU1     ,"LBU1"          ,0xFF800000L,0xB2800000L,AForm1,DForm1,S_LBU1    },
//{__LBU2     ,"LBU2"          ,0xFF800000L,0xB3000000L,AForm1,DForm1,S_LBU2    },
//{__LBU3     ,"LBU3"          ,0xFF800000L,0xB3800000L,AForm1,DForm1,S_LBU3    },
  {__LDA      ,"LDA"           ,0xFF800000L,0x1E800000L,AForm1,DForm1,S_LDA     },
//{__LDEP     ,"LDEP"          ,0xFFE0FFC0L,0x76000000L,AForm1,DForm1,S_ldep    },
//{__LDHI     ,"LDHI"          ,0xFFE00000L,0x1FE00000L,AForm1,DForm1,S_LDHI    },
//{__LDPE     ,"LDPE"          ,0xFFE0FFE0L,0x76800000L,AForm1,DForm1,S_ldpE    },//C4x
//{__LDPK     ,"LDPK"          ,0xFFFF0000L,0x1F700000L,AForm1,DForm1,S_ldpK    },//C4x
//{__LH       ,"LH0"           ,0xFF800000L,0xBA000000L,AForm1,DForm1,S_LH      },
//{__LH       ,"LH1"           ,0xFF800000L,0xBA800000L,AForm1,DForm1,S_LH      },
//{__LHU      ,"LHU0"          ,0xFF800000L,0xBB000000L,AForm1,DForm1,S_LHU     },
//{__LHU      ,"LHU1"          ,0xFF800000L,0xBB800000L,AForm1,DForm1,S_LHU     },
//{__LWL      ,"LWL0"          ,0xFF800000L,0xB4000000L,AForm1,DForm1,S_LWL     },
//{__LWL      ,"LWL1"          ,0xFF800000L,0xB4800000L,AForm1,DForm1,S_LWL     },
//{__LWL      ,"LWL2"          ,0xFF800000L,0xB5000000L,AForm1,DForm1,S_LWL     },
//{__LWL      ,"LWL3"          ,0xFF800000L,0xB5800000L,AForm1,DForm1,S_LWL     },
//{__LWR      ,"LWR0"          ,0xFF800000L,0xB6000000L,AForm1,DForm1,S_LWR     },
//{__LWR      ,"LWR1"          ,0xFF800000L,0xB6800000L,AForm1,DForm1,S_LWR     },
//{__LWR      ,"LWR2"          ,0xFF800000L,0xB7000000L,AForm1,DForm1,S_LWR     },
//{__LWR      ,"LWR3"          ,0xFF800000L,0xB7800000L,AForm1,DForm1,S_LWR     },
  {__FRIEEE   ,"FRIEEE"        ,0xFF800000L,0x1C000000L,AForm1,DForm1,S_FRIEEE  },
//{__MB       ,"MB0"           ,0xFF800000L,0xB8000000L,AForm1,DForm1,S_MB      },
//{__MB       ,"MB1"           ,0xFF800000L,0xB8800000L,AForm1,DForm1,S_MB      },
//{__MB       ,"MB2"           ,0xFF800000L,0xB9000000L,AForm1,DForm1,S_MB      },
//{__MB       ,"MB3"           ,0xFF800000L,0xB9800000L,AForm1,DForm1,S_MB      },
//{__MH       ,"MH0"           ,0xFF800000L,0xBC000000L,AForm1,DForm1,S_MH      },
//{__MH       ,"MH1"           ,0xFF800000L,0xBC800000L,AForm1,DForm1,S_MH      },
//{__MPYSHI   ,"MPYSHI"        ,0xFF800000L,0x1D800000L,AForm1,DForm1,S_MPYSHI  },
//{__MPYUHI   ,"MPYUHI"        ,0xFF800000L,0x1E000000L,AForm1,DForm1,S_MPYUHI  },
//{__RCPF     ,"RCPF"          ,0xFF800000L,0x1D000000L,AForm0,DForm0,S_RCPF    },
//{__RSQRF    ,"RSQRF"         ,0xFF800000L,0x1C800000L,AForm0,DForm0,S_RSQRF   },
  {__TOIEEE   ,"TOIEEE"        ,0xFF800000L,0x1B800000L,AForm0,DForm0,S_TOIEEE  },

{__word       ,".word"/*ncode*/,0x00000000L,0x00000000L,AForm1,DForm1,S_word    }

};

//#endif
