//------------------------------------------------------------
// SIMFUNC.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//
// Portions of this file are created from the following source
// from The University of Texas at Austin.  The license agreement
// for these source files is given below.
//------------------------------------------------------------
#ifndef _PIPELINE_H
#define _PIPELINE_H
/*=====================================================*/
/* Structures used in simulation (not accurate!)       */
/*=====================================================*/
//typedef struct pipeline
struct pipeline
{
  unsigned long inst;
  unsigned long s;
  unsigned long flushed;
  unsigned long newPC;
  unsigned long modifyPC;
  unsigned long oprnd1;
  unsigned long oprnd2;
  unsigned long oprnd3;
  unsigned long oprnd4;
  unsigned long opfloat1;
  unsigned long opfloat2;
  unsigned long opfloat3;
           long *finalDest1;
           long *finalDest2;
  unsigned long dummy;
};

//typedef struct state
struct state
{
  int                 st;
  unsigned long       dp;
  unsigned long       re;
  unsigned long       rs;
  unsigned long       rc;
  unsigned long       sp;
  unsigned long       pc;
  unsigned long    dummy;
};
/*=====================================================*/
/* Function form defintion                             */
/*=====================================================*/
typedef void (*SFUNC)(pipeline *pipe, state *st);
/*=====================================================*/
/* A dummy definition to avoid not used warnings       */
/*=====================================================*/
#define dummy_code() pipe->dummy=0; st->dummy=0; if(pipe[0].inst==0) return;
/*=====================================================*/
/* Simulator function prototypes                       */
/*=====================================================*/
void S_absf      (pipeline *pipe, state *st);
void S_addf	 (pipeline *pipe, state *st);
void S_cmpf	 (pipeline *pipe, state *st);
void S_float	 (pipeline *pipe, state *st);
void S_lde	 (pipeline *pipe, state *st);
void S_ldf	 (pipeline *pipe, state *st);
void S_ldfi	 (pipeline *pipe, state *st);
void S_ldm	 (pipeline *pipe, state *st);
void S_mpyf	 (pipeline *pipe, state *st);
void S_negf	 (pipeline *pipe, state *st);
void S_popf	 (pipeline *pipe, state *st);
void S_pushf	 (pipeline *pipe, state *st);
void S_rnd	 (pipeline *pipe, state *st);
void S_subf	 (pipeline *pipe, state *st);
void S_subrf	 (pipeline *pipe, state *st);
void S_norm	 (pipeline *pipe, state *st);
void S_absi	 (pipeline *pipe, state *st);
void S_addc	 (pipeline *pipe, state *st);
void S_addi	 (pipeline *pipe, state *st);
void S_and	 (pipeline *pipe, state *st);
void S_andn	 (pipeline *pipe, state *st);
void S_ash	 (pipeline *pipe, state *st);
void S_cmpi	 (pipeline *pipe, state *st);
void S_fix	 (pipeline *pipe, state *st);
void S_ldp	 (pipeline *pipe, state *st);
void S_ldi	 (pipeline *pipe, state *st);
void S_ldii	 (pipeline *pipe, state *st);
void S_lsh	 (pipeline *pipe, state *st);
void S_mpyi	 (pipeline *pipe, state *st);
void S_negb	 (pipeline *pipe, state *st);
void S_negi	 (pipeline *pipe, state *st);
void S_nop	 (pipeline *pipe, state *st);
void S_not	 (pipeline *pipe, state *st);
void S_pop	 (pipeline *pipe, state *st);
void S_push	 (pipeline *pipe, state *st);
void S_or	 (pipeline *pipe, state *st);
void S_rol	 (pipeline *pipe, state *st);
void S_rolc	 (pipeline *pipe, state *st);
void S_ror	 (pipeline *pipe, state *st);
void S_rorc      (pipeline *pipe, state *st);
void S_rpts	 (pipeline *pipe, state *st);
void S_stf	 (pipeline *pipe, state *st);
void S_stfi	 (pipeline *pipe, state *st);
void S_sti	 (pipeline *pipe, state *st);
void S_stii	 (pipeline *pipe, state *st);
void S_subb	 (pipeline *pipe, state *st);
void S_subc	 (pipeline *pipe, state *st);
void S_subi	 (pipeline *pipe, state *st);
void S_subrb	 (pipeline *pipe, state *st);
void S_subri	 (pipeline *pipe, state *st);
void S_tstb	 (pipeline *pipe, state *st);
void S_xor	 (pipeline *pipe, state *st);
void S_iack	 (pipeline *pipe, state *st);
void S_mpyf3_addf3(pipeline *pipe, state *st);
void S_mpyf3_subf3(pipeline *pipe, state *st);
void S_mpyi3_addi3(pipeline *pipe, state *st);
void S_mpyi3_subi3(pipeline *pipe, state *st);
void S_stf_stf   (pipeline *pipe, state *st);
void S_sti_sti   (pipeline *pipe, state *st);
void S_ldf_ldf   (pipeline *pipe, state *st);
void S_ldi_ldi   (pipeline *pipe, state *st);
void S_absf_stf  (pipeline *pipe, state *st);
void S_absi_sti  (pipeline *pipe, state *st);
void S_addf3_stf (pipeline *pipe, state *st);
void S_addi3_sti (pipeline *pipe, state *st);
void S_and3_sti  (pipeline *pipe, state *st);
void S_ash3_sti  (pipeline *pipe, state *st);
void S_fix_sti   (pipeline *pipe, state *st);
void S_float_stf (pipeline *pipe, state *st);
void S_ldf_stf   (pipeline *pipe, state *st);
void S_ldi_sti   (pipeline *pipe, state *st);
void S_lsh3_sti  (pipeline *pipe, state *st);
void S_mpyf3_stf (pipeline *pipe, state *st);
void S_mpyi3_sti (pipeline *pipe, state *st);
void S_negf_stf  (pipeline *pipe, state *st);
void S_negi_sti  (pipeline *pipe, state *st);
void S_not_sti   (pipeline *pipe, state *st);
void S_or3_sti   (pipeline *pipe, state *st);
void S_subf3_stf (pipeline *pipe, state *st);
void S_subi3_sti (pipeline *pipe, state *st);
void S_xor3_sti  (pipeline *pipe, state *st);
void S_addc3	 (pipeline *pipe, state *st);
void S_addi3	 (pipeline *pipe, state *st);
void S_and3	 (pipeline *pipe, state *st);
void S_andn3	 (pipeline *pipe, state *st);
void S_ash3	 (pipeline *pipe, state *st);
void S_cmpi3	 (pipeline *pipe, state *st);
void S_lsh3	 (pipeline *pipe, state *st);
void S_mpyi3	 (pipeline *pipe, state *st);
void S_or3	 (pipeline *pipe, state *st);
void S_subb3	 (pipeline *pipe, state *st);
void S_subi3	 (pipeline *pipe, state *st);
void S_tstb3	 (pipeline *pipe, state *st);
void S_xor3	 (pipeline *pipe, state *st);
void S_addf3	 (pipeline *pipe, state *st);
void S_cmpf3	 (pipeline *pipe, state *st);
void S_mpyf3	 (pipeline *pipe, state *st);
void S_subf3	 (pipeline *pipe, state *st);
void S_sigi	 (pipeline *pipe, state *st);
void S_idle	 (pipeline *pipe, state *st);
void S_idle2	 (pipeline *pipe, state *st);
void S_lopower	 (pipeline *pipe, state *st);
void S_maxspeed	 (pipeline *pipe, state *st);
void S_swi	 (pipeline *pipe, state *st);
void S_trap	 (pipeline *pipe, state *st);
void S_trap4x	 (pipeline *pipe, state *st);
void S_ldfc	 (pipeline *pipe, state *st);
void S_ldic	 (pipeline *pipe, state *st);
void S_call	 (pipeline *pipe, state *st);
void S_rptb	 (pipeline *pipe, state *st);
void S_retsc	 (pipeline *pipe, state *st);
void S_retic	 (pipeline *pipe, state *st);
void S_callc	 (pipeline *pipe, state *st);
void S_dbc	 (pipeline *pipe, state *st);
void S_dbdc	 (pipeline *pipe, state *st);
void S_br	 (pipeline *pipe, state *st);
void S_brd	 (pipeline *pipe, state *st);
void S_bcnd      (pipeline *pipe, state *st);
void S_bdc	 (pipeline *pipe, state *st);
void S_addc3_B	 (pipeline *pipe, state *st);
void S_addi3_B	 (pipeline *pipe, state *st);
void S_and3_B	 (pipeline *pipe, state *st);
void S_andN3_B	 (pipeline *pipe, state *st);
void S_ash3_B	 (pipeline *pipe, state *st);
void S_cmpi3_B	 (pipeline *pipe, state *st);
void S_lsh3_B	 (pipeline *pipe, state *st);
void S_mpyi3_B	 (pipeline *pipe, state *st);
void S_or3_B	 (pipeline *pipe, state *st);
void S_subb3_B	 (pipeline *pipe, state *st);
void S_subi3_B	 (pipeline *pipe, state *st);
void S_tstb3_B	 (pipeline *pipe, state *st);
void S_xor3_B	 (pipeline *pipe, state *st);
void S_mpyshi3_B (pipeline *pipe, state *st);
void S_mpyuhi3_B (pipeline *pipe, state *st);
void S_addf3_B	 (pipeline *pipe, state *st);
void S_cmpf3_B	 (pipeline *pipe, state *st);
void S_mpyf3_B	 (pipeline *pipe, state *st);
void S_subf3_B	 (pipeline *pipe, state *st);
void S_word	 (pipeline *pipe, state *st);
//void S_LDP	 (pipeline *pipe, state *st);
//void S_sti	 (pipeline *pipe, state *st);
//void S_sti	 (pipeline *pipe, state *st);
//void S_FRIEEE_ST(pipeline *pipe, state *st);
//void S_TOIEEE_ST(pipeline *pipe, state *st);
//void S_MPYSHI3  (pipeline *pipe, state *st);
//void S_MPYUHI3  (pipeline *pipe, state *st);
//void S_ldf_B	 (pipeline *pipe, state *st);
//void S_ldi_B	 (pipeline *pipe, state *st);
//void S_TRAP	 (pipeline *pipe, state *st);
//void S_B_A	 (pipeline *pipe, state *st);
//void S_B_B	 (pipeline *pipe, state *st);
//void S_DB_A	 (pipeline *pipe, state *st);
//void S_CALL_A	 (pipeline *pipe, state *st);
//void S_DB_B	 (pipeline *pipe, state *st);
//void S_RETIc	 (pipeline *pipe, state *st);
//void S_RETS	 (pipeline *pipe, state *st);
//void S_RETI	 (pipeline *pipe, state *st);
//void S_BR	 (pipeline *pipe, state *st);
//void S_SIGI	 (pipeline *pipe, state *st);
//void S_stiK_A	 (pipeline *pipe, state *st);
//void S_stiK_B	 (pipeline *pipe, state *st);
//void S_RPTBD_A  (pipeline *pipe, state *st);
//void S_RPTBD_B  (pipeline *pipe, state *st);
//void S_RPTB_B	 (pipeline *pipe, state *st);
//void S_BAT_	 (pipeline *pipe, state *st);
//void S_BAF_	 (pipeline *pipe, state *st);
//void S_LAJ_A	 (pipeline *pipe, state *st);
//void S_LATc	 (pipeline *pipe, state *st);
//void S_LAJ	 (pipeline *pipe, state *st);
//void S_LB	 (pipeline *pipe, state *st);
//void S_LBU0	 (pipeline *pipe, state *st);
//void S_LBU1	 (pipeline *pipe, state *st);
//void S_LBU2	 (pipeline *pipe, state *st);
//void S_LBU3	 (pipeline *pipe, state *st);
  void S_LDA	 (pipeline *pipe, state *st);
//void S_LDEP	 (pipeline *pipe, state *st);
//void S_LDHI	 (pipeline *pipe, state *st);
//void S_LDPE	 (pipeline *pipe, state *st);
//void S_LDPK	 (pipeline *pipe, state *st);
//void S_LH	 (pipeline *pipe, state *st);
//void S_LH	 (pipeline *pipe, state *st);
//void S_LHU	 (pipeline *pipe, state *st);
//void S_LHU	 (pipeline *pipe, state *st);
//void S_LWL	 (pipeline *pipe, state *st);
//void S_LWR	 (pipeline *pipe, state *st);
void S_FRIEEE	 (pipeline *pipe, state *st);
//void S_MB	 (pipeline *pipe, state *st);
//void S_MH	 (pipeline *pipe, state *st);
//void S_MPYSHI	 (pipeline *pipe, state *st);
//void S_MPYUHI	 (pipeline *pipe, state *st);
//void S_RCPF	 (pipeline *pipe, state *st);
//void S_RSQRF	 (pipeline *pipe, state *st);
void S_TOIEEE	 (pipeline *pipe, state *st);
//
// End SIMFUNC.H
#endif
