/*=======================================================================
  LOGARITHMIC DIFFERENTIAL COMPRESSION (LDC)

  Keith Larson
  TMS320 DSP Applications
  (C) Copyright 1996,1997,1998
  Texas Instruments Incorporated

  A patent application has been made covering Logarithmic
  Differential Compression as a new technology.  Please contact
  Texas Instruments for proper usage outside of this demonstration
 ========================================================================*/
#include "C3MMR.H"
/*define  S0gctrl 00E970300h */      /* Sport, noninverted clkx/clkr     */
#define  S0gctrl 0x0E973300          /* Sport,    inverted clkx/clkr     */
#define  S0xctrl 0x00000111          /*                                  */
#define  S0rctrl 0x00000111          /*                                  */
#define  TA_   8
#define  TB_  60
#define  RA_   8
#define  RB_  60
#define  MAXCNT  30000
long     TA = TA_;
long     TB = TB_;
long     RA = RA_;
long     RB = RB_;
/*==================================================================*/
void ST_STUB   (void   );
float Input    (void   );
void  Output   (float  );
void  prog_AIC (int    );
void  AIC_INIT (void   );
/*************************************************/
volatile long A_LOC   = ((TA_<<9)+(RA_<<2)+0);
volatile long B_LOC   = ((TB_<<9)+(RB_<<2)+2);
volatile long C_LOC   = 3;
volatile long T_LOC   = 2;
volatile long TRG_LOC = 0;
/*************************************************/
volatile int xdata    = 0;
volatile int free_run = 0;
volatile int RRDY     = 0;
/*************************************************************/
float LDC_SUM1 = 0;           /* Compress integral           */
float LDC_SUM2 = 0;           /* Decompress integral         */
#define LDC_MASK  0x0f800000L /* Mask chop out mantissa bits */
/*-----------------------------------------------------------*/
float LDC_compress(float f);
asm("K2      .word  0C0000000h                              ");
asm("_LDC_compress                                          ");
asm("        ldi    SP,AR3         ; load frame pointer     ");
asm("        ldf    *-AR3(1),R0    ; F0 = input             ");
asm("        subf   @_LDC_SUM1,R0  ; LDC = input - LDC_SUM1 ");
asm("        and    @K2,R0         ; mask out mantissa bits ");
asm("        ldf    R0,R1          ; reconstruct LDC_SUM1   ");
asm("        addf   @_LDC_SUM1,R1  ; from LDC+err data      ");
asm("        stf    R1,@_LDC_SUM1  ;                        ");
asm("        rets                  ;                        ");
/*
long l;
float LDC_compress(float f)
{
  f = f - LDC_SUM1;
  if(f == 0) return 0;
  l = *(long *)&f;
  l = l & LDC_MASK;
  l = l << 4;
  l = l >> 4;
  f = *(float *)&l;
  LDC_SUM1 = LDC_SUM1 + f;
  return f;
}
*/
float LDC_decompress(float f)
{
  LDC_SUM2 = 0.999 * (LDC_SUM2 + f);
  return LDC_SUM2; /* * 256.0; */
}

volatile long l;
float ULAW_compress(float f)
{
  if(f == 0) return 0;
  l = *(long *)&f;
  l = l & 0xFFF00000L; /* 4/1/3 format ~= u-law a-law */
  f = *(float *)&l;
  return f;
}

float ULAW_decompress(float f)
{
  return f;    /* do nothing.  4/1/3 format is correct */
}


/*-------------------------------------------------------------------*/
void main(void)
{
   float GGG ;
   float f,fin;
   long count=0;
   ST_STUB();
   for(;;)
   {
     *T0_ctrl = 0;
     *T0_count= 0;
     *T0_prd  = T_LOC;
     *T0_ctrl = 0x2C1;
     free_run = 0;
     AIC_INIT();
     free_run = 1;
     TRG_LOC = 0;
     asm("  ldi   0F4h,IE     ");
     asm("  andn  00Fh,IF     ");
     GGG = Input();
     *S0_xdata = xdata;
     asm(" OR 02000h,ST  ");
     for(;;)
     {
       asm(" STI R0,@080A000h ");
       RRDY = 0;
       while(RRDY==0);
       fin  = Input();
       fin = fin/256.0;
       f = fin;
       /*                                                        */
       /* Toggle between LDC, u-law and linear every few seconds */
       /*                                                        */
       if((count>=    0)&&(count<10000))
       {
         f  = LDC_compress  (f);  /* A simple loopback is used for   */
         f  = LDC_decompress(f);  /* comparing LDC, u-law and linear */
       }
       if((count>=10000)&&(count<20000))
       {
        f  = ULAW_compress(f);
        f  = ULAW_decompress(f);
       }

       if(count > MAXCNT) count = 0;
       count++;
       f = f*256.0;
       Output(f);
       asm(" STI R0,@080AFFFh");
       if(TRG_LOC) break;          /* Re-start with new parameters   */
     }                             /* downloaded from host           */
   }
}
/*===================================================================
  The ADC data is read and buffered here
 ====================================================================*/
float Input(void)
{
  int   x;
  float f;
  x = *S0_rdata;     /*get ADC data                         */
  x = x >> 16;       /* Sign extend previous sample in MSBs */
  f = x;             /* Convert the ADC data to float       */
  return f;
}
/*===================================================================
  The output section is written for both Spectrum analyzer output
  as well as REAL/IMAG filter sum outputs
 ====================================================================*/
void Output(float f)
{
  long x;
  if(f>  32767) f =  32767;
  if(f< -32768) f = -32768;
  x = f;
  x &= 0xFFFC;
  xdata = x;
}
/*===================================================================
  The startup stub is used during initialization only and can be
  overwritten by the stack or data after initialization is complete.
  Note: A DSK or RTOS communications kernel may also use the stack.
  In this case be sure to not put the stack here during debug.
 ====================================================================*/
void ST_STUB(void)
{
   *T0_ctrl = 0;         /* Halt TIM0           */
   *T0_count= 0;         /* Set counts to 0     */
   *T0_prd  = T_LOC;     /* Set period          */
   *T0_ctrl = 0x2C1;     /* Restart both timers */
   /* - - - - - - - - - - - - - - - - - - - - - */
   *S0_xctrl = S0xctrl;  /* transmit control    */
   *S0_rctrl = S0rctrl;  /* receive  control    */
   *S0_xdata =       0;  /* DXR data value      */
   *S0_gctrl = S0gctrl;  /* global control      */
  /*AIC_INIT();*/
}
/*===============================================================
  This function initializes the AIC and would be supplied by the
  board manufacturer.
 ================================================================*/
void AIC_INIT(void)
{
  /* *dma_ctrl =        0;  */
  asm("  andn  034h,IF  ");
  asm("  ldi   004h,IE  ");  /* Enable only INT2 */
  *S0_xdata = 0;
  asm(" rpts  0040h     ");
  asm(" ldi   2,IOF     ");  /* XF0=0 resets AIC */
  asm(" ldi   6,IOF     ");  /* XF0=1 runs AIC   */
  asm(" rpts  040h      ");
  asm(" nop             ");
  asm(" andn  034h,IF   ");
  asm(" ldi   014h,IE   ");  /* Enable only XINT interrupt */
  /*- - - - - - - - - - - -*/
  prog_AIC(C_LOC   );      /* program control register */
  prog_AIC(0xFFFC  );      /* Program the AIC to be real slow */
  prog_AIC(0xFFFC|2);      /* Program the AIC to be real slow */
  prog_AIC(B_LOC   );      /* Bump up the F s to final rate    */
  prog_AIC(A_LOC   );      /* smaller divisors sent first     */
  asm("  or  080h,ST");    /* Use the overflow mode for fast saturate */
}
/*===================================================================
  This called by AIC_INIT()

  prog_AIC is used to transmit new timing configurations to the AIC.
  If you single step this routine, the AIC timing will be corrupted
  causing AIC programming to fail.
  STEP OVER THIS ROUTINE USING THE F10 FUNCTION STEP
 ====================================================================*/
void prog_AIC(int xmit2)
{
  int x;
  *S0_xdata =     0; asm(" idle "); /* Pre transmit a safe value       */
  *S0_xdata =     3; asm(" idle "); /* Request 2ndy xmit               */
  *S0_xdata = xmit2; asm(" idle "); /* Send register porgram value     */
  *S0_xdata =     0; asm(" idle "); /* Leave with a safe value         */
  x = *S0_rdata;                    /* Fix rcvr underrun by dummy read */
}

/*-------------------------------------------------------------------
  Send the output value posted by Output to the serial port xmit
  -------------------------------------------------------------------*/
void c_int05(void)
{
  if(free_run)
    *S0_xdata = xdata;
}
/*-------------------------------------------------------------------
  Set a flag to let the Input() routine know that a value is ready
  -------------------------------------------------------------------*/
void c_int06(void)
{
  RRDY = 1;
}
/*===================================================================
  Install the XINT/RINT ISR branch vectors
 ====================================================================*/
  asm(" .sect  \"SP0VECTS\" ; secondary branch table ");
  asm(" b   _c_int05        ; XINT0                  ");
  asm(" b   _c_int06        ; RINT0                  ");
  asm(" .text               ; secondary branch table ");
