/*=======================================================================
  DMALOOP.C
  Keith Larson
  TMS320 DSP Applications
  (C) Copyright 1996,1997,1998
  Texas Instruments Incorporated

  This is unsupported freeware with no implied warranties or
  liabilities.  See the C3x DSK disclaimer document for details
 ========================================================================*/
#include "C3MMR.H"
#include "c3xdma.h"
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
#define  TIM0_prd  4             /* AIC reference clock is TIM0          */
#define  TA        8             /* DAC setup                            */
#define  TB        16            /*                                      */
#define  RA        8             /* ADC setup                            */
#define  RB        16            /*                                      */
/*===================================================================
  The application code begins here, beginning with constants that
  are used in various routines.
 ====================================================================*/
#define  A_REG   ((TA<<9)+(RA<<2)+0) /* Packed AIC register values       */
#define  B_REG   ((TB<<9)+(RB<<2)+2) /*                                  */
#define  C_REG   0x3                 /*                                  */
/*efine  S0gctrl 00E970300h */       /* Sport, noninverted clkx/clkr     */
#define  S0gctrl 0x0E973300          /* Sport,    inverted clkx/clkr     */
#define  S0xctrl 0x00000111          /*                                  */
#define  S0rctrl 0x00000111          /*                                  */
#define  bigval  000010000h          /* Used in overflow mode saturation */
/*===================================================================
  The main loop consists of waiting for a new ADC sample.
  When an receive interrupt occurs, the new data is loaded into the
  data delay line buffer, followed by the SFFT and output routines.
  Four dummy writes to the external bus have been added in the main
  loop to allow real time benchmarking of the three functions using
  and oscilloscope to monitor the address bus LSB's
 ====================================================================*/
void ST_STUB (void);
float Input   (void);
void  Output  (float);
void  prog_AIC(int );
void  AIC_INIT(void);
/********************************************************/
#define      HOSTXFRBUF  0xF00000

asm("   .global  _F0, _F1, _F2, _F3, _F4, _F5, _F6, _F7    ");
asm("   .global  _R0, _R1, _R2, _R3, _R4, _R5, _R6, _R7    ");
asm("   .global _AR0,_AR1,_AR2,_AR3,_AR4,_AR5,_AR6,_AR7    ");
asm("   .global  _DP,_IR0,_IR1, _BK, _SP, _ST, _IE, _IF    ");
asm("   .global _IOF, _RS, _RE, _RC                        ");
asm("   .global  _PC,_FREERUN,_dT,CPUCTXT,_CTXTPTR,__stack,_SPIN ");

asm("_F0      .float  0     ;F0                            ");
asm("_F1      .float  0     ;F1                            ");
asm("_F2      .float  0     ;F2                            ");
asm("_F3      .float  0     ;F3                            ");
asm("_F4      .float  0     ;F4                            ");
asm("_F5      .float  0     ;F5                            ");
asm("_F6      .float  0     ;F6                            ");
asm("_F7      .float  0     ;F7                            ");
asm("_R0      .word   0     ;R0                            ");
asm("_R1      .word   0     ;R1                            ");
asm("_R2      .word   0     ;R2                            ");
asm("_R3      .word   0     ;R3                            ");
asm("_R4      .word   0     ;R4                            ");
asm("_R5      .word   0     ;R5                            ");
asm("_R6      .word   0     ;R6                            ");
asm("_R7      .word   0     ;R7                            ");
asm("_AR0     .word   0     ;AR0                           ");
asm("_AR1     .word   0     ;AR1                           ");
asm("_AR2     .word   0     ;AR2                           ");
asm("_AR3     .word   0     ;AR3                           ");
asm("_AR4     .word   0     ;AR4                           ");
asm("_AR5     .word   0     ;AR5                           ");
asm("_AR6     .word   0     ;AR6                           ");
asm("_AR7     .word   0     ;AR7                           ");
asm("_DP      .word   0     ;Data page                     ");
asm("_IR0     .word   0     ;Index register 0              ");
asm("_IR1     .word   0     ;Index register 1              ");
asm("_BK      .word   0     ;Block size                    ");
asm("_SP      .word __stack ;Stack ptr (initial DSK3D val) ");
asm("_ST      .word   0     ;Status                        ");
asm("_IE      .word   0     ;Internal int enable           ");
asm("_IF      .word   0     ;CPU interrupt flags           ");
asm("_IOF     .word   0     ;I/O flags                     ");
asm("_RS      .word   0     ;Repeat start                  ");
asm("_RE      .word   0     ;Repeat end                    ");
asm("_RC      .word   0     ;Repeat counter                ");
asm("_PC      .word   0     ;program counter               ");
asm("_FREERUN .word   0     ;1= free run, 0= HALT          ");
asm("_dT      .word   0     ;TIM1 delta between run-halt   ");
asm("_CTXTPTR                                              ");
asm("CPUCTXT  .word   _F0   ;                              ");
asm("_STEPACK .word   0     ;                              ");
asm("DMA_IE   .word   00040400h  ;                         ");
asm("_SPIN    .word   0     ;                              ");
extern long     SPIN;
extern long       dT;
extern long  FREERUN;
extern long  CTXTPTR;
extern long  STEPACK;

long  DSPDMABUF          [8]; // DSP buffer 8 nibbles/32 long
long  DSPCMD             [8];
long *DSPAppPtr      =DSPCMD;
long  PcktCnt        =     1;
int   DMA_MODE       =  RECV; // Current DMA direction
volatile long  SPFLAG         =     1;
extern long  WSHIFT;
extern long WSCOUNT;
extern long DMABUF;
//--------------------------------------------------------------
#define  DMA_RUN          0xC53  // No sycnh, just run DMA
#define  DMA_RUN_R        0xD53  // Srce (read) synch
#define  DMA_RUN_W        0xE53  // Dest (write) synch
#define  DMA_RUN_RW       0xF53  // Read & Write synch
//--------------------------------------------------------------
  asm("DMA_CTRL   .set  0808000h   ");
  asm("DMA_SRCE   .set  0808004h   ");
  asm("DMA_DEST   .set  0808006h   ");
  asm("DMA_COUNT  .set  0808008h   ");
  asm("DMA_RUN_R  .set     0D53h   ");
  asm("DMA_RUN_RW .set     0F53h   ");
//enum DMADIR{SEND=0,SENDSTART=1,RECV=2,RECVSTART=3,NODMA=4};
  asm("RECV       .set         2   ");
  asm("HPIADDR    .word 0F00000h   ");
  asm("_DMABUF    .word _DSPDMABUF ");

#define INLINE     1

#if  INLINE
  asm("_c_int03                  ");
  asm("   push   st              ");
  asm("   push   R0              ");
  asm("   ldi    @HPIADDR,R0     ");
  asm("   sti    R0,@DMA_SRCE    ");
  asm("   ldi    @_DMABUF    ,R0 ");
  asm("   sti    R0,@DMA_DEST    ");
  asm("   ldi    4           ,R0 ");
  asm("   sti    R0,@DMA_COUNT   ");
  asm("   ldi    DMA_RUN_R   ,R0 ");
  asm("   sti    R0,@DMA_CTRL    ");
  asm("   ldi    @HPIADDR,R0     ");
  asm("   sti    R0,@DMA_SRCE    ");
  asm("   ldi    @_DMABUF,R0     ");
  asm("   sti    R0,@DMA_DEST    ");
  asm("   ldi    4,R0            ");
  asm("   sti    R0,@DMA_COUNT   ");
  asm("   ldi    DMA_RUN_R,R0    ");
  asm("   sti    R0,@DMA_CTRL    ");
  asm("   pop    R0              ");
  asm("   andn   404h,IF         ");
  asm("   andn   4h,IE           "); // Turn off INT2
  asm("   or     @DMA_IE,IE      "); // Turn on DINT and DMA synch interrupt
  asm("   pop    st              ");
  asm("   reti                   ");
#else
void c_int03(void)
{
  *dma_srce  =      HOSTXFRBUF;
  *dma_dest  = (long)DSPDMABUF;
  *dma_xfr   =               4;
  *dma_ctrl  =       DMA_RUN_R;
  asm("   andn     404h,IF  ");
  asm("   andn       4h,IE  "); // Turn off INT2
  asm("   or    @DMA_IE,IE  "); // Turn on DINT and DMA synch interrupt
}
#endif

//------------------------------------------------------------
void c_int11(void)
{
  int i;
  unsigned long temp;
  #if INLINE
  asm("       .global RCVR1,RCVR2,RCVR3 ");
  asm("RCVR1  push    R0                  ");
  asm("       push    R1                  ");
  asm("       push    AR0                 ");
  asm("       push    AR1                 ");
  asm("       ldi     @_DMA_MODE,R0       ");
  asm("       cmpi    RECV,R0             ");
  asm("       bne     RCVR3               ");
  asm("RCVR2  ldi     0FFh,AR1            ");
  asm("       ldi     @_DMABUF,AR0        ");
  asm("       and3    *AR0++,AR1,R1       ");
  asm("       and3    *AR0++,AR1,R0       ");
  asm("       lsh     8,R0                ");
  asm("       or      R0,R1               ");
  asm("       and3    *AR0++,AR1,R0       ");
  asm("       lsh     16,R0               ");
  asm("       or      R0,R1               ");
  asm("       and3    *AR0++,AR1,R0       ");
  asm("       lsh     24,R0               ");
  asm("       or      R0,R1               ");
  asm("       ldi     @_DSPAppPtr,AR0     ");
  asm("       sti     R1,*AR0++           ");
  asm("       sti     AR0,@_DSPAppPtr     ");
  asm("RCVR3  pop     AR1                 ");
  asm("       pop     AR0                 ");
  asm("       pop     R1                  ");
  asm("       pop     R0                  ");

  #else
  if(DMA_MODE==RECV)
  {
    temp  = (DSPDMABUF[0] & 0xFF)    ;
    temp |= (DSPDMABUF[1] & 0xFF)<< 8;
    temp |= (DSPDMABUF[2] & 0xFF)<<16;
    temp |= (DSPDMABUF[3] & 0xFF)<<24;
    *DSPAppPtr++ = temp;
  }
  #endif
  if(PcktCnt<=0)
  {
    DMA_MODE  =         RECV;  // Setup to DMA receive 1 command
    DSPAppPtr =       DSPCMD;
    PcktCnt   =            1;
    asm("    push  R0         ");
    asm("    ldi   150,R0     "); // 3uS delay
    asm("    subi  1,R0       ");
    asm("    bgt   $-1        ");
    asm("    pop   R0         ");
    asm("    or    4h,IE      ");
    asm("    andn  @DMA_IE,IE ");
    asm("    andn  4h,IF      ");
    return;
  }
  switch(DSPCMD[0]) // Simulate commands coming from host
  {
    default:     break;
//  case XRUNF : break;
    case XCTXT : DMA_MODE  =            SEND;
                 PcktCnt   =               1;
                 DSPAppPtr =(long *)&CTXTPTR;
                 break;
    case XSTEP : DMA_MODE  =            SEND;
                 PcktCnt   =               1;
                 DSPAppPtr =(long *)&STEPACK;
                 break;
    case XHALT : DMA_MODE  =            SEND;
                 PcktCnt   =               1;
                 DSPAppPtr =(long *)&CTXTPTR;
                 break;
    //------------------------------------------------------
    case XREAD2 :if(PcktCnt>1) break;
                 DSPCMD[0] =           W_HOST;
                 DMA_MODE  =             SEND;
                 DSPAppPtr =(long *)DSPCMD[2];
                 PcktCnt   =        DSPCMD[1];
                 break;
    case XREAD : DSPCMD[0] =           XREAD2;
                 PcktCnt   =                4;
                 break;
    //------------------------------------------------------
    case XWRITE2:if(PcktCnt>1) break;
                 DSPCMD[0] =           R_HOST;
                 DSPAppPtr =(long *)DSPCMD[2];
                 PcktCnt   =        DSPCMD[1];
                 break;
    case XWRITE: DSPCMD[0] =          XWRITE2;
                 PcktCnt   =                4;
                 break;
  }
  PcktCnt--;
  switch(DMA_MODE)
  {
    case SEND:
                #if  INLINE
                asm("   .global WX,WH,WE      ");
                asm("WX push  R0              ");
                asm("   push  AR0             ");
                asm("   push  AR1             ");
                asm("   ldi   @_DSPAppPtr,AR0 ");
                asm("   ldi   *AR0++,R0       ");
                asm("   sti   AR0,@_DSPAppPtr ");
                asm("   ldi   @_DMABUF,AR0    ");
                asm("   sti   AR0,@DMA_SRCE   ");
                asm("   ldi   @_WSCOUNT,AR1   ");
                asm("WH sti   R0,*AR0++       ");
                asm("   lsh   @_WSHIFT,R0     ");
                asm("   db    AR1,WH          ");
                asm("   ldi   @HPIADDR,R0     ");
                asm("   sti   R0,@DMA_DEST    ");
                asm("   ldi   @_WSCOUNT,R0    ");
                asm("   addi  1,R0            ");
                asm("   sti   R0,@DMA_COUNT   ");
                asm("   ldi   DMA_RUN_R ,R0   ");
                asm("   sti   R0,@DMA_CTRL    ");
                asm("   pop   AR1             ");
                asm("   pop   AR0             ");
                asm("WE pop   R0              ");
                #else
                temp = *DSPAppPtr++;
                for(i=0;i<=WSCOUNT;i++)
                {
                  DSPDMABUF[i] = temp;
                  temp = temp >> -WSHIFT;
                }
                *dma_srce  =(long) DSPDMABUF;
                *dma_dest  =      HOSTXFRBUF;
                *dma_xfr   =       WSCOUNT+1;
                *dma_ctrl  =       DMA_RUN_R;
                #endif
                asm("   or    4,IF            ");
                break;
    case RECV:
                #if  INLINE
                asm("   push  R0            ");
                asm("   ldi   @HPIADDR,R0   ");
                asm("   sti   R0,@DMA_SRCE  ");
                asm("   ldi   @_DMABUF,R0   ");
                asm("   sti   R0,@DMA_DEST  ");
                asm("   ldi   4,R0          ");
                asm("   sti   R0,@DMA_COUNT ");
                asm("   ldi   DMA_RUN_RW,R0 ");
                asm("   sti   R0,@DMA_CTRL  ");
                asm("   pop   R0            ");
                #else
                *dma_srce  =      HOSTXFRBUF;
                *dma_dest  = (long)DSPDMABUF;
                *dma_xfr   =               4;
                *dma_ctrl  =      DMA_RUN_RW;
                #endif
    default:    break;
  }
//This goes after the SEND is initiated
/*
  asm("spin0   ldi   @_SPIN,R0     ");
  asm("        bz    FREE          ");
  asm("        or    @DMA_IE,IE    ");
  asm("        or    2000h,ST      ");
  asm("        b     spin0         ");
  asm("FREE    andn  2000h,ST      ");
*/
//asm("   andn       4h,IE  "); // Turn off INT2
  asm("   or    @DMA_IE,IE  "); // Turn on DINT and DMA synch interrupt
}
/*===================================================================
  The ADC data is read and buffered here
 ====================================================================*/
inline float Input(void)
{
  int   x;
  float f;
  x = *S0_rdata;     /*get ADC data                         */
  x = x >> 16;       /* Sign extend previous sample in MSBs */
  f = x;             /* Convert the ADC data to float       */
  return f;
}
/*===================================================================
  The output section is written for both Spectrum analyzer output
  as well as REAL/IMAG filter sum outputs
 ====================================================================*/
inline void Output(float f)
{
  int x;
  x = f;
  x &= 0xFFFC;
  *S0_xdata = x;
}
/*===================================================================
  The startup stub is used during initialization only and can be
  overwritten by the stack or data after initialization is complete.
  Note: A DSK or RTOS communications kernel may also use the stack.
  In this case be sure to not put the stack here during debug.
 ====================================================================*/
void ST_STUB(void)
{
   *T0_ctrl = 0;         /* Halt TIM0           */
   *T0_count= 0;         /* Set counts to 0     */
   *T0_prd  = TIM0_prd;  /* Set period          */
   *T0_ctrl = 0x2C1;     /* Restart both timers */
   /* - - - - - - - - - - - - - - - - - - - - - */
   *S0_xctrl = S0xctrl;  /* transmit control    */
   *S0_rctrl = S0rctrl;  /* receive  control    */
   *S0_xdata =       0;  /* DXR data value      */
   *S0_gctrl = S0gctrl;  /* global control      */
    AIC_INIT();
}
/*================================================
  This function initializes the AIC
 ================================================*/
void AIC_INIT(void)
{
  asm("  andn  034h,IF  ");
  asm("  ldi   004h,IE  ");  /* Enable only INT2 */
  *S0_xdata = 0;
  asm(" rpts  0040h     ");
  asm(" ldi   2,IOF     ");  /* XF0=0 resets AIC */
  asm(" ldi   6,IOF     ");  /* XF0=1 runs AIC   */
  asm(" rpts  040h      ");
  asm(" nop             ");
  asm("  andn  034h,IF  ");
  asm("  ldi   014h,IE  ");  /* Enable only XINT interrupt */
  /*- - - - - - - - - - - -*/
  prog_AIC(C_REG   );      /* program control register */
  prog_AIC(0xFFFC  );      /* Program the AIC to be real slow */
  prog_AIC(0xFFFC|2);      /* Program the AIC to be real slow */
  prog_AIC(B_REG   );      /* Bump up the Fs to final rate    */
  prog_AIC(A_REG   );      /* smaller divisors sent first     */
  asm("  or  080h,ST");    /* Use the overflow mode for fast saturate */
}
/*===================================================================
  prog_AIC is used to transmit new timing configurations to the AIC.
  If you single step this routine, the AIC timing will be corrupted
  causing AIC programming to fail.
  STEP OVER THIS ROUTINE USING THE F10 FUNCTION STEP
 ====================================================================*/
void prog_AIC(int xmit2)
{
  int x;
  *S0_xdata =     0; asm(" idle "); /* Pre transmit a safe value       */
  *S0_xdata =     3; asm(" idle "); /* Request 2ndy xmit               */
  *S0_xdata = xmit2; asm(" idle "); /* Send register porgram value     */
  *S0_xdata =     0; asm(" idle "); /* Leave with a safe value         */
  x = *S0_rdata;                    /* Fix rcvr underrun by dummy read */
}
void c_int05(void)
{
  SPFLAG = 1;
}
void c_int06(void)
{
  SPFLAG = 1;
}

//------------------------------------------------------------
void main(void)
{
   float    f;
   float sign;
   sign=1;
   DSPCMD[0] = NOCMD;
   ST_STUB();
   asm("  ldi   0E0h,IE     ");  /* Enable XINT/RINT/INT2          */
   asm("  idle              ");  /* Wait for Receive Interrupt     */
   f = (float)*S0_rdata;         /* The first int occurs shortly   */
   *S0_xdata = 0;                /* after AIC init is complete     */
   asm("  ldi   0h,IF    ");
   asm("  or    4h,IE    ");  // respond to host and dma interrupts
   asm("  or    2000h,ST ");
   f = 0;
   for(;;)
   {
     dT++;
     for(;;)
     {
  //   asm("  idle              "); // Wait for Receive Interrupt
  //   asm("  rpts 2            ");
  //   asm("  andn 2000h,ST     "); // No host ints during analog loop
       *S0_xdata = *S0_xdata;       // Refresh DXR
    // Output(f);
       if(SPFLAG) break;
     }
     SPFLAG = 0;
     /*
     if(PLAY_WAV)
     {
       f = Input();
       f = *wavplayptr++;
       Output(f);
       if(wavplayptr >= playbuf+bufsize) wavplayptr = playbuf;
       for(i=0;i<bufsize)
       {
         playbuf[i] = (hostbuf[i]<<16)>>16;
       }
     }
     else
     {
       f = Input();
       f = *wavplayptr++;
       Output(f);
       if(wavplayptr >= playbuf+bufsize) wavplayptr = playbuf;
       for(i=0;i<bufsize)
       {
         playbuf[i] = (hostbuf[i]<<16)>>16;
       }
     }
     */
     f    = Input();        // Put ADC sample in delay buffer
//   f    = f*sign;
//   sign = -sign;
     Output(f);             // Output result
   }
}
//------------------------------------------------------------
asm("   .global SIZELOC,VECTLOC    ");
asm("   .global DASMBGN,STEPLOC    ");
asm("   .global SP_DFLT            ");
asm("   .global _WSCOUNT,_WSHIFT   ");
asm("SIZELOC                       ");
asm("_WSCOUNT .word  7             ");
asm("_WSHIFT  .word  -4            ");
asm("VECTLOC  .word  0809FC1h      ");
asm("DASMBGN  .word  0809800h      ");
asm("STEPLOC  .word  $+1           ");
asm("         or     4,IE          ");
asm("SP_DFLT  .word  0809C00h      ");
asm("         .text                ");
asm("         .global br_int2,br_dint   ");
asm("         .global _c_int03,_c_int11 ");
asm("         .sect  \"BR_INT2\"        ");
asm("br_int2  br     _c_int03           ");
asm("         .sect  \"BR_DINT\"        ");
asm("br_dint  br     _c_int11           ");
asm("         .text                     ");
/*===================================================================
  Install the XINT/RINT ISR branch vectors
 ====================================================================*/
  asm(" .sect  \"BRTBL\"");  /* secondary branch table */
  asm(" br  _c_int05    ");  /* XINT0                  */
  asm(" br  _c_int06    ");  /* RINT0                  */
  asm(" .text           ");
/*===================================================================
  Recreate the C31 vector table in the bootrom if using an EVM
 ====================================================================*/
  asm(" .sect  \"VECTS\"   "); /* secondary branch table  */
  asm(" .word  0000045h    ");  /* Reset                  */
  asm(" .word  0809FC1h    ");  /* INT0                   */
  asm(" .word  0809FC2h    ");  /* INT1                   */
  asm(" .word  0809FC3h    ");  /* INT2  (Debug Host int) */
  asm(" .word  0809FC4h    ");  /* INT3                   */
  asm(" .word  0809FC5h    ");  /* XINT0                  */
  asm(" .word  0809FC6h    ");  /* RINT0                  */
  asm(" .word  0809FC7h    ");  /* XINT1 (Debug SSTEP)    */
  asm(" .word  0809FC8h    ");  /* RINT1                  */
  asm(" .word  0809FC9h    ");  /* TINT0                  */
  asm(" .word  0809FCAh    ");  /* TINT1                  */
  asm(" .word  0809FCBh    ");  /* DMA                    */
  asm(" .text               ");
