;---------------------------------------------------------------------
; DMA.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; This is a simple test program showing how to start the DMA which
; then moves a block of data under interrupt control.  Interrupts are
; set by the CPU allowing the user to see the DMA move each value
; while singlestepping in the debugger
;---------------------------------------------------------------------
         .include "C3XMMRS.ASM" ;
         .start ".text",0x809800;
         .text                  ;
         .entry                 ;
SWS      .set     1             ;
         ldp      stack         ;
         ldi      @stack,SP     ;
         ;----------------------
         ldi      @p_buscon,R0  ;
         andn     7<<5,R0       ; Clear SWS field
         or       SWS<<5,R0     ; Set sws
         sti      R0,@p_buscon  ;
         ;----------------------
main     ldi      0,R0          ; Zero the destination array
         ldi      @DMA_DEST,AR0 ;
         ldi      SRCE2-SRCE,RC ;
         rptb     ZERO          ;
ZERO     sti      R0,*AR0++     ;
         ;----------------------
StartDMA ldi      0,R0          ; Stop DMA
         sti      R0,@DMA_ctrl  ;
         ldi      @DMA_SRCE,R0  ; Load source, dest and xfr length
         sti      R0,@DMA_srce  ;
         ldi      @DMA_DEST,R0  ;
         sti      R0,@DMA_dest  ;
         ldi      SRCE2-SRCE+1,R0;
         sti      R0,@DMA_xfr   ;
         ;----------------------
Begin    and      0,IF          ; clear all previous interrupts
         ldi      0x553,R0      ; Start DMA, DMA config tells DMA to
         sti      R0,@DMA_ctrl  ; transfer on interrupt, but does NOT stop
         or       @DMAENBL,IE   ; when the count goes to zero.
         ldi      SRCE2-SRCE,RC ; Set INT0 to signal each transfer
         rptb     LOOP          ;
         b        $+1           ; CPU has priority if in same on chip
LOOP     or       1,IF          ; ram block.  Branch frees 3 cycles/loop
         b        main          ;
         ;--------------------
DMAENBL  .word    0x000100C4    ; Enable INT0 (dma) and DSK debug interrupts
DMA_SRCE .word    SRCE          ; Toggle the Addr lsbs to indentify read/writes
DMA_DEST .word    DEST          ;
;-------------------------------
SRCE      .word    0x11111111   ;
          .word    0x22222222   ;
          .word    0x33333333   ;
          .word    0x44444444   ;
          .word    0x55555555   ;
          .word    0x66666666   ;
          .word    0x77777777   ;
          .word    0x88888888   ;
          .word    0x99999999   ;
SRCE2     .word    0xAAAAAAAA   ;
          ;---------------------
DEST      .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
          .word    0x00000000   ;
;-------------------------------
stack    .word    stack         ;
          .end
