/*=======================================================================
  DMA_C.C
  Keith Larson
  TMS320 DSP Applications
  (C) Copyright 1996,1997,1998
  Texas Instruments Incorporated

  This is unsupported freeware with no implied warranties or
  liabilities.  See the C3x DSK disclaimer document for details
-----------------------------------------------------------------------
  This example shows how to set up a DMA block transfer of items
  from one array to another using an interrupt triggered by the CPU.

Question: Global and interrupt enable bit in status register
    - does it disable the DMA interrupt in addition to CPU interrupt?

Answer: No. The GIE bit only enables interrupts to the CPU.

        Within the DMA global control register there are two 'SYNC'
        bits.  One bit causes the DMA to synchronize an interrupt to
        the READ half of the DMA cycle, and the other WRITE.  If both
        bits are set, it will take two interrupts to transfer one
        data item.

NOTE: The CPU must fetch an instruction for an interrupt flag to
      be updated. Since the DMA and CPU share the same interrupt
      flags, this would also be true for the DMA.  The CPU must
      be allowed to fetch an instruction.

=====================================================================*/
#include "C3MMR.H"
#define LENGTH  16
float SRCE[LENGTH];
float DEST[LENGTH];
/********************************************************/
void main(void)
{
  float f;
  int x;
  for(x=0;x<LENGTH;x++)             /* Initialize SRCE/DEST arrays  */
  {
    SRCE[x]=x;
    DEST[x]=0;
  }
  asm(" push R0      ");            /* Enable a DMA interrupt        */
  asm(" ldi  20h,R0  ");
  asm(" lsh  16,R0   ");
  asm(" or   R0,IE   ");
  asm(" pop  R0  ");
  for(;;)
  {
    *dma_ctrl  =  0;                 /* Halt and reset DMA state      */
    *dma_srce  =  (long)&SRCE;
    *dma_dest  =  (long)&DEST;
    *dma_xfr   = LENGTH;
    *dma_ctrl  =  0x553;             /* Start DMA with source sync    */
    for(;;)
    {
      asm(" or   20h,IF  ");         /* INT=1 flag transfers one item */
      if(*dma_xfr==0) break;         /* Exit if DMA finished          */
    }
    for(x=0;x<LENGTH;x++) DEST[x]=0; /* Clear DEST[] for next loop    */
  }
}

/*===================================================================
  Recreate the C31 vector table in the bootrom if using an EVM
 ====================================================================*/
  asm(" .sect  \"VECTS\"   ");  /* secondary branch table */
  asm(" .word  0000045h");      /* Reset                  */
  asm(" .word  0809FC1h    ");  /* INT0                   */
  asm(" .word  0809FC2h    ");  /* INT1                   */
  asm(" .word  0809FC3h    ");  /* INT2  (Debug Host int) */
  asm(" .word  0809FC4h    ");  /* INT3                   */
  asm(" .word  0809FC5h    ");  /* XINT0                  */
  asm(" .word  0809FC6h    ");  /* RINT0                  */
  asm(" .word  0809FC7h    ");  /* XINT1 (Debug SSTEP)    */
  asm(" .word  0809FC8h    ");  /* RINT1                  */
  asm(" .word  0809FC9h    ");  /* TINT0                  */
  asm(" .word  0809FCAh    ");  /* TINT1                  */
  asm(" .word  0809FCBh    ");  /* DMA                    */
  asm(" .text               ");
/*===================================================================*/
