//----------------------------------------------------------------------
// DSKGRAPH.CPP        Graphs DSK data at a user defined address
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//----------------------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <bios.h>
#include <graphics.h>
#include <math.h>
#include "DSK.H"
#include "EXP_ANAL.H"
//===================================================================
//Constants for functions and setup
//===================================================================
ulong   GSIZE   = 512;
#define Xd        512                   // X pix width
#define xd        52                    // X pix/division
#define Yd        260                   // Y pix height
#define yd        20                    // Y pix/division
//===================================================================
typedef enum GRAPHMODES
{
  LIN_LIN,
  LIN_LOG,
  LOG_LIN,
  LOG_LOG
};
typedef enum NUMTYPES
{
  IEEE_FLOAT,
  TMS_FLOAT,
  INT,
  UINT,
  LONG,
  ULONG
};

NUMTYPES DATATYPE = TMS_FLOAT;

float f_gain = 1.0;

int   graphmode  =         LIN_LIN;           // Which type of bode display
char  DSK_APP    []="DSK_GRPH.OUT";     //
char  DSK_EXE_APP[]="DSKGRAPH.EXE";     //
ulong DSP_addr   = 0x809900L;
char  Message[2000];
//-------------------------------------------------

typedef struct CMPLX
{
  ulong R;
  ulong I;
}cmplx;
//---------------------------------------------------
ulong DSPDATA[1024];   // do only 3 bins are required
//---------------------------------------------------
void  binsprintf       (char *s,int val);
int   check_key        (void);
void  graph            (void);
float bode            (int x);
//---------------------------------------------------
void init_graphics(void)
{
  int gdriver = EGA, gmode = EGAHI, errorcode;
  //
  // register EGAVGA_driver which is the name of the driver in EGAVGA.OBJ
  // EGAVGA.OBJ is created from EGAVGA.BGI using the BGIOBJ.EXE utility
  // and is linked by either the link list or project file
  //
  // NOTE: This section of code can be ommitted if EGAVGA.BGI is
  //       located in the applications startup directory
  //
  errorcode = registerbgidriver(EGAVGA_driver);
  if (errorcode < 0)  // report any registration errors
  {
    printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");
    getch();
    exit(1); // terminate with an error code
  }
  initgraph(&gdriver, &gmode, "");        // if possible open EGA mode
  errorcode = graphresult();
  if (errorcode != grOk)
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");
    getch();
    exit(1);
  }
  clearviewport();
}
//---------------------------------------------------------
int inline xwarp(float in)
{
  return(1 + 50*log(in));
}
//---------------------------------------------------------

void graph(void)
{
  float MAG;
  ulong l;
  int yc=0,xc;
  int dB;
  int Yt;
  int Y;
  int x;
  int d;
  float f0;
  float f1;
  float f2;
  char MSG[32];
  init_graphics();
  setcolor(WHITE);
  moveto(0,0);
  //------------------------------------------
  // Plot vertical lines and Freq markers
  //------------------------------------------
  setcolor(LIGHTGRAY);
  switch(graphmode)
  {
    default:
    case LIN_LIN:
          for(d=0;d<11;d++)
          {
            x = d * (float)GSIZE/20.0;
            f2 =  x;
            if((f2>=  0)&&(f2<1E3)) sprintf(MSG,"%0.1f" ,f2     );
            if((f2>=1E3)&&(f2<1E6)) sprintf(MSG,"%0.1fk",f2*1E-3);
            if((f2>=1E6)&&(f2<1E9)) sprintf(MSG,"%0.1fM",f2*1E-6);
            xc = Xd*d/10.0;
            line(xc-1,Yd,xc-1,Yd+4);
            line(xc  ,Yd,xc  ,Yd+4);
            line(xc+1,Yd,xc+1,Yd+4);
            outtextxy(xc,Yd+10,MSG);
            setcolor(GREEN);
            line(xc,0,xc,Yd);
            setcolor(LIGHTGRAY);
          }
          xc = Xd;
          break;

    case LIN_LOG:
          f1=1;
          f2=1;
          setcolor(LIGHTGRAY);
          for(f0=1;f0<100e3;)
          { if(f1==1)
            { if((f2>=  0)&&(f2<1E3)) sprintf(MSG,"%0.0fhz" , f1*f2);
              if((f2>=1E3)&&(f2<1E6)) sprintf(MSG,"%0.0fkhz",(f1*f2)*1E-3);
              if((f2>=1E6)&&(f2<1E9)) sprintf(MSG,"%0.0fMhz",(f1*f2)*1E-6);
              xc = xwarp(f1*f2);
              line(xc-1,Yd,xc-1,Yd+4);
              line(xc  ,Yd,xc  ,Yd+4);
              line(xc+1,Yd,xc+1,Yd+4);
              outtextxy(xc,Yd+10,MSG);
            }
            f0 = f1 * f2;
            xc = xwarp(f1*f2);
            if(xc<0) xc=0; if(xc>Xd) xc=Xd;
            setcolor(GREEN);
            line(xc,0,xc,Yd);
            setcolor(LIGHTGRAY);
            f1++;
            if(f1>=10)
            {
              f1=1;
              f2*=10;
            }
            f0 = f1*f2;
          }
          break;
  }
  //------------------------------------------
  // Plot horizontal lines and dB markers
  //------------------------------------------
  setcolor(GREEN);
  Yt = yd-11;
  dB = 20;
  for(Y=0;Y<=Yd;Y+=yd)
  {
    line(0,Y,xc,  Y);  // draw reticle
    if(Y<Yd)
    {
      sprintf(MSG,"%+02d",dB);
      outtextxy(2,Yt,MSG);
    }
    dB -= 10;
    Yt += yd;
  }
  //------------------------------------------
  // Now graph the response
  //------------------------------------------
  setcolor(WHITE);
  moveto(0,Yd);
  // Graph response
  //
  // dBscale = yd / 20; //yd/20*log10(10^.5);
//  if(getmem(DSP_addr ,GSIZE,(ulong *)DSPDATA)!=NO_ERR) return;

  moveto( 0, 0);
  for(x=0;x<GSIZE;x++)
  {
    l = DSPDATA[x];

    switch(DATATYPE)
    {
      case IEEE_FLOAT:
      case TMS_FLOAT : f0 = TMS_IEEE(l); break;
      case INT       : f0 =           l; break;
    }
    MAG = f0 * f_gain*10;

    switch(graphmode)
    {
      case LIN_LIN:
      case LOG_LIN: break;
      case LIN_LOG:
      case LOG_LOG: if(MAG < .0001) MAG = .0001;
                    MAG = log(MAG); break;
    }
    yc = MAG;
    xc =   x;
    if(yc<0) yc=0; if(yc>Yd) yc=Yd;
    if(xc<0) xc=0; if(xc>Xd) xc=Xd;
    lineto(xc,yc);
  }
  getch();
  closegraph();
}
//--------------------------------------------------
void main(void)
{
  int reset_flag = 0;
  clrscr();
  Scan_Command_line(DSK_EXE_APP);
  clrscr();
  //------------------------------------------------
  // The outer loop initializes the DSK on entry
  // or if the application fails
  //------------------------------------------------
  for(;;)
  {
    for(;;)
    { if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }
    HALT_CPU(); // Halt previously running apps code
    //-----------------------------------------------
    // Get the location of the coefficients from the
    // symbol table which has been loaded into the host
    //-----------------------------------------------
//  ref_value("DSP_addr"    , &(long)DSP_addr);
    //-----------------------------------------------
    RUN_CPU();  // Start the application running
    clrscr();
    check_key();
    //***********************************************************//
    // The inner loop is repeated until a keyboard hit exits the //
    // application or the application reports an error and needs //
    // to be reinitialized.                                      //
    //***********************************************************//
    for(;;)
    { for(;;)
      { //
        // Wait for a key to be pressed, and then update the generator
        // analyzer if directed to do so.
        //
        if(kbhit())
        {
          reset_flag = check_key();
          break;
        }
        delay(1);
      }
      if(reset_flag) break;
    }
    printf("Communications are being reinitialized");
    DSK_reset();
  }
}
//---------------------------------------------
int inline clipint(int x, int min, int max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}
//---------------------------------------------
long inline cliplong(long x, long min, long max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}
//---------------------------------------------
void get_float(float *f, char *s)
{
  float ftemp;
  char strng[40];
  printf("%s=%7.8f ",s,*f);
  scanf(" %20s",&strng);
  ftemp = atof(strng);
  *f = ftemp;
}
//---------------------------------------------
int check_key(void)
{
  float f;
  char *c, instrg[80];
  int x,y,key=0;
  ulong addr, *ulptr,l;
  MSGS err;
  //
  // If the last keystroke caused a DTMF signal to be generated
  // wait for the key to be released before moving on.  Note
  // that the keyboards typematic rate is a potential problem here
  // and that the minimum DTMF period is 100mS
  //
  if(kbhit())
  {
// if(bioskey(2) & 3)  shift_key = 1;
    key = bioskey(0) & 0xFF00;
  }

  if(key)
  {
    switch(key)
    {
      //============== Quit (with run optional), Reset ======//
      case _R  : return 1;  // Return reset (break) flag
      case _Q  : clrscr();
                 _setcursortype(_NORMALCURSOR);
                 DSK_reset();
                 exit(0);
                 break;
      //=========== Graph the response =======================//
      case _G:  graph(); break;
      case _M:  switch(graphmode)
                {
                  default:
                  case LIN_LIN: graphmode = LIN_LOG; break;
                  case LIN_LOG: graphmode = LOG_LIN; break;
                  case LOG_LIN: graphmode = LOG_LOG; break;
                  case LOG_LOG: graphmode = LIN_LIN; break;
                }
                break;
      case _S:  printf("\nLoad symbols from: ");
                scanf("%60ns",instrg);
                Load_File(instrg,SLOAD);
                break;
      case _L:  printf("\nLoad file (w/syms): ");
                scanf("%60s",instrg);
                err = Load_File(instrg,LOAD );
                if(err!=NO_ERR)
                {
                  printf("FLOAD>%s: %s\n",instrg,Error_Strg(err)); getch();
                }
                err = Load_File(instrg,SLOAD);
                if(err!=NO_ERR)
                {
                  printf("FLOAD>%s: %s\n",instrg,Error_Strg(err)); getch();
                }

                break;

      case _D:  switch(DATATYPE)
                {
                  default:
                  case INT       : DATATYPE =       UINT; break;
                  case UINT      : DATATYPE =       LONG; break;
                  case LONG      : DATATYPE =      ULONG; break;
                  case ULONG     : DATATYPE =  TMS_FLOAT; break;
                  case TMS_FLOAT : DATATYPE = IEEE_FLOAT; break;
                  case IEEE_FLOAT: DATATYPE =        INT; break;
                }
                break;

      case _Pup: DSP_addr-=24; break;  // Page window up
      case _Pdn: DSP_addr+=24; break;  // Page window down
      case _Up : DSP_addr-= 4; break;  // Scroll up
      case _Dn : DSP_addr+= 4; break;  // Scroll down

      case _A:  // Convert string input using epxression analyzer
                printf("\nInput expression for address: ");
                scanf("%60s",instrg);
                expressionz(instrg, &DSP_addr, NT_INTEGER);
                break;
      //============== Default - do nothing  =================//
      case _Spc: break;
      default : return 0;
    }
  }
  clrscr();
  //
  // Update Fsx and Fsr frequency
  //
  gotoxy(1,1);
  printf(
"ͻ\n"
"Quit Reset Graph Mode Data Address Length Symbols  ShowSym Load Stride Run\n"
"ͼ\n");
  textcolor(WHITE);
  cprintf("Addr = %08lx\n\r",(long)DSP_addr);
  switch(graphmode)
  {
    default:
    case LIN_LIN:cprintf("Mode = Lin X, Lin Y\n\r"); break;
    case LIN_LOG:cprintf("Mode = Lin X, Log Y\n\r"); break;
    case LOG_LIN:cprintf("Mode = Log X, Lin Y\n\r"); break;
    case LOG_LOG:cprintf("Mode = Log X, Log Y\n\r"); break;
  }
  switch(DATATYPE)
  {
    default:
    case INT       : cprintf("Data = Signed int\n"   ); break;
    case UINT      : cprintf("Data = Unsigned int\n" ); break;
    case LONG      : cprintf("Data = Signed long\n"  ); break;
    case ULONG     : cprintf("Data = Unsigned long\n"); break;
    case TMS_FLOAT : cprintf("Data = TMS float\n"    ); break;
    case IEEE_FLOAT: cprintf("Data = IEEE float\n"   ); break;
  }
  printf("\r");

  if(getmem(DSP_addr ,GSIZE,(ulong *)DSPDATA)!=NO_ERR) return -1;

  addr = DSP_addr;
  c = Message;
  ulptr = DSPDATA;

  c+=sprintf(c,
  "C31DSK MEMORY VIEW UTILITY\r\n"
  "--------------------------\r\n"
  "PGUP,PGDN,UP,DN - Scroll window\r\n");
  for(y=0;y<6;y++)
  {
    c+=sprintf(c,"0x%08lx > ",addr);
    addr += 4;
    for(x=0;x<4;x++)
    {
      switch(DATATYPE)
      {
        default:
        case INT       :
        case UINT      :
        case LONG      :
        case ULONG     : c+=sprintf(c,"%08lx ",*ulptr++); break;

        case TMS_FLOAT : f = TMS_IEEE(*ulptr++);
                         c+=sprintf(c,"%+9.3e ",f);
                         break;

        case IEEE_FLOAT: l = *ulptr++;
                         f = *((float *)&l);
                         if((f>2E38)||(f<-2E38)) f = 0;
                         c+=sprintf(c,"%+9.3e ",f);
                         break;
      }
    }
    c+=sprintf(c,"\r\n");
  }
  cprintf(Message);

  return 0;
}
//---------------------------------------------------------
void binsprintf(char *s,int val)
{
  char *p;
  unsigned int t;
  p = s;
  t = 0x80;  // scan 8 bits
  for(;t>0;t=t>>1)
  {
    if(val & t) *p++ = '1';
    else        *p++ = '0';
  }
  *p=0;
}
// This application does not require a link of every API
// to the debugger and assembler. Fake functions and
// symbols are used to satisfy the linker
//
void Cmd_Msg(char *ptr,int ATTR,int outmsg, int endpos)
{
  ATTR++;
  outmsg++;
  endpos++;
  if(*ptr) *ptr='A';
}

MSGS assm_error_msg(MSGS err,char *strg)
{
  sprintf(Message,"%s %s\n",strg,Error_Strg(err));
  return NO_ERR;
}
int g_pass = 1;
FILE *dsk_file;
