//------------------------------------------------------------
// DSK_FREQ.CPP     Precision frequency counter
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  File          Where
//  ----------------------
//  DSK_FREQ.CPP  DSK3APPS
//  DRIVER.CPP    COMMON
//  DSK_COFF.CPP  COMMON
//  ERRORMSG.CPP  COMMON
//  OBJECT.CPP    COMMON
//  SYMBOLS.CPP   COMMON
//  TARGET.CPP    COMMON
//  TEXTWIN.CPP   COMMON
//------------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <bios.h>
#include <math.h>
#include "DSK.H"
#include "DSK_COFF.H"
#include "C3XMMRS.H"
#include "keydef.h"

#define LOAD_FLAG 0x809C00L  // write a non-zero to reload AIC
#define T0_PRD    0x809C01L
#define T0_CNT    0x809C02L
#define T1_PRD    0x809C03L
#define T1_CNT    0x809C04L
#define T0_LAST   0x809C05L
#define T1_LAST   0x809C06L
#define DT0       0x809C07L
#define DT1       0x809C08L

#define THx 40e-9 // DSP cycle time H1/H3 clock rate

char  DSK_APP[]    ="DSKFREQ.DSK";
char  DSK_EXE_APP[]="DSK_FREQ.EXE";
ulong T0_prdv      =  0x20000L;
ulong T1_prdv      =  0x20080L;
ulong T0_cntv      =  0x00000L;
ulong T1_cntv      =  0x00000L;
int   RG_pct       =      50;

int   check_key(void);
MSGS  update_application(void);

void main(void)
{
  int New_Params = 0, reset_flag = 0;
  double ratio;
  double xratio;
  double d0,d1;
  long dT[2]={1000,1000};
  MSGS err;
  clrscr();
  Scan_Command_line(DSK_EXE_APP);
  clrscr();
  //***********************************************//
  // The outer loop initializes the DSK on entry   //
  // or if the application fails                   //
  //***********************************************//
  for(;;)
  {
    for(;;)
    { if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }

    HALT_CPU(); // Halt previously running apps code
    if((err=Load_File(DSK_APP,LOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
    RUN_CPU();

    check_key();  // Check key will update parameters even if no keypress
    clrscr();
    update_application(); // Errors are not detected here...
    //***********************************************************//
    // The inner loop is repeated until a keyboard hit exits the //
    // application or the application reports an error and needs //
    // to be reinitialized                                       //
    //***********************************************************//
    check_key();   // by putting a dummy character in the buffer
    xratio = 1;
    for(;;)
    {
      if((err=getmem(DT0,2, (ulong *)dT))!=NO_ERR) break;
      if(dT[1]==0)
      {
        printf("Error: dT1 cannot be zero  %08lx %08lx",dT[0],dT[1]);
        exit(0);
      }
      d0 = dT[0];
      d1 = dT[1];
      xratio = d0/d1;
      gotoxy(1,20);
      printf("dT0=%08lx  dT1=%08lx  dT0/dT1=%le  \n",dT[0],dT[1],xratio);
      printf("dT0-dT1=%08lx  \n",dT[1]-dT[0]);
      ratio = (double)T0_prdv/(double)T1_prdv;
      printf("T0p=%08lx  T1p=%08lx  Ratio=%le  \n",T0_prdv,T1_prdv,ratio);
      //
      // If a key was pressed, update the setup
      if(kbhit())
      {
        reset_flag = check_key();
        New_Params=1;
      }
      if(reset_flag) break;
      delay(1);
      if(New_Params)
      {
       if(update_application()!=NO_ERR) break;
      }
      New_Params = 0;
    }
    printf("Communications are being reinitialized");
    DSK_reset();
  }
}

int inline clipint(int x, int min, int max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}

long inline cliplong(long x, long min, long max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}

long increase(long X)
{
  X = (X * 1.1) + 1;
  return X;
}
long decrease(long X)
{
  X = (X / 1.1) + 1;
  return X;
}
void RGpc(void)
{
  T0_prdv = T1_prdv;
  T0_cntv = T0_prdv;
  RG_pct = clipint(RG_pct,0,100);
  T1_cntv = T0_cntv * ((float)RG_pct/100.0);
}
int check_key(void)
{
  int key=0;
  float FT0,FT1,Fpwm;
  if(kbhit()) key = bioskey(0) & 0xFF00;
  if(key)
  {
    switch(key)
    {
      //============== Quit (with run optional), Reset ======//
      case _R  : return 1;  // Return reset (break) flag
      case _Q  : _setcursortype(_NORMALCURSOR);
                 exit(0);
                 break;
      //============== Timer 0 setup ===================//
      case _F1: T0_prdv++; break;
      case _F2: T0_prdv--; break;
      case _F3: T0_cntv++; break;
      case _F4: T0_cntv--; break;

      case _SF1 : T0_prdv = increase(T0_prdv); break;
      case _SF2 : T0_prdv = decrease(T0_prdv); break;
      case _SF3 : T0_cntv = increase(T0_cntv); break;
      case _SF4 : T0_cntv = decrease(T0_cntv); break;
      //============== Timer 0 setup ===================//
      case _F5: T1_prdv++; break;
      case _F6: T1_prdv--; break;
      case _F7: T1_cntv++; break;
      case _F8: T1_cntv--; break;

      case _SF5 : T1_prdv = increase(T1_prdv); break;
      case _SF6 : T1_prdv = decrease(T1_prdv); break;
      case _SF7 : T1_cntv = increase(T1_cntv); break;
      case _SF8 : T1_cntv = decrease(T1_cntv); break;
      //========= Change R/G as a percentage ===========//
      case _SF9 : RG_pct+=1; RGpc(); break;
      case _SF10: RG_pct-=1; RGpc(); break;
      case _F9  : RG_pct+=10; RGpc();  break;
      case _F10 : RG_pct-=10; RGpc(); break;
      //========= Select term in equation to modify ====//
      case _Dn :
      case _Up : break;
      //============== Default - do nothing  ===========//
      default : return 0;
    }
    T0_prdv = cliplong(T0_prdv,  0, 0x20000000L);
    T1_prdv = cliplong(T1_prdv,  0, 0x20000000L);
    T0_cntv = cliplong(T0_cntv,  0, T0_prdv);
    T1_cntv = cliplong(T1_cntv,  0, T1_prdv);

  }
  clrscr();
  gotoxy(1,1);
  if(T0_prdv==0) FT0 = 0.250/THx;
  else           FT0 = 0.250/(THx * (float)T0_prdv);
  if(T0_prdv==0) FT0 = 0.250/THx;
  else           FT1 = 0.250/(THx * (float)T1_prdv);
  Fpwm = fabs(FT0-FT1);
  printf(
    "ͻ\n"
    "  F1:F2   T0 prd = %08lx \n"
    "  F3:F4   T0 cnt = %08lx \n"
    "                            \n"
    "  F5:F6   T1 prd = %08lx \n"
    "  F7:F8   T1 cnt = %08lx \n"
    "                            \n"
    "  FT0         = %10.4e  \n"
    "  FT1         = %10.4e  \n"
    "  Fpwm=FT0-FT1= %10.4e  \n"
    "                            \n"
    "  F9:F10     R/G = %8d \n"
    "͹\n"
    " (Q)uit (R)eset             \n"
    "ͼ\n",
  T0_prdv,T0_cntv, T1_prdv,T1_cntv, FT0, FT1, Fpwm, RG_pct);
  return 0;
}

MSGS update_application(void)
{
  MSGS err = NO_ERR;
//  delay(50);
  if((err=putmem(T0_PRD  ,1, &T0_prdv))!=NO_ERR) return err;
  if((err=putmem(T0_CNT  ,1, &T0_cntv))!=NO_ERR) return err;
  if((err=putmem(T1_PRD  ,1, &T1_prdv))!=NO_ERR) return err;
  if((err=putmem(T1_CNT  ,1, &T1_cntv))!=NO_ERR) return err;
  // non-zero LOAD_FLAG signals update
  if((err=putmem(LOAD_FLAG,1,&T0_prdv))!=NO_ERR) return err;
  return err;
}
