//------------------------------------------------------------
// FFT.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  NOTE: THIS APPLICATION USES EGA GRAPHICS
//
//  YOU MUST EITHER CREATE AND LINK IN EGAVGA.OBJ AND ALSO USE
//  REGISTER THE DRIVER IN YOUR CODE WITH registerbgidriver();
//  OR EGAVGA.BGI MUST BE IN THE CURRENT DIRECTORY
//  -AND-
//  THE LINKER OPTIONS NEED TO BE SET TO LINK IN GRAPHICS.LIB
//--------------------------------------------------------------
//  The project file (link list) should include the following
//
//    FFT.CPP       This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//  * EGAVGA.OBJ    EGA and VGA graphics driver
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  A C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//  Windows 3.x/95
//        This DOS graphics executable uses the Winodws timelsice managment
//        interrupt hooks to enable multiple DOS applications.
//
//        Since Windows cannot translate DOS graphics to windows graphics
//        this app must either be run full screen or in text mode.  Use
//        the 'G' key to enter text mode.
//--------------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <graphics.h>
#include <bios.h>
#include <math.h>
#include "DSK.H"
#include "DSK_COFF.H"
#include "C3XMMRS.H"
#include "keydef.h"
typedef enum messages
{
  STOP =1,
  START=2
}message;
#define MaxSamples 1024        // Max FFT size
float Fh        =       25e6;  // rating in MIP's
float Fmclk     =        1e6;
float Fsclk     =        1e6;
float Fadc      =     1000.0;
float Fdac      =     1000.0;
float Ftyp      =          0;
float dB        =       -200;
ulong Tprd      =0x00000001L;
ulong ZERO      =0x00000000L;
ulong MSG_BOX   =  0x809800L;
ulong A_BOX     =  0x809800L;
ulong B_BOX     =  0x809800L;
ulong C_BOX     =  0x809800L;
ulong AICLOAD_BOX= 0x809800L;
ulong SAMPLES   =  0x809800L;
ulong DATABLOCK =  0x809800L;
ulong Samples   =       1024;
int   StepSize  =          2;
int   graph_en  =          1;
int   TA        =         10; // DAC divisors
int   TB        =         14; //
int   RA        =         10; // ADC divisors
int   RB        =         14; //
ulong C_REG     =       0x03; // AIC control register bits
int   pw        =          1; // Peak indicator pixel width = 1 + pw*2
int   maxx      =          0;
int   AVG       =          1;
int   PulseMode =          0;
int   oldbuf    [MaxSamples];
char  buf_0     [MaxSamples];
char  buf_1     [MaxSamples];
char  pk_t      [MaxSamples];
int   y_pk      [MaxSamples];
char  DSK_APP    [] = "FFT_RR2.DSK";
char  DSK_EXE_APP[] = "FFT.EXE";
//----------------------------------------------------
// Function prototypes
//----------------------------------------------------
void  init_graphics(void);
int   check_key (void);
//----------------------------------------------------
//
//----------------------------------------------------
void TextXY(int x,int y,char *s)
{
  int xc,yc;
  if(graph_en) outtextxy(x,y,s);
  else
  {
    xc = 1+(80*(x  ))/640;
    yc = 1+(25*(y  ))/250;
    if(yc< 1) yc =  1; if(yc>25) yc = 25;
    if(xc< 1) xc =  1; if(xc>60) xc = 60;
    gotoxy(xc,yc);
    printf("%s",s);
  }
}
void mysetwritemode(int mode)
{
  if(graph_en) setwritemode(mode);
}
void myclearviewport(void)
{
  if(graph_en) clearviewport();
}
void  mysetcolor(int c)
{
  if(graph_en) setcolor(c);
}
//---------------------------------------------------------------
// Special print routines for engineers
//    eprintf()     prints using engineering prefixes
//    E_printf()    prints engineering style floats
//    Bin_sprintf() prints binary base 2 1's and 0's
//---------------------------------------------------------------
void  eprintf(char *s,float f,char *format)//int prec)
{
  float sign;
  char *c;
  int   Exp = 0;
  if(f <0) sign = -1;
  else     sign =  1;
  f = (float)fabs(f);
  if(f==0.0) { sprintf(s,"0.000"); return; }

  if((f>1e-90)&&(f<1e90))
  {
    if(f > 1)  { while(f > 1000) { Exp += 3; f *= 0.0010; }; }
    else       { while(f <    1) { Exp -= 3; f *= 1000.0; }; }
    f*=sign;
  }
  else { sprintf(s,"RANGE"); return; }
  c = s;
  c += sprintf(c,format,f);
  switch(Exp)
  {
      case  12: c+=sprintf(c,"T"); break;
      case   9: c+=sprintf(c,"G"); break;
      case   6: c+=sprintf(c,"M"); break;
      case   3: c+=sprintf(c,"K"); break;
      case   0: c+=sprintf(c,"" ); break;
      case  -3: c+=sprintf(c,"m"); break;
      case  -6: c+=sprintf(c,"u"); break;
      case  -9: c+=sprintf(c,"n"); break;
      case -12: c+=sprintf(c,"p"); break;
      case -15: c+=sprintf(c,"f"); break;
      default:  c+=sprintf(c,"E");
                c+=sprintf(c,"%d",Exp);
                //sprintf(s ,"%s,E%d",c2,Exp);
                break;
  }
}
void  E_printf(char *s,float f)
{
  float sign;
  int   Exp = 0;
  if(f <0) sign = -1;
  else     sign =  1;
  f = (float)fabs(f);
  if(f==0.0) { sprintf(s,"0.000"); return; }
  if(f > 1)  { while(f > 1000) { Exp += 3; f *= 0.0010; }; }
  else       { while(f <    1) { Exp -= 3; f *= 1000.0; }; }
  f*=sign;
  sprintf(s,"%7.3fE%d",f,Exp);
}

void Bin_sprintf(char *c, int x, int digits)
{
  unsigned int i;
  i=1;
  for(;digits>1;digits--) i=i<<1;
  for(;i!=0;i=i>>1)
  {
    if(i&x) *c++='1';
    else    *c++='0';
  }
  *c = 0;
}
//--------------------------------------------------------
// draw_vect_peak() draws the vertical display bars for
// each frequency bin.  To speed up the line draws, only
// the part which changes is drawn using an XOR function
//--------------------------------------------------------
void xor_draw_vect_peak()
{
  int  x, y, xx;
  char strg0[80];
  char strg1[80];
   strcpy(strg1,"^ ");
  eprintf(strg1+2,Ftyp,"\%8.6f"); strcat(strg1,"hz  ");
  eprintf(strg0  ,dB  ,"\%+5.3f");strcat(strg1,strg0);
                                  strcat(strg1,"dB");
  if(graph_en)
  {
    setcolor(WHITE);
    setwritemode(1);                      // Set line draw to XOR mode
    //
    xx = 0;
    for(x=0;x<Samples/2;x++)
    {
      xx+=StepSize;
      switch(AVG)
      {
        default:
        case  1:                                         break;
        case  2: buf_0[x] = (buf_1[x]   + buf_0[x]) >>1; break;
        case  3: buf_0[x] = (buf_1[x]*3 + buf_0[x]) >>2; break;
        case  4: buf_0[x] = (buf_1[x]*7 + buf_0[x]) >>3; break;
      }
      buf_1[x] = buf_0[x];
      y = 128 - buf_0[x];
  //  if(y == oldbuf[x]) do nothing
      if(y  > oldbuf[x]) line(xx,oldbuf[x]+1,xx,y  );
      if(y  < oldbuf[x]) line(xx,oldbuf[x]  ,xx,y+1);
      oldbuf[x] = y;
    }
    setfillstyle(SOLID_FILL, BLACK);
    bar(0,261,639,268); // Clear region to show Ftyp
    TextXY(maxx,261,strg1);
  }
  else
    TextXY(300,200,strg1);

  if(graph_en)
  {
    //
    // Draw peaks in red
    //
    xx = 0;
    if(pw==0) return;
    setcolor(LIGHTRED);
    for(x=0;x<Samples/2;x++)
    {
      xx+=StepSize;
      y = 128 - buf_0[x];               // present Y to display
      pk_t[x] += 1;                      // Inc times peak has been displayed
      if((pk_t[x] > 8) || (y < y_pk[x]))   // If vmag>last redraw new peak
      {
        line(xx-pw,y_pk[x],xx+pw,y_pk[x]); // undraw old horizontal peak
        if(y <= y_pk[x])                 // if vmag>last freshen peak hold
        {
          y_pk[x] = y;
          pk_t[x] = 0;
        }
        else
        {
          if(y>=254) y_pk[x]=254;         // No peak if array is zero
          if(y > (y_pk[x]+6)) y_pk[x] += 6; // Fast peak decay for rapid change
          else                y_pk[x] += 1; // slow decay
        }
        line(xx-pw,y_pk[x],xx+pw, y_pk[x]  );  // draw new horizontal peak
      }
    }

  }
}

void Zero(void)
{
  int  x;
  for(x=0;x<Samples/2;x++)
  {
    pk_t [x] =   9;
    buf_0[x]= -128;                  // present Y to display
  }
}
//---------------------------------------------------------------
// main()  After checking for any command line arguments main
// enters an outer 'forever loop' where the DSK communications
// channel is initialized, followed by loading the code and
// then initializing the graphics mode.  A second 'inner forever
// loop' is then entered where the application interacts with the
// host.  When a failure occurs inside the inner forever loop that
// loop is broken (see break; commands), causing the application
// to re-execute the outer loop, which causes the channel to be
// re-initialized followed by a code load and graphics initialize.
// This method allows the DSK to be disconnected and reconnected
// without the application bombing out to the command line.
//----------------------------------------------------------------
void calc_regs(void)
{
  if(TA>31) TA=31; if(TA< 4)TA= 4;
  if(TB>63) TB=63; if(TB<10)TB=10;
  if(RA>31) RA=31; if(RA< 4)RA= 4;
  if(RB>63) RB=63; if(RB<10)RB=10;
  if(Tprd<1) Tprd = 1;    if(Tprd>16) Tprd = 16;
  Fmclk  = 0.5*Fh / (float)Tprd;
  if(!PulseMode) Fmclk/=2;
  Fsclk  = (float)(Fmclk * 0.25);
  Fadc = Fmclk / (float) (2*(TA * TB));
  Fdac = Fmclk / (float) (2*(RA * RB));
  StepSize = MaxSamples/Samples;
//Fadcscf = Fsclk / RA;
//Fdacscf = Fsclk / TA;
//if(CREG&0x20){ Fadc=Fdac; Fadcscf = Fdacscf;}
//Fadchi = (float)(3000.0 * Fadcscf/288000.0);
//Fadclo = (float)( 300.0 * Fadcscf/288000.0);
//Fdaclo = (float)(3000.0 * Fdacscf/288000.0);
//Fdac     = 1/(2*TA*TB*(2*THx * Tprd));
//if(C_REG & 0x20) Fadc = Fdac;
//else             Fadc = 1/(2*RA*RB*(2*THx * Tprd));
}
void main(void)
{
  float f1,f2;
  float f[10];
//  ulong Tprd = 2;
  ulong AREG, BREG;
  int maxy;
  int    UpdateAIC   = 1;
  int    reset_flag   = 0;
  int    L2           = 0;
  ulong START_MSG=START,TEMP;
  MSGS err;
  float sum;
  int i,x;
  clrscr();
  Scan_Command_line(DSK_EXE_APP);
  clrscr();
  //***********************************************//
  // The outer loop initializes the DSK on entry   //
  // or if the application fails                   //
  //***********************************************//
  for(;;)
  { for(;;)
    { if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }
    HALT_CPU(); // Halt previously running apps code
    if((err=Load_File(DSK_APP,LOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
    if((err=Load_File(DSK_APP,SLOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
    // Load location information for updatable variables
    // from the loaded DSP applications symbol table
    //
    x  = ref_value("A_REG"     ,(long *) &A_BOX    );
    x += ref_value("B_REG"     ,(long *) &B_BOX    );
    x += ref_value("C_REG"     ,(long *) &C_BOX    );
    x += ref_value("MSG_BOX"   ,(long *) &MSG_BOX  );
    x += ref_value("AICLOAD"   ,(long *) &AICLOAD_BOX );
    x += ref_value("DATA_ARRAY",(long *) &DATABLOCK);
    x += ref_value("SIZE"      ,(long *) &SAMPLES  );
    if(x!=7)
    {
      printf("\nError loading DSK file symbols\n");
      exit(0);
    }
    //
    // Load size parameter from application running on DSK
    //
    getmem(SAMPLES,1,&TEMP);
    Samples = TEMP;
    if(Samples>MaxSamples) Samples = MaxSamples;
    //
    RUN_CPU();
    init_graphics();
    //
    // Init buff ptrs, Temps are rotated
    //
    for(x=0;x<Samples;x++)                   // Clear all buffersq
    {
      buf_0[x]    = 0;
      buf_1[x]    = 0;
      y_pk[x] = 255;
      pk_t[x] = 8;
      oldbuf[x]   = 255;
    }

    StepSize = MaxSamples/Samples;
    check_key();
    calc_regs();
    xor_draw_vect_peak();
    //***********************************************************//
    // The inner loop is repeated until a keyboard hit exits the //
    // application or the application reports an error and needs //
    // to be reinitialized                                       //
    //***********************************************************//
    for(;;)
    {
      // The inner loop draws the display using an XOR line draw
      // to overdraw existing vectors
      StepSize = MaxSamples/Samples;
      //--------------------------------------------------------
      // Use simple IIR filter to low pass 'Average' data
      xor_draw_vect_peak();
      // To prevent getmem timeouts an artificial strobe is used to
      // signal to the DSK that a host request is in progress
      HPI_STRB(0);            // Drive HPSTB (INT2) low and wait
      reset_flag = 0;
      for(;;)                 // for DSK to stop with full buffer
      { if(kbhit())
        {
          reset_flag = check_key();
          UpdateAIC = 1;
        }
        if(HPI_ACK())break;  // Note: break last to ensure keytrap!
        delay(1);
      }
      if(reset_flag) break;
      // If a key was pressed, update the AIC setup
      if(getmem(DATABLOCK,Samples/8,(ulong *)buf_0)!=NO_ERR) break;
      if(UpdateAIC)
      {
        UpdateAIC = 0;
        if(PulseMode) AREG = 0x2C1;
        else          AREG = 0x3C1;
        if((err=putmem(0x00808020L,1,&AREG))!=NO_ERR) break;
        if((err=putmem(0x00808028L,1,&Tprd))!=NO_ERR) break;
        AREG = 1;
        if((err=putmem(0x00808024L,1,&AREG))!=NO_ERR) break;
        AREG = (TA<<9)+(RA<<2)+0;
        BREG = (TB<<9)+(RB<<2)+2;
        if((err=putmem(A_BOX   ,1,&AREG ))!=NO_ERR) break;
        if((err=putmem(B_BOX   ,1,&BREG ))!=NO_ERR) break;
        if((err=putmem(C_BOX   ,1,&C_REG ))!=NO_ERR) break;
        if((err=putmem(AICLOAD_BOX,1,&C_REG))!=NO_ERR) break;
        calc_regs();
      }
      if((err=putmem(SAMPLES ,1,&Samples))!=NO_ERR) break;
      //---------------------------------------------------------
      // Find peak (avoiding ends), then get full precision data
      maxy = buf_0[5];
      maxx = 0;
      for(x=5;x<(Samples/2)-5;x++)
      {
        if(buf_0[x]>maxy)
        {
          maxy = buf_0[x];
          maxx = x;
        }
      }
      x = maxx;
      maxx*=StepSize;  // two pixels/bin
      maxx-=2;         // half pixel width of '^' symbol
      #define  CENT  7 // Number of samples to use in centroid
      L2 = CENT>>1;
      if((err=fgetmem(DATABLOCK+(MaxSamples/2)+x-L2,CENT,f))!=NO_ERR) break;
      sum = f[0]; for(i=1;i<CENT;i++) sum += f[i];
      if(sum==0) f1 = 0;
      else
      {
        f2 = x-L2;
        for(i=0;i<CENT;i++) { f1 +=f[i]*f2; f2+=1; }
        f1/= sum;
        f1 = (f1*Fadc)/(float)(Samples);
      }
      Ftyp = (Ftyp*(AVG-1) + f1)/AVG;
      if(sum<1) dB = -200;
      else      dB = (10*log(sum)/log(10))-121.4; // by measurement
      putmem(MSG_BOX,1,&START_MSG); // Restart
    }
    closegraph();  // Shutdown graphics before re-initializing
    printf("%s: %s\n",DSK_APP, Error_Strg(err));
    printf("Communications are being reinitialized");
    delay(1000);
    DSK_reset();
  }
}
//----------------------------------------------------------------
// clip() is used to clip the upper and lower bounds of a number
//----------------------------------------------------------------
long inline clip(long x, int min, int max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}
//----------------------------------------------------------------
// check_key() is used to associate keystrokes with actions
//----------------------------------------------------------------
int check_key(void)
{
  int C1;
  int  key=0;
  int  Yt=0;
  char buf[80];
  if(kbhit()) key = bioskey(0) & 0xFF00;
  //
  // Clear the sections of the screen that text will be written to
  //
  Zero();
  xor_draw_vect_peak();
  //
  if(key)
  {
    switch(key)
    {
      case _Ins: Tprd--; break;
      case _Del: Tprd++; break;
      case _R  : return 1;  // Return reset (break) flag
      case _P:  PulseMode^=1; break;
      case _Q  :closegraph();
                _setcursortype(_NORMALCURSOR);
                exit(0);
                break;
      case _G  : graph_en^=1;
                 if(graph_en)
                 {
                   init_graphics(); // re-init graphics mode
                   for(int x=0;x<Samples/2;x++)  // Clear all buffers
                   {
                     buf_0[x] = 0;
                     buf_1[x] = 0;
                     y_pk[x] = 255;
                     pk_t[x] = 8;
                     oldbuf[x]   = 255;
                   }
                   xor_draw_vect_peak();
                 }
                 else
                 {
                   closegraph();    // go back to EGA/VGA text mode
                 }
                 break;
      case _F1 : TA++; break;
      case _F2 : TA--; break;
      case _F3 : TB++; break;
      case _F4 : TB--; break;
      case _F5 : RA++; break;
      case _F6 : RA--; break;
      case _F7 : RB++; break;
      case _F8 : RB--; break;
      case _F9 : xor_draw_vect_peak();  // undraw previous
                 Samples /= 2;
                 if(Samples<  64) Samples =  64;
                 break;
      case _F10: xor_draw_vect_peak();  // undraw previous
                 Samples *= 2;
                 if(Samples>1024) Samples =1024;
                 break;
      case _1  : C_REG = C_REG ^ 0x80; break; // bit 7
      case _2  : C_REG = C_REG ^ 0x40; break; // bit 6
      case _3  : C_REG = C_REG ^ 0x20; break; // bit 5
      case _4  : C_REG = C_REG ^ 0x10; break; // bit 4
      case _5  : C_REG = C_REG ^ 0x08; break; // bit 3
      case _6  : C_REG = C_REG ^ 0x04; break; // bit 2
      case _A  : AVG++; if(AVG>4) AVG=1; break;
      default : break;
    }
  }
  calc_regs();
  mysetcolor(11);
  Yt=1;
  //====================================================================
  bar(0,270,639,349); // Clear below graph
  bar(513,0,639,349); // Clear to right of graph
  if(graph_en) { C1 = 520; Yt =  10;}
  else         { C1 = 100; Yt =  10;}
  sprintf(buf,"Q  quit"  );                   TextXY(C1,Yt    ,buf);
  sprintf(buf,"R  reset" );                   TextXY(C1,Yt+=10,buf);
  sprintf(buf,"G  Graph/text");               TextXY(C1,Yt+=10,buf);
  sprintf(buf,"A  Avg =%d"   ,AVG);           TextXY(C1,Yt+=10,buf);
  //====================================================================
  if(graph_en) { C1 =  10; Yt = 270;}
  else         { C1 = 100; Yt =  10;}
  sprintf(buf,"Ins/Del Tprd=%02ld",Tprd);     TextXY(C1,Yt    ,buf);
  sprintf(buf,"F1/F2   TA  =%02d" ,TA);       TextXY(C1,Yt+=10,buf);
  sprintf(buf,"F3/F4   TB  =%02d" ,TB);       TextXY(C1,Yt+=10,buf);
  sprintf(buf,"F5/F6   RA  =%02d" ,RA);       TextXY(C1,Yt+=10,buf);
  sprintf(buf,"F7/F8   RB  =%02d" ,RB);       TextXY(C1,Yt+=10,buf);
  sprintf(buf,"F9/F10  Size=%d",(int)Samples);TextXY(C1,Yt+=10,buf);
  //====================================================================
  // Display sample rates
  if(graph_en) { C1 = 160; Yt = 270;}
  else         { C1 = 100; Yt =  10;}
  sprintf(buf,  "Hz/div=%7.2f",Fadc/16);           TextXY(C1,Yt    ,buf);
  sprintf(buf,  "  Fdac=%7.2f",   Fdac);           TextXY(C1,Yt+=10,buf);
  if(C_REG&0x20)  sprintf(buf,"  Fadc=Fdac");
  else            sprintf(buf,"  Fadc=%7.2f",Fadc);TextXY(C1,Yt+=10,buf);
  //====================================================================
  // If in text mode, move the column over
  if(graph_en) { C1 = 320; Yt = 270;}
  else         { C1 = 100; Yt =  10;}
  sprintf(buf,"AIC CTRL :  ");Bin_sprintf(buf+12,C_REG,8);TextXY(C1,Yt ,buf);
  sprintf(buf,"            ||||||"             ); TextXY(C1,Yt+=10,buf);
  sprintf(buf,"00  +0dB 1 -+||||+- 6 BP filter" ); TextXY(C1,Yt+=10,buf);
  sprintf(buf,"01  +6dB 2 --+||+-- 5 Loopback"  ); TextXY(C1,Yt+=10,buf);
  sprintf(buf,"10 +12dB      |+--- 4 AIN/AUXIN" ); TextXY(C1,Yt+=10,buf);
  sprintf(buf,"11  +0dB      +---- 3 Async"     ); TextXY(C1,Yt+=10,buf);
  sprintf(buf,"         (Use numeric keys)"     ); TextXY(C1,Yt+=10,buf);
  //====================================================================
  return 0;
}
//----------------------------------------------------------------
// Intialize graphics mode, draw reticle, and add labels
//----------------------------------------------------------------
void init_graphics(void)
{
  int gdriver = EGA, gmode = EGAHI, errorcode, Y, X;
  // register EGAVGA_driver which is the name of the driver in EGAVGA.OBJ
  // EGAVGA.OBJ is created from EGAVGA.BGI using the BGIOBJ.EXE utility
  // and is linked by either the link list or project file
  // NOTE: This section of code can be ommitted if EGAVGA.BGI is
  //       located in the applications startup directory
  if(!graph_en) return;
  errorcode = registerbgidriver(EGAVGA_driver);
  if (errorcode < 0)  // report any registration errors
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");  getch();  exit(1);
  }
  initgraph(&gdriver, &gmode, "");        // if possible open EGA mode
  errorcode = graphresult();
  if (errorcode != grOk)
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:"); getch(); exit(1);
  }
  myclearviewport();
  mysetcolor(GREEN);
  #define Yd 260
  #define yd 26
  for(Y=0;Y<= Yd;Y+=yd) line(0,Y,512,  Y);  // draw reticle
  for(X=0;X<=512;X+=32) line(X,0, X, Yd);
  Y = 2; X = 2;
  TextXY(X,Y    ,"+20"); TextXY(X,Y+=26,"+10");
  TextXY(X,Y+=26," +0"); TextXY(X,Y+=26,"-10");
  TextXY(X,Y+=26,"-20"); TextXY(X,Y+=26,"-30");
  TextXY(X,Y+=26,"-40"); TextXY(X,Y+=26,"-50");
  TextXY(X,Y+=26,"-60"); TextXY(X,Y+=26,"-70");
  mysetwritemode(1);                        // display lines are XOR drawn
  mysetcolor(15);                           // light gray
}
