;------------------------------------------------------------------
; FFT256B.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; This application is written to run with the DOS executable FFT_256B.EXE
;
; The FFT code used in this example is written for readability and ease of
; understanding not for size and speed.  It can be easily optimized!
;
;FFT Window
;----------
; By using a post convolution of the window function after the FFT is
; complete a table for the window function is not required. Furthermore
; the time domain coefficients for a raised cosine window are very simple
; (-0.5,+1.0,-0.5).
;
;Bit Reversal of Twiddle Table
;-----------------------------
; By bit-reversing the twiddle tables the size of an FFT is not dependent
; on the size of the table loaded.  In this case simply redefining the
; FFT size will result in a correctly coded FFT.
;
;STARTUP STUB
;------------
; The initialization code which is used only on startup is placed inside
; the volatile data memory array to gain back internal memory.
;
;SAMPLING RATES
;--------------
; The AIC sampling rates can be set to any combination which can still
; communicate with the DSP.  Some combinations will work as high as 130 KHz
; with substantial performance degradation.  Experimentation is required to
; find values that work best, or at all, since some will crash the
; communications entirely.
;
;HOST SYNCHRONIZATION
;--------------------
; Since the host should not disturb the ADC while data is being collected
; an interlock is used to keep the host from timing out.  This application
; uses a message box.
;
;SERIAL PORT REFRESH
;-------------------
; If the serial port is not serviced once every frame synch an underrun
; condition will occur and the port will shut down.  This is important for
; the transmit section since putting a new value in the DXR will cause the
; previous value to move to the shift register irregardless of the state
; of FSX.  Since the bit patterns are data dependent and in this case shifted
; by an unknown amount the AIC could be reprogrammed if steps are not taken
; to avoid a bad restart.  This is done by placing a zero in the transmitter
; whenever the serial port and AIC are likely to underrun.
;
; To prevent this the communications kernel is written such that the serial
; port tranmit channel is updated with zero whenever the kernel enters the
; wait for command loop 'spin0'.  When spin0 is exited (RUN command) the
; serial port is restarted with the original value.
;-------------------------------------------------------------------------
RAM0     .set    0x809800
RAM1     .set    0x809C00
;-------------------------------------
TA       .set   10     ; Default startup values
TB       .set   14     ;
RA       .set   10     ; Default startup values
RB       .set   14     ;
         .include "C3XMMRS.ASM"
N        .set   256
N2       .set   N/2
PI       .set   3.1415926
PI2      .set   2*PI
PI2N     .set   2.0*PI/N
PIN      .set   PI/N
;==================================================
; Create the Twiddle, FFT and I/O buffer arrays
;==================================================
         .start  "TWIDDLES",0X809800  ;
         .sect   "TWIDDLES"           ;
TR                                    ; 0x809800
         .loop   N2                   ;
         .float    cos(br($-TR,N)*PIN);
         .endloop                     ;
TI                                    ;
         .loop   N2                   ; 0x809880
         .float -1*sin(br($-TI,N)*PIN);
         .endloop                     ;

BF       .set    TI+N2                ; 0x809900
DR       .set    BF+N                 ; 0x809A00
DI       .set    DR+N                 ; 0x809B00
;==================================================
          .start  "FFTCODE",0x809C00  ; Start of RAM1
          .sect   "FFTCODE"           ;
;==================================================
_STOP     .set   1
_START    .set   2
;
MSG_BOX   .word  _STOP             ; 0x809C00
TLVL      .word  1000              ; 0x809C01
A_REG     .word  (TA<<9)+(RA<<2)+0 ; 0x809C02
B_REG     .word  (TB<<9)+(RB<<2)+2 ; 0x809C03
C_REG     .word  10000011b         ; 0x809C04  +/- 1.5 V
EDGESEL   .word  1                 ; 0x809C05
SAMPLES   .word  N                 ; 0x809C06
A_REGOLD  .word  0
B_REGOLD  .word  0
C_REGOLD  .word  0
;
Source    .word  S0_rdata       ; Use xdata=rdata to loopback ADC->DAC
Dest      .word  S0_xdata       ; Destination is always DAC
;
S0_gctrl_val  .word  0x0E970300 ; Runtime value XINT/RINT enabled
S0_xctrl_val  .word  0x00000111 ;
S0_rctrl_val  .word  0x00000111 ;
;
FFTSIZE   .word N               ; 256 point FFT
TR_ADDR   .word TR              ; 128 SIN values
TI_ADDR   .word TI              ; 128 COS values
DR_ADDR   .word DR              ; 128 REAL data point
DI_ADDR   .word DI              ; 128 IMAG data point
BF_ADDR   .word BF              ; Array of 256   Real buffer data
TEMP      .word 0
;-------------------------------
main      ldi   0x30,IE
          ldi   @S0_rdata,R0    ; Clear SP under/overflow
          ldi   0,R0            ;
          sti   R0,@S0_xdata    ;
          ldi   @S0_rdata,R0    ;
          ldi   0,R0            ;
          sti   R0,@S0_xdata    ;
          sti   R0,@RAMP

          ldi   25,RC           ; Preload some ADC data to flush out
          rptb  preload         ; the AIC after putting it to sleep
preload   call  GETADC          ;
          ;---------------------
          ldi   @DR_ADDR,AR0    ;
          ldi   @DI_ADDR,AR1    ;
          ldi   @SAMPLES,RC     ; Now get samples
          subi  1,RC            ; N+1 repeats
          rptb  samples         ;
          ;---------------------
          call  GETADC          ;
          float R0,R0           ;
          stf   R0,*AR0++       ; store to data array
          ldf   0,R0            ;
samples   stf   R0,*AR1++       ;
          ;---------------------
          ldi   0,R0            ; Put 0 into the DXR when it is not
          sti   R0,@S0_xdata    ; going to be used for awhile
;==========================================================
; Perform FFT
;-------------------------------
FFT:      ldi   @FFTSIZE,IR0    ;
          ldi   @FFTSIZE,IR1    ;
          lsh   -1,IR0
New_Stg
          ldi   @FFTSIZE,RC     ;
          ldi   @DR_ADDR,AR0    ;
          ldi   @DI_ADDR,AR1    ;
          ldi   @TR_ADDR,AR2    ; Tw Base never modified
          ldi   @TI_ADDR,AR3    ;
          lsh   -1,RC           ; Perform FFTSIZE/2 butterfly loops
          subi  1,RC            ;
          lsh   -1,IR0          ;
          lsh   -1,IR1          ;
          ldi   IR1,R0          ;
          bz    FFT_END         ;
          ;---------------------
Blk_Top   rptb  B_Fly           ; Start by getting all 6 Butterfly inputs
          ldf   *+AR0(IR1)  ,R0 ; Bt real
    ||    ldf   *AR0        ,R1 ; Tp real
          ldf   *+AR1(IR1)  ,R2 ; Bt imag
    ||    ldf   *AR1        ,R3 ; Tp imag
          ldf   *AR2++(IR0)B,R4 ; TW real - R4
    ||    ldf   *AR3++(IR0)B,R5 ; TW imag - R5

          addf3 R0,R1,R6        ; Top sum REAL
      ;   stf   R6,*AR0         ;
      ;   addf3 R2,R3,R7        ; Top sum IMAG
          addf3 *+AR1(IR1),R3,R7; Top sum IMAG
    ||    stf   R6,*AR0

          subf3 R0,R1,R6        ; R6=d_REAL  (R1 free)
          stf   R7,*AR1         ;

          subf3 R2,R3,R7        ; R7=d_IMAG  (R3 free)

          mpyf3 R6,R4,R1        ; R1 = R*TR = REAL_1
          mpyf3 R7,R5,R3        ; R3 = I*TI = REAL_2
          subf  R3,R1           ;
          stf   R1,*+AR0(IR1)   ; Store bottom real
          nop   *++AR0

          mpyf3 R6,R5,R1        ; R1 = R*TI = IMAG_1
          mpyf3 R7,R4,R3        ; R3 = I*TR = IMAG_2
          addf  R3,R1           ;
          stf   R1,*+AR1(IR1)   ; Store bottom real
          nop   *++AR1

          ;----------------------
          ; Identify EOB by twiddle wraparound
          ;----------------------
ident     ldi   @TR_ADDR,R7     ; At the end of a block the bit-reversed
          subi  AR2,R7          ; addressing of the twiddles will cause
          ldiz  IR1,R7          ; TR_ADDR==AR2.  If true, increment the R/I
          ldinz 0,R7            ; data pointers to start at the next block.
          addi  R7,AR0          ;
B_Fly     addi  R7,AR1          ;
     ;    nop                   ; Done go to next butterfly
          b     New_Stg         ; When RC=0, set up for new stage
;==========================================================
FFT_END   ; FIlter and BR sort data
          ldf   -.5,R5          ; -5 coefficiant
          ldi   @BF_ADDR,AR0    ; Bit reverse REAL
          ldi   @DR_ADDR,AR1    ; R1=AR1+0 R2=AR2+1 R3=AR3+2
          ldi   @DI_ADDR,AR4    ; I1=AR4+0 I2=AR5+1 I3=AR6+2

          mpyf3 *AR1,*AR1,R1    ; DC is not filterable,
          mpyf3 *AR4,*AR4,R2    ; calculated seperately
          addf  R1,R2           ;
          lsh   1,R2            ; Quick log
          pushf R2
          pop   R2
          ldi   R2,R1
          ash   -16,R1
          andn  0xffff,R2
          or    R1,R2
          sti   R2,*AR0++

          ldi   @SAMPLES,IR0    ; 256
          lsh   -1,IR0
          ;---------------------
          ldi   AR1,AR2         ;
          nop
          nop   *AR2++(IR0)B    ;
          ldi   AR2,AR3         ;
          nop
          nop   *AR3++(IR0)B    ;
          ;---------------------

          ldi   AR4,AR5         ;
          nop
          nop   *AR5++(IR0)B    ;
          ldi   AR5,AR6         ;
          nop
          nop   *AR6++(IR0)B    ;
          ;---------------------
          ldi   @SAMPLES,RC     ;
          lsh   -1,RC           ; Pack 2 results per word
        ; subi  1,RC            ;

  ;=================================================
          ldf   -0.5,R5
          rptb  WINDOW
          ;---------------------
          mpyf3 R5,*AR1++(IR0)B,R1
          addf     *AR2++(IR0)B,R1
          mpyf3 R5,*AR3++(IR0)B,R2
          addf  R1,R2
          mpyf  R2,R2           ; REAL^2


          mpyf3 R5,*AR4++(IR0)B,R3
          addf     *AR5++(IR0)B,R3
          mpyf3 R5,*AR6++(IR0)B,R4
          addf  R3,R4
          mpyf  R4,R4           ; IMAG^2

          addf  R4,R2           ; REAL^2 + IMAG^2
          lsh   1,R2            ; Quick log
          pushf R2
          pop   R7              ; R7 = S0
          ;---------------------
          mpyf3 R5,*AR1++(IR0)B,R1
          addf     *AR2++(IR0)B,R1
          mpyf3 R5,*AR3++(IR0)B,R2
          addf  R1,R2
          mpyf  R2,R2           ; REAL^2
          mpyf3 R5,*AR4++(IR0)B,R3
          addf     *AR5++(IR0)B,R3
          mpyf3 R5,*AR6++(IR0)B,R4
          addf  R3,R4
          mpyf  R4,R4           ; IMAG^2
          addf  R4,R2           ;
          lsh   1,R2            ; Quick log
          pushf R2
          pop   R6              ; R6 = S1
          ;---------------------
          ash   -16,R7
          andn  0xffff,R6
          or    R6,R7
WINDOW    sti   R7,*AR0++       ;
          ;---------------------
          ldi   0x4,IE          ;
          ldi   _START,R0       ;
NO_START  cmpi  @MSG_BOX,R0     ; Restart when START message is received
          bnz   NO_START        ;
          ldi   _STOP,R0        ; Set MSG box to STOP
          sti   R0,@MSG_BOX     ;
          ;---------------------
          ldi   0,R2            ;
          ldi   @A_REG   ,R0    ; Reload any new runtime parameters
          cmpi  @A_REGOLD,R0    ;
          ldinz 1,R2            ;
          sti   R0,@A_REGOLD    ;
          ;- - - - - - - - - - -
          ldi   @B_REG   ,R0    ;
          cmpi  @B_REGOLD,R0    ;
          ldinz 1,R2            ;
          sti   R0,@B_REGOLD    ;
          ;- - - - - - - - - - -
          ldi   @C_REG   ,R0    ;
          cmpi  @C_REGOLD,R0    ;
          ldinz 1,R2            ;
          sti   R0,@C_REGOLD    ;
          ;- - - - - - - - - - -
          cmpi  0,R2            ;
          bz    main            ;
          call  AIC_INIT        ; Restart with new AIC setup
          b     main            ; Do it all over again!
;***************************************************************************
RAMP      .word 0
FLAGS     .word 0

GETADC    ldi   0x30,IE         ; Come here and wait for ADC interrupt
          IDLE                  ; confirmation to save power and code space
          ldi   @FLAGS,R0       ;
          tstb  0x20,R0         ;
          bz    $-3             ;
          andn  0x20,R0         ;
          sti   R0,@FLAGS       ;
          ldi   @S0_rdata,R0    ; Return sign extended ADC value
          lsh   16,R0           ;
          ash   -16,R0          ;
          rets

ADC       push  ST              ; On interrupt, set a software flag to
          push  R0              ; let the CPU know that the RINT has been
          ldi   @S0_rdata,R0    ;
          ldi   @FLAGS,R0       ;
          or    0x20,R0         ;
          sti   R0,@FLAGS       ;
          pop   R0              ;
          pop   ST              ;
          reti                  ;

DAC       push  ST              ;
          push  R1              ;
          ldi   @RAMP,R1        ; Send RAMP signal out DAC for loopback test
          subi  1024,R1         ;
          lsh   17,R1
          ash   -17,R1
          andn  3,R1            ;
          sti   R1,@RAMP        ;
          sti   R1,@S0_xdata    ; loopback ADC->DAC
          pop   R1
          pop   ST
          reti
;--------------------------------
prog_AIC  push  R1              ;
          push  IE              ;
          ldi   0x10,IE         ;
          andn  0x30,IF         ;
          ldi   @S0_xdata,R1    ; Use original DXR data during 2 ndy
          sti   R1,@S0_xdata    ;
          idle
          ldi   @S0_xdata,R1    ; Use original DXR data during 2 ndy
          or    3,R1            ; Request 2 ndy XMIT
          sti   R1,@S0_xdata    ;
          idle                  ;
          sti   R0,@S0_xdata    ; Send register value
          idle                  ;
          andn  3,R1            ;
          sti   R1,@S0_xdata    ; Leave with original safe value in DXR
          pop   IE              ;
          pop   R1              ;
          rets                  ;
;======================================================;
; This section of code is called by the initialization ;
; code as well as by the main program loop.  It is     ;
; therfor assembled into the regular program RAM       ;
;======================================================;
AIC_INIT  push  R0              ;
          LDI   0x10,IE         ; Enable XINT interrupt
          andn  0x34,IF         ;
AIC_reset
          ldi   0,R0            ;
          sti   R0,@S0_xdata    ;
          RPTS  0x040           ;
          LDI   2,IOF           ; XF0=0 resets AIC
          rpts  0x40            ;
          LDI   6,IOF           ; XF0=1 runs AIC
          ldi   @S0_rdata,R0
          ldi   0,R0
          sti   R0,@S0_xdata
          ;-----------------------------
          ldi   @C_REG,R0       ; Setup control register
          call  prog_AIC        ;
          ldi   0xfffc  ,R0     ; Program the AIC to be real slow
          call  prog_AIC        ;
          ldi   0xfffc|2,R0     ;
          call  prog_AIC        ;
          ldi   @B_REG,R0       ; Bump up the Fs to final rate
          call  prog_AIC        ; (smallest divisor should be last)
          ldi   @A_REG,R0       ;
          call  prog_AIC        ;
          pop   R0              ;
          ldi   0,R0            ; Put a safe 0 in DXR
          sti   R0,@S0_xdata    ;
          ldi   @S0_rdata,R0    ; Clear receive underrun
          rets                  ;
;*****************************************************;
; Startup stub...                                     ;
;                                                     ;
; The following section of code is used only once for ;
; initialization and can be safely overwritten by     ;
; assembling it into the stack or volatile data       ;
; storage.                                            ;
;*****************************************************;
          .start   "STUB",BF    ; Place this code in the data buffer
          .sect    "STUB"       ; area as this is the first to go
          .entry   ST_STUB
ST_STUB   ldp   T0_ctrl         ; Use kernel data page and stack
          ldi   0,R0            ; Halt TIM0 & TIM1
          sti   R0,@T0_ctrl     ;
          sti   R0,@T1_ctrl     ;
          sti   R0,@T0_count    ; Set counts to 0
          sti   R0,@T1_count    ;
          ldi   1,R0            ; Set periods to 1
          sti   R0,@T0_prd      ;
          sti   R0,@T1_prd      ;
          ldi   0x2C1,R0        ; Restart both timers
          sti   R0,@T0_ctrl     ;
          sti   R0,@T1_ctrl     ;
          ;---------------------
          ldi   @S0_xctrl_val,R0;
          sti   R0,@S0_xctrl    ; transmit control
          ldi   @S0_rctrl_val,R0;
          sti   R0,@S0_rctrl    ; receive control
          ldi   0,R0            ;
          sti   R0,@S0_xdata    ; DXR data value
          ldi   @S0_gctrl_val,R0; Setup serial port
          sti   R0,@S0_gctrl    ; global control
          ;---------------------
          call  AIC_INIT        ; Initialize the AIC
          ldi   0x30,IE         ; Service both RINT/XINT
          ldi   @S0_rdata,R0    ;
          b     main            ;
;****************************************************;
; Install the XINT/RINT ISR handler directly into    ;
; the vector RAM location it will be used in         ;
;****************************************************;
          .start   "SP0VECTS",0x809FC5
          .sect    "SP0VECTS"
          B     DAC           ; XINT0
          B     ADC           ; RINT0
;*************************************************************;
; The folowing section is for C3x devices which are configured;
; in the u-processor mode (eg EVM or XDS510) and therefor have;
; RAM instead of bootrom at the vector table address.  The    ;
; DSK loader will also write to this address but the bootrom  ;
; is obviously not modifiable...                              ;
;*************************************************************;
          .start   "ROMVECTS",0x000000
          .sect    "ROMVECTS"
          .word    0x809FC0   ; RESET
          .word    0x809FC1   ; INT0
          .word    0x809FC2   ; INT1
          .word    0x809FC3   ; INT2
          .word    0x809FC4   ; INT3
          .word    0x809FC5   ; XINT0
          .word    0x809FC6   ; RINT0
          .word    0x809FC7   ; XINT1  NA
          .word    0x809FC8   ; RINT1  NA
          .word    0x809FC9   ; TINT0
          .word    0x809FCA   ; TINT1
          .word    0x809FCB   ; DINT
