//------------------------------------------------------------
// FFT_512.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  FFT_512.CPP is a DOS graphics based program which is a modifed
//  version of DSK_256.CPP.  In this case the data array is converted
//  to the frequency domain before it is sent to the PC for display.
//
//  +--------------------------------------------------------------+
//  | PLEASE NOTE: THIS APPLICATION USES EGA GRAPHICS              |
//  |                                                              |
//  | YOU MUST EITHER CREATE AND LINK IN EGAVGA.OBJ AND ALSO USE   |
//  | REGISTER THE DRIVER IN YOUR CODE WITH registerbgidriver();   |
//  | -OR-                                                         |
//  | EGAVGA.BGI MUST BE IN THE CURRENT DIRECTORY                  |
//  |                                                              |
//  | -ALSO-                                                       |
//  | THE LINKER OPTIONS NEED TO BE SET TO LINK IN GRAPHICS.LIB    |
//  +--------------------------------------------------------------+
//
//  The project file (link list) should include the following
//
//    FFT_512.CPP   This file
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//  * EGAVGA.OBJ    EGA and VGA graphics driver
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        This is a DOS graphics executable which uses the timelsice
//        managment interrupt hooks to make the application more efficient
//        at swapping in and out as a Windows task.
//
//        However since this application is a DOS graphics executable
//        it must be run full screen.  Compatiblity with other background
//        applications was NOT tested.
//
//        A PIF file can be created to automate setup and execution.
//--------------------------------------------------------------
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <graphics.h>
#include <bios.h>
#include "DSK.H"
#include "DSK_COFF.H"
#include "C3XMMRS.H"
#include "keydef.h"

#define MSG_BOX     0x809E00L
#define TRG_BOX     0x809E01L
#define A_BOX       0x809E02L
#define B_BOX       0x809E03L
#define C_BOX       0x809E04L
#define EDGESEL     0x809E05L
#define SAMPLES     0x809E06L
#define LOAD_BOX    0x809E07L
#define Samples 512 // FFT size
#define THx 40e-9   // DSP cycle time H1/H3 clock rate
#define DATABLOCK (0x809800L + Samples)
#define graph_vwport() setviewport( 50, 0, 563, 340, 1)
#define menu_vwport()  setviewport(334, 0, 639, 340, 1)
#define A_REG  ((TA <<9)+(RA <<2)+0) // A divisors.. set SCF rate
#define AP_REG ((TAP<<9)+(RAP<<2)+1) // TA RA prime registers (not used)
#define B_REG  ((TB <<9)+(RB <<2)+2) // B divisors

char DSK_APP[]    ="FFT512.DSK";
char DSK_EXE_APP[]="FFT_512.EXE";

typedef enum messages
{
  STOP =1,
  START=2
}message;

long  TLVL_V;
ulong T0_prdv = 0x00000001L;
ulong ZERO    = 0x00000000L;

float Hz_per_div = 0.0;
float Fsr=1000.0, Fsx=1000.0;
int   TA =  10;     // DAC divisors
int   TB =  14;     //
int   RA =  10;     // ADC divisors
int   RB =  14;     //
int   TAP=   1;     // TA' and RA' are not used in this application
int   RAP=   1;     //
int C_REG=0x03;     // AIC control register bits

int  oldbuf[Samples];
char buf_0[Samples];                      // Keep past data history for
char buf_1[Samples];                      // time averaging of signals
char buf_2[Samples];
char buf_3[Samples];
char buf_4[Samples];
char buf_5[Samples];
char buf_6[Samples];
char buf_7[Samples];
char buf_8[Samples];
char buf_pk_t[Samples];
int  buf_y_pk[Samples];

float fmax=0;
char  strg[32];
int   maxy=0,maxx=0;
float f,f1=0,f2=0,f3=0,f4=0,f5=0;
char  *p;

void binsprintf(char *s,int val);
void init_graphics(void);
int  check_key(void);
void out_TEXT(void);
int  avg_on = 0;
//--------------------------------------------------------
// draw the red cross bars at the top of each data column
//--------------------------------------------------------
#define pw 1 // define peak indicator draw width
void draw_peak(void)
{
  int  x, y, *y_pk;
  char *pk_t, *ptr0, *tmp0;
  pk_t = buf_pk_t;
  tmp0 = buf_0;
  y_pk = buf_y_pk;
  ptr0 = tmp0;                           // Set buffer pointers
  setcolor(LIGHTRED);
  for(x=0;x<Samples/2;x++)
  {
    y = 128 - *ptr0++;                  // present Y to display
    *pk_t += 1;                         // Inc times peak has been displayed
    if((*pk_t > 8) || (y < *y_pk))// If vmag>last redraw new peak
    {
      line(x-pw,*y_pk,x+pw,*y_pk  ); // undraw old hsorizontal peak
    //line(x   ,*y_pk,x   ,*y_pk-4); // vertical
      if(y <= *y_pk)                 // if vmag>last freshen peak hold
      {
        *y_pk = y;
        *pk_t = 0;
      }
      else
      {                              // else decay the peak
        if(y > (*y_pk+6))
          *y_pk += 6;
        else
          *y_pk += 1;
      }
      line(x-pw,*y_pk,x+pw, *y_pk  );  // draw new horizontal peak
   // line(x   ,*y_pk,x   , *y_pk-4);  // vertical
    }
    y_pk++;
    pk_t++;
  }
}
//--------------------------------------------------------
// draw the data data columns using an XOR line draw of
// only the pixels that change for maximum speed.
//--------------------------------------------------------
void draw_vect()
{
  int  x, y, *old;
  char *ptr0, *tmp0;
  tmp0 = buf_0;
  ptr0 = tmp0;                           // Set buffer pointers
  setcolor(WHITE);
  old = oldbuf;
  setwritemode(1);
  for(x=0;x<Samples/2;x++)
  {
    y = 128 - *ptr0++;                  // present Y to display
//  if(y == old_y) do nothing
    if(y  > *old) line(x,*old+1,x,y  );
    if(y  < *old) line(x,*old  ,x,y+1);
    *old++ = y;
  }
  setfillstyle(SOLID_FILL, BLACK);
  bar(0,261,256,268);
  if(maxx < 128)
  {
    sprintf(strg,"^ %7.3f",fmax);
    outtextxy(maxx,261,strg);
  }
  else
  {
    sprintf(strg,"%7.3f ^",fmax);
    outtextxy(maxx-67,261,strg);
  }
}
//--------------------------------------------------------
// main(): Note the use of an outer/inner forever loop.
// If a communications error occurs in the inner loop the
// outer loop catches the error and re-initializes the DSK
//--------------------------------------------------------
void main(void)
{
  int New_Params = 0, reset_flag = 0;
  ulong MSG=START, aic;
  long l;
  float sum;
  MSGS err;
  char *ptr1, *ptr2, *ptr3, *ptr4;
  char *ptr5, *ptr6, *ptr7, *ptr8, *ptr0;
  char *tmp1, *tmp2, *tmp3, *tmp4;
  char *tmp5, *tmp6, *tmp7, *tmp8, *tmp0;
  int x;
  clrscr();
  Scan_Command_line(DSK_EXE_APP);
  clrscr();
  //***********************************************//
  // The outer loop initializes the DSK on entry   //
  // or if the application fails                   //
  //***********************************************//
  for(;;)
  { for(;;)
    { if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }
    HALT_CPU(); // Halt previously running apps code
    if((err=Load_File(DSK_APP,LOAD))!=NO_ERR)
    { printf("%s %s\n",DSK_APP,Error_Strg(err));
      exit(0);
    }
    RUN_CPU();
    init_graphics();
    //
    // Init buff ptrs, Temps are rotated
    //
    tmp0 = buf_0;
    tmp1 = buf_1; tmp2 = buf_2; tmp3 = buf_3; tmp4 = buf_4;
    tmp5 = buf_5; tmp6 = buf_6; tmp7 = buf_7; tmp8 = buf_8;
    ptr0 = tmp0;
    for(x=0;x<Samples;x++)                   // Clear all buffers
    {
      buf_1[x] = 0; buf_2[x] = 0; buf_3[x] = 0; buf_4[x] = 0;
      buf_5[x] = 0; buf_6[x] = 0; buf_7[x] = 0; buf_8[x] = 0;

      buf_0[x]    = 0;
      buf_y_pk[x] = 255;
      buf_pk_t[x] = 8;
      oldbuf[x]   = 255;
    }
    check_key();
    draw_vect(); //
    draw_peak(); // Draw peaks and vector displays using XOR write
    //***********************************************************//
    // The inner loop is repeated until a keyboard hit exits the //
    // application or the application reports an error and needs //
    // to be reinitialized                                       //
    //***********************************************************//
    for(;;)
    { // The inner loop draws the display using an XOR line draw
      // to overdraw existing vectors
      //
      // Search the data array for the maximum peak and then find the
      // centroid to determine a more acurate frequency.
      // DC and Nyquist are not included since the centroid requires
      // values +/- from the peak to work.  Also, small DC offsets
      // can overwhelm small signals that are the likely target
      //
      ptr1 = tmp0+2;
      maxy = *ptr1;
      maxx = 0;
      for(x=2;x<254;x++)
      { if(*ptr1>maxy)
        { maxy = *ptr1;
          maxx = x;
        }
        ptr1++;
      }
      x = maxx;
      maxx-=3;    // half pixel width of '^' symbol
      //
      // This section converts the logrithmic (dB) character data back to
      // linear using the same floating point - log2 duality that was used
      // to convert to log but in reverse for 2^val exponentiation.  The
      // now linear data is then used to find the centroid of the spectral
      // peak.  Five bins are used to help maintain a better center.
      //
      // signed char IEEE exp  Remove sgn Correct  Cast to float
      // log value   offset    (all pos)  position
      //
      l= buf_0[x-2]; l+=0x3F8; l&=0x7FFF; l=l<<20; f1=*((float *)&l);
      l= buf_0[x-1]; l+=0x3F8; l&=0x7FFF; l=l<<20; f2=*((float *)&l);
      l= buf_0[x  ]; l+=0x3F8; l&=0x7FFF; l=l<<20; f3=*((float *)&l);
      l= buf_0[x+1]; l+=0x3F8; l&=0x7FFF; l=l<<20; f4=*((float *)&l);
      l= buf_0[x+2]; l+=0x3F8; l&=0x7FFF; l=l<<20; f5=*((float *)&l);
      sum = f1+f2+f3+f4+f5;
      if(sum==0)
        f = 0;
      else
      {
        f = f1*(x-2) + f2*(x-1) + f3*(x) + f4*(x+1) + f5*(x+2);
        f /= sum;
        f    = ((f * Fsr)/512.0)*1e-3;
        //
        // Use a smear filter to remove jitter
        //
        #define Smear 8
        fmax = (fmax*(Smear-1) + f)/Smear;
      }
      //--------------------------------------------------------
      // Average the data over up to 8 frames
      //
      ptr0 = tmp0;                                   // Set buffer pointers
      ptr1 = tmp1; ptr2 = tmp2; ptr3 = tmp3; ptr4 = tmp4;
      ptr5 = tmp5; ptr6 = tmp6; ptr7 = tmp7; ptr8 = tmp8;
      for(x=0;x<Samples/2;x+=1)
      { switch(avg_on)
        { case  1: *ptr0=(*ptr1+*ptr2)             >> 1; break; // avg 2
          case  2: *ptr0=(*ptr1+*ptr2+*ptr3+*ptr4) >> 2; break; // avg 4
          case  3: *ptr0=(*ptr1+*ptr2+*ptr3+*ptr4+              // avg 8
                          *ptr5+*ptr6+*ptr7+*ptr8) >> 3; break;
          default: *ptr0= *ptr1;                         break; // avg 1
        }
        ptr0++;
        ptr1++; ptr2++; ptr3++; ptr4++;               // next data
        ptr5++; ptr6++; ptr7++; ptr8++;
      }
      draw_vect();
      draw_peak();
      // To prevent getmem timeouts an artificial strobe is used to
      // signal to the DSK that a host request is in progress
//    delay(100);
      disable_Mtask();
      HPI_STRB(0);            // Drive HPSTB (INT2) low and wait
      reset_flag = 0;
      for(;;)                 // for DSK to stop with full buffer
      { if(kbhit())
        {
          reset_flag = check_key();
          New_Params=1;
        }
        if(reset_flag) break;
        if(HPI_ACK())break;  // Note: break last to ensure keytrap!
        delay(1);
      }
      enable_Mtask();
      if(reset_flag) break;

      ptr1 = tmp8;                    // Rotate the buffer pointers
      tmp8 = tmp7; tmp7 = tmp6; tmp6 = tmp5; tmp5 = tmp4;
      tmp4 = tmp3; tmp3 = tmp2; tmp2 = tmp1; tmp1 = ptr1;
      //
      // If a key was pressed, update the AIC setup
      if(New_Params)
      {
        if(putmem(T0_prd  ,        1,&T0_prdv)!=NO_ERR) break;
        if(putmem(T0_count,        1,      &ZERO)!=NO_ERR) break;
        if(putmem(T1_prd  ,        1,&T0_prdv)!=NO_ERR) break;
        if(putmem(T1_count,        1,      &ZERO)!=NO_ERR) break;
        if(TB>TA)
        {
          aic = A_REG; if(putmem(A_BOX,1,&aic)!=NO_ERR) break;
          aic = B_REG; if(putmem(B_BOX,1,&aic)!=NO_ERR) break;
        }
        else
        {
          aic = B_REG; if(putmem(A_BOX,1,&aic)!=NO_ERR) break;
          aic = A_REG; if(putmem(B_BOX,1,&aic)!=NO_ERR) break;
        }
        aic = C_REG; if(putmem(C_BOX,1,&aic)!=NO_ERR) break;
        if(putmem(LOAD_BOX,1,&aic)!=NO_ERR) break; // Any nonzero reinits AIC
      }
      New_Params = 0;
      if(getmem(DATABLOCK,Samples/8,(ulong *)ptr1)!=NO_ERR) break;//128 char
      putmem(MSG_BOX,1,&MSG);
    }
    closegraph();  // Shutdown graphics before re-initializing
    printf("%s: %s\n",DSK_APP, Error_Strg(err));
    printf("Communications are being reinitialized");
    delay(1000);
    DSK_reset();
  }
}
//-------------------------------------------------------
// clip() clips a value to min and max
//-------------------------------------------------------
long inline clip(long x, int min, int max)
{
  if(x<min) return min;
  if(x>max) return max;
  return x;
}
//-------------------------------------------------------
// check_key() is the main keytrap routine.
//-------------------------------------------------------
int check_key(void)
{
  int key=0;
  char buf[80];
  int Yt=0;
  static int old_key=0;  // If the same key is hit repeatedly, speed up
  static int accel=1;

  if(kbhit()) key = bioskey(0) & 0xFF00;
  if(old_key==key) accel = accel + 1;
  else             accel = accel / 4;
  accel = clip(accel,1,200); old_key = key;
  if(key)
  {
    switch(key)
    {
      case _Ins: T0_prdv -=accel; break;
      case _Del: T0_prdv +=accel; break;
      case _R  : return 1;  // Return reset (break) flag
      case _Q  : enable_Mtask();
                 closegraph();
                 _setcursortype(_NORMALCURSOR);
                 exit(0);
                 break;
      case _F1 : TA++; break;
      case _F2 : TA--; break;
      case _F3 : TB++; break;
      case _F4 : TB--; break;
      case _F5 : RA++; break;
      case _F6 : RA--; break;
      case _F7 : RB++; break;
      case _F8 : RB--; break;
      case _1  : C_REG = C_REG ^ 0x80; break; // bit 7
      case _2  : C_REG = C_REG ^ 0x40; break; // bit 6
      case _3  : C_REG = C_REG ^ 0x20; break; // bit 5
      case _4  : C_REG = C_REG ^ 0x10; break; // bit 4
      case _5  : C_REG = C_REG ^ 0x08; break; // bit 3
      case _6  : C_REG = C_REG ^ 0x04; break; // bit 2
      case _A  :
                 switch(avg_on)
                 {
                   case  1: avg_on=2; break;
                   case  2: avg_on=3; break;
                   case  3: avg_on=4; break;
                   default: avg_on=1; break;
                 }
                 break;

      default : return 0;
    }
    TA         = clip(TA        ,     3,         31);
    TB         = clip(TB        ,    12,         63);
    RA         = clip(RA        ,     3,         31);
    RB         = clip(RB        ,    12,         63);
    T0_prdv = clip(T0_prdv,     1,         64);
  }
  setwritemode(0);                      // turn off XOR write
  menu_vwport();                       // Write to window in bright blue
  clearviewport();
  setcolor(11);
  Yt=1;

  #define C1 1
  outtextxy(C1,Yt    ,   "Q    quit"  );
  outtextxy(C1,Yt+=10,   "R    reset" ); switch(avg_on)
  { case  1: sprintf(buf,"A    avg    => 2 frames");break;
    case  2: sprintf(buf,"A    avg    => 4 frames");break;
    case  3: sprintf(buf,"A    avg    => 8 frames");break;
    default: sprintf(buf,"A    avg    => 1 frame");break;
  }
  outtextxy(C1,Yt+=10,buf);

  Yt+=10;
  sprintf(buf,"Ins  TIM0+");  outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"Del  TIM0-  => Tprd=%02ld",T0_prdv);  outtextxy(C1,Yt+=10,buf);

  Yt+=10;
  sprintf(buf,"F1   TA++");                    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F2   TA--   => TA=%02d",TA);    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F3   TB++");                    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F4   TB--   => TB=%02d",TB);    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F5   RA++");                    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F6   RA--   => RA=%02d",RA);    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F7   RB++");                    outtextxy(C1,Yt+=10,buf);
  sprintf(buf,"F8   RB--   => RB=%02d",RB);    outtextxy(C1,Yt+=10,buf);
//sprintf(buf,"            => Fdac=%7.2f",Fsx);outtextxy(C1,Yt+=10,buf);
//sprintf(buf,"            => Fadc=%7.2f",Fsr);outtextxy(C1,Yt+=10,buf);

  Yt+=10;
 sprintf(buf,"AIC CTRL:  ");binsprintf(buf+10,C_REG);outtextxy(C1,Yt+=10,buf);
 sprintf(buf,"          ||||||"                   ); outtextxy(C1,Yt+=10,buf);
 sprintf(buf,"  use num |||||+---6   BP filter"   ); outtextxy(C1,Yt+=10,buf);
 sprintf(buf,"  keys to |||+-----5   Loopback"    ); outtextxy(C1,Yt+=10,buf);
 sprintf(buf,"  toggle  ||+------4   AIN/AUXIN"   ); outtextxy(C1,Yt+=10,buf);
 sprintf(buf,"  bits    |+-------3   Asynch/synch"); outtextxy(C1,Yt+=10,buf);
 sprintf(buf,"          +--------1,2 gain bits"   ); outtextxy(C1,Yt+=10,buf);
  Yt+=10;
  switch(C_REG&0xC0)
  { case 0x00:  outtextxy(C1,Yt+=10,"+0dB      6.0 Vmax"); break;
    case 0x40:  outtextxy(C1,Yt+=10,"+6dB      3.0 Vmax"); break;
    case 0x80:  outtextxy(C1,Yt+=10,"+12dB     1.5 Vmax"); break;
    case 0xC0:  outtextxy(C1,Yt+=10,"+0dB      6.0 Vmax"); break;
  }
  if(C_REG&0x20)outtextxy(C1,Yt+=10,"Synch     Fadc==Fdac");
  else          outtextxy(C1,Yt+=10,"Asynch    Fadc!=Fdac");
  if(C_REG&0x10)outtextxy(C1,Yt+=10,"AUXIN     ENABLE");
  else          outtextxy(C1,Yt+=10,"AIN       ENABLE");
  if(C_REG&0x08)outtextxy(C1,Yt+=10,"loopback  ENABLE");
  else          outtextxy(C1,Yt+=10,"loopback  DISABLE");
  if(C_REG&0x04)outtextxy(C1,Yt+=10,"BP filter ENABLE");
  else          outtextxy(C1,Yt+=10,"BP filter DISABLE");

  graph_vwport();
  Fsx     = 1/(2*TA*TB*(2*THx * T0_prdv));
  if(C_REG & 0x20) Fsr = Fsx;
  else             Fsr = 1/(2*RA*RB*(2*THx * T0_prdv));
  Hz_per_div = (520.0/Samples)*Fsr/(2.0*10);
  //
  //
 setfillstyle(SOLID_FILL, BLACK);
 bar(0,269,260,310);

 sprintf(buf,  "Hz/div=%7.2f",Hz_per_div); outtextxy(10,270,buf);
 sprintf(buf,  "  Fdac=%7.2f",Fsx); outtextxy(10,285,buf);
 if(C_REG&0x20)
   sprintf(buf,"  Fadc=Fdac");
 else
   sprintf(buf,"  Fadc=%7.2f",Fsr);
 outtextxy(10,295,buf);

 sprintf(buf,"Note: A sawtooth signal generated by the DAC can be looped");
 outtextxy(10,315,buf);
 sprintf(buf,"      back for self analysis using the number 5 key");
 outtextxy(10,325,buf);
 return 0;
}
//-----------------------------------------------------------------
// init_graphics() is responsible for initializing the graphics
// and then filling in the display lines and text
//-----------------------------------------------------------------
void init_graphics(void)
{
  int gdriver = EGA, gmode = EGAHI, errorcode, Y, X;
//
// register EGAVGA_driver which is the name of the driver in EGAVGA.OBJ
// EGAVGA.OBJ is created from EGAVGA.BGI using the BGIOBJ.EXE utility
// and is linked by either the link list or project file
//
// NOTE: This section of code can be ommitted if EGAVGA.BGI is
//       located in the applications startup directory
//
errorcode = registerbgidriver(EGAVGA_driver);
if (errorcode < 0)  // report any registration errors
{
   printf("Graphics error: %s\n", grapherrormsg(errorcode));
   printf("Press any key to halt:");
   getch();
   exit(1); // terminate with an error code
}

  initgraph(&gdriver, &gmode, "");        // if possible open EGA mode
  errorcode = graphresult();
  if (errorcode != grOk)
  { printf("Graphics error: %s\n", grapherrormsg(errorcode));
    printf("Press any key to halt:");
    getch();
    exit(1);
  }
  clearviewport();                        //
  graph_vwport();
  setcolor(GREEN);
  for(Y=0;Y<=260;Y+=26) line(0,Y,260,Y);  // draw reticle
  for(X=0;X<=260;X+=26) line(X,0,X,260);  //

//  setcolor(DARKGRAY);
  Y = 2;
  X = 2;
  outtextxy(X,Y    ,"+20");
  outtextxy(X,Y+=26,"+10");
  outtextxy(X,Y+=26," +0");
  outtextxy(X,Y+=26,"-10");
  outtextxy(X,Y+=26,"-20");
  outtextxy(X,Y+=26,"-30");
  outtextxy(X,Y+=26,"-40");
  outtextxy(X,Y+=26,"-50");
  outtextxy(X,Y+=26,"-60");
  outtextxy(X,Y+=26,"-70");
//outtextxy(X,Y+=26,"-80");

  setwritemode(1);                        // display lines are XOR drawn
  setcolor(15);                           // light gray
}
//-------------------------------------------------
// binsprintf() creates a 1/0 binary print string
//-------------------------------------------------
void binsprintf(char *s,int val)
{
  char *p;
  unsigned int t;
  p = s;
  t = 0x80;  // scan 8 bits
  for(;t>0;t=t>>1)
  {
    if(val & t) *p++ = '1';
    else        *p++ = '0';
  }
  *p=0;
}
