;---------------------------------------------------------------------
; IDLE2.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; This code shows a feature of the C31 where IDLE2 can be used to
; freeze the external bus during a data write.  If used properly
; this can eliminate the need for 32 data bus pullup/down resistors
;
; To use this feature the value being written to external bus must
; be in the middle of a write cycle when the IDLE2 executes.  This
; may require shuffling the opcodes around a little depending on
; the bus control register setup.
;
; A second feature has been added showing how to configure the timer
; and serial port pins as general putpose outputs.  To avoid driver
; conflicts with the AIC, the state of the pins are first sampled
; while the pins are configured as inputs.  The direction is then
; changed reinforcing the original state.  Note that it is import to
; halt the timer first since this drives the MCLK of the AIC.
; Another option is to simply disconnect the AIC via jumper block JP1
;---------------------------------------------------------------------
          .include "C3XMMRS.ASM"
          .start "CODE",0x809802 ; Start assembling CODE section here
          .sect  "CODE"          ;
          .entry  SAMPLE         ; Debugger entry point
          ;----------------------
SAMPLE    ldp     @stack         ; Load a data page
          ldi     @stack,SP      ; Load a stack pointer
          ;----------------------
          call    TIM_OFF
          call    SP_OFF
          ;----------------------
          ldi     0,R0           ; Load all 0's into R0
          ldi     0x4000,AR0     ; Load AR0=0x8000 with an external address
          lsh     1,AR0          ;
          ;----------------------
LOOP      not    R0,R0           ; Invert all bits
          call   LOZBUS          ; Freeze R0 value on bus while in IDLE2
          call   HIZBUS          ; Execute an IDLE2 normaly (bus is tri-state)
          b      LOOP            ;
          ;----------------------
LOZBUS    sti    R0,*AR0         ; Write bit pattern to the external bus
       ;  nop                    ; more code depending on bus setup
       ;  nop                    ;
          idle2                  ; Freeze operation during a multicycle write
          rets                   ;
          ;----------------------
HIZBUS    idle2                  ; Freeze operation - No write
          rets                   ;
          ;----------------------  Shutdown TIM_0
TIM_OFF   ldi    @TIM_input,R0   ;
T0        sti    R0,@T0_ctrl     ;
          ldi    @T0_ctrl,R0     ; Readback pin states
          rpts   15              ;
          ldi    @T0_ctrl,R0     ;
          and    @TIM_inmask,R0  ; Mask current pin states
          lsh    -1,R0           ; Move to ouput bit position
          or     @TIM_output,R0  ; Set timer as output
          sti    R0,@T0_ctrl     ;
          ;- - - - - - - - - - -   Repeat for TIM_1
          ldi    @TIM_input,R0   ;
          sti    R0,@T1_ctrl     ;
          ldi    @T1_ctrl,R0     ; Readback pin states
          rpts   15              ;
          ldi    @T1_ctrl,R0     ;
          and    @TIM_inmask,R0  ; Mask current pin states
          lsh    -1,R0           ; Move to ouput bit position
          or     @TIM_output,R0  ; Set timer as output
          sti    R0,@T1_ctrl     ;
          rets
          ;----------------------
SP_OFF    ldi    @SP_input,R0    ; Shutdown serial port xmit
          sti    R0,@S0_xctrl    ;
          ldi    @S0_xctrl,R0    ; Readback pin states
          rpts   15              ;
          ldi    @S0_xctrl,R0    ;
          and    @SP_inmask,R0   ; Mask current pin states
          lsh    -1,R0           ; Move to ouput bit position
          or     @SP_output,R0   ; Set timer as output
          sti    R0,@S0_xctrl    ;
          ;- - - - - - - - - - -
          ldi    @SP_input,R0    ; Shutdown serial port xmit
          sti    R0,@S0_rctrl    ;
          ldi    @S0_rctrl,R0    ; Readback pin states
          rpts   15              ;
          ldi    @S0_rctrl,R0    ;
          and    @SP_inmask,R0   ; Mask current pin states
          lsh    -1,R0           ; Move to ouput bit position
          or     @SP_output,R0   ; Set timer as output
          sti    R0,@S0_rctrl    ;
          rets                   ;
          ;----------------------
SP_input   .word  0x00000000
SP_output  .word  0x00000222
SP_inmask  .word  0x00000888

TIM_input  .word  0x00000000
TIM_output .word  0x00000002
TIM_inmask .word  0x00000008

stack   .word   $
        .end
