;---------------------------------------------------------
; FIR.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; The FIR filter code used in this example is taken
; from the TMS320C3x Users Guide.  The AIC setup and
; control is designed to work with the TMS320C31 DSK
;
; This example can either be loaded and run from the debugger
; or by directly loading and running from DSK3LOAD
;---------------------------------------------------------
; Define constants used by program    ;
TA        .set     8                  ; AIC timing register values
TB	  .set	   20		      ;
RA        .set     8                  ;
RB	  .set	   20		      ;
GIE       .set     0x2000             ; This bit in ST turns on interrupts
          .include "C3XMMRS.ASM"      ;
          .start   "AICTEST",0x809802 ; Start assembling here
          .sect    "AICTEST"          ;
N         .set     32                 ; Up to N taps data/coef storage
;------------------------------------------------------------------------
; 32 bit float data buffer of incoming data from the AIC
; The location in memory must be on a 2^N boundary and the
; size of the coefficeint table must be the same as the data
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; NOTE that the first two locations are skipped.  The first two locations
; should not be used if the application is to be directly bootloaded into
; the on-chip RAM.  The first two locations are reserved by the bootloader
; as a small stack area.
;------------------------------------------------------------------------
ADC_recv     .set      $-2
             .loop     N-2
	     .float    0.0
             .endloop
;- - - - - - - - - - - - - - - - - - - - - - - - -
; FIR filter coefficients
;- - - - - - - - - - - - - - - - - - - - - - - - -
FIR_coef     .float    1.0	      ; FIR filter coefficients
	     .float    0.0	      ;
	     .float    0.0	      ;
	     .float    0.0	      ;
	     .float    0.0	      ; These coefficients will create a
	     .float    0.0	      ; comb filter at   Hz.  By inspection
	     .float    0.0	      ; all taps are zero except for the 0th
	     .float    0.0	      ; and 15th that are set to 1 and -1
	     .float    0.0	      ; respectively.  Therefor a cancellation
	     .float    0.0	      ; will occur for any signal which is
	     .float    0.0	      ; 180' out of phase when delayed by
	     .float    0.0	      ; 15 samples.  The Z transform is...
	     .float    0.0	      ;
	     .float    0.0	      ;
	     .float    0.0	      ; 	-15
	     .float   -1.0	      ; H(z)=1-z
END_coef
IIR_COEF     .word    IIRCOEF         ;
IIR_DELAY    .word    IIRDELAY        ;

             .if 0
B0           .set       0.5000000000000 ; 0.5, 1.0, 0.5 forms a LPF
B1           .set       1.0000000000000 ; in the feedforward (FIR)
B2           .set       0.5000000000000 ;
;A0          .set       1.0000000000000 ; y[n] = x[n] 0.5*y[n-1]
A1           .set       0.5000000000000 ;
A2           .set       0.0000000000000 ; simple schmooze low pass
             .endif

             .if 1
B0           .set       0.0000000000000 ; 0, 1, 0 forms an all pass
B1           .set       1.0000000000000 ; in the feedforward (FIR)
B2           .set       0.0000000000000 ;
;A0          .set       1.0000000000000 ; LPF coefficients from design
A1           .set  0.8*-0.9623253014110 ; package were not stable at
A2           .set  0.8* 0.2372719360026 ; first.  0.8* seems to work
             .endif

             .align
IIRCOEF      .float    A2             ;
             .float    B2             ;
             .float    A1             ;
             .float    B1             ;
             .float    B0             ;
             .float    0.0            ; IIRDELAY to 2^N boundary
             .float    0.0            ;
             .float    0.0            ;

IIRDELAY     .float    0
             .float    0
             .float    0
             .float    0
             .float    0
             .float    0
             .float    0
             .float    0
;-------------------------------------------------------
; If more coeficients than buffers, generate an error
;-------------------------------------------------------
SZ           .set     END_coef-FIR_coef; Size of filter
              .if      N<SZ
              error -> The buffer length is less than coeficient length
              .endif
;-------------------------------------
SIZE         .word    SZ               ; Size of filter
ADC_first    .word    ADC_recv         ;
ADC_end      .word    ADC_recv+SZ      ;
ADC_last     .word    ADC_recv         ;
FIR_coefx    .word    FIR_coef         ;
;------------------------------------
; Define some constant storage data
;------------------------------------
A_REG        .word  (TA<<9)+(RA<<2)+0 ; A registers
B_REG        .word  (TB<<9)+(RB<<2)+2 ; B registers
C_REG	     .word  00000011b	      ; control
S0_gctrl_val .word  0x0E970300        ; Serial port control register values
S0_xctrl_val .word  0x00000111        ;
S0_rctrl_val .word  0x00000111        ;
;****************************************************
; Begin main code loop here
;****************************************************
main      or    GIE,ST          ; Turn on INTS
          ldi   0xF4,IE         ; Enable XINT/RINT/INT2
          b     main            ; Do it again!
;-------------------------------
;
; A direct IIR form called a bi-quad is shown below.  It can be considered
; two be two cascaded filter type.  The first half is in the form of an FIR,
; comprising only of feed forward taps.  The second half, which feeds back
; delayed versions of the output, is that of an IIR.
;
;  y[n] = A1*y[n-1] + A2*y[n-2] + B0*x[n] + B1*x[n-1] + B2*x[n-2]
;
;        (FIR feed forward)                 (IIR feed back)
;
;                                             +------------->> Output Yn
;                                             |
;                                +---------+  |
; Input    +---+     +---+       |         |  |  +---+     +---+
; x[n]--+->| t |--+->| t |--*B2->|    +    |--+->| t |--+->| t |-+
;       |  +---+  |  +---+       |         |     +---+  |  +---+ |
;       |         |              +---------+            |        |
;       |         |               ^ ^   ^ ^             |        |
;       |         |               | |   | |             |        |
;       |         +---------*B1---+ |   | +--*A1--------+        |
;       |                           |   |                        |
;       +-------------------*B0-----+   +----*A2-----------------+
;
;
; Since the ordering of filter sections is not critical, the FIR can
; follow the IIR as shown below.  Note how the number of coefficients
; is the same, but the number of delays is reduced.  The equation can
; also be rewritten as shown.
;
;    d[n] =    x[n] + A1*d[n-1] + A2*d[n-1]   (IIR)
;    y[n] = B0*d[n] + B1*d[n-1] + B2*d[n-2]   (FIR)
;
;       (IIR feed back)                    (FIR feed forward)
;
;                      d[n]                     +-----+
;                  +----------------------*B0-->|     |     y[n]
;                  |          +-----------*B1-->|  +  |--------> Out
;         +-----+  |          |        +--*B2-->|     |
; Input   |     |  |  +---+   |  +---+ |        +-----+
; x[n] -->|  +  |--+->| t |--++->| t |-+
;         |     |     +---+  |   +---+ |
;         +-----+            |         |
;           ^ ^              |         |
;           | |       d[n-1] |         |
;           | +--*A1---------+         |
;           |         d[n-2]           |
;           +----*A2-------------------+
;
;
IIR       ldi   @IIR_COEF,AR0
          ldi   @IIR_DELAY,AR1
          ldi   3,BK
          mpyf3 *AR0,*AR1,R0
          mpyf3 *++AR0(1),*AR1--(1)%,R1
          mpyf3 *++AR0(1),*AR1,R0
     ||   addf3  R0,R2,R2
          mpyf3 *++AR0(1),*AR1--(1)%,R0
     ||   addf3  R0,R2,R2
          mpyf3 *++AR0(1),R2,R2
     ||   stf    R2,*AR1++(1)%
          addf   R0,R2
          addf   R1,R2,R0
       ;  sti   AR0,@IIR_COEF
          sti   AR1,@IIR_DELAY
          rets
;-------------------------------
FIR       ldi   @ADC_last,AR1   ; Load pointers and circular access regsiters
          ldi   @FIR_coefx,AR0
          ldi   @SIZE,BK
          mpyf3 *AR0++,*AR1++(1)%,R0
          ldf   0.0,R2
          ldi   @SIZE,RC
          subi  2,RC
          rptb  FIR2
          mpyf3 *AR0++,*AR1++(1)%,R0
FIR2  ||  addf3 R0,R2,R2
          addf  R2,R0
          sti   AR1,@ADC_last   ; Load pointers and circular access regsiters
          rets
;-------------------------------
IIRX      ldi   @S0_rdata,R2
          ash   -16,R2
          float R2,R2
          call  IIR
          rets
;-------------------------------
IIR0      ldf   0.0,R2
          call  IIR
          rets
;-------------------------------
IIR1      ldf   1.0,R2
          call  IIR
          rets
;-------------------------------
DAC2      push  ST              ; DAC Interrupt service routine
          push  R0              ; Save what is to be used
          pushf R0              ;
          push  R1              ;
          pushf R1              ;
          push  R2              ;
          pushf R2              ;
          push  AR0             ;
          push  AR1             ;
          push  BK

      ;   call  FIR             ; FIR/IIR return with answer in F0

          .if 1                 ; 1 = ADC->IIR->DAC filter
          call  IIRX            ; 0 = impulse test
          .else                 ;
          ldi   0xC4,IE         ;
          ldf   0,R0            ;
          ldf   0,R1            ;
          ldf   0,R2            ;
IMPULSE   call  IIR0            ; <- 0  Set BP here using 'CMD:>sb IMPULSE'
          call  IIR0            ; <- 0  after loading with DSK3D and use
          call  IIR1            ; <- 1  F10 to step over each call
          call  IIR0            ; <- 0
          call  IIR0            ; <- 0
          call  IIR0            ; <- 0
          call  IIR0            ;    .  Response will be in F0
          call  IIR0            ;    .
          call  IIR0            ;    .
          call  IIR0            ;    .
          call  IIR0            ;    .
          call  IIR0            ;
          call  IIR0            ;
          call  IIR0            ;
          call  IIR0            ;
          call  IIR0            ;
          call  IIR0            ;
          call  IIR0            ;
          .endif
          fix   R0,R0           ;
          andn  3,R0            ;
          sti   R0,@S0_xdata    ; Output the new DAC value

          pop   BK
          pop   AR1             ; Restore what was used
          pop   AR0             ;
          popf  R2              ;
          pop   R2              ;
          popf  R1              ;
          pop   R1              ;
          popf  R0              ;
          pop   R0              ;
          pop   ST              ;
          reti                  ;
;-------------------------------
ADC2      push  ST              ; Save what is to be used
          push  R3              ;
          pushf R3              ;
          push  AR0             ;
          ldi   @S0_rdata,R3    ; Get data from serial port
          lsh   16,R3           ; sign extend 16 lsb's
          ash   -16,R3          ;
          ldi   @ADC_last,AR0   ;
          float R3,R3           ; Convert to float and store for FIR data
          stf   R3,*AR0++       ;
          cmpi  @ADC_end,AR0    ; If at end of buffer, wrap back to begin
          ldige @ADC_first,AR0  ;
          sti   AR0,@ADC_last   ;
          pop   AR0             ; Restore what was used
          popf  R3              ;
          pop   R3              ;
          pop   ST              ;
          reti                  ;
;*****************************************************;
; The startup stub is used during initialization only ;
; and can be safely overwritten by the stack or data  ;
;*****************************************************;
          .entry   ST_STUB      ; Debugger starts here
ST_STUB   ldp   T0_ctrl         ; Use kernel data page and stack
          ldi   @stack,SP
          ldi   0,R0            ; Halt TIM0 & TIM1
          sti   R0,@T0_ctrl     ;
          sti   R0,@T0_count    ; Set counts to 0
          ldi   1,R0            ; Set periods to 1
          sti   R0,@T0_prd      ;
          ldi   0x2C1,R0        ; Restart both timers
          sti   R0,@T0_ctrl     ;
          ;---------------------
          ldi   @S0_xctrl_val,R0;
          sti   R0,@S0_xctrl    ; transmit control
          ldi   @S0_rctrl_val,R0;
          sti   R0,@S0_rctrl    ; receive control
          ldi   0,R0            ;
          sti   R0,@S0_xdata    ; DXR data value
          ldi   @S0_gctrl_val,R0; Setup serial port
          sti   R0,@S0_gctrl    ; global control
;======================================================;
; This section of code initializes the AIC             ;
;======================================================;
AIC_INIT  LDI   0x10,IE         ; Enable only XINT interrupt
          andn  0x34,IF         ;
          ldi   0,R0            ;
          sti   R0,@S0_xdata    ;
          RPTS  0x040           ;
          LDI   2,IOF           ; XF0=0 resets AIC
          rpts  0x40            ;
          LDI   6,IOF           ; XF0=1 runs AIC
          ;---------------------
          ldi   @C_REG,R0       ; Setup control register
          call  prog_AIC        ;
          ldi   0xfffc  ,R0     ; Program the AIC to be real slow
          call  prog_AIC        ;
          ldi   0xfffc|2,R0     ;
          call  prog_AIC        ;
          ldi   @B_REG,R0       ; Bump up the Fs to final rate
          call  prog_AIC        ; (smallest divisor should be last)
          ldi   @A_REG,R0       ;
          call  prog_AIC        ;
          b     main            ; the DRR before going to the main loop
;-------------------------------
prog_AIC  ldi   @S0_xdata,R1    ; Use original DXR data during 2 ndy
          sti   R1,@S0_xdata    ;
          idle
          ldi   @S0_xdata,R1    ; Use original DXR data during 2 ndy
          or    3,R1            ; Request 2 ndy XMIT
          sti   R1,@S0_xdata    ;
          idle                  ;
          sti   R0,@S0_xdata    ; Send register value
          idle                  ;
          andn  3,R1            ;
          sti   R1,@S0_xdata    ; Leave with original safe value in DXR
          ;---------------------
          ldi   @S0_rdata,R0    ; Fix the receiver underrun by reading
          rets                  ;
stack     .word   $             ; Put stack here
;****************************************************;
; Install the XINT/RINT ISR handler directly into    ;
; the vector RAM location it will be used for        ;
;****************************************************;
          .start   "SP0VECTS",0x809FC5
          .sect    "SP0VECTS"
          B        DAC2         ; XINT0
          B        ADC2         ; RINT0
