//--------------------------------------------------------------
// MANDEL3X.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//--------------------------------------------------------------
//   NOTE: MANDEL3X.EXE USES SHAREWARE DOS LEVEL SVGA GRAPHICS
//         DRIVER WHICH WAS NOT CREATED BY TEXAS INSTRUMENTS.
//
//         SVGA256.BGI is a product of Jordon Powell Hargrave
//         and can be found in the shareware program
//
//         BG40.ZIP
//
//   SVGA256.BGI MUST BE IN THE CURRENT DIRECTORY!!
//   -ALSO-
//   THE LINKER OPTIONS NEED TO BE SET TO LINK IN GRAPHICS.LIB
//--------------------------------------------------------------
// MANDEL3X uses DSP programming and the C3x communications
// interface to accelerate the calculation of the Mandelbrot set
//--------------------------------------------------------------
//  Your project file should include the following
//
//    MANDEL3X.CPP  This file
//    VIDEO.CPP     Super VGA functions
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//    HARDWARE.CPP  Command line help message
//                  (Built from HARDWARE.HLP source)
//
//  * SVGA256.BGI   Must be in the runtime directory!
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        This application is a SVGA DOS graphics executable and MUST
//        be run in a full screen DOS session.
//---------------------------------------------------------
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graphics.h>
#include <dos.h>

#include "keydef.h"
#include "dsk.h"
#include "errormsg.h"
#include "DSK_COFF.h"
#include "video.h"
#include "tmsfloat.h"

#define Max_x 640
#define Max_y 480
double  Xmin  = -2.00;
double  Xmax  =  1.20;
double  Ymin  = -1.20;
double  Ymax  =  1.20;
double  TXmin = -2.00;
double  TXmax =  1.20;
double  TYmin = -1.20;
double  TYmax =  1.20;

char  DSK_APP[]="MANDEL.DSK";
char  DSK_EXE[]="MANDEL3X.EXE";

char  far *VRAM;
int   lines   =   1;
int   curs_x  = 100;
int   curs_y  = 100;
int   curs_x2 = 200;
int   curs_y2 = 200;
uint  last_x  =   0;
uint  last_y  =   0;
long  Maxiter =1024;
ulong pixdata[2048];
int   check_key(void);

//-----------------------------------------------------------
// Send user defined commands of various lengths to the target
//-----------------------------------------------------------
MSGS USERCMD1(ulong CMD)
{
  MSGS err=NO_ERR;
  if((err=xmit_long(XSPARE))!=NO_ERR) return err; // Function
  if((err=xmit_long(   CMD))!=NO_ERR) return err; // Sub function or 1st arg
  return err;
}
MSGS USERCMD2(ulong CMD, ulong ARG)
{
  MSGS err=NO_ERR;
  if((err=xmit_long(XSPARE))!=NO_ERR) return err; // Function
  if((err=xmit_long(   CMD))!=NO_ERR) return err; // Sub function or 1st arg
  if((err=xmit_long(   ARG))!=NO_ERR) return err; // next value
  return err;
}
MSGS USERCMD3(ulong CMD, ulong ARG1, ulong ARG2)
{
  MSGS err=NO_ERR;
  if((err=xmit_long(XSPARE))!=NO_ERR) return err; // Function
  if((err=xmit_long(   CMD))!=NO_ERR) return err; // Sub function or 1st arg
  if((err=xmit_long(  ARG1))!=NO_ERR) return err; // next value
  if((err=xmit_long(  ARG2))!=NO_ERR) return err; // next value
  return err;
}
//-----------------------------------------------
// Send the extended user command to the DSK
//-----------------------------------------------
MSGS man40(double X   ,double Y,
           double Xoff,double Yoff,
           long   Xpix,long   Ypix,
           long Maxiter)
{
  MSGS err;
  if((err = xmit_long(XSPARE        ))!=NO_ERR) return err;
  if((err = xmit_long(IEEE_TMS(X)   ))!=NO_ERR) return err;
  if((err = xmit_long(IEEE_TMS(Y)   ))!=NO_ERR) return err;
  if((err = xmit_long(IEEE_TMS(Xoff)))!=NO_ERR) return err;
  if((err = xmit_long(IEEE_TMS(Yoff)))!=NO_ERR) return err;
  if((err = xmit_long(Xpix          ))!=NO_ERR) return err;
  if((err = xmit_long(Ypix          ))!=NO_ERR) return err;
  if((err = xmit_long(Maxiter       ))!=NO_ERR) return err;
  return NO_ERR;
}

inline void putpixel1(int x, int y, int c)
{
  if(y != last_y)
  {
    putpixel(x,y,c);
    VRAM = (char far *)MK_FP(0xA000, ((y<<9)+(y<<7))+x);
    last_y = y;
  }
  else
    VRAM = (char far *)MK_FP(0xA000, FP_OFF(VRAM) + x-last_x);
  last_x = x;
  if(FP_OFF(VRAM)==0) putpixel(x,y,c);
  else                *VRAM = c;
}

inline uint getpixel1(int x, int y)
{
  int c;
  if(y != last_y)
  { c = getpixel(x,y);
    VRAM = (char far *)MK_FP(0xA000, ((y<<9)+(y<<7))+x);
    last_y = y;
  }
  else
    VRAM = (char far *)MK_FP(0xA000, FP_OFF(VRAM) + x-last_x);
  last_x = x;
  if(FP_OFF(VRAM) == 0) c = getpixel(x,y);
  else                  c = *VRAM;
  return c;
}

void put_cursor(void)
{
  int x, x1,x2, y, y1, y2;
  char c;
  if(curs_x < curs_x2) {x1 = curs_x; x2 = curs_x2;}
  else                 {x2 = curs_x; x1 = curs_x2;}
  for(x=x1;x<x2;x+=2)
  { c=getpixel1(x,curs_y );putpixel1(x,curs_y ,c^0xff);
    c=getpixel1(x,curs_y2);putpixel1(x,curs_y2,c^0xff);
  }
  if(curs_y < curs_y2) {y1 = curs_y; y2 = curs_y2;}
  else                 {y2 = curs_y; y1 = curs_y2;}
  for(y=y1;y<y2;y+=2)
  { c=getpixel1(curs_x ,y);putpixel1(curs_x ,y,c^0xff);
    c=getpixel1(curs_x2,y);putpixel1(curs_x2,y,c^0xff);
  }
}
//----------------------------------------------------------------
// fastline() is written to directly access the video memory
// for a much faster box fill operation.  fastline() only works
// with the SVGA256.BGI driver.  fastline() works by detecting
// 64K page boundary crossings of the video data pointer.  If a
// crossing is detected a standard putpixel() function is used
// to update the video cards registers.  This then insures that
// each direct write to the video memory goes to the correct
// page but without continuously calling putpixel().
//----------------------------------------------------------------
void fastline(int xc,int yc,int Xpix,int Ypix, char *p)
{
  register char far *VRAM;
  register int x;
  int y;
  long l;
  l = xc + (yc * Xpix);
  l = l & 0xFFFF;
  VRAM  = (char far *) MK_FP(0xA000, l);
  putpixel(xc,yc,*p); // Set the video page registers
  for(y=0;y<Ypix;y++)
  {
    for(x=0;x<Xpix;x++)
    {
      if(FP_OFF(VRAM)==0) // detect 64K offset rollover
      {
        VRAM = (char far *)MK_FP(0xA000,0); // go back to page start
        putpixel(xc+x,yc+y,*p); // Set the video page registers
      }
      *VRAM++ = *p++;
    }
  }
}



void mandelhelp(void)
{
  closegraph();
  clrscr();
  printf(
  "MANDEL3x Commands\n"
  "-----------------\n"
  "Use the arrow keys to move the corners of the next draw box\n"
  "Z - Toggles the corners\n"
  "X - Executes the new box\n"
  "Q - Quit\n"
  "1 - Black to White palette\n"
  "2 - White to black palette\n"
  "5 - Iteration limit = 256\n"
  "6 - Iteration limit = 512\n"
  "7 - Iteration limit = 1024\n"
  "8 - Iteration limit = 2048\n"
  "9 - Iteration limit = 4096\n"
  "0 - Iteration limit = 8192\n"
  "\n"
  "Note: When the draw box limits are changed, sections of the\n"
  "      original or underlying box may not disappear.  Upon\n"
  "      exiting the help menu, previously drawn pixels will not\n"
  "      be redrawn\n"
  "\n"
  "Hit any key to continue\n");
  getch();
  init_video();
  set_bw();
}

int check_key()
{
  double Ytmp;
  double Xtmp;
  uint   key  = 0;
  uint   rval = 0;
  char   MSG[80];
  if(kbhit())
  {
    put_cursor();
    key = bioskey(0) & 0xff00;
    switch(key)
    {
      case  _H  : mandelhelp(); break;
      case  _Q  : closegraph(); exit(0); break;
      case  _Hm : curs_y-=3; curs_x-=4; break;
      case  _Up : curs_y-=3;            break;
      case  _Pup: curs_y-=3; curs_x+=4; break;
      case  _Rt :            curs_x+=4; break;
      case  _Pdn: curs_y+=3; curs_x+=4; break;
      case  _Dn : curs_y+=3;            break;
      case  _End: curs_y+=3; curs_x-=4; break;
      case  _Lt :            curs_x-=4; break;
      case  _1  : set_bw();    break;
      case  _2  : set_ibw();   break;

      case  _5  : Maxiter =  256; break;
      case  _6  : Maxiter =  512; break;
      case  _7  : Maxiter = 1024; break;
      case  _8  : Maxiter = 2048; break;
      case  _9  : Maxiter = 4096; break;
      case  _0  : Maxiter = 8192; break;

      case  _X  : TXmin = Xmin;
                  TXmax = Xmax;
                  TYmin = Ymin;
                  TYmax = Ymax;
                  rval=1  ; break;
      case  _Z  : //put_cursor();
		  curs_y2 = curs_y  ;
		  curs_x2 = curs_x  ; break;
      default : break;
    }
    if(curs_x > Max_x -5) curs_x = Max_x-5;
    if(curs_x <        5) curs_x =       5;
    if(curs_y > Max_y -5) curs_y = Max_y-5;
    if(curs_y <        5) curs_y =       5;
    put_cursor();
  }
  Ytmp = TYmin + (TYmax-TYmin)* ((double)(Max_y-curs_y )/(double)Max_y);
  Ymax = TYmin + (TYmax-TYmin)* ((double)(Max_y-curs_y2)/(double)Max_y);
  Ymin = Ytmp;
  if(Ymax < Ymin) {Ytmp = Ymin; Ymin=Ymax ; Ymax = Ytmp;}

  Xtmp = TXmax - (TXmax-TXmin)* ((double)(Max_x-curs_x )/(double)Max_x);
  Xmax = TXmax - (TXmax-TXmin)* ((double)(Max_x-curs_x2)/(double)Max_x);
  Xmin = Xtmp;
  if(Xmax < Xmin) {Xtmp = Xmin; Xmin=Xmax ; Xmax = Xtmp;}
  setfillstyle(EMPTY_FILL, 0);   // Black
  bar(0,0,630,10);
  sprintf(MSG,"X:%3.6lf %3.6lf Y:%3.6lf %3.6lf  %d %d %d %d  Iter:%ld",
               Xmin,    Xmax,    Ymin,    Ymax, curs_x,curs_x2,curs_y,curs_y2,   Maxiter);
  outtextxy(0,0,MSG);
  return(rval);
}

void main(void)
{

  MSGS err;
  double X,Xoff,Y,Yoff;
  int y;
  int Ylines  =     4;
  Scan_Command_line(DSK_EXE);
  Detect_Windows();
  for(;;)
  { if((err=Init_Communication(1000)) == NO_ERR) break;
    if(kbhit()) exit(0);
  }
  HALT_CPU();
  if((err=Load_File(DSK_APP,LOAD))!=NO_ERR)
  { printf("%s %s\n",DSK_APP,Error_Strg(err)); exit(0); }
  RUN_CPU();
  init_video();
  set_bw();
  TXmin = Xmin;
  TXmax = Xmax;
  TYmin = Ymin;
  TYmax = Ymax;

  for(;;)
  {
    X = TXmin;  Y = TYmax;
    Xoff = (double)(TXmax-TXmin)/(double)Max_x;
    Yoff = (double)(TYmin-TYmax)/(double)Max_y;
    cleardevice();

    if((err= man40(X,Y,Xoff,Yoff,Max_x,Ylines,Maxiter))!=NO_ERR) break;

    HPI_STRB(0);
    for(;;) if(HPI_ACK()) break;
    if((err=getmem(0x809900L,(Max_x*Ylines)/4,pixdata))!=NO_ERR) break;

    cleardevice();
    for(y=0;y<Max_y;y+=Ylines)
    {
      if(y>10)
        outtextxy(1,1,"(H)elp");

      Y = Y + Yoff*(double)Ylines;

      if(kbhit())            check_key();
      if((y>curs_y2)&&(y>curs_y)) //dont know which is min
        if((y&0xF)==0) put_cursor();

      HPI_STRB(0);
      for(;;) if(HPI_ACK()) break;
        if((err=getmem(0x809900L,(Max_x*Ylines)/4,pixdata))!=NO_ERR) break;
      fastline(0,y,Max_x,Ylines,(char *)pixdata);
      if((err= man40(X,Y,Xoff,Yoff,Max_x,Ylines,Maxiter))!=NO_ERR) break;
    }
    if(err!=NO_ERR) break;
    for(;;)
    {
      while(kbhit()==0);
      if(check_key()) break;
    };
  }
  closegraph();
  printf("%s %s\n",DSK_APP,Error_Strg(err));
}


