/************************************************************************/
/*                                                                      */
/* TTTTTTTTT IIIIIIIII   Texas Instruments Semiconductor Division       */
/* TTTTTTTTT IIIIIIIII   Digital Signal Processor Applications Group    */
/*    TTT       III                                                     */
/*    TTT       III      TMS320C31 DSP Starters Kit Demo Program        */
/*    TTT    IIIIIIIII                                                  */
/*    TTT    IIIIIIIII   Author: Matthew Shoemake                       */
/*                                                                      */
/************************************************************************/
/* PLAYWAV.CPP - This demo plays a series of 8b unsigned .wav files to  */
/* the D/A of the TMS32040.  The Star Wars files that it currently      */
/* are copyrighted, so they should never leave TI as part of a product! */
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>

#include "object.h"
#include "driver.h"

void bad_exit(ERROR_TYPE err);

struct text_info ti;

void main(void)
{
  char wv[14][20] = {
   "DEACTIVE.WAV",
   "DOOMED.WAV"  ,
   "DOOR2.WAV"   ,
   "HELPME1.WAV" ,
   "HOLO2.WAV"   ,
   "IHAVEYOU.WAV",
   "JUNK.WAV"    ,
   "LOOKAT.WAV"  ,
   "R2D2N1.WAV"  ,
   "SHOT2.WAV"   ,
   "THANKME.WAV" ,
   "THEFORCE.WAV",
   "THRUHY.WAV"  ,
   "WILLBWU.WAV"};

  unsigned char huge *waves;

  ERROR_TYPE err;

  struct {
    unsigned int TA;
    unsigned int TB;
    unsigned int RA;
    unsigned int RB;
    unsigned int period;
  } aic;

  long count,i,j;

  int not_valid,
  sample;

  FILE *fptr;

  char filename[100];

  unsigned char usample;

  unsigned long data[2];

  gettextinfo(&ti);

  /********************************/
  /* Verify correct function call */
  /********************************/

  /****************************************************/
  /* Obtain AIC Configuration Information             */
  /****************************************************/

  aic.TA = aic.RA = 4;
  aic.TB = aic.RB = 35;
  aic.period = 1;

  /****************************************************/
  /* Load ad2file TMS320C31 program                   */
  /****************************************************/
  while(!kbhit()){ for(j=0;j<14;j++){
  
  if(kbhit()) break;

  textcolor(WHITE);

  data[1] = 0;

  if((err = Init_System("playwav.hex")) != NO_ERR) bad_exit(err);

  textcolor(LIGHTBLUE);

  clrscr();

  cprintf("TTTTTTTTT IIIIIIIII   Texas Instruments Semiconductor Division\r\n");
  cprintf("TTTTTTTTT IIIIIIIII   Digital Signal Processor Department     \r\n");
  cprintf("   TTT       III                                              \r\n");
  cprintf("   TTT       III      TMS320C31 DSP Starters Kit Demo Program \r\n");
  cprintf("   TTT    IIIIIIIII                                           \r\n");
  cprintf("   TTT    IIIIIIIII   PLAYWAV.EXE                             \r\n");

  textcolor(CYAN);

  cprintf("\nPlaying %s", wv[j]);

  for(count = 0; count < 1000; count++)
  {
    if((err = recv_long(&data[0])) != NO_ERR) bad_exit(err);
    if(data[0] != data[1])
      exit(1);
    if((err = xmit_long(data[0])) != NO_ERR) bad_exit(err);
    data[1] += 0x5555;
  }

  /* Request number of samples */
  textcolor(WHITE);

  fptr = fopen(wv[j], "rb");
  count = 0;
  while(!feof(fptr))
    count += fread(&usample, sizeof(unsigned char), 1, fptr);
  fclose(fptr);

  waves = (unsigned char huge*) farcalloc(count, sizeof(unsigned char));
  if(waves == NULL) exit(1);

  fptr = fopen(wv[j], "rb");
  for(unsigned long ii=0;ii<count;ii++)
  {
    fread(&usample, sizeof(unsigned char), 1, fptr);
    waves[ii] = usample;
  }
  fclose(fptr);
  asm cli;

  if((err=xmit_long(aic.period)) != NO_ERR) bad_exit(err);


  if((err=xmit_long((aic.TB << 9) | (aic.RB << 2) | 2)) != NO_ERR)
    bad_exit(err);

  if((err=xmit_long((aic.TA << 9) | (aic.RA << 2))) != NO_ERR)
    bad_exit(err);
  
  if((err=xmit_long((1 << 2) |      /* Input BP filter         */
		    (0 << 3) |      /* Loopback function       */
		    (0 << 4) |      /* Auxillary inputs        */
		    (1 << 5) |      /* Syn/asyn RX/TX sections */
		    (0 << 6) |      /* Gain                    */
		    (1 << 7) |      /*   control bits          */
		    3)) != NO_ERR) bad_exit(err);



  for(i=0; i<count; i++)
  {
    sample = waves[i] - 128;
    sample = sample << 8;
    *(long*)data = sample;
    data[0]+= 0x0ffe;
    if((err = xmit_long(data[0])) != NO_ERR) bad_exit(err);
  }

  farfree(waves);
  delay(1000);
  asm sti;
  }}
  /****************************************************/
  /* Restore originial attributes and exit            */
  /****************************************************/
  textattr(ti.normattr);
  clrscr();
  exit(0);
}

void bad_exit(ERROR_TYPE err)
{
  asm sti;
  textcolor(RED);
  cprintf("\r\n%s\r\n", Error_Strg(err));
  cprintf("\r\n\nPress any key to quit");
  getch();
  textattr(ti.attribute);
  clrscr();
  exit(0);
}
