;================================================================
; RANDOM Lookup table for DSK_SG.EXE signal generator
;
; After testing the white noise random number wavetable method
; it was found that this method is not satisfactory for most
; applications.  Since the signal generator has a true 32 bit
; random number generator built into the assembly program the
; table method is almost unneeded other than that this might be
; a good demonstration of what not to do.  That is unless there
; is still a good use for an almost random number sequence.
;
; A switch has been added where the assembly of this file can
; either be a random number table (default as shipped) or a
; square wave.
;
; NOTE: The square wave oovershoot from the DAC may appear to
;       'modulate' with respect to time.  This is because of
;       several factors. a) The table is interpolated, and
;       therefor will not have straight edges at the transitions.
;       b) There will be some interaction with the DAC's
;       reconstruction filters where the phase angle from one
;       cycle of the square wave to the next will change.
;================================================================
         .start    "TABLE",0X809800
         .sect     "TABLE"
N        .set      128
RANDOM   .set      1
         ;--------------------------
         .if       RANDOM
         ;--------------------------
         .loop     N               ; int * rand() in this
         .float    32767 * rand()  ; case returns 32767 * (+/-1)
         .endloop                  ;
         ;--------------------------
         .else
         ;--------------------------
         .loop     N/2             ; A symetrical square
         .float    32767.0         ; +32767.0 for first N/2 samples
         .endloop                  ;
         .loop     N/2             ;
         .float    -32767.0        ; -32767.0 for last N/2 samples
         .endloop                  ;
         ;--------------------------
         .endif
         ;--------------------------
         .end
