//------------------------------------------------------------
// SCANNER.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//--------------------------------------------------------------
// This application takes data received from the SCAN.ASM DSK
// application and creates a strip chart recording of data.  As
// prototyped with a TSL1402 256x1 linear optical device, this
// application is similar to a 256 gray scale hand scanner.
//--------------------------------------------------------------
//   NOTE: SCANNER.EXE WAS DEVELOPED USING AN SVGA BGI GRAPHICS
//         DRIVER (SVGA256.BGI) THAT IS NOT DISTRIBUTED BY
//         TEXAS INSTRUMENTS.  YOU MUST DOWNLOAD THIS FROM THE
//         INTERNET YOURSELF.
//
//   SVGA256.BGI MUST BE IN THE CURRENT DIRECTORY!
//
//   IF THIS FILE IS NOT FOUND, AN ERROR MESSAGE WILL BE DISPLAYED
//   THAT WILL REMIND THE USER THAT THIS FILE MUST BE DOWNLOADED
//   FROM AN INTERNET OR BBS PROVIDER.
//
//   -ALSO-
//
//   THE LINKER OPTIONS NEED TO BE SET TO LINK IN GRAPHICS.LIB
//
//--------------------------------------------------------------
//  Your project file should include the following
//
//    SCANNER.CPP   This file
//    VIDEO.CPP     Super VGA functions
//    DRIVER.CPP    Low level printer port drivers
//    TARGET.CPP    DSK Command level
//    OBJECT.CPP    Application setup routines
//    DSK_COFF.CPP  DSK and COFF file loaders and other utils
//    ERRORMSG.CPP  Messages used for most function returns
//    SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//    TEXTWIN.CPP   DOS level text window functions
//
//  * SVGA256.BGI   Must be in the runtime directory!
//
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        This application is a SVGA DOS graphics executable and MUST
//        be run in a full screen DOS session.
//--------------------------------------------------------------
#include <stdlib.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <graphics.h>
#include <dos.h>
#include "video.h"
#include "keydef.h"
#include "errormsg.h"
#include "dsk.h"
#include "DSK_COFF.h"
#define  text_color 128
int    dtime   =    10;
long   xpsr    =   16L;   // exposure in mS
long   gain    =    32;   // gain in 1/32's
long   off1    =     0;   // lower histogram adjust point
long   off2    = 16384;   // upper histogram adjust point 8192
char   left_bubble=1;
char   Auto_scale=1;
ulong  C1[512];
ulong  CT[512];
uint   sdata[512];
uint   sblack[512];
uint   blackbuf[512];
char   strg[80];
float  accel=1.0;
int    old_key = 0;
//===========================================================
#define VID_DATA 0x809A00L
void draw_hist(void);
int  flog(ulong C);
MSGS scanner(void);
char DSK_EXE[]="SCANNER.EXE";
char DSK_APP[]="SCAN.DSK";
void main(void)
{
  MSGS err;
  clrscr();
  Scan_Command_line(DSK_EXE);
  //
  // An outer loop is used for power/communication loss recovery
  // If a failure ocurs the inner loop exits, reinitializing the DSK
  xpsr = 20;
  for(;;)
  {
    // Download the communications kernel
    for(;;)
    { if(Init_Communication(10000) == NO_ERR) break;
      if(kbhit()) exit(0);
    }
    // Load applications code
    if((err=Load_File(DSK_APP,LOAD))==NO_ERR)
    {
      RUN_CPU();  // Run SSTUB to install XSPARE vector
      //=======================================================
      init_video();
      set_bw();
      setcolor(text_color);
      cleardevice();
      scanner();
    }
    closegraph();
    printf("%s: %s\n",DSK_APP, Error_Strg(err));
    printf("Communications are being reinitialized");
    delay(1000);
    DSK_reset();
  }
}
//------------------------------------------------------
// Sends user defined commands to the target
//------------------------------------------------------
MSGS USERCMD2(ulong CMD, ulong ARG)
{
  MSGS err=NO_ERR;
  if((err=xmit_long(XSPARE))!=NO_ERR) return err; // Function
  if((err=xmit_long(   CMD))!=NO_ERR) return err; // Sub function
  if((err=xmit_long(   ARG))!=NO_ERR) return err; // 1st argument
  return err;
}
//*********************************************************************
void disp_par(void)
{
  int row=80;
  setfillstyle(SOLID_FILL,0);
  bar(500, row+1,639,479);
  sprintf(strg,"%ld" ,off1);outtextxy(505,row+=10,strg);
  sprintf(strg,"%5ld",off2);outtextxy(592,row    ,strg);
  sprintf(strg,"Gain=%4.2g",gain/32.0);outtextxy(505,row+=10,strg);
  sprintf(strg,"(Q)uit"               );outtextxy(505,row+=10,strg);
  if(Auto_scale)
  sprintf(strg,"(S)cale AUTO"         );
  else
  sprintf(strg,"(S)cale MANUAL"       );outtextxy(505,row+=10,strg);
  sprintf(strg,"To adjust, set "      );outtextxy(505,row+=10,strg);
  sprintf(strg,"to manual, then"      );outtextxy(505,row+=10,strg);
  sprintf(strg,"use L/R/SPC keys"     );outtextxy(505,row+=10,strg);
  sprintf(strg,"+/- adjust delay"     );outtextxy(505,row+=20,strg);
  sprintf(strg,"(B)lack ref set"      );outtextxy(505,row+=20,strg);
  sprintf(strg,"(Z)ero black  ref"    );outtextxy(505,row+=10,strg);
  sprintf(strg,"(Esc) Defaults"       );outtextxy(505,row+=10,strg);
  sprintf(strg,"F1: BW palette"       );outtextxy(505,row+=10,strg);
  sprintf(strg,"F2: IBW palette"      );outtextxy(505,row+=10,strg);
  draw_hist();
}
//------------------------------------------------------------//
void check_key2(void)
{
  int x,key,shift_key;
  if(bioskey(1))
  {
    key = bioskey(0) & 0xff00;         // get keystroke
    shift_key  = bioskey(2);           // get modifiers
    shift_key &=  (_Rt_Sh | _Lt_Sh);   // shift
    if(key==old_key) accel = 1 + accel * 1.4;
    else             accel = .1             ;
    if(accel > 100) accel = 100;
    if(accel <  .1) accel =  .1;
    old_key = key;
    switch(key)
    { case _Spc: left_bubble ^= 1; break;
      case _B  : for(x=0;x<266;x++) sblack[x]=blackbuf[x]; break;
      case _Z  : for(x=0;x<266;x++) sblack[x] = 0        ; break;
      case _S  : Auto_scale ^= 1; break;
      case _Q  : closegraph(); exit(0); //return SRC_IND;
      //======================================================
      case _F1 : set_bw();   break;
      case _F2 : set_ibw();  break;
      //======================================================
      case _Rt : if(shift_key)
                 { if(left_bubble) off2 = off2 + accel * 100;
	           else            off1 = off1 + accel * 100;
                 }
                 else
                 { if(left_bubble) off2 = off2 + accel * 10;
	           else            off1 = off1 + accel * 10;
                 }
                 break;
      case _Lt : if(shift_key)
                 { if(left_bubble) off2 = off2 - accel * 100;
	           else            off1 = off1 - accel * 100;
                 }
                 else
                 { if(left_bubble) off2 = off2 - accel * 10;
	           else            off1 = off1 - accel * 10;
                 }
                 break;
      //=======================================================
      case _pls: if(shift_key) dtime += 10;
                 else          dtime +=  1;
                 break;
      case _mns: if(shift_key) dtime -= 10;
                 else          dtime -=  1;
                 break;
      //=======================================================
      case _ESC: off1 = 0; gain = 32;  off2=16384; break;
      default  : break;
    }
    //=========================================================
    if(off1 > 16384) off1 = 16384; if(off2 < -256) off2 = -256;
    if(off2 > 16384) off2 = 16384; if(off1 < -256) off1 = -256;
    if((off2-off1) == 0) gain = -gain;
    else gain = 32.0*16384.0/(float)(off2 - off1);
    if (dtime <   0) dtime =   0;
    if (dtime > 400) dtime = 400;
  }
  disp_par();
}
//------------------------------------------------------------//
void FastLine(int xc,int yc,int Xpix,int Ypix,uint *p) //faster line fill
{
  char far *VRAM;
  int x,y;
  long l;
  l = xc + yc*640;
  l &= 0xFFFF;
  VRAM  = (char far *) MK_FP(0xA000, l);
  putpixel(xc,yc,*p); // Set the video page registers
  for(y=0;y<Ypix;y++)
  {
    for(x=0;x<Xpix;x++)
    {
      if(FP_OFF(VRAM)==0) // detect 64K offset rollover
      {
        VRAM = (char far *)MK_FP(0xA000,0); // go back to page start
        putpixel(xc+x,yc+y,*p); // Set the video page registers
      }
      *VRAM++ = *p++;
    }
  }
}
//------------------------------------------------------------//
MSGS scanner(void)
{
  long gl, gl2;
  char strg[80];
  int x;
  int y;
  int min=1024;
  int max=1024;
  off1 = 1024;
  off2 = 1024;
  disp_par();
  y = 0;
  gl = 0;
  USERCMD2(1,1);  // Send line convert command
  for(;;)
  {
    if(y>300) y=0;
    delay(dtime); // mS per line
    //---------------------------------------------------------
    for(;;) // Wait for line to convert... If keyhit process kestroke
    {
      if(kbhit())  check_key2();
      HPI_STRB(0); if(HPI_ACK()) break;
      delay(1);  // Set maximum polling rate
    }
    if(getmem(VID_DATA,256/2,(ulong *)sdata)!=NO_ERR) break;
    USERCMD2(1,1);  // Send line convert command
    //----------------------------------------------------------
    if(Auto_scale) { off1 = min-200; off2 = max+200; }
    if(off1==off2) off2++;
    gain = 32.0*16384.0/(float)(off2 - off1);
    min = 32700; max = 0;
    for(x=0;x<256;x++){C1[x]=0;CT[x]=0;} // Clear the histogram
    for(x=0;x<256;x++)
    {
      gl = (int)sdata[x];
      //-------------------------------------------------------
      // Use different averaging depending on level
      //-------------------------------------------------------
      gl2 = blackbuf[x];
      if(gl > gl2) gl2 = (gl2*31 + gl) >> 5;
      else         gl2 = (gl2*3  + gl) >> 2;
      blackbuf[x] = (uint)gl2;
      //----------------------------------------------
      gl = gl - sblack[x];
      gl2 = (gl >> 6) & 0xFF; C1[(int)gl2] +=1;
      if((x>6) & (x<260))
      {
        if(gl<min) min = (int)gl;
        if(gl>max) max = (int)gl;
      }
      gl = (int)(((gl - off1) * gain) >> 11);
      if(gl<  0) gl =   0; if(gl>255) gl = 255;
      CT[(int)gl] +=1;
      sdata[x] = (uint)gl;
    }
    FastLine(0,y++,256,1,sdata); // Use much faster line draw
    FastLine(0,y,256,1,sdata); // Use much faster line draw
    //------------------------------------------------------

    for(x=0;x<266;x+=2) sdata[x]=  0;  // Draw divider line...
    for(x=1;x<266;x+=2) sdata[x]=255;  // Draw divider line...
    y++;
    FastLine(0,y,256,1,sdata); // Use much faster line draw
    //------------------------------------------------------
    draw_hist();
    sprintf(strg," %+05d %+05d %d",min,max,dtime);
    bar(0,460,540,479); outtextxy(10,470,strg);
  }
  fcloseall();
  return RECV_ERR;
}
//------------------------------------------------------------
// draws a histogram of the data in C1[] & C2[]
//------------------------------------------------------------
void draw_hist(void)
{
  int x, y, xc;
  ulong *c;
  bar(501,0,639,81);
  c=C1;for(x=505;x<633;x++) line(x, 35,x, 35-flog(*c++ + *c++));
  c=CT;for(x=505;x<633;x++) line(x, 80,x, 80-flog(*c++ + *c++));
  y  = 35;                        //0x2000 0x0080
  x  = (int) (505+(off1 >> 7));   //8192/128
  xc = (int) (505+(off2 >> 7));
  line(x,y,xc,y-32);
  if(left_bubble) circle(xc,y-32,2);
  else            circle(x ,y   ,2);
}
//--------------------------------------------
// fast log2 for the PC
//--------------------------------------------
int flog(ulong C)
{
  int y=16;
  if(C <     1) return 0;
  if(C > 16384) C = 16384;
  for(;;)
  { if(C & 0x8000)break;
    C = (C<<1);
    y--;
  }
  y = y << 1;
  y = y | (int)((C >> 14) & 0x1);
  return y;
}
