;-----------------------------------------------------------------------
; STRBTST.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; This code can be used to check the DSK's PAL decoded strobe outputs.
; The list below shows the address' for each strobe.  By running this
; program from the debugger you can simply halt the debugger and then
; manualy change the value of AR0 from within the debugger.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; USER_BOOT	  0000000 00FFFFF + PWM line must be pulled low to enable
;		  0100000 07FFFFF   No decode
; SRAM		  0800000 0BFFFFF + External SRAM (includes some internal)
; USER_R	  0C00000 0DFFFFF   Read active
; USER_W	  0C00000 0DFFFFF   Write active
; USER_X	  0C00000 0DFFFFF + R/W active
; HPI(asynch)	  0E00000 0EFFFFF   DO NOT READ THE HOST PORT ADDRESS
; HPI(host lock)  0F00000 0FFFFFF   THIS WILL CRASH THE DEBUGGER
;
; NOTES
;  - In some cases the PWM line will need to be pulled low
;  - In other cases, such as /SRAM, the base address is internal
;    and therefor not valid.  In this case, change the address to
;    be immediately after the on-chip memory.
;  - Avoid the HPI interlock addresses as this will crash the debugger
;---------------------------------------------------------------------;
        .start "CODE",0x809802 ; Start assembling CODE section here
        .sect  "CODE"          ;
        .entry  SAMPLE         ; Debugger entry point
        ;----------------------
SAMPLE  ldp     @stack         ; Load a data page
        ldi     @stack,SP      ; Load a stack pointer
	ldi	0,R0
	ldi	-1,R1
	ldi	@ADDR,AR0
LOOP	ldi	AR0,AR1
	addi	AR1,AR1
	subi	1,AR1
	lsh	-1,AR1
        ;----------------------
	ldi	*AR0,R2
	sti	R0,*AR0
	ldi	*AR0,R2
	sti	R1,*AR1
	b	LOOP
;----------------------------------------
ADDR	.word	0x1000
stack	.word	stack


