;-------------------------------------------------------------------------
; TINT.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; TINT.ASM is a simple program which shows how to initialize the two
; on-chip timers and attach interrupts to them.  Two count values
; show how many times the interrupts are called.
;
; To run this program, assemble it with DSK3A, then load it using
; the DSK3D debugger.  Then run the program (F5 key or 'run' command)
; for a few seconds.  When you halt the debugger (escape key) examine
; the contents of the software interrupt timer counters TCNT0 and TCNT1
;
; Note1: if you single step this program you will not see TCNT0 and TCNT1
; update. This is because the priority of these interrupts is lower than
; the interrupts used in the debugger.
;
; Note2: You can however set a breakpoint inside a timer interrupt
; routine. If you set a breakpoint in TINT0, this interrupt (and the
; breakpoint trap) you will only see TCNT0 get updated.
;
; If you set a BP in TCNT1, both TCNT0 and TCNT1 will update, but the ratio
; of count values will be off.  This happens because as breakpoint is found,
; the other interrupt bits are likely to be set long before the next RUN.
;-------------------------------------------------------------------------
          .include "C3XMMRS.ASM"
          .start   "TINT",0x809802 ; Start assembling here
          .sect    "TINT"          ;
GIE       .set     0x00002000      ; This ST bit enables interrupts
PRD0      .set     0x00001000      ;
PRD1      .set     0x00001020      ;
TSTART    .set     0x000003C3      ; reset and restart value for timers
;****************************************************
; Begin main code loop here
;****************************************************
          .entry START          ;
START     ldp     @START        ; Set up stack and other params
          ldi     @stack,SP     ;
          ;=====================  Init T0&T1 for slow PWM modulation
          ldi     PRD0,R0       ; Init periods (note they are different)
          sti     R0,@T0_prd    ;
          ldi     PRD1,R0       ;
          sti     R0,@T1_prd    ;
          ldi     TSTART,R0     ; Start timers (reset and restart)
          sti     R0,@T0_ctrl   ;
          sti     R0,@T1_ctrl   ;
          ;---------------------
main      or    GIE,ST          ; Turn on INTS
          ldi   0x3F4,IE        ; Enable TINT1/INT2
          b     main            ; Do forever
;-------------------------------
TINT0     push  ST              ; Count TINT events
          push  R0              ;
          ldi   @TCNT0,R0       ;
          addi  1,R0            ;
          sti   R0,@TCNT0       ;
          pop   R0              ;
          pop   ST              ;
          reti                  ;
;-------------------------------
TINT1     push  ST              ; Count TINT events
          push  R0              ;
          ldi   @TCNT1,R0       ;
          addi  1,R0            ;
          sti   R0,@TCNT1       ;
          pop   R0              ;
          pop   ST              ;
          reti                  ;
;-------------------------------
TCNT0     .word   0
TCNT1     .word   0
;-------------------------------
stack     .word   $             ; Put stack here
;****************************************************;
; Install the TINT ISR branch statements here        ;
;****************************************************;
          .start   "TINTVECTS",0x809FC9
          .sect    "TINTVECTS"
          B        TINT0        ; TINT0
          B        TINT1        ; TINT1
