;---------------------------------------------------------------------
; TOGGLE.ASM
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;
; This is unsupported freeware with no implied warranties or
; liabilities.  See the disclaimer document for details
;
; A simple program that toggles the LED colors at 1 second intervals
; Use this program as a test for the DSK3LOAD utility
; This program can either be bootloaded or loaded via the comm kernel
;---------------------------------------------------------------------
        .start  "toggle",0x809802; Avoid 0x809800-0x809801 boot stack
        .entry  START            ; if file is to be bootlaoded
        .sect   "toggle"
START   ldp     @START          ; Set up stack and other params
        ldi     @stack,SP       ;
        ;=======================
        ldi     @MMRBASE,AR0    ; Init timers for slow PWM modulation
        ldi     3,R0            ; HALT timers
        sti     R0,*+AR0(0x20)  ;
        sti     R0,*+AR0(0x30)  ;
        sti     R0,*+AR0(0x24)  ; Init count registers
        sti     R0,*+AR0(0x34)  ;
        ldi     @PRD0,R0        ; Init periods
        sti     R0,*+AR0(0x28)  ;
        ldi     @PRD1,R0        ;
        sti     R0,*+AR0(0x38)  ;
        ldi     @TSTART,R0      ; Start timers
        sti     R0,*+AR0(0x20)  ;
        sti     R0,*+AR0(0x30)  ;
LOOP    or      0x4,IE          ; Wait for a new command
        idle                    ;
        b       LOOP            ;
        ;-----------------------
MMRBASE .word   0x00808000      ; Constants used to initialize the timers
PRD0    .word   25E6/2          ; (MIPRATE/2)/Toggle duration
PRD1    .word   0xFFFFFFFF      ; F1 at lowest possible rate
TSTART  .word   0x000003C3      ;
stack:  .word   stack           ; start stack here
