//------------------------------------------------------------
// ANALYZE.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//--------------------------------------------------------------------
#include <alloc.h>
#include <bios.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <stdio.h>

#include "dsk.h"         // Application level DSK functions and variables

#include "screen.h"      // Debugger and assembler functions and variables
#include "argsplit.h"
#include "exp_anal.h"
#include "assm_fun.h"

long MaxFileLen = 2048L; // Nominal is 2K on chip memory
char HDRFILL[]=
">HEADER FILL TO OFFSET 0x80...........................................";
char *DSKEXT1 = ".DSK";
double QVAL=0;
//-------------------------------------------------------------
// PATCHF() takes a character string and assembles it into an
// opcode.  Expressions can contain any currently defined symbol.
// The required format is as shown
//
//
// patch  address   opcode   operand,operand...
// asm    address   opcode   operand,operand...
// |        |
// |        +--- If an expression is used, no white spaces are allowed
// +------------ Debugger 'command' keyword
//-------------------------------------------------------------
MSGS PATCHF(char *p)
{
  OBJ obj;
  ulong o,addr;
  int SDefine = 0;
  char *p2, nullstring[]="";
  char temp[80];
  MSGS err;
  p = argend(p,0); // p is at end of 'patch'
  if(*p==0) return MISS_ARG;
  p = argstart(p); // p is at start of 'address'
  if(*p==0) return MISS_ARG;
  p2= argend(p,0); // p is at end of 'address'
  if(*p2==0) return MISS_ARG;

  if(strstr(p,".sdef")!=NULL) SDefine =1;
  if(strstr(p, ".def")!=NULL) SDefine =1;
  if(strstr(p, ".set")!=NULL) SDefine =1;
  *p2 =0;
  //
  // If the label field is not resolvable an error is
  // returned.  This is effectively the first problem
  // to solve in getting patch to accept symbol definitions...
  //
  //
  if(SDefine)
  {
    g_pass = 1;
    addr = 0;
  }
  else
  {
    g_pass = 2;
    if(expressionz(p,&addr,NT_INTEGER)!=NT_INTEGER) return EXPR_ERR;
    p = p2;
  }

  *p2 = ' ';
//  p=p2;
  SEG[current_seg].offs = addr;
  if((p2=strstr(p,"||"))!=NULL)
  {
    *p2++ = 0  ; // Terminate first half of parallel code
    *p2   = ' '; // Shift second half up one char to make room for ||
    strcpy(temp,  p2);
    strcpy(p2+3,temp);
    *p2++ =' ';
    *p2++ ='|';
    *p2-- ='|';
    p2--;
  }
  else
    p2 = nullstring;
  //
  // At this point the label field, which may be a symbol
  // being defined has been cleared.  The assembler itself
  // would normaly ignore this field since it would only
  // use it if the lable were being used for definition purposes
  //
  err = assm(p,p2,obj);
  g_pass = 2;
  switch(err)
  {
    case NO_ERR    :
    case PAR_NO_ERR: err = NO_ERR; break;
    case DIR_NO_ERR: return NO_ERR;
    default        : return err;
  }
  o = obj_pack(obj);
  if(SDefine == 0)
    err = putmem(addr,1,&o);
  return err;
}
//-----------------------------------------------------------
// Update_Ctxt_Vars() is called after a singlestep, debugger
// assignment or other operation that might change the value
// of a CPU register.  The contents of the register equivelent
// in the symbol is then updated in this function.
//-----------------------------------------------------------
void Update_Ctxt_Vars(void)
{
  float f;
  ref_mod("R0",CTXT[R0]);
  ref_mod("R1",CTXT[R1]);
  ref_mod("R2",CTXT[R2]);
  ref_mod("R3",CTXT[R3]);
  ref_mod("R4",CTXT[R4]);
  ref_mod("R5",CTXT[R5]);
  ref_mod("R6",CTXT[R6]);
  ref_mod("R7",CTXT[R7]);
  f = TMS_IEEE(CTXT[R0F]); ref_mod("F0", *(long *)&f);
  f = TMS_IEEE(CTXT[R1F]); ref_mod("F1", *(long *)&f);
  f = TMS_IEEE(CTXT[R2F]); ref_mod("F2", *(long *)&f);
  f = TMS_IEEE(CTXT[R3F]); ref_mod("F3", *(long *)&f);
  f = TMS_IEEE(CTXT[R4F]); ref_mod("F4", *(long *)&f);
  f = TMS_IEEE(CTXT[R5F]); ref_mod("F5", *(long *)&f);
  f = TMS_IEEE(CTXT[R6F]); ref_mod("F6", *(long *)&f);
  f = TMS_IEEE(CTXT[R7F]); ref_mod("F7", *(long *)&f);

  ref_mod("AR0",CTXT[AR0]);
  ref_mod("AR1",CTXT[AR1]);
  ref_mod("AR2",CTXT[AR2]);
  ref_mod("AR3",CTXT[AR3]);
  ref_mod("AR4",CTXT[AR4]);
  ref_mod("AR5",CTXT[AR5]);
  ref_mod("AR6",CTXT[AR6]);
  ref_mod("AR7",CTXT[AR7]);

  ref_mod("IR0",CTXT[IR0]);
  ref_mod("IR1",CTXT[IR1]);
  ref_mod("DP" ,CTXT[DP ]);
  ref_mod("BK" ,CTXT[BK ]);
  ref_mod("SP" ,CTXT[SP ]);
  ref_mod("ST" ,CTXT[ST ]);
  ref_mod("IE" ,CTXT[IE ]);
  ref_mod("IF" ,CTXT[IF ]);
  ref_mod("IOF",CTXT[IOF]);
  ref_mod("RS" ,CTXT[RS ]);
  ref_mod("RE" ,CTXT[RE ]);
  ref_mod("RC" ,CTXT[RC ]);
  ref_mod("PC" ,CTXT[PC ]);
  SEG[current_seg].offs = CTXT[PC];
}
//-----------------------------------------------------
// Update_Ctxt_Regs() When an assignment is made modifying
// a register value, this function identifies the register
// and places the new value both into the in-chip storage
// and the local symbol table.
//-----------------------------------------------------
MSGS Update_Ctxt_Regs(char *r, char *v)
{
  ulong val,addr;//,temp;
  char reg[20];
  char *p;
  int x;
  NUM_TYPE type;
  strncpy(reg,r,19);
  strupr(reg);
  r = reg;

  p = argend(r,0);
  *p=0;

  if(*r=='F')
  {
    switch(type = expressionz(v,&val,NT_FLOAT))
    {
      case NT_FLOAT: sprintf(CMSG, "%#g",*(float *)&val);
                     val =  IEEE_TMS(*(float *)&val); break;
      default      : return EXPR_ERR;
    }
  }
  else
  {
    switch(type = expressionz(v,&val,NT_INTEGER))
    {
      case NT_INTEGER:sprintf(CMSG,"0x%08lx = %ld",val,val);
                      break;
      default        :return EXPR_ERR;
    }
  }
  if(*Cmd_Line=='*') // Place result in *expressionz(arg[0])
  {
    switch(type = expressionz(arg[0].s,&addr,NT_INTEGER))
    {
      case NT_INTEGER:sprintf(CMSG,"*0x%08lx=%08lx (%ld) ",addr,val,val);
                      break;
      default        :return EXPR_ERR;
    }
    putmem(addr,1,&val);
    return NO_ERR; //MEM_Window(MEM_Address);
  }
  //
  // Determine if the left side argument of the assignment is
  // for a register or a symbol.  Note that if a symbol is
  // specified the symbol value is updated.  Earlier DSK3D
  // versions simply returned without modification.  In this
  // case if the symbol is not modifiable a NO_REF is returned.
  //
  if(isreg2(arg[0].s)==0)
  {
    if((x=ref_offs(arg[0].s))==-1) return NO_REF;
    type = expressionz(v,&val,(NUM_TYPE)SYM[x].numt);        // convert using old type
//  if(type==FLOAT) val = IEEE_TMS(*(float *)&val);// TI float format
//  type = expressionz(v,&val,       AUTO);   // adopt new type
    return(xref_mod2(arg[0].s,val,type,(SYM_TYPE)SYM[x].symt));
  }
  else
  {
    if(strexact("R0",r)) CTXT[ R0] = val;
    if(strexact("R1",r)) CTXT[ R1] = val;
    if(strexact("R2",r)) CTXT[ R2] = val;
    if(strexact("R3",r)) CTXT[ R3] = val;
    if(strexact("R4",r)) CTXT[ R4] = val;
    if(strexact("R5",r)) CTXT[ R5] = val;
    if(strexact("R6",r)) CTXT[ R6] = val;
    if(strexact("R7",r)) CTXT[ R7] = val;

    if(strexact("F0",r)) {CTXT[R0F] = val; CTXT[ R0] = val<<8;}
    if(strexact("F1",r)) {CTXT[R1F] = val; CTXT[ R1] = val<<8;}
    if(strexact("F2",r)) {CTXT[R2F] = val; CTXT[ R2] = val<<8;}
    if(strexact("F3",r)) {CTXT[R3F] = val; CTXT[ R3] = val<<8;}
    if(strexact("F4",r)) {CTXT[R4F] = val; CTXT[ R4] = val<<8;}
    if(strexact("F5",r)) {CTXT[R5F] = val; CTXT[ R5] = val<<8;}
    if(strexact("F6",r)) {CTXT[R6F] = val; CTXT[ R6] = val<<8;}
    if(strexact("F7",r)) {CTXT[R7F] = val; CTXT[ R7] = val<<8;}

    if(strexact("AR0",r)) CTXT[AR0] = val;
    if(strexact("AR1",r)) CTXT[AR1] = val;
    if(strexact("AR2",r)) CTXT[AR2] = val;
    if(strexact("AR3",r)) CTXT[AR3] = val;
    if(strexact("AR4",r)) CTXT[AR4] = val;
    if(strexact("AR5",r)) CTXT[AR5] = val;
    if(strexact("AR6",r)) CTXT[AR6] = val;
    if(strexact("AR7",r)) CTXT[AR7] = val;

    if(strexact("IR0",r)) CTXT[IR0] = val;
    if(strexact("IR1",r)) CTXT[IR1] = val;
    if(strexact("DP" ,r)) CTXT[DP ] = val;
    if(strexact("BK" ,r)) CTXT[BK ] = val;
    if(strexact("SP" ,r)) CTXT[SP ] = val;
    if(strexact("ST" ,r)) CTXT[ST ] = val;
    if(strexact("IE" ,r)) CTXT[IE ] = val;
    if(strexact("IF" ,r)) CTXT[IF ] = val;
    if(strexact("IOF",r)) CTXT[IOF] = val;
    if(strexact("RS" ,r)) CTXT[RS ] = val;
    if(strexact("RE" ,r)) CTXT[RE ] = val;
    if(strexact("RC" ,r)) CTXT[RC ] = val;
    if(strexact("PC" ,r)) CTXT[PC ] = val;
  }
  PC_Appli = CTXT[PC];
  SEG[current_seg].offs=CTXT[PC];
  return putmem(CTXT_PTR,CTXTSIZE,&CTXT[0]);
}
void  file_ext(char *file,char *ext)
{
  char *p;
  if((p=strstr(file,"."))!=NULL) {strcpy(p+1,ext); return;}
  strcat(file,".");
  strcat(file,ext);
}

//---------------------------------------------------------------
// Execute_Cmd() is the function called by the command window
// when a command is entered on the command line.  This function
// determines what the command was and then performs the
// appropriate actions before returnining back to the command loop.
//---------------------------------------------------------------
MSGS Execute_Cmd(int cmd, int Update)
{
  FILE *out;
  struct ftime ft1,ft2;
  char bug_last_cmd[80];
  char sMSG[120];
  float f;
  int i;
  char c, *p;
  char Old_file[80];
  ulong la[4], temp;
  long length;
  int n, args=0;
  MSGS err = NO_ERR;
  MSGS err1= NO_ERR;
  DSK3D = 1;     // Turn on register recognition in expressionz()
//  if((err=Sanity_Check())!=NO_ERR) return err;
  Update_Ctxt_Vars();
  strcpy(Old_file,DASM_file);

  switch(cmd)
  {
    case ENDTAKE: return d_end; // return a unique but recognizable err
    case DASM0: Dasm_Mode = DASM0; break;
    case DASM1: Dasm_Mode = DASM1; break;
    case DASM2: Dasm_Mode = DASM2; break;
    case DASM3: Dasm_Mode = DASM3; break;
    case CMDBUFLOAD: /* copy string to command buffer CMDxx */
                     i = (int)strtol(last_cmd+3,&p,10);
                     if(i <       0) return EXPR_ERR;
                     if(i > CMDBFRS) return EXPR_ERR;
                     while(*p==' ') p++;
                     strcpy(Cmd_Buf[i].s,p);
                     return NO_ERR;

    case CREAD :   return cmdread(     ); // Restore previous environment
    case CSAVE :   return cmdsave(0,cmd); // Save current environment
    case CSAVEALLCOFF:
    case CSAVEALL: return cmdsave(1,cmd); // Also save on-chip memory and
                                            // add reload command to cmdfile
                                            // Default is HEX, option is COFF
    case SAVE:
    case DOS:
    case EDIT:
    case DSK3A:
    case LF :       // Commands that except strings do not need
    case BLF:       // a syntax check
    case PATCH:
    case FLF:

    case FILEHEX:

//  case DSKHEX :
//  case COFFHEX:
    case MEMHEX :
    case MEMCOFF:
    case HEXCOFF:
    case DSKCOFF:


    case SYMBOLS:
    case SLF: break;
    case MEMQ : QVAL = strtod(arg[0].s+4,&p);
             // Convert remaining fields
    default: for(n=0;n<4;n++)
             { la[n]=0;
               if(*arg[n+1].s)
               { if(expressionz(arg[n+1].s,&la[n],NT_INTEGER)!=NT_INTEGER)
                 return EXPR_ERR;
                 args++;
               }
             }
             break;
  }
  //
  // When a program is loaded on top of another program the existing
  // stack pointer can cause trouble since the new code might end up
  // inside the existing stack.  To fix this, stop the processor and
  // then load a new SP before doing the load.
  //
  switch(cmd)
  {
    case   FLF:
    case    LF:
    case DSK3A: // Reset the SP for the next application
                HALT_CPU();    // Stop DSK.  Now in spin0 loop
                HALT_CPU();    // Stop again sets context to spin0 loop

            //  CTXT[SP] = 0x809F00L; putmem(CTXT_PTR+SP,1,&CTXT[SP]);
                CTXT[SP] = SP_DFLT  ; putmem(CTXT_PTR+SP,1,&CTXT[SP]);
            //  getmem(0,1,&temp);
                CTXT[DP] = 0x000080L; putmem(CTXT_PTR+DP,1,&CTXT[DP]);
            //  getmem(0,1,&temp);
                CTXT[IF] = 0x000000L; putmem(CTXT_PTR+IF,1,&CTXT[IF]);
            //  getmem(0,1,&temp);
                CTXT[IE] = 0x0000C4L; putmem(CTXT_PTR+IE,1,&CTXT[IE]);
           //   getmem(0,1,&temp);
                RUN_CPU();    // Running sets the environment to spin0
                HALT_CPU();   // stop in spin0 loop
    default   : break;
  }

  switch (cmd)
  {

    case  LF  :
    case SLF  :
    case FLF  :

    case FILEHEX:
//  case MEMHEX :
//  case MEMCOFF:
    case HEXCOFF:
    case DSKCOFF:

//  case SYMBOLS:
    case BLF  : arg_split(last_cmd,0);
                if(*arg[2].s!=0) return XTRA_ARG;
                if(*arg[1].s==0)
                { if(strstr(DASM_file,"C3X.DSK")) return OPEN_ERR;
                  strncpy(arg[1].s,DASM_file,20);
                }
                break;
    case SAVE:  strupr(arg[4].s);
                p = arg[4].s;
                for(;;)
                {
                  if(strexact("L"       ,p)) {cmd = SAVEL  ; break;}
                  if(strexact("LONG"    ,p)) {cmd = SAVEL  ; break;}
                  if(strexact("U"       ,p)) {cmd = SAVEU  ; break;}
                  if(strexact("UNSIGNED",p)) {cmd = SAVEU  ; break;}
                  if(strexact("F"       ,p)) {cmd = SAVEF  ; break;}
                  if(strexact("FLOAT"   ,p)) {cmd = SAVEF  ; break;}
                  if(strexact("X"       ,p)) {cmd = SAVEH  ; break;}
                  if(strexact("H"       ,p)) {cmd = SAVEH  ; break;}
                  if(strexact("HEX"     ,p)) {cmd = SAVEH  ; break;}
                  if(strexact("B"       ,p)) {cmd = SAVEBB ; break;}
                  if(strexact("BIN"     ,p)) {cmd = SAVEBB ; break;}
                  if(strexact("BINARY"  ,p)) {cmd = SAVEBB ; break;}
                  if(strexact("C"       ,p)) {cmd = SAVEBB ; break;}
                  if(strexact("CHAR"    ,p)) {cmd = SAVEBB ; break;}
                  if(strexact("I"       ,p)) {cmd = SAVEBI ; break;}
                  if(strexact("INT"     ,p)) {cmd = SAVEBI ; break;}
                  if(strexact("INTEGER" ,p)) {cmd = SAVEBI ; break;}
                  if(strexact("W"       ,p)) {cmd = SAVEBL ; break;}
                  if(strexact("WORD"    ,p)) {cmd = SAVEBL ; break;}
                  if(strexact("D"       ,p)) {cmd = SAVED  ; break;}
                  if(strexact("DASM"    ,p)) {cmd = SAVED  ; break;}
                  return EXPR_ERR;
                }
                if(*arg[5].s!=0) return XTRA_ARG;
                if(*arg[4].s==0) return MISS_ARG;
                if(expressionz(arg[2].s,&la[0],NT_INTEGER)!=NT_INTEGER)
                  return EXPR_ERR;
                if(expressionz(arg[3].s,(ulong *)&length,NT_INTEGER)
                              !=NT_INTEGER)
                  return EXPR_ERR;
                if(length <    0) return BAD_LENGTH;
                if(length > 4096) return BAD_LENGTH;
                if(strlen(arg[1].s) > 12) return FILE_LEN;
                if((out=fopen(arg[1].s,"wb"))== NULL)
                  return OPEN_ERR;
                Cmd_Msg("SAVING DATA: PLEASE WAIT",CMD_ATTR,1,1);
                sprintf(sMSG,
                ">%s\n"
                ">START : 0x%08lx\n"
                ">END   : 0x%08lx\n"
                ">LENGTH: 0x%08lx\n",
                Cmd_Line,la[0],la[0]+length-1, length);
                fprintf(out,sMSG);
                i = strlen(sMSG);
                strcpy(&HDRFILL[128-i-2],"\r\n");
                fprintf(out,HDRFILL);
                /*-------- Write formatted data to out file --------*/
                for(;length>0;length--)
                {
                  if((err=getmem(la[0],1,&temp))!=NO_ERR)
                  { fclose(out); return err; }
                  switch(cmd)
                  {
                    case SAVEL : fprintf(out,"%ld\r\n",  temp); break;
                    case SAVEU : fprintf(out,"%lu\r\n",  temp); break;
                    case SAVEF : f = TMS_IEEE(temp);
                                 fprintf(out,"%+10e\r\n",   f);  break;
                    case SAVEH : fprintf(out,"%08lx\r\n",temp); break;
                    case SAVEBB: c = (char)(temp&0xff);
                                 fwrite(&c,1,1,out); break;
                    case SAVEBI: i = (int)(temp & 0xffff);
                                 fwrite(&i,2,1,out); break;
                    case SAVEBL: fwrite(&temp,4,1,out); break;
                    case SAVED :
                          // Dasm_Mode?
                          p = sMSG;
                          p += sprintf(p,"%08lx %08lx ",la[0],temp);
                          get_label(p,la[0],0); // label @address
                          strcat(sMSG,"           ");
                          p += 8;
                          *p++ = ' ';
                          Disasm(la[0], temp, p);
                          fprintf(out,"%s\r\n", sMSG);
                          break;
                  }
                  la[0]++; /* Increment here for DASM version */
                }
                fclose(out);
                return(NO_ERR);
    default   : break;
  }
  switch (cmd)
  {
    case MEM2 :
    case MEMA :
    case MEMF :
    case MEML :
    case MEMUL:
    case MEM  : QVAL = 0;
    case MEMQ :
                switch(cmd)
                {
                  case MEM2 : Mem_Mode = NT_BASE2;   break;
                  case MEMA : Mem_Mode = NT_AUTO;    break;
                  case MEMQ : Mem_Mode = NT_QFORM;   break;
                  case MEMF : Mem_Mode = NT_FLOAT;   break;
                  case MEML : Mem_Mode = NT_SLONG;   break;
                  case MEMUL: Mem_Mode = NT_ULONG;   break;
                  case MEM  : Mem_Mode = NT_INTEGER; break;
                }
                switch(args)
                { case  0: err=MEM_Window (MEM_Address); break;
                  case  1: err=MEM_Window (        la[0]); break;
                  default: err=XTRA_ARG; break;
                }
                break;
    case DASM : switch(args)
                { case  0: err=DASM_Window(DASM_Address); break;
                  case  1: DASM_Address = la[0];
                           err=DASM_Window(la[0]); break;
                  default: err =XTRA_ARG; break;
                }
                break;
    case VERSION: sprintf(CMSG,"DSK3 Version %2.2f",DSK3_rev);
                  Cmd_Msg(CMSG,CMD_ATTR,1,1);
                  while(!kbhit());
                  break;

    case RESET: if(args) err=XTRA_ARG;
                else     err=RESET_Cmd();
              //  if((err=HALT_CPU())!=NO_ERR) return err;
              //if((err=getmem(CTXT_PTR,CTXTSIZE,CTXT))!=NO_ERR)
              //   return err;
              //Update_Ctxt_Vars();
                PC_Appli    = CTXT[PC];
                DASM_Address= CTXT[PC];
                Update = 1;
                break;
    case SCLR : if(args) err=XTRA_ARG;
                else     Symbol_Clear(1);
                break; // Set symbolcount to BOOT level
    //--------------------------------------------------
    // File and Mem to file conversion functions
    //--------------------------------------------------
    case MAXFLEN: if(expressionz(arg[1].s,&la[1],NT_INTEGER)!=NT_INTEGER)
                  return EXPR_ERR;
                  MaxFileLen = la[1];
                  if(MaxFileLen > 2048) return MAX_FLEN;
                  break;

    case MEMCOFF: Cmd_Msg("Creating *.OUT file: PLEASE WAIT",CMD_ATTR,1,1);
                  if(expressionz(arg[2].s,&la[2],NT_INTEGER)!=NT_INTEGER)
                     return EXPR_ERR;
                  if(expressionz(arg[3].s,&la[3],NT_INTEGER)!=NT_INTEGER)
                     return EXPR_ERR;
                  if(la[3] > MaxFileLen) return MAX_FLEN2;
                  err=Save_File(arg[1].s,la[2],la[3],MEM2COFF);
                  if(err!=NO_ERR) return err;
                  break;
    case MEMHEX:  Cmd_Msg("Creating *.HEX file: PLEASE WAIT",CMD_ATTR,1,1);
                  //
                  // Following expression repeats except for task.
                  // conversion to a function call will save code space
                  // Next rev...
                  //
                  if(expressionz(arg[2].s,&la[2],NT_INTEGER)!=NT_INTEGER)
                     return EXPR_ERR;
                  if(expressionz(arg[3].s,&la[3],NT_INTEGER)!=NT_INTEGER)
                     return EXPR_ERR;
                  if(la[3] > MaxFileLen) return MAX_FLEN2;
                  err=Save_File(arg[1].s,la[2],la[3],MEM2HEX);
                  if(err!=NO_ERR) return err;
                  break;

    case HEXCOFF: Cmd_Msg(
        "Please use DSK2COFF or MEM2COFF for direct conversion to COFF"
                  ,ERR_ATTR,1,1);
                  break;
                  /*
                  Cmd_Msg("Creating *.OUT file: PLEASE WAIT",CMD_ATTR,1,1);
                  strupr(arg[1].s);
                  if(strstr(arg[1].s,".OUT")) return OPEN_ERR;
                  Load_File(arg[1].s,SLOAD); //Dont care if no symbol file
                  if((err=Load_File(arg[1].s,DSK2COFF))!=NO_ERR) return err;
                  Load_File(Old_file,SLOAD);
                  break;
                  */
    case DSKCOFF: Cmd_Msg("Creating *.OUT file: PLEASE WAIT",CMD_ATTR,1,1);
                  strupr(arg[1].s);
                  if(strstr(arg[1].s,".OUT")) return OPEN_ERR;
                  if((err=Load_File(arg[1].s,SLOAD   ))!=NO_ERR) return err;
                  if((err=Load_File(arg[1].s,DSK2COFF))!=NO_ERR) return err;
                  Load_File(Old_file,SLOAD);
                  break;
//   case DSKHEX:
//   case COFFHEX:
     case FILEHEX:
                  Cmd_Msg("Creating *.HEX file: PLEASE WAIT",CMD_ATTR,1,1);
                  strupr(arg[1].s);
                  if(strstr(arg[1].s,".HEX")) return OPEN_ERR;

                  if((err=Load_File(arg[1].s,FILE2HEX))!=NO_ERR)
                  { //fcloseall();
                    return err;
                  }
                  Load_File(Old_file,SLOAD);
                  break;
    //--------------------------------------------------
    // File load functions
    //--------------------------------------------------
    case FLF:   strncpy(sMSG,arg[1].s,12);
                //
                // Append .DSK extension to filename
                //
                p = strstr(sMSG,".");
                if(p==NULL) strcat(sMSG,DSKEXT1);
                else        strcpy(   p,DSKEXT1);
                //
                // When using a HEX boot(load)able cache, check that the
                // source and cache files both  exist and that the date
                // stamp follows the source (FILE.DSK)
                //
                p = strstr(sMSG,".");  // make p point to '.'
                if(access(sMSG,0)!=0)
                {
                  strcpy(p,".out");
                  if(access(sMSG,0)!=0)
                  {
                    strcpy(p,".hex");
                    if(access(sMSG,0)!=0)
                    {
                      Cmd_Msg("DSK, COFF or HEX file not found",ERR_ATTR,1,1);
                      return NO_ERR;
                    }
                  }
                }
                // File is known to exist, so get date stamp
                //
                out = fopen(sMSG,"rb");
                getftime(fileno(out), &ft1);
                fclose(out);
                //
                // Now look for HEX file
                //
                strcpy(p,".HEX");
                if ((out = fopen(sMSG,"rb")) != NULL)
                {
                  getftime(fileno(out), &ft2);
                  //
                  // The file time structure is 32 bits, so a typecasted
                  // 32 bit compare avoids normalization of each field
                  //
                  la[0] = *(long *)&ft1;
                  la[1] = *(long *)&ft2;
                  if(la[0] > la[1])
                    unlink(sMSG);
                  fclose(out);
                }
                //
                //
                //
                if(access(sMSG,0)!=0) //create HEX file if it does not exist
                {
                  Cmd_Msg("Updating *.HEX file: PLEASE WAIT",CMD_ATTR,1,1);
                  if((err=Load_File(arg[1].s,FILE2HEX))!=NO_ERR)
                  { fclose(out);
                    return err;
                  }
                }
                else
                  Cmd_Msg("Using existing *.HEX cache file",CMD_ATTR,1,1);
                err=Load_File(arg[1].s,LOADHEX);
                if(err!=NO_ERR) {fclose(out); return err;}
                /*----------------------------------------------------
                   If the HEX file was created from memory, there will
                   not be a corresponding DSK file to load symbols from.
                 -----------------------------------------------------*/

                p = strstr(arg[1].s,".");
                if(p==NULL) strcat(arg[1].s,".DSK");
                else        strcpy(       p,".DSK");

                if(access(arg[1].s,0)==0)
                {
                  err=Load_File(arg[1].s,SLOAD);
                  if(err!=NO_ERR)
                  {
                    sprintf(sMSG,"No symbols loaded : %s",Error_Strg(err));
                    Cmd_Msg(sMSG,ERR_ATTR,1,1);
                    getch();
                  }
                }
                DASM_Address = PC_Appli;
                break;
    //
    // Open a window for displaying the contents of the symbol table
    //
    case SYMBOLS:
                SYM_Help();
                break;

    case SLF  : Cmd_Msg("LOADING FILE: PLEASE WAIT",CMD_ATTR,1,1);
                err=    Load_File(arg[1].s, SLOAD);         break;
    case LF   : Cmd_Msg("LOADING FILE: PLEASE WAIT",CMD_ATTR,1,1);
                err1=Load_File(arg[1].s, LOAD);
                if((err1!=NO_ERR)&&(err1!=HEXMATCH)) return err1; //break;
                //----------------------------------
                // Load symbols
                //    HEX -> search for DSK then OUT file
                //    *.  -> search for DSK, then OUT file
                //    OUT -> Load from filename
                //    DSK -> Load from filename
                //
                strupr(arg[1].s);
                if(strstr(arg[1].s,".OUT")||strstr(arg[1].s,".DSK"))
                { err = Load_File(arg[1].s,SLOAD);
                }
                else
                { file_ext(arg[1].s,"DSK");    // Try .DSK extension first
                  err = Load_File(arg[1].s,SLOAD);
                  if(err!=NO_ERR)              // If no load, try .OUT next
                  { file_ext(arg[1].s,"OUT");
                    err = Load_File(arg[1].s,SLOAD);
                  }
                }
                //---------------------------------
                if(err!=NO_ERR)
                {
            sprintf(sMSG,"No DSK/OUT symbols loaded : %s",Error_Strg(err));
                  Cmd_Msg(sMSG,ERR_ATTR,1,1);
              //  Cmd_Msg("Symbol Load Error",ERR_ATTR,1,1);
                  getch();
                }
                err = err1; //NO_ERR;
                DASM_Address = PC_Appli;
                break;
    case BLF  : Cmd_Msg("LOADING FILE: PLEASE WAIT",CMD_ATTR,1,1);
                err=    Load_File(arg[1].s,  LOAD);
                DASM_Address = PC_Appli;
                break;
    /*-------------------------------------------------------*/
    case DB   : if(args) err=XTRA_ARG;
                else     err = DB_Cmd();
                break;
    case GO   : switch(args)
                { case 0: err=RUN_Cmd(); break;
                  case 1: if(BP_SET(la[0])) {err=RUN_Cmd(); break;}
                          //else
                          SB_Cmd(la[0]);
                          err=RUN_Cmd();
                          //
                          // If a key was pressed to break the
                          // RUN condition clear it
                          err = CB_Cmd(la[0]);
                          //DASM_Address = PC_Appli;
                          break;
                  default:err = XTRA_ARG; break;
                } break;
    case RUN  : if(args) err=XTRA_ARG;
                else     err=RUN_Cmd();
                //
                // If a key was pressed to break the
                // RUN condition clear it
                break;
    case RUNF : if(args) err=XTRA_ARG;
                else     err = RUNF_Cmd();
                // If a key was pressed to break the
                // RUN condition clear it
                break;
    case EXTR1: if(args) err=XTRA_ARG;
                else
                {
                  CPU_mode = 1;
                  CPU_Window();
                }
                break;   // REG40
    case EXTR2: if(args) err=XTRA_ARG;
                else
                {
                  CPU_mode = 2;
                  CPU_Window();
                }
                break;   // FLOAT
    case QUIT2: if(args) err=XTRA_ARG;
                else
                { //fcloseall();
               // if(screenmode == C4350)
                  textmode(oldscreenmode); // Force mode back to 25x80
                  clrscr();
                  _setcursortype(_NORMALCURSOR);
                  printf(Exit_Hlp);
                  exit(0);
                }
                break;
    case DOS  : //clrscr();
                _setcursortype(_NORMALCURSOR);
                if(system("cls")==-1) return SYS_ERR;
                printf("Type EXIT when you want to return to DSK3D\n");
                //system(""    );
                if(strlen(last_cmd) > 4)
                {
                  if(system(last_cmd+4)==-1) return SYS_ERR;
                  //system(last_cmd+4);
                }
                system(""        );
                err = Init_Screen();
                break;
    case EDIT : _setcursortype(_NORMALCURSOR);
                system("cls");
                if(arg[1].s!=0)
                {
                  if(system(Cmd_Line)==-1) return SYS_ERR;
                }
                else
                {
                  sprintf(CMSG,"edit %s",DASM_file);
                  strcpy(strstr(CMSG,"."),".asm");
                  if(system(CMSG)==-1) return SYS_ERR;
                }
                printf("\nHit Enter to return to DSK3D");
                getch();
                err = Init_Screen();
                strcpy(CMSG,"");
                break;
    case DSK3A: _setcursortype(_NORMALCURSOR);
                system("cls");

                if(arg[1].s)
                {
                  if(system(Cmd_Line)==-1) return SYS_ERR;
                  p=Cmd_Line+5;
                  while(*p==' ')p++;
                  strcpy(DASM_file,p);
                }
                else
                {
                  sprintf(CMSG,"DSK3A %s",DASM_file);
                  strcpy(strstr(CMSG,"."),".asm");
                  if(system(CMSG)==-1) return SYS_ERR;
                }

                printf("\nHit Enter to return to DSK3D");
                getch();
                if((err=Init_Screen())!=NO_ERR) return err;
                strcpy(CMSG,"");
                Cmd_Msg("LOADING FILE: PLEASE WAIT",CMD_ATTR,1,1);
                strcpy(CMSG,DASM_file);      // Wack off .asm during load
                strcpy(strstr(CMSG,"."),"");

                if((err=Load_File(CMSG,  LOAD))!=NO_ERR)break;
                    err=Load_File(CMSG, SLOAD);
                DASM_Address = PC_Appli;
                if(err==NO_ERR)
                  err = Init_Screen();
                break;
    case PATCH:
                SEG[current_seg].offs = CTXT[PC];
                strncpy(bug_last_cmd,last_cmd,60);
                err=PATCHF(last_cmd);
                strncpy(last_cmd,bug_last_cmd,60);
                break;
    //===================================================
    // The next few lines require an expression analyzer
    // to determine the value of each argument.
    //===================================================
    case SB  : switch(args)
               { case  1: err = SB_Cmd(la[0]);break;
                 case  0: err = MISS_ARG;     break;
                 default: err = XTRA_ARG;     break;
               } break;
    case CB  : switch(args)
               { case  1: err = CB_Cmd(la[0]);break;
                 case  0: err = CB_Cmd(   0L);break;
                 default: err = XTRA_ARG;     break;
               } break;
    case MM  : switch(args)
               { case  0: err = MM_Cmd(MEM_Address,   0L,   0L); break;
                 case  1: err = MM_Cmd(      la[0],   0L,   0L); break;
                 case  3: if(expressionz(arg[3].s,&la[2],NT_AUTO)==NT_FLOAT)
                            la[2] = IEEE_TMS(*(float *)&la[2]);
                          err = MM_Cmd(la[0],la[1],la[2]);
                          break;
                 case  2: err = MISS_ARG; break;
                 default: err = XTRA_ARG; break;
               } break;
    case XG   :switch(args)
               { case  1: err = XG_Cmd(la[0]);    break;
                 case  0: err = MISS_ARG;         break;
                 default: err = XTRA_ARG;         break;
               } break;
    case FSTEP:if(args==0) {args=1; la[0]=1;}
               switch(args)
               { case  1: err = FSTEP_Cmd(la[0]); break;
                 case  0: err = MISS_ARG;         break;
                 default: err = XTRA_ARG;         break;
               } break;
    case SSTEP:if(args==0) {args=1; la[0]=1;}
    case XN   :switch(args)
               { case  1: err = SStep_Cmd(la[0]); break;
                 case  0: err = MISS_ARG;         break;
                 default: err = XTRA_ARG;         break;
               } break;

    case HELP : Edit_Help(); break;

    case EVAL :// Display depends on the expression return type
    case ASIGN:
               SEG[current_seg].offs = CTXT[PC];
               switch(args)
               { case  0: err = EXPR_ERR; break;
                 case  1: Update = 1;
                          err = NO_ERR;
                          Update_Ctxt_Vars();
                          switch(expressionz(arg[1].s,&la[0],NT_AUTO))
                          {
                            case NT_FLOAT  :
                            sprintf(CMSG, "%#g",*(float *)&la[0]); break;
                            case NT_INTEGER:
                            sprintf(CMSG,"0x%08lx = %ld",la[0],la[0]); break;
                            default     : err = EXPR_ERR; break;
                          }
                          if(err!=NO_ERR) break;
                          if(cmd==ASIGN) // Decide which register to update
                          {
                            err = Update_Ctxt_Regs(arg[0].s,arg[1].s);
                          }
                          break;
                 default: err = XTRA_ARG; break;
               }
               strupr(arg[0].s);
               if(strexact(arg[0].s,"PC"))
               {
                 if((CTXT[PC] < DASM_Address)||(CTXT[PC] > DASM_Ad_End))
                   DASM_Address = CTXT[PC];
               }
               break;

    case MOVEMEM: switch(args)
                  {
                    case  0:
                    case  1:
                    case  2: err = MISS_ARG; break;
                    case  3: break;
                    default: err = XTRA_ARG; break;
                  }
                  if(la[2] > 256) err = range_warn;
                  if(err!=NO_ERR) break;
                  for(i=(int)la[2];i>0;i--)
                  {
                    if((err=getmem(la[0]++,1,&temp))!=NO_ERR) break;
                    if((err=putmem(la[1]++,1,&temp))!=NO_ERR) break;
                  }
                  break;
    case REDRAW: break;
    default :  err = UNKN_ERR; break;
  }
  fclose(out);
  switch (cmd)
  {
    case REDRAW:
    case RUN  :
    case RUNF :
    case LF   :
    case BLF  :
    case FLF  :
    case SLF  :
    case RESET:
    case GO   :
    case MOVEMEM:
                if(PC_Appli < DASM_Address) DASM_Address = PC_Appli;
                if(PC_Appli > DASM_Ad_End ) DASM_Address = PC_Appli;
    case MMF  :
    case MM   :
    case PATCH:
    case EVAL :
    case SCLR :
    case CB   :
    case SB   :
    case ASIGN: i = post_boot_sym;
                if(((err==NO_ERR)||(err==HEXMATCH)) && (Update==1))
                  err = Init_Screen();
                post_boot_sym = i;
                break;
    default   : break;
  }
  _setcursortype(_NORMALCURSOR);
  return err;
}


