//------------------------------------------------------------
// DISPCOFF.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include "dsk.h"
#include "screen.h"
int HLL_1 = 0;
#define L1 HLL_1
char DSK_APP[80];
char HLLfunction[20];
//--------------------------------------------------------
// HLL_SRCE_LINE returns the C source line number and sets
// the filename to the file associated with the function.
//--------------------------------------------------------
int HLL_SRCE_LINE(void)
{
  int x, line;
  ulong addr;
  //
  // Search the cross reference table for a match,
  // remembering the name of each function associated
  //
  addr = CTXT[PC];
  line = 0;
    //-------------------------------
    line = HLL[lastHLL].xref.HLL_line;
    for(x=0;x<lastHLL;x++)
    {
      if(HLL[x].xref.HLL_line == 0)
      {
        strncpy(HLLfunction,SYM[(int)HLL[x].xref.DSP_addr].sptr,20);
        if((addr>= HLL[x+1].xref.DSP_addr)&& (addr < HLL[x+2].xref.DSP_addr))
        {
          line = HLL[x+1].xref.HLL_line;
          break;
        }
      }
      if((HLL[x+2].xref.DSP_addr)!=0)
      if((HLL[x+1].xref.HLL_line == 0) && (addr < HLL[x+2].xref.DSP_addr))
      {
        line = HLL[x].xref.HLL_line - 1;
        break;
      }
      if((HLL[x+1].xref.DSP_addr)!=0)
      if((addr >= HLL[x].xref.DSP_addr) && (addr < HLL[x+1].xref.DSP_addr))
      {
        line = HLL[x].xref.HLL_line - 1;
        break;
      }
      line = HLL[lastHLL].xref.HLL_line;
    }
    if(x==lastHLL)
    {
      strcpy(HLLfunction,"");
      line = HLL[lastHLL].xref.HLL_line-1;
    }
  return line;
}

void COFF_print( int x, int y, char *buf,  int highlight)
{
  char attr,*p;
  attr=Dasm_Win->tattr;
  if   ((p=strstr(buf,"\n"))!=NULL) *p=  0;
  if   ((p=strstr(buf,"\r"))!=NULL) *p=  0;
  //-----------------------------------
  // Strip out the tabs
  //-----------------------------------
  tabstrip(buf+22,8); // Strip at end of prepended hex fields +22
  //-----------------------------------
  p = buf;
  if(*p=='0') // A Line which is either directive or loadable code
  { p+=4;
    strncpy(p+7,p+18,79);
  }
  if(highlight) attr=PC_ATTR;
  PutnChar (x   ,y,Dasm_Win->w- 2,32,attr,CARFOND);
  PutString(x   ,y,Dasm_Win->w- 2, p,attr,    CAR);
}
//==========================================================
// Display the source file using the line information
//==========================================================
char filename[20];
MSGS Display_Source(int debug_line, int *OpenLine)
{
  FILE *csrcfile;
  char buf[220];
  char *p;
  int i,xx, yy;
  //--------------------------------------------------------------
  // Search the symbol table for the function name prepended to
  // the filename with a ':' seperator
  //--------------------------------------------------------------
  strcat(HLLfunction,":");
  for(xx=0;xx<last_ref;xx++)
  { if((p=strstr(SYM[xx].sptr,":"))!=NULL)
    { if((p=strstr(SYM[xx].sptr,HLLfunction))!=NULL)
      { p=strstr(SYM[xx].sptr,":");
        break;
      }
    }
  }
  if((xx==last_ref)) //||(*OpenLine <=1))
  { sprintf(EXTMSG,"No HLL source at current PC");
    fcloseall();
    return EXT_MSG_ERR;
  }
  strncpy(filename,p+1,19);
  //-------------------------------------------------------------
  // Open the source file
  if((csrcfile = fopen(filename,"rt")) == NULL)
  { fcloseall();
    return OPEN_ERR;
  }
  //-------------------------------------------------------------
  for(i=1;i<*OpenLine;i++)
  {
     if(fgets(buf,119, csrcfile)==NULL)
     {
       *OpenLine = i;
       fcloseall();
       return NO_ERR;
       //sprintf(EXTMSG,"End of file");
       //return EXT_MSG_ERR;
     }
  }
  xx = Dasm_Win->x;
  yy = Dasm_Win->y;
  for(i=0;i<Dasm_Win->h-2;i++)
  {
    if(fgets(buf,119, csrcfile)==NULL) break;
    tabstrip(buf,8);   // Tabs do not cprintf() to the screen nicely
    if((*OpenLine+i)==debug_line) COFF_print(xx,yy++,buf,1);
    else                          COFF_print(xx,yy++,buf,0);
  }
  for(;i<Dasm_Win->h-2;i++) COFF_print(xx,yy++,"",0);
  fcloseall();
  return NO_ERR;
}
extern WINDOW *Dasm_Win;
//==========================================================
//  L1 -> Begin display at line L1
//  L2 -> Current PC is at line L2
//  L3 -> End display at line L3
//==========================================================
int  Invalidate_DASM = 0;

MSGS DispCOFF(void)
{
  MSGS err;
//static int       L1 =  0;
  static int   old_L1 =  0;
  static int       L2 =  0;
  static int   old_L2 =  0;
  static ulong old_PC =  0;
  int              L3 = 12;

  if(Invalidate_DASM)
  {
        L2 = 0;
    old_L2 = 0;
    old_L1 = 0;
    old_PC = 0;
    Invalidate_DASM = 0;
  }
  //
  // Need only call this one time on first load
  // on load, sload, F4, dasm4
  //
//if((err=get_file_name())!=NO_ERR) return err; // Get file name
  //
  textbackground(BLACK );
  textcolor     (YELLOW);
  if(L1 < 1) L1 = 1;
  //-----------------------------------------------------
  // Get the C source line that cross references with
  // the PC of the DSK and display the source (if any)
  //-----------------------------------------------------
  L2 = HLL_SRCE_LINE();
  //
  // compare and if different display on the following
  // Code step detected   Scrolled screen and no code step
  //
  if((L2!=old_L2) || (L1 != old_L1))
  {
    if(L2!=old_L2)
    {
      L3 = L1 + Dasm_Win->h-2;
      if(L2 < L1) L1 = L2;
      if(L2 > L3) L1 = L2;
    }
    if(L1 < 1) L1 = 1;
    if((err=Display_Source(L2,&L1))!=NO_ERR) return err;
  }
  old_PC = CTXT[PC];
  old_L2 = L2;
  old_L1 = L1;
  gotoxy(38,1);
  printf("-> %s:%d ", filename, L2);
  return NO_ERR;
}

