//------------------------------------------------------------
// DSK3D.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997, 1998
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  DSK3D.CPP is a DOS text window based program.
//  The project build file should include the following files
//  in a directory tree similar to the one shown
//
//  C:\DSK3\DSK3\DSK3A
//       |      \DSK3D
//       |      \COMMON
//       |      \COMMON2
//       |      \DSK3APPS
//       |
//       +--\DSK3xxxx  (Version xxxx)
//          \DSK3yyyy
//
//  Files in root directory
//  -----------------------
//  DSK3D.PRJ     Borland project file
//  DSK3D.DSK     Borland desktop file
//  CMDHELP.TXT   Text for DSK3D commands help
//  HARDWARE.TXT  Text for command line (hardware) help
//
//  CMDHELP.CPP   C string of above  (do not include in project!)
//  HARDWARE.CPP  C string of above  (do not include in project!)
//  *.obj         Object output from compiler
//
//  Files in DSK3D directory
//  ------------------------
//  DSK3D.CPP     This file - Setup, pass1-2, loopback testing...
//  ANALYZE.CPP   Command analysis and execution
//  COMMANDS.CPP  Command entry routines
//  DSK3DHLP.CPP  Help menus for each debugger window
//  SCREEN.CPP    Screen update functions
//  WIN.CPP       Window create/destruct and managment functions
//  SCANS.CPP     This function is used to edit a one line text string
//  TEXTWIN.CPP   DOS Text window functions
//
//  Files in COMMON2 directory
//  --------------------------
//  ARGSPLIT.CPP  Functions to split arguments up for analysis
//  ASCIINUM.CPP  Universal number type recognizer
//  ASMC40.CPP    Assembler routines
//  ASSM_FUN.CPP  Functions for recognizing assembly constructs
//  DASMC40.CPP   Disassembler routines
//  EXP_ANAL.CPP  Expression analyzer and function recognizer
//  MATHERR.CPP   Math error trap routines
//  OPCODES1.CPP  Text strings and structures used for assy/dasm
//  OPCODES2.CPP  Main array of assembler menmonics and codes
//  SIM3XNUL.CPP  Null functions for SIM3X.CPP
// *SIM3X.CPP     Functions for SIM3X.CPP * Not finished
//
//  Files in COMMON directory
//  -------------------------
//  DRIVER.CPP    Low level printer port drivers
//  DSK_COFF.CPP  DSK and COFF file loaders and other utils
//  ERRORMSG.CPP  Messages used for most function returns
//  OBJECT.CPP    Application setup routines
//  SYMBOLS.CPP   Symbol tables (needed to link DSK_COFF)
//  TARGET.CPP    DSK Command level
//  TMSFLOAT.CPP  TMSFLOAT - IEEE floating point conversion functions
//
// NOTE: The *.TXT are kept in the root directory such that TXT2SRC.EXE
//       can be automatically called to convert these files to the *.CPP
//       files that are #included withing the body of source code. The
//       converted *.CPP files are NOT included withing the project build.
//
//       The Borland IDE Transfer utility feature in Borland 3.1 may
//       not be available in the Windows versions of Borland C
//       (4.0 and later).  If you cant get the auto-translation to work,
//       you can simply not include the *.TXT files in the build list.
//
//       In this case, if you make an edit to the *.TXT files, you need
//       manualy convert them using TXT2SRC before compiling your project.
//------------------------------------------------------------------------
//  Borland C++ version 3.1 setup (use defaults if not shown)
//
//    Compiler
//     Memory Model      - Large        (objects reused in DSK3D link)
//     Processor         - 80286        (old PC support)
//     Floating Point    - Emulation
//     Code Gen          - DOS Standard (works in Win DOS prompt box)
//     Calling convention- C
//     Optimization      - Speed        (code reduction is not significant)
//
//    Linker
//     Output              - DOS Standard EXE   (Not a windows app!)
//     Libraries           - Graphics
//     Object Windows Lib  - None
//     Container Class     - None
//     Standard Runtime Lib- Static
//
//  NOTE: Other than using '//' comments and other simple C++ features
//        this code follows ANSI C.  The C++ compiler is used primarily
//        for convenience as well as its performance and advanced error
//        checking and warnings.
//
//        An 80286 output is used for DSK users who are using old PC's
//        for automated 'smart' data collection boxes.
//
//  Windows 3.x/95
//        DSK3D is a DOS text application which uses timelsice management
//        interrupt hooks to improve task swapping.
//
//  DSK3D Debugger core revision history
//  -------------------------------------
//  1.00  02/01/96  Keith Larson - Release version
//  1.01  05/15/96  Keith Larson
//  1.02  06/15/96  Keith Larson
//  1.03  07/10/96  Keith Larson
//  1.04  07/20/96  Keith Larson
//  1.10  08/05/96  Keith Larson
//  1.11  08/05/96  Keith Larson - Increase stack space, add MEM modes
//  1.12  11/05/96  Keith Larson - Numerous new features added
//  1.15   1/03/97  Keith Larson
//  1.16   1/06/97  Keith Larson - Added 43x80 and 50x80 text modes
//  1.17
//  1.18                         - Release to production 3/30/97
//   ||
//  1.23   3/25/98  Keith Larson
//--------------------------------------------------------------------
#include "DISCLAIM.H" // You must remove the comment in DISCLAIM.H to compile
#ifndef __DISCLAIM
========================================================================
 NOTE: By removing this statement or the comment inside DISCLAIM.H which
 blocks the definition of __DISCLAIM you are hereby recognizing that you
 have read and will abide by the disclaimer statement and guidelines of
 useage which are outlined in the file DISCLAIM.H

 Please note that the contents of DISCLAIM.H include statements specific
 to the DSK assembler and debugger that are not covered in the standard
 disclaimer.
========================================================================
#endif
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>

#include "dsk.h"        // Application level DSK functions and variables

#include "screen.h"     // These headers and libraries are for debugger
#include "argsplit.h"   // and assembler functions and variables
#include "opcodes.h"    //
//-----------------------------------------------
char  CMD_TITLE[]   = " COMMAND ";
char  CPU_TITLE[]   = "#C#PU REGISTERS";
char  MEM_TITLE[]   = " #M#EMORY ";
char  DASM_TITLE[]  = " #D#ISASSEMBLY ";
char  BRK_PT_TITLE[]= " BREAKPOINTS ";
//=======================================================================
// Is_Cmd() scans a string ptr and associates an exact match to a command
//========================================================================
int Is_Cmd(char *ptr)
{
  char t;
  strupr(ptr);
  if(strexact(ptr,"LF"    )) return LF;
  if(strexact(ptr,"FILE2HEX")) return FILEHEX;
  if(strexact(ptr,"DSK2HEX" )) return FILEHEX;
  if(strexact(ptr,"COFF2HEX")) return FILEHEX;
  if(strexact(ptr,"MEM2HEX" )) return MEMHEX;
  if(strexact(ptr,"HEX2COFF")) return HEXCOFF;
  if(strexact(ptr,"DSK2COFF")) return DSKCOFF;
  if(strexact(ptr,"MEM2COFF")) return MEMCOFF;
  if(strexact(ptr,"MAXFLEN" )) return MAXFLEN;

  if(strexact(ptr,"FLF"   )) return FLF;
  if(strexact(ptr,"LOAD"  )) return LF;
  if(strexact(ptr,"RELOAD")) return LF;
  if(strexact(ptr,"SYMBOLS"))return SYMBOLS;
  if(strexact(ptr,"SYM"   )) return SYMBOLS;
  if(strexact(ptr,"SLOAD" )) return SLF;  // Load symbols
  if(strexact(ptr,"BLOAD" )) return BLF;  // Load binary
  if(strexact(ptr,"SC"    )) return SCLR; // Clear symbols
  if(strexact(ptr,"SCLEAR")) return SCLR; // Clear symbols
  if(strexact(ptr,"SB"    )) return SB;
  if(strexact(ptr,"CB"    )) return CB;
  if(strexact(ptr,"DB"    )) return DB;
  if(strexact(ptr,"MEM"   )) return MEM;  // display mem using 32 bit hex
  if(strexact(ptr,"MEMX"  )) return MEM;  // display mem using 32 bit hex
  if(strexact(ptr,"MEMF"  )) return MEMF; // display mem using float
  if(strexact(ptr,"MEM2"  )) return MEM2; // display mem using base 2
  if(strexact(ptr,"MEMB"  )) return MEM2; // display mem using base 2

  if(strexact(ptr,"MEMD"  )) return MEML; // display mem using long
  if(strexact(ptr,"MEML"  )) return MEML; // display mem using long
  if(strexact(ptr,"MEMI"  )) return MEML; // display mem using long
  if(strexact(ptr,"MEMUD" )) return MEMUL;// display mem using long
  if(strexact(ptr,"MEMUI" )) return MEMUL;// display mem using long
  if(strexact(ptr,"MEMUL" )) return MEMUL;// display mem using long
  if(strexact(ptr,"MEMU"  )) return MEMUL;// display mem using long

//if(strexact(ptr,"MEMA"  )) return MEMA; // symbol type sets print mode
  if(strexact(ptr,"DASM"  )) return DASM;
  if(strexact(ptr,"MM"    )) return MM;
//if(strexact(ptr,"MMF"   )) return MMF;
  if(strexact(ptr,"RUN"   )) return RUN;
  if(strexact(ptr,"RUNB"  )) return RUN;
  if(strexact(ptr,"RUNF"  )) return RUNF;
  if(strexact(ptr,"XG"    )) return XG;
  if(strexact(ptr,"XN"    )) return XN;
  if(strexact(ptr,"QUIT"  )) return QUIT2;
  if(strexact(ptr,"EXIT"  )) return QUIT2;
  if(strexact(ptr,"RESET" )) return RESET;
  if(strexact(ptr,"REG40" )) return EXTR1;
  if(strexact(ptr,"FLOAT" )) return EXTR2;
  if(strexact(ptr,"DOS"   )) return DOS;
  if(strexact(ptr,"EDIT"  )) return EDIT;
  if(strexact(ptr,"DSK3A" )) return DSK3A;
//if(strexact(ptr,"SHELL" )) return DSK3A;
  if(strexact(ptr,"ASM"   )) return PATCH;
  if(strexact(ptr,"PATCH" )) return PATCH;
  if(strexact(ptr,"?"     )) return EVAL;
  if(strexact(ptr,"GO"    )) return GO;
  if(strexact(ptr,"SS"    )) return SSTEP;
  if(strexact(ptr,"STEP"  )) return SSTEP;
  if(strexact(ptr,"FSTEP" )) return FSTEP;
  if(strexact(ptr,"HELP"  )) return HELP;
  if(strexact(ptr,"SAVE"  )) return SAVE;
  if(strexact(ptr,"REDRAW")) return REDRAW;
  if(strexact(ptr,"VERSION"))return VERSION;
  if(strexact(ptr,"VER"    )) return VERSION;
  if(strexact(ptr,"XINDON" )) { Enhanced_Enable=1; return DASM;}
  if(strexact(ptr,"XINDOFF")) { Enhanced_Enable=0; return DASM;}
  if(strexact(ptr,"XON" )) { Enhanced_Enable=1; return DASM;}
  if(strexact(ptr,"XOFF")) { Enhanced_Enable=0; return DASM;}
  if(strexact(ptr,"MOVE"  )) return MOVEMEM;
  if(strexact(ptr,"MOV"   )) return MOVEMEM;
  if(strexact(ptr,"CSAVE"       )) return CSAVE;
  if(strexact(ptr,"CSAVEALL"    )) return CSAVEALL;
  if(strexact(ptr,"CSAVEALLHEX" )) return CSAVEALL;
  if(strexact(ptr,"CSAVEALLCOFF")) return CSAVEALLCOFF;
  if(strexact(ptr,"TAKE"        )) return CREAD;
  if(strexact(ptr,"CLOAD"       )) return CREAD;
  if(strexact(ptr,"CREAD"       )) return CREAD;
  if(strexact(ptr,"PAUSE"       )) {while(!kbhit()); return REDRAW;}
  if(strexact(ptr,"END"    )) return ENDTAKE;
  if(strexact(ptr,"DASM0"  )) {Dasm_Mode = DASM0; return DASM;}
  if(strexact(ptr,"DASM1"  )) {Dasm_Mode = DASM1; return DASM;}
  if(strexact(ptr,"DASM2"  )) {Dasm_Mode = DASM2; return DASM;}
  if(strexact(ptr,"DASM3"  )) {Dasm_Mode = DASM3; return DASM;}
  if(strexact(ptr,"DASM4"  )) {Dasm_Mode = DASM4; return DASM;}
  if(strexact(ptr,"C3XMODE"))
    {if(kbhit()) getch(); C3Xmode = 1; return DASM;}
  if(strexact(ptr,"C4XMODE"))
    {if(kbhit()) getch(); C3Xmode = 0; return DASM;}

  t = ptr[3];
  ptr[3]=0;
  if(strexact(ptr,"CMD"))
  {
    ptr[3]=t;
    return CMDBUFLOAD;
  }
  ptr[3]=t;

  t = ptr[4];
  ptr[4]=0;
  if(strexact(ptr,"MEMQ"))
  {
    ptr[4]=t;
    return MEMQ; // Qxx format display
  }
  ptr[4]=t;

  return CMD_NULL;
}

#define SCRL 0x10
#define NUML 0x20
#define CAPL 0x40
#define INS  0x80

void keyset(int key, int ON)
{
  union REGS regs;
  unsigned short KeyboardStatus;
  KeyboardStatus = *(unsigned short far *)MK_FP( 0x40, 0x17 );
  if (ON) KeyboardStatus = KeyboardStatus | key;     // set
  else    KeyboardStatus = KeyboardStatus & (!key);  // clear
  *(unsigned short far *)MK_FP( 0x40, 0x17 ) = KeyboardStatus;
  regs.h.ah = 1;  //
  int86(0x16, &regs, &regs);
}

//=========================================================
// main()
//=========================================================
void main(void)
{
//  unsigned char KeyStates[256];
//  union REGS regs;
//  unsigned short KeyboardStatus;
  MSGS err;
  int x, th;
  struct text_info ti;
  char *ptr;
  DSK3D=0;               // Enables register recognition for debugger
  g_pass=2;              // Init for expression analyzer

  // XREF_TABLE SYM[MAX_SYMBOLS]; malloc into existance a big table
  // SYM = (XREF_TABLE *) malloc(MAX_SYMBOLS*sizeof(XREF_TABLE));

  BuildFastLook();
  strcpy(g_file ,"");
  strcpy(g_strg1,"");
  strcpy(g_strg2,"");
  /*-------------------------------------------------------------*/
  /* The following line is used to insert DSK3D specific command */
  /* line options into the help string before being printed. The */
  /* help string itself has enough WS chars to allow this.       */
  /*-------------------------------------------------------------*/
  Edit_Help_Msg("DSK3D","",
  "  H HI L or LO    Select HI 43 line or LO 25 line display mode\r\n");
//"  EXT             Enable extended addressing opcodes (>PG6)\r\n");
  Enhanced_Enable = 0;
  /*----------------------------------------------------*/
  /* Determine present screen mode                      */
  screenmode =   C4350; // default changed to 43/50 row ver 1.25
  gettextinfo(&ti);
  /*
  if(ti.screenheight > 25) screenmode = C4350;
  else                     screenmode =   C80;  // default
  */
  keyset(NUML,0);  // Clear the NUM lock key
  /* If requested, force mode */
  Scan_Command_line("DSK3D");
  for(x=1;x<_argc;x++)
  {
    strupr(_argv[x]);
    if(strexact(_argv[x],"QUIRK")) LO_PWR         = 0; // quirky ports !LP
//  if(strexact(_argv[x],"EXT"))   Enhanced_Enable= 1; //
    if(strexact(_argv[x],"HI"))    screenmode = C4350; // Force Hi Video
    if(strexact(_argv[x],"LO"))    screenmode =   C80; // Force Lo Video
    if(strexact(_argv[x],"H"))     screenmode = C4350; // Force Hi Video
    if(strexact(_argv[x],"L"))     screenmode =   C80; // Force Lo Video
  }
  /*----------------------------------------------------*/
  if((err=Init_Communication(10000))!=NO_ERR)
  {
    //clrscr();
    printf("\r\n");
    printf(Error_Strg(err));
    exit(0);
  }
  InitVideo();
  gettextinfo(&ti);
  th = ti.screenheight;
                    // LCol, TRow, W, H
  if(screenmode==C4350)
  {
    Dasm_Win=DSKCreateWindow( 1,    1,64,th-11,DASM_TITLE,FRAME1,WIN_ATTR,WIN_ATTR);
    Cpu_Win =DSKCreateWindow(65,    1,16,th-11,CPU_TITLE ,FRAME1,WIN_ATTR,WIN_ATTR);
    Cmd_Win =DSKCreateWindow( 1,th-11,34,   11,CMD_TITLE ,FRAME1,WIN_ATTR,WIN_ATTR);
    Mem_Win =DSKCreateWindow(35,th-11,46,   11,MEM_TITLE ,FRAME1,WIN_ATTR,WIN_ATTR);
  }
  else
  {
    Dasm_Win=DSKCreateWindow( 1,   1,51,th-8,DASM_TITLE,FRAME1,WIN_ATTR,WIN_ATTR);
    Cpu_Win =DSKCreateWindow(52,   1,29,th-8,CPU_TITLE ,FRAME1,WIN_ATTR,WIN_ATTR);
    Cmd_Win =DSKCreateWindow( 1,th-8,34,   8,CMD_TITLE ,FRAME1,WIN_ATTR,WIN_ATTR);
    Mem_Win =DSKCreateWindow(35,th-8,46,   8,MEM_TITLE ,FRAME1,WIN_ATTR,WIN_ATTR);
  }
  OpenWindow(Cpu_Win) ;
  CPU_Window();
  OpenWindow(Dasm_Win);
  DASM_Window(DASM_Address);
  OpenWindow(Mem_Win) ; MEM_Window(MEM_Address);
  OpenWindow(Cmd_Win) ; CMD_Window();

  DASM_Address = MEM_Address = DASMBGN; //0x809800L;
  Nb_Brk_Pt=0;
  for (int i=0; i<CMDBFRS; i++) { Cmd_Buf[i].a = 0xFF07;}
   strcpy (Cmd_Buf[0].s,"TMS320C3x DSK Debugger"         );
   strcpy (Cmd_Buf[1].s,"Texas Instruments Incorporated" );
   strcpy (Cmd_Buf[2].s,"(C)Copyright 1996"              );
   sprintf(Cmd_Buf[3].s,"DSK3 version %2.2f",    DSK3_rev);
   strcpy (Cmd_Buf[4].s,"The Leader In DSP Solutions"    );
   strcpy (Cmd_Buf[5].s,""                               );
   strcpy (Cmd_Buf[6].s,"Read WHATSNEW.TXT for new ");
   strcpy (Cmd_Buf[7].s,"features and fixes");
  Init_Screen();
  StatusLine(Edit_Banner);
  sprintf(CMSG,"CMD> TMS320C3x DSK Ready");
  Cmd_Msg(CMSG,CMD_ATTR,1,1);
  for (x=0; x<CMDBFRS; x++)
    strcpy (Cmd_Buf[x].s,"");
  strcpy (Cmd_Buf[0].s,"Enter a command or F1 for help");
  for(i=100;i>0;i--)
  {
    if(kbhit()) break;
    delay(50); // 1/20 second tick...results in 5 second delay
  }
  Init_Screen();
  Cmd_Msg(CMSG,CMD_ATTR,1,1);
  for ( i=0; i<CMDBFRS; i++) {*Cmd_Buf[i].s=0;}
  //
  // Enter forever loop, getting commands to process
  //
  for(;;)
  { // Get keystrokes, either directly executing
    // functions or building them up into commands
    if((err=Edit_Cmd())==NO_ERR)
      err = ExeCmdStrg(Cmd_Line,1);
    CMD_Window();
    _setcursortype(_NORMALCURSOR);
    if(err != NO_ERR)
    {
      ptr = Error_Strg(err);
      if(ptr!=NULL)
      Cmd_Msg(ptr,ERR_ATTR,1,1);
      while(!kbhit());
    }
    else Cmd_Msg(CMSG,CMD_ATTR,1,1);
    x = 0;
    while(!kbhit());
  }
}
MSGS ExeCmdStrg(char *buf, int Update)
{
  MSGS err;
  int cmd;
  char *p, *ptr, *buf2;
  p = strstr(buf,"\r"); if(p!=NULL) *p = 0;
  p = strstr(buf,"\n"); if(p!=NULL) *p = 0;
  strcpy(last_cmd,buf);
  strcpy(Cmd_Line,buf);
  //
  // This section pulled from end of Edit_Cmd();
  // Packs Cmd_Line WS after the first operand
  //
  p = buf;
  if(*p++=='?') // If EVAL insert a WS after '?'
  {
    if(strlen(buf) < 2)  return EXPR_ERR;
    *p++=' ';
    strcpy(buf+2,last_cmd+1);
  }
  if((p=strstr(buf,"="))!=NULL)
    *p = ' ';
  ptr = argend(buf,0);       // Find end of first argument
  if(p!=NULL) *p = '=';
  if(*ptr)
  { ptr++;
    for(;;)
    { switch(*ptr)
      { case '\r':
        case '\n':
        case    0: *ptr=0; break;
        case  ' ':
        case '\t': buf2 = ptr;
                   while(*ptr)
                   {*ptr=*(ptr+1);
                     ptr++;
                   };
                   ptr = buf2;
                   break;
        default  : ptr++; break;
      }
      if(*ptr==0) break;
    }
  }
  arg_split(buf,0);
  strupr(arg[0].s);

  //----------------------------------------
  // Begin parsing
   if(
         ((p=strstr(buf     ,"="))!=NULL)
       && (strstr(arg[0].s,"CMD") ==NULL)
     )
   {  p=strstr(buf,"=");
      *p= ' ';
      if(*buf=='*')  arg_split(buf+1,0);
      else           arg_split(buf  ,0);
      err = Execute_Cmd(ASIGN,Update);
      cmd = ASIGN;
   }
   else
   { arg_split(buf,0);
     if(*arg[0].s) err=EXPR_ERR;
     if((cmd=Is_Cmd(arg[0].s))!=CMD_NULL)
     err = Execute_Cmd(cmd,Update);
   }
  return err;
}

/*------------------------------------------------------*/
/* This function will load and save a file containing   */
/* the command buffer strings, the current file name,   */
/* registers, memory configuration, etc...              */
/*------------------------------------------------------*/
MSGS cmdsave(int Full, int cmd)
{
  int x;
  MSGS err;
  FILE *file;
  if(*arg[1].s==0)
  { if((file=fopen("CMDFILE.SAV","wt"))==NULL) return OPEN_ERR;}
  else
  { if((file=fopen(arg[1].s,"wt"))==NULL) return OPEN_ERR; }
  for(x=0; x<CMDBFRS+1;x++)
  {
    fprintf(file,"CMD%02d %s\n",x,Cmd_Buf[x].s); // Load string to cmd bufr
  }
  /*   Debugger window save   */
  if(Full)
  {
    if(cmd == CSAVEALL)
    {
      fprintf(file,"FLF FULLSAVE.HEX\n");
      fprintf(file,"SLOAD %s\n", DASM_file);
      strcpy(arg[0].s,"MEM2HEX");
      strcpy(arg[1].s,"FULLSAVE.OUT");
    //strcpy(arg[2].s,"0x809800");
      sprintf(arg[2].s,"0x%08lX",DASMBGN);
      strcpy(arg[3].s,"2048");
      err = Execute_Cmd(MEMHEX,1);
    }
    else /* CSAVEALLCOFF */
    {
      fprintf(file,"LOAD FULLSAVE.OUT\n");
      strcpy(arg[0].s,"MEM2COFF");
      strcpy(arg[1].s,"FULLSAVE.OUT");
  //  strcpy(arg[2].s,"0x809800");
      sprintf(arg[2].s,"0x%08lX",DASMBGN);
      strcpy(arg[3].s,"2048");
      err = Execute_Cmd(MEMCOFF,1);
    }
    if(err!=NO_ERR) return err;
  }
  else
  {
    if(*DASM_file!=0)
    fprintf(file,"SLOAD %s\n"   ,DASM_file);
  }
  fprintf(file,"DASM 0x%08lx\n",DASM_Address);
  switch(Mem_Mode)
  {
    case NT_AUTO   : fprintf(file,"MEMA  0x%08lx\n", MEM_Address); break;
    case NT_FLOAT  : fprintf(file,"MEMF  0x%08lx\n", MEM_Address); break;
    case NT_SLONG  : fprintf(file,"MEML  0x%08lx\n", MEM_Address); break;
    case NT_ULONG  : fprintf(file,"MEMUL 0x%08lx\n", MEM_Address); break;
    case NT_INTEGER: fprintf(file,"MEM   0x%08lx\n", MEM_Address); break;
  }
  /* save minimum of registers to file */
  fprintf(file,"SP = 0x%08lx\n", CTXT[SP]);
  fprintf(file,"PC = 0x%08lx\n", CTXT[PC]);
  fclose(file);
  return NO_ERR;
}

MSGS cmdread(void)
{
  MSGS err;
  FILE *file;
  int line = 0;
  char buf[120];
  char buf2[120];
  char *p;
  if(*arg[1].s==0)
  { if((file=fopen("CMDFILE.SAV","rt"))==NULL) return OPEN_ERR;}
  else
  { if((file=fopen(arg[1].s,"rt"))==NULL) return OPEN_ERR; }
  /*-----------------------------------------*/
  /* read and execute each line as a command */
  /*-----------------------------------------*/
  for(;;)
  {
    if(fgets(buf,119,file)==NULL)
    {
      CmdNum = 0;
      fclose(file);
      Init_Screen();
      return NO_ERR;
    }
    line++;
    if((p=strstr(buf,"\n"))!=NULL) *p=0;
    if((p=strstr(buf,"\r"))!=NULL) *p=0;
    if((p=strstr(buf,"/*"))!=NULL) *p=0;
    if((p=strstr(buf,"//"))!=NULL) *p=0;
    if((p=strstr(buf,";"))!=NULL) *p=0;
    if(strlen(buf))
    {
      Cmd_Msg(buf            ,CMD_ATTR,1,1);
      err = ExeCmdStrg(buf,1);
      if(err==d_end)
      {
        CmdNum = 0;
        return NO_ERR;
      }
      if(err!=NO_ERR)
      {
        sprintf(buf2,"Line %d:\"%s\",%s",line,buf,Error_Strg(err));
        Cmd_Msg(buf2,ERR_ATTR,1,1);
        if(kbhit()) getch(); // Clear pending keystrokes
      }
    }
  }
}