//------------------------------------------------------------
//  DSK3DHELP.CPP
//  Keith Larson
//  TMS320 DSP Applications
// (c) Copyright 1996, 1997, 1998
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//------------------------------------------------------------
//  This file contains the code and message strings that are
//  used to create the help menu boxes in the debugger
//------------------------------------------------------------
//  The project file should include the following files in a directory
//  tree similar to the one shown below.
//
//                  (root)
//
//  C:\---\DSK3SRC--+--\DSK3--+-- \DSK3A  (not used for DSK3D)
//                  |         +-- \DSK3D
//                  |         +-- \COMMON
//                  |         +-- \COMMON2
//                  |         +-- \DSK3APPS
//                  |
//                  +-- Verxxx
//                  +-- Veryyy
//                      etc...
//
//  Files in root directory
//  -----------------------
//    DSK3DHLP.PRJ  Borland project file
//    DSK3DHLP.DSK  Borland desktop file
//    CMDHELP.TXT   Text for DSK3D commands help
//    HARDWARE.TXT  Text for command line (hardware) help
//    APPHELP.TXT   Text for application help (Tips Tricks and Traps)
//  * CMDHELP.CPP   C string of above
//  * HARDWARE.CPP  C string of above
//  * APPHELP.CPP   C string of above
//    *.obj         Object output from compiler
//
//  * These files are #included within the body of source code.
//    Do not add these files to the project
//
// NOTE: The *.TXT and *.CPP files are kept in the root directory
//       such that the TXT2SRC.EXE utility can be automatically called
//       to update the *.CPP files if the *.TXT files are modified.
//
//       The converted *.CPP files are NOT added as an element of the
//       project build.  Instead they are #included within the body of
//       the C source.
//
//       The Borland IDE Transfer utility feature in Borland 3.1 may
//       not be available in the Windows versions of Borland C
//       (4.0 and later).  If you cant get the auto-translation to work,
//       you can simply not include the *.TXT files in the build list.
//
//       In this case, if you make an edit to the *.TXT files, you need
//       manualy convert them using TXT2SRC before compiling your project.
//
//   Files in root directory
//   -----------------------
//   CMDHELP.TXT     Text source
//   HARDWARE.TXT    Text source
//   APPHELP.TXT     Text source
//
//   Files in DSK3D directory
//   ------------------------
//   DSK3HELP.CPP    Main
//   DSK3DHLP.CPP    Opens debugger help screens
//
//   Files in COMMON directory
//   -------------------------
//   TEXTWIN.CPP     DOS Text window functions
//   ERRORMSG.CPP    Messages used for most function returns
//
// NOTE: The *.TXT are kept in the root directory such that TXT2SRC.EXE
//       can be automatically called to convert these files to the *.CPP
//       files that are #included withing the body of source code. The
//       converted *.CPP files are NOT included withing the project build.
//
//       The Borland IDE Transfer utility feature in Borland 3.1 may
//       not be available in the Windows versions of Borland C
//       (4.0 and later).  If you cant get the auto-translation to work,
//       you can simply not include the *.TXT files in the build list.
//
//       In this case, if you make an edit to the *.TXT files, you need
//       manualy convert them using TXT2SRC before compiling your project.
//------------------------------------------------------------
#include "dsk.h"
#include "textwin.h"
/*----------------------------------------------------------------
  Debugger help screens are defined here.  The huge keyword is used
  to tell Borlands DOS level compiler to place data beyond the usual
  64K boundary eliminating the need to HUGE model compile.  For
  UNIX, LINUX, WINDOWS and other non DOS OS, the huge and far keywords
  are undefined in the file 'typedefs.h'
  ----------------------------------------------------------------*/
char huge Mem_Hlp[]=
 " F1       Help screen\r\n"
 " F2       Edit Start Address\r\n"
 " F3       Edit Data\r\n"
 " F9       Toggle window size\r\n"
 " ESC      Exit window\r\n"
 " HOME     Move to top\r\n"
 " END      Move to bottom\r\n"
 " Page U/D Move by page up\r\n"
 " Up/Dn    Move cell vertical\r\n"
 " TAB      Move cell horizontal\r\n"
 "\r\n"
 " To edit the active cell type over the contents of\r\n"
 " the cell and press enter.  Moving off the cell will\r\n"
 " not update the cell.\r\n"
 "\r\n"
 " The F2/F3 keys open up a diologue where numbers and\r\n"
 " symbols can be cobined in expressions"
 ;

char huge CPU_Hlp[]=
 "\r\n"
 " F1        This help screen\r\n"
 " ESC       Exit CPU window\r\n"
 " HOME      Move to top\r\n"
 " END       Move to bottom\r\n"
 " Up/Dn     Move cell vertical\r\n"
 " TAB       Move cell horizontal\r\n"
 "\r\n"
 " To edit the active cell type over the contents\r\n"
 " of the cell and press enter.  Moving off the\r\n"
 " cell will not update the cell.\r\n"
 ;

char huge Dasm_Hlp[]=
  "\r\n"
  "  F1 : Help Screen\r\n"
  "  F2 : Set breakpoint at cursor\r\n"
  "  F3 : Clear breakpoint at cursor\r\n"
  "  F4 : Run to cursor\r\n"
  "  F5 : Run\r\n"
  "  F6 : Display breakpoints\r\n"
  "  F7 : Clear all breakpoints\r\n"
  "  F8 : Singlestep\r\n"
  "  F9 : Grow window\r\n"
  "  F10: Step over\r\n"
  "  SF9: Shrink Window\r\n"
  "  ESC or Return: Escape\r\n";


//-----------------------------------------------------------
// Since the version in About_Hlp[] is a hardcoded string, a
// 'compile error' is generated if the version is incorrect.
// IE Dont forget to change the version stamp in the string!
//-----------------------------------------------------------
#if DSK3_ver != 1.25
  Error_Here
#endif
char huge About_Hlp[]=
  "\r\n\r\n"
  "      DSK3D.EXE   version 1.25\r\n\r\n"
  "      TMS320C31 DSP Starter Kit Debugger\r\n"
  "      Texas Instruments Incorporated\r\n"
  "      (C)Copyright 1994-97\r\n"
  "\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n"  // Must page down to see this
  "\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n"
  "\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n"
  "\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n"
  " TMS320C3x DSK Contributors\r\n"
  " Keith Larson\r\n"
  " Pedro Gelabert   Yves Gagniere \r\n"
  " Richard Oed      Bill Gordan   \r\n"
  " Brian Evans      Robert Eastman\r\n"
  " Ali Rahimi       Ludger Mimberg\r\n"
  " Matthew Shoemake Simon Liu-Lao \r\n"
  " John Tibbits     Gerald Coley  \r\n"
  " Edd Zink         Mike Shust    \r\n"
  " Mehmet Akhan     John Storrs   \r\n"
  "";
/*---------------------------------------------------------------
   This included file is a C formatted help screen message.  To save
   time, a conversion utility TXT2SRC.EXE was written to convert a
   text file to a formatted C string.  This makes editing much more
   convenient. The Borland program transfer utility is also used,
   creating auto-dependancies for easy project management
 -----------------------------------------------------------------*/
char huge  Cmd_Hlp[]=      // Command editor help file is created from
  #include "CMDHELP.CPP"   // CMDHELP.TXT
//-------------------------------------------------------
MSGS Edit_Help (void)
{ return(Help_Menu(" COMMANDS ",Cmd_Hlp  ,10,60,3,20)); }
MSGS About_Help(void)
{ return(Help_Menu(" ABOUT "   ,About_Hlp,10,60,3,20)); }
MSGS Dasm_Help (void)
{ return(Help_Menu(" DASM "    ,Dasm_Hlp ,10,60,3,20)); }
MSGS Mem_Help  (void)
{ return(Help_Menu(" MEM "     ,Mem_Hlp  ,10,60,3,20)); }
MSGS CPU_Help  (void)
{ return(Help_Menu(" CPU "     ,CPU_Hlp  ,10,60,3,20)); }



