//----------------------------------------------------------------
// SCANS.CPP
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996, 1997
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//----------------------------------------------------------------
#include <bios.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "dsk.h"
#include "screen.h"
/*******************************************************************/
/* This function is used to edit a string which is printed to the  */
/* current cursor position with a maximum length of l              */
/*******************************************************************/
MSGS scans(char *p1,int l)
{
  char buf[80];
  int cx1, cy1;
  int x = 0;
  int xc = 0;
  int Insert = 0;
  int key;
  int key2;

  Insert = 0;
  strcpy(buf,p1);
  x = strlen(buf);
  for(;x<l;x++) buf[x] = ' '; // Fill back end of string with WS chars
  x = 0;
  cx1 = wherex();
  cy1 = wherey();
  for(;;)
  {
    buf[l-1]=0;
    gotoxy(cx1,cy1);
    cputs(buf);
    gotoxy(cx1+x,cy1);
    if(Insert) _setcursortype(_NORMALCURSOR);
    else       _setcursortype( _SOLIDCURSOR);
    while(!kbhit());
    //          getch
    key=bioskey(1) & 0xFF00;    // Get controls
    if(kbhit()) key2 = getch(); // Get ascii & flush
    else        key2 = 0;
    switch(key)
    {

      case _Hm   :
      case _TAB  : x = 0; break;
      case _End  : // Clear to buffer end
                   if(shift_key())
                   {
                     for(;x<l;x++) buf[x]=' ';
                     buf[x] = 0;
                   }
                   x = strlen(buf)-1;      // Back up thru trailing WS
                   while(buf[x]==' ') x--;
                   x++;
                   break;

      case      0: break;
      case _Enter: break;
      case _Bs   : x--;
      case _Del  : xc = x;
                   for(;x<l-1;x++)
                   {
                     buf[x]=buf[x+1];
                     if(buf[x]==0) break;
                   }
                   buf[l-1]=' ';
                   buf[l-2]=' ';
                   x = xc;
                   break;

      case _Ins  : Insert ^= 1; break;

      case _ESC  : break;
      case _Lt   : x--; if(x< 0) x=  0; break;
      case _Rt   : x++; if(x>=l) x=l-1; break;
      case _Spc  :
      default    : if(isprint(key2))
                   {
                     if(Insert==0) // Typeover
                     buf[x++] = key2;
                     else
                     {
                       xc = x;
                       for(x=l-1;x>xc;x--)
                       buf[x] = buf[x-1];
                       buf[x] = key2;
                       x = xc+1;
                     }
                   }
                   break;
    }
    if(key==_ESC)   break;
    if(key==_Enter) break;
    if(x>=l-1) x=l-1;
    if(x<   0) x=  0;
    buf[l-1]=  0;
  }
  x = strlen(buf)-1;      // Back up thru trailing WS
  while(buf[x]==' ') x--;
  buf[x+1] = 0;
  strncpy(p1,buf  ,l);
//if(kbhit()) getch();
//bioskey(0);
  _setcursortype(_NORMALCURSOR);
  if(key==_ESC) return NO_LINE;
  return NO_ERR;
}
