#ifndef __SCREEN
#define __SCREEN
//---------------------------------------------------------
// SCREEN.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//---------------------------------------------------------
//#include "ERRORMSG.H"
//#include "typedefs.h"
#include "textwin.h"
#include "dsk.h"
//#include "symbols.h"
/*--------------------------------------------------------*/
#define MOST_POSITIVE   3.4028236683E+38
#define LEAST_POSITIVE  5.8774717541E-39
#define MOST_NEGATIVE   -3.4028236691E+38
#define LEAST_NEGATIVE  -5.8774717569E-39
#define ERR_ATTR        (RED  <<4)|WHITE
#define CMD_ATTR        (BLUE <<4)|WHITE
#define CMDBUF_ATTR     (BLACK<<4)|CYAN
#define PC_ATTR         (BLUE <<4)|WHITE
#define WIN_ATTR        (BLACK<<4)|LIGHTGRAY
#define CMDBFRS         15    /* # lines IN cmd buffer   */
#define CMDLENG         78    /* max length of a command */
#define MAX_BRK_PT      32    /* max breakpoints         */
/*-------------------------------------------------------*/
/* Structure and union typedefs and enumerations         */
/*-------------------------------------------------------*/
struct  CMD_BUFFER
{
  char s[81];
  int a;
};

typedef struct
{
  ulong address; // address of the breakpoint
  ulong instr;   // instruction code
} BRKPOINT;

typedef enum  { M_READ, M_WRITE, M_READ_WRITE, M_INVALID } MEM_TYPE;

typedef struct
{
  ulong address;
  ulong length;
  MEM_TYPE type;
}MEMORY_MAP;
/* ---------------------------------------------------------*/
/* enumerated debugger commands                             */
/* ---------------------------------------------------------*/
typedef enum
{ CMD_NULL  ,LF      ,SB      ,CB      ,DB       ,MEM    ,
  MEM2      ,MEMF    ,MEMA    ,MEML    ,MEMUL    ,DASM   ,  MM,
  MMF       ,XG      ,RUNF    ,RUN     ,RESET    ,REDRAW ,
  EXTR1     ,EXTR2   ,XN      ,QUIT2   ,CALLCOFF ,VERSION,
  SLF       ,FLF     ,BLF     ,SCLR    ,DOS      ,EDIT   ,
  DSK3A     ,PATCH   ,CMDF    ,EVAL    ,ASIGN    ,SSTEP  ,
  FSTEP     ,GO      ,HELP    ,SAVE    ,SAVEL    ,SAVEU  ,
  SAVEF     ,SAVEH   ,SAVEBB  ,SAVEBI  ,SAVEBL   ,SAVED  ,
  FILEHEX   ,MEMHEX  ,HEXCOFF ,MEMCOFF ,DSKCOFF  ,MAXFLEN,
  SYMBOLS   ,MOVEMEM ,CREAD   ,CSAVE   ,CSAVEALL ,CSAVEALLCOFF,
  CMDBUFLOAD,DASM0   ,DASM1   ,DASM2   ,DASM3    ,DASM4       ,
  ENDTAKE   ,MEMQ
} CMDS;

/*----------------------------------------------------------*/
WINDOW *GrowWindow    (int x, int y, int w, int h, WINDOW *win);
int   shift_key       (void);
void  CMD_Window      (void);
void  Cmd_Msg         (char *msg,int attr,int outmsg, int endpos);
void  DSK3D_Stats     (void);
void  StatusLine      (char *p1);
MSGS  SYM_Help        (void);
MSGS  DASM_Window     (ulong address);
MSGS  MEM_Window      (ulong address);
MSGS  CPU_Window      (void);
MSGS  Init_Screen     (void);
MSGS  Edit_Cmd        (void);
MSGS  ExeCmdStrg      (char *buf, int Update);
MSGS  Execute_Cmd     (int cmd, int Update);
MSGS  scans           (char *p, int l);
MSGS  RUN_Cmd         (void );
MSGS  RUNF_Cmd        (void );
MSGS  FSTEP_Cmd       (long n);
MSGS  SStep_Cmd       (long n);
MSGS  RESET_Cmd       (void);
MSGS  SB_Cmd          (ulong address );
MSGS  CB_Cmd          (ulong address );
MSGS  DB_Cmd          ( void );
MSGS  MM_Cmd          (ulong address, ulong length, ulong value);
MSGS  XG_Cmd          (ulong N);
MSGS  Valid_Address   (ulong start, ulong end );
MSGS  clr_all_BP      (void);
MSGS  cmdsave         (int Full, int cmd);
MSGS  cmdread         (void);
NUM_TYPE EditBox      (ulong *val, NUM_TYPE MODE);
char  BP_SET          (long addr);
/*----------------------------------------------------------*/
/* Globaly defined variables                                */
/*----------------------------------------------------------*/
extern int      oldscreenmode;
extern WINDOW   *Cmd_Win;
extern WINDOW   *Dasm_Win;
extern WINDOW   *Cpu_Win;
extern WINDOW   *Mem_Win;
extern struct   CMD_BUFFER Cmd_Buf[];
extern char     CMSG[];
extern char     Cmd_Line[];
extern char     Edit_Banner[];
extern char     last_cmd[];
extern double   QVAL;
extern int      CPU_mode;
extern NUM_TYPE Mem_Mode;
extern int      Dasm_Mode;
extern int      Nb_Brk_Pt;
extern int      CmdNum;
extern ulong    DASM_Address;
extern ulong    MEM_Address;
extern BRKPOINT Brk_Tab[];
extern ulong    DASM_Ad_End;
extern ulong    MEM_Ad_End;

#endif
