/* Generic command file for linking TMSc2xx assembler files     */
/* input files : *.obj files                                    */
/* ouput files : *.out file                                     */
/* Map files   : *.map file                                     */
/* TMSc2xx architecture declaration for linker use              */


MEMORY
{

PAGE 0: 			       /* Program Memory                         */

EX1_PM  :ORIGIN=0H   ,  LENGTH=0fdffH  /* 63.5K external RAM                     */
B0_PM   :ORIGIN=0FE00H, LENGTH=0200H   /* On-chip DARAM if CNF=1, else external  */
				       /* B0 = FE00 to FEFF  or  FF00 to FFFF    */

PAGE 1: 			       /* Data Memory                            */

REGS    :ORIGIN=0H   ,  LENGTH=60H     /* Memory mapped regs. & reserved address */
BLK_B2  :ORIGIN=60H  ,  LENGTH=20H     /* Block B2                               */
BLK_B0  :ORIGIN=100H ,  LENGTH=200H    /* Block B0, On-chip DARAM if CNF=0       */
BLK_B1  :ORIGIN=300H ,  LENGTH=200H    /* Block B1                               */
EX1_DM  :ORIGIN=0800H,  LENGTH=7800H   /* External data RAM                      */
GM_DM   :ORIGIN=8000H,  LENGTH=8000H   /* External data RAM, Global memory       */

PAGE 2: 			       /* I/O Memory				 */

IO_IN   :ORIGIN=0FFF0H, LENGTH=0FH     /* On-chip I/O mapped peripherals	 */
IO_EX   :ORIGIN=0000H,  LENGTH=0FFF0H  /* External I/O mapped peripherals	 */


}

SECTIONS

{

	 vectors :{}  > EX1_PM   PAGE 0
	.text    :{}  > EX1_PM   PAGE 0
	.bss     :{}  > EX1_DM   PAGE 1
	 new     :{}  > BLK_B2   PAGE 1
	.data    :{}  > 0x1100   PAGE 1
}
